/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.demo;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.demo.BasicComponentsPanel;
import com.formdev.flatlaf.demo.ControlBar;
import com.formdev.flatlaf.demo.DataComponentsPanel;
import com.formdev.flatlaf.demo.DemoPrefs;
import com.formdev.flatlaf.demo.HintManager;
import com.formdev.flatlaf.demo.MoreComponentsPanel;
import com.formdev.flatlaf.demo.NewDialog;
import com.formdev.flatlaf.demo.OptionPanePanel;
import com.formdev.flatlaf.demo.TabsPanel;
import com.formdev.flatlaf.demo.extras.ExtrasPanel;
import com.formdev.flatlaf.demo.intellijthemes.IJThemesPanel;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import com.formdev.flatlaf.extras.FlatDesktop;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.extras.FlatSVGUtils;
import com.formdev.flatlaf.extras.FlatUIDefaultsInspector;
import com.formdev.flatlaf.extras.components.FlatButton;
import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.formdev.flatlaf.ui.JBRCustomDecorations;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.FontUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;

class DemoFrame
extends JFrame {
    private final String[] availableFontFamilyNames;
    private int initialFontMenuItemCount = -1;
    private static String[] accentColorKeys = new String[]{"Demo.accent.default", "Demo.accent.blue", "Demo.accent.purple", "Demo.accent.red", "Demo.accent.orange", "Demo.accent.yellow", "Demo.accent.green"};
    private static String[] accentColorNames = new String[]{"Default", "Blue", "Purple", "Red", "Orange", "Yellow", "Green"};
    private final JToggleButton[] accentColorButtons = new JToggleButton[accentColorKeys.length];
    private JLabel accentColorLabel;
    private Color accentColor;
    private JMenuItem exitMenuItem;
    private JMenu scrollingPopupMenu;
    private JMenuItem htmlMenuItem;
    private JMenu fontMenu;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem windowDecorationsCheckBoxMenuItem;
    private JCheckBoxMenuItem menuBarEmbeddedCheckBoxMenuItem;
    private JCheckBoxMenuItem unifiedTitleBarMenuItem;
    private JCheckBoxMenuItem showTitleBarIconMenuItem;
    private JCheckBoxMenuItem underlineMenuSelectionMenuItem;
    private JCheckBoxMenuItem alwaysShowMnemonicsMenuItem;
    private JCheckBoxMenuItem animatedLafChangeMenuItem;
    private JMenuItem aboutMenuItem;
    private JToolBar toolBar;
    private JTabbedPane tabbedPane;
    private ControlBar controlBar;
    IJThemesPanel themesPanel;

    DemoFrame() {
        int tabIndex = DemoPrefs.getState().getInt("tab", 0);
        this.availableFontFamilyNames = (String[])FontUtils.getAvailableFontFamilyNames().clone();
        Arrays.sort(this.availableFontFamilyNames);
        this.initComponents();
        this.updateFontMenuItems();
        this.initAccentColors();
        this.controlBar.initialize(this, this.tabbedPane);
        this.setIconImages(FlatSVGUtils.createWindowIconImages("/com/formdev/flatlaf/demo/FlatLaf.svg"));
        if (tabIndex >= 0 && tabIndex < this.tabbedPane.getTabCount() && tabIndex != this.tabbedPane.getSelectedIndex()) {
            this.tabbedPane.setSelectedIndex(tabIndex);
        }
        if (SystemInfo.isMacOS) {
            this.exitMenuItem.setVisible(false);
            this.aboutMenuItem.setVisible(false);
            this.htmlMenuItem.setText("some text");
            if (SystemInfo.isMacFullWindowContentSupported) {
                this.getRootPane().putClientProperty("apple.awt.fullWindowContent", true);
                this.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
                if (SystemInfo.isJava_17_orLater) {
                    this.getRootPane().putClientProperty("apple.awt.windowTitleVisible", false);
                } else {
                    this.setTitle(null);
                }
                this.toolBar.add(Box.createHorizontalStrut(70), 0);
            }
            if (!SystemInfo.isJava_11_orLater) {
                this.getRootPane().putClientProperty("apple.awt.fullscreenable", true);
            }
        }
        FlatDesktop.setAboutHandler(this::aboutActionPerformed);
        FlatDesktop.setPreferencesHandler(this::showPreferences);
        FlatDesktop.setQuitHandler(response -> response.performQuit());
        SwingUtilities.invokeLater(() -> this.showHints());
    }

    @Override
    public void dispose() {
        super.dispose();
        FlatUIDefaultsInspector.hide();
    }

    private void showHints() {
        HintManager.Hint fontMenuHint = new HintManager.Hint("Use 'Font' menu to increase/decrease font size or try different fonts.", this.fontMenu, 3, "hint.fontMenu", null);
        HintManager.Hint optionsMenuHint = new HintManager.Hint("Use 'Options' menu to try out various FlatLaf options.", this.optionsMenu, 3, "hint.optionsMenu", fontMenuHint);
        HintManager.Hint themesHint = new HintManager.Hint("Use 'Themes' list to try out various themes.", this.themesPanel, 2, "hint.themesPanel", optionsMenuHint);
        HintManager.showHint(themesHint);
    }

    private void clearHints() {
        HintManager.hideAllHints();
        Preferences state = DemoPrefs.getState();
        state.remove("hint.fontMenu");
        state.remove("hint.optionsMenu");
        state.remove("hint.themesPanel");
    }

    private void showUIDefaultsInspector() {
        FlatUIDefaultsInspector.show();
    }

    private void newActionPerformed() {
        NewDialog newDialog = new NewDialog((Window)this);
        newDialog.setVisible(true);
    }

    private void openActionPerformed() {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(this);
    }

    private void saveAsActionPerformed() {
        JFileChooser chooser = new JFileChooser();
        chooser.showSaveDialog(this);
    }

    private void exitActionPerformed() {
        this.dispose();
    }

    private void aboutActionPerformed() {
        JLabel titleLabel = new JLabel("FlatLaf Demo");
        titleLabel.putClientProperty("FlatLaf.styleClass", "h1");
        final String link = "https://www.formdev.com/flatlaf/";
        final JLabel linkLabel = new JLabel("<html><a href=\"#\">" + link + "</a></html>");
        linkLabel.setCursor(Cursor.getPredefinedCursor(12));
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(link));
                }
                catch (IOException | URISyntaxException ex) {
                    JOptionPane.showMessageDialog(linkLabel, "Failed to open '" + link + "' in browser.", "About", -1);
                }
            }
        });
        JOptionPane.showMessageDialog(this, new Object[]{titleLabel, "Demonstrates FlatLaf Swing look and feel", " ", "Copyright 2019-" + Year.now() + " FormDev Software GmbH", linkLabel}, "About", -1);
    }

    private void showPreferences() {
        JOptionPane.showMessageDialog(this, "Sorry, but FlatLaf Demo does not have preferences. :(\nThis dialog is here to demonstrate usage of class 'FlatDesktop' on macOS.", "Preferences", -1);
    }

    private void selectedTabChanged() {
        DemoPrefs.getState().putInt("tab", this.tabbedPane.getSelectedIndex());
    }

    private void menuItemActionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, e.getActionCommand(), "Menu Item", -1));
    }

    private void windowDecorationsChanged() {
        boolean windowDecorations = this.windowDecorationsCheckBoxMenuItem.isSelected();
        FlatLaf.setUseNativeWindowDecorations(windowDecorations);
        this.menuBarEmbeddedCheckBoxMenuItem.setEnabled(windowDecorations);
        this.unifiedTitleBarMenuItem.setEnabled(windowDecorations);
        this.showTitleBarIconMenuItem.setEnabled(windowDecorations);
    }

    private void menuBarEmbeddedChanged() {
        UIManager.put("TitlePane.menuBarEmbedded", this.menuBarEmbeddedCheckBoxMenuItem.isSelected());
        FlatLaf.revalidateAndRepaintAllFramesAndDialogs();
    }

    private void unifiedTitleBar() {
        UIManager.put("TitlePane.unifiedBackground", this.unifiedTitleBarMenuItem.isSelected());
        FlatLaf.repaintAllFramesAndDialogs();
    }

    private void showTitleBarIcon() {
        boolean showIcon = this.showTitleBarIconMenuItem.isSelected();
        this.getRootPane().putClientProperty("JRootPane.titleBarShowIcon", showIcon);
        UIManager.put("TitlePane.showIcon", showIcon);
    }

    private void underlineMenuSelection() {
        UIManager.put("MenuItem.selectionType", this.underlineMenuSelectionMenuItem.isSelected() ? "underline" : null);
    }

    private void alwaysShowMnemonics() {
        UIManager.put("Component.hideMnemonics", !this.alwaysShowMnemonicsMenuItem.isSelected());
        this.repaint();
    }

    private void animatedLafChangeChanged() {
        System.setProperty("flatlaf.animatedLafChange", String.valueOf(this.animatedLafChangeMenuItem.isSelected()));
    }

    private void showHintsChanged() {
        this.clearHints();
        this.showHints();
    }

    private void fontFamilyChanged(ActionEvent e) {
        String fontFamily = e.getActionCommand();
        FlatAnimatedLafChange.showSnapshot();
        Font font = UIManager.getFont("defaultFont");
        Font newFont = FontUtils.getCompositeFont(fontFamily, font.getStyle(), font.getSize());
        UIManager.put("defaultFont", newFont);
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
    }

    private void fontSizeChanged(ActionEvent e) {
        String fontSizeStr = e.getActionCommand();
        Font font = UIManager.getFont("defaultFont");
        Font newFont = font.deriveFont((float)Integer.parseInt(fontSizeStr));
        UIManager.put("defaultFont", newFont);
        FlatLaf.updateUI();
    }

    private void restoreFont() {
        UIManager.put("defaultFont", null);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
    }

    private void incrFont() {
        Font font = UIManager.getFont("defaultFont");
        Font newFont = font.deriveFont((float)(font.getSize() + 1));
        UIManager.put("defaultFont", newFont);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
    }

    private void decrFont() {
        Font font = UIManager.getFont("defaultFont");
        Font newFont = font.deriveFont((float)Math.max(font.getSize() - 1, 10));
        UIManager.put("defaultFont", newFont);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
    }

    void updateFontMenuItems() {
        if (this.initialFontMenuItemCount < 0) {
            this.initialFontMenuItemCount = this.fontMenu.getItemCount();
        } else {
            for (int i = this.fontMenu.getItemCount() - 1; i >= this.initialFontMenuItemCount; --i) {
                this.fontMenu.remove(i);
            }
        }
        Font currentFont = UIManager.getFont("Label.font");
        String currentFamily = currentFont.getFamily();
        String currentSize = Integer.toString(currentFont.getSize());
        this.fontMenu.addSeparator();
        ArrayList<String> families = new ArrayList<String>(Arrays.asList("Arial", "Cantarell", "Comic Sans MS", "DejaVu Sans", "Dialog", "Inter", "Liberation Sans", "Noto Sans", "Open Sans", "Roboto", "SansSerif", "Segoe UI", "Serif", "Tahoma", "Ubuntu", "Verdana"));
        if (!families.contains(currentFamily)) {
            families.add(currentFamily);
        }
        families.sort(String.CASE_INSENSITIVE_ORDER);
        ButtonGroup familiesGroup = new ButtonGroup();
        for (String family : families) {
            if (Arrays.binarySearch(this.availableFontFamilyNames, family) < 0) continue;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(family);
            item.setSelected(family.equals(currentFamily));
            item.addActionListener(this::fontFamilyChanged);
            this.fontMenu.add(item);
            familiesGroup.add(item);
        }
        this.fontMenu.addSeparator();
        ArrayList<String> sizes = new ArrayList<String>(Arrays.asList("10", "11", "12", "14", "16", "18", "20", "24", "28"));
        if (!sizes.contains(currentSize)) {
            sizes.add(currentSize);
        }
        sizes.sort(String.CASE_INSENSITIVE_ORDER);
        ButtonGroup sizesGroup = new ButtonGroup();
        for (String size : sizes) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(size);
            item.setSelected(size.equals(currentSize));
            item.addActionListener(this::fontSizeChanged);
            this.fontMenu.add(item);
            sizesGroup.add(item);
        }
        boolean enabled = UIManager.getLookAndFeel() instanceof FlatLaf;
        for (Component item : this.fontMenu.getMenuComponents()) {
            item.setEnabled(enabled);
        }
    }

    private void initAccentColors() {
        this.accentColorLabel = new JLabel("Accent color: ");
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.add(this.accentColorLabel);
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.accentColorButtons.length; ++i) {
            this.accentColorButtons[i] = new JToggleButton(new AccentColorIcon(accentColorKeys[i]));
            this.accentColorButtons[i].setToolTipText(accentColorNames[i]);
            this.accentColorButtons[i].addActionListener(this::accentColorChanged);
            this.toolBar.add(this.accentColorButtons[i]);
            group.add(this.accentColorButtons[i]);
        }
        this.accentColorButtons[0].setSelected(true);
        FlatLaf.setSystemColorGetter(name -> name.equals("accent") ? this.accentColor : null);
        UIManager.addPropertyChangeListener(e -> {
            if ("lookAndFeel".equals(e.getPropertyName())) {
                this.updateAccentColorButtons();
            }
        });
        this.updateAccentColorButtons();
    }

    private void accentColorChanged(ActionEvent e) {
        String accentColorKey = null;
        for (int i = 0; i < this.accentColorButtons.length; ++i) {
            if (!this.accentColorButtons[i].isSelected()) continue;
            accentColorKey = accentColorKeys[i];
            break;
        }
        this.accentColor = accentColorKey != null && accentColorKey != accentColorKeys[0] ? UIManager.getColor(accentColorKey) : null;
        Class<?> lafClass = UIManager.getLookAndFeel().getClass();
        try {
            FlatLaf.setup((LookAndFeel)lafClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            FlatLaf.updateUI();
        }
        catch (Exception ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    private void updateAccentColorButtons() {
        Class<?> lafClass = UIManager.getLookAndFeel().getClass();
        boolean isAccentColorSupported = lafClass == FlatLightLaf.class || lafClass == FlatDarkLaf.class || lafClass == FlatIntelliJLaf.class || lafClass == FlatDarculaLaf.class || lafClass == FlatMacLightLaf.class || lafClass == FlatMacDarkLaf.class;
        this.accentColorLabel.setVisible(isAccentColorSupported);
        for (int i = 0; i < this.accentColorButtons.length; ++i) {
            this.accentColorButtons[i].setVisible(isAccentColorSupported);
        }
    }

    private void initComponents() {
        JMenuBar menuBar1 = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem newMenuItem = new JMenuItem();
        JMenuItem openMenuItem = new JMenuItem();
        JMenuItem saveAsMenuItem = new JMenuItem();
        JMenuItem closeMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        JMenu editMenu = new JMenu();
        JMenuItem undoMenuItem = new JMenuItem();
        JMenuItem redoMenuItem = new JMenuItem();
        JMenuItem cutMenuItem = new JMenuItem();
        JMenuItem copyMenuItem = new JMenuItem();
        JMenuItem pasteMenuItem = new JMenuItem();
        JMenuItem deleteMenuItem = new JMenuItem();
        JMenu viewMenu = new JMenu();
        JCheckBoxMenuItem checkBoxMenuItem1 = new JCheckBoxMenuItem();
        JMenu menu1 = new JMenu();
        JMenu subViewsMenu = new JMenu();
        JMenu subSubViewsMenu = new JMenu();
        JMenuItem errorLogViewMenuItem = new JMenuItem();
        JMenuItem searchViewMenuItem = new JMenuItem();
        JMenuItem projectViewMenuItem = new JMenuItem();
        JMenuItem structureViewMenuItem = new JMenuItem();
        JMenuItem propertiesViewMenuItem = new JMenuItem();
        this.scrollingPopupMenu = new JMenu();
        JMenuItem menuItem2 = new JMenuItem();
        this.htmlMenuItem = new JMenuItem();
        JRadioButtonMenuItem radioButtonMenuItem1 = new JRadioButtonMenuItem();
        JRadioButtonMenuItem radioButtonMenuItem2 = new JRadioButtonMenuItem();
        JRadioButtonMenuItem radioButtonMenuItem3 = new JRadioButtonMenuItem();
        this.fontMenu = new JMenu();
        JMenuItem restoreFontMenuItem = new JMenuItem();
        JMenuItem incrFontMenuItem = new JMenuItem();
        JMenuItem decrFontMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.windowDecorationsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.menuBarEmbeddedCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.unifiedTitleBarMenuItem = new JCheckBoxMenuItem();
        this.showTitleBarIconMenuItem = new JCheckBoxMenuItem();
        this.underlineMenuSelectionMenuItem = new JCheckBoxMenuItem();
        this.alwaysShowMnemonicsMenuItem = new JCheckBoxMenuItem();
        this.animatedLafChangeMenuItem = new JCheckBoxMenuItem();
        JMenuItem showHintsMenuItem = new JMenuItem();
        JMenuItem showUIDefaultsInspectorMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.toolBar = new JToolBar();
        JButton backButton = new JButton();
        JButton forwardButton = new JButton();
        JButton cutButton = new JButton();
        JButton copyButton = new JButton();
        JButton pasteButton = new JButton();
        JButton refreshButton = new JButton();
        JToggleButton showToggleButton = new JToggleButton();
        JPanel contentPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        BasicComponentsPanel basicComponentsPanel = new BasicComponentsPanel();
        MoreComponentsPanel moreComponentsPanel = new MoreComponentsPanel();
        DataComponentsPanel dataComponentsPanel = new DataComponentsPanel();
        TabsPanel tabsPanel = new TabsPanel();
        OptionPanePanel optionPanePanel = new OptionPanePanel();
        ExtrasPanel extrasPanel1 = new ExtrasPanel();
        this.controlBar = new ControlBar();
        this.themesPanel = new IJThemesPanel();
        this.setTitle("FlatLaf Demo");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        fileMenu.setText("File");
        fileMenu.setMnemonic('F');
        newMenuItem.setText("New");
        newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        newMenuItem.setMnemonic('N');
        newMenuItem.addActionListener(e -> this.newActionPerformed());
        fileMenu.add(newMenuItem);
        openMenuItem.setText("Open...");
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        openMenuItem.setMnemonic('O');
        openMenuItem.addActionListener(e -> this.openActionPerformed());
        fileMenu.add(openMenuItem);
        saveAsMenuItem.setText("Save As...");
        saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        saveAsMenuItem.setMnemonic('S');
        saveAsMenuItem.addActionListener(e -> this.saveAsActionPerformed());
        fileMenu.add(saveAsMenuItem);
        fileMenu.addSeparator();
        closeMenuItem.setText("Close");
        closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        closeMenuItem.setMnemonic('C');
        closeMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        fileMenu.add(closeMenuItem);
        fileMenu.addSeparator();
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.exitMenuItem.setMnemonic('X');
        this.exitMenuItem.addActionListener(e -> this.exitActionPerformed());
        fileMenu.add(this.exitMenuItem);
        menuBar1.add(fileMenu);
        editMenu.setText("Edit");
        editMenu.setMnemonic('E');
        undoMenuItem.setText("Undo");
        undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        undoMenuItem.setMnemonic('U');
        undoMenuItem.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/undo.svg"));
        undoMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        editMenu.add(undoMenuItem);
        redoMenuItem.setText("Redo");
        redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        redoMenuItem.setMnemonic('R');
        redoMenuItem.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/redo.svg"));
        redoMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        editMenu.add(redoMenuItem);
        editMenu.addSeparator();
        cutMenuItem.setText("Cut");
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        cutMenuItem.setMnemonic('C');
        cutMenuItem.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/menu-cut.svg"));
        editMenu.add(cutMenuItem);
        copyMenuItem.setText("Copy");
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        copyMenuItem.setMnemonic('O');
        copyMenuItem.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/copy.svg"));
        editMenu.add(copyMenuItem);
        pasteMenuItem.setText("Paste");
        pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        pasteMenuItem.setMnemonic('P');
        pasteMenuItem.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/menu-paste.svg"));
        editMenu.add(pasteMenuItem);
        editMenu.addSeparator();
        deleteMenuItem.setText("Delete");
        deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        deleteMenuItem.setMnemonic('D');
        deleteMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        editMenu.add(deleteMenuItem);
        menuBar1.add(editMenu);
        viewMenu.setText("View");
        viewMenu.setMnemonic('V');
        checkBoxMenuItem1.setText("Show Toolbar");
        checkBoxMenuItem1.setSelected(true);
        checkBoxMenuItem1.setMnemonic('T');
        checkBoxMenuItem1.addActionListener(e -> this.menuItemActionPerformed(e));
        viewMenu.add(checkBoxMenuItem1);
        menu1.setText("Show View");
        menu1.setMnemonic('V');
        subViewsMenu.setText("Sub Views");
        subViewsMenu.setMnemonic('S');
        subSubViewsMenu.setText("Sub sub Views");
        subSubViewsMenu.setMnemonic('U');
        errorLogViewMenuItem.setText("Error Log");
        errorLogViewMenuItem.setMnemonic('E');
        errorLogViewMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        subSubViewsMenu.add(errorLogViewMenuItem);
        subViewsMenu.add(subSubViewsMenu);
        searchViewMenuItem.setText("Search");
        searchViewMenuItem.setMnemonic('S');
        searchViewMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        subViewsMenu.add(searchViewMenuItem);
        menu1.add(subViewsMenu);
        projectViewMenuItem.setText("Project");
        projectViewMenuItem.setMnemonic('P');
        projectViewMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        menu1.add(projectViewMenuItem);
        structureViewMenuItem.setText("Structure");
        structureViewMenuItem.setMnemonic('T');
        structureViewMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        menu1.add(structureViewMenuItem);
        propertiesViewMenuItem.setText("Properties");
        propertiesViewMenuItem.setMnemonic('O');
        propertiesViewMenuItem.addActionListener(e -> this.menuItemActionPerformed(e));
        menu1.add(propertiesViewMenuItem);
        viewMenu.add(menu1);
        this.scrollingPopupMenu.setText("Scrolling Popup Menu");
        viewMenu.add(this.scrollingPopupMenu);
        menuItem2.setText("Disabled Item");
        menuItem2.setEnabled(false);
        viewMenu.add(menuItem2);
        this.htmlMenuItem.setText("<html>some <b color=\"red\">HTML</b> <i color=\"blue\">text</i></html>");
        viewMenu.add(this.htmlMenuItem);
        viewMenu.addSeparator();
        radioButtonMenuItem1.setText("Details");
        radioButtonMenuItem1.setSelected(true);
        radioButtonMenuItem1.setMnemonic('D');
        radioButtonMenuItem1.addActionListener(e -> this.menuItemActionPerformed(e));
        viewMenu.add(radioButtonMenuItem1);
        radioButtonMenuItem2.setText("Small Icons");
        radioButtonMenuItem2.setMnemonic('S');
        radioButtonMenuItem2.addActionListener(e -> this.menuItemActionPerformed(e));
        viewMenu.add(radioButtonMenuItem2);
        radioButtonMenuItem3.setText("Large Icons");
        radioButtonMenuItem3.setMnemonic('L');
        radioButtonMenuItem3.addActionListener(e -> this.menuItemActionPerformed(e));
        viewMenu.add(radioButtonMenuItem3);
        menuBar1.add(viewMenu);
        this.fontMenu.setText("Font");
        restoreFontMenuItem.setText("Restore Font");
        restoreFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        restoreFontMenuItem.addActionListener(e -> this.restoreFont());
        this.fontMenu.add(restoreFontMenuItem);
        incrFontMenuItem.setText("Increase Font Size");
        incrFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        incrFontMenuItem.addActionListener(e -> this.incrFont());
        this.fontMenu.add(incrFontMenuItem);
        decrFontMenuItem.setText("Decrease Font Size");
        decrFontMenuItem.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        decrFontMenuItem.addActionListener(e -> this.decrFont());
        this.fontMenu.add(decrFontMenuItem);
        menuBar1.add(this.fontMenu);
        this.optionsMenu.setText("Options");
        this.windowDecorationsCheckBoxMenuItem.setText("Window decorations");
        this.windowDecorationsCheckBoxMenuItem.addActionListener(e -> this.windowDecorationsChanged());
        this.optionsMenu.add(this.windowDecorationsCheckBoxMenuItem);
        this.menuBarEmbeddedCheckBoxMenuItem.setText("Embedded menu bar");
        this.menuBarEmbeddedCheckBoxMenuItem.addActionListener(e -> this.menuBarEmbeddedChanged());
        this.optionsMenu.add(this.menuBarEmbeddedCheckBoxMenuItem);
        this.unifiedTitleBarMenuItem.setText("Unified window title bar");
        this.unifiedTitleBarMenuItem.addActionListener(e -> this.unifiedTitleBar());
        this.optionsMenu.add(this.unifiedTitleBarMenuItem);
        this.showTitleBarIconMenuItem.setText("Show window title bar icon");
        this.showTitleBarIconMenuItem.addActionListener(e -> this.showTitleBarIcon());
        this.optionsMenu.add(this.showTitleBarIconMenuItem);
        this.underlineMenuSelectionMenuItem.setText("Use underline menu selection");
        this.underlineMenuSelectionMenuItem.addActionListener(e -> this.underlineMenuSelection());
        this.optionsMenu.add(this.underlineMenuSelectionMenuItem);
        this.alwaysShowMnemonicsMenuItem.setText("Always show mnemonics");
        this.alwaysShowMnemonicsMenuItem.addActionListener(e -> this.alwaysShowMnemonics());
        this.optionsMenu.add(this.alwaysShowMnemonicsMenuItem);
        this.animatedLafChangeMenuItem.setText("Animated Laf Change");
        this.animatedLafChangeMenuItem.setSelected(true);
        this.animatedLafChangeMenuItem.addActionListener(e -> this.animatedLafChangeChanged());
        this.optionsMenu.add(this.animatedLafChangeMenuItem);
        showHintsMenuItem.setText("Show hints");
        showHintsMenuItem.addActionListener(e -> this.showHintsChanged());
        this.optionsMenu.add(showHintsMenuItem);
        showUIDefaultsInspectorMenuItem.setText("Show UI Defaults Inspector");
        showUIDefaultsInspectorMenuItem.addActionListener(e -> this.showUIDefaultsInspector());
        this.optionsMenu.add(showUIDefaultsInspectorMenuItem);
        menuBar1.add(this.optionsMenu);
        helpMenu.setText("Help");
        helpMenu.setMnemonic('H');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.addActionListener(e -> this.aboutActionPerformed());
        helpMenu.add(this.aboutMenuItem);
        menuBar1.add(helpMenu);
        this.setJMenuBar(menuBar1);
        this.toolBar.setMargin(new Insets(3, 3, 3, 3));
        backButton.setToolTipText("Back");
        backButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/back.svg"));
        this.toolBar.add(backButton);
        forwardButton.setToolTipText("Forward");
        forwardButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/forward.svg"));
        this.toolBar.add(forwardButton);
        this.toolBar.addSeparator();
        cutButton.setToolTipText("Cut");
        cutButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/menu-cut.svg"));
        this.toolBar.add(cutButton);
        copyButton.setToolTipText("Copy");
        copyButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/copy.svg"));
        this.toolBar.add(copyButton);
        pasteButton.setToolTipText("Paste");
        pasteButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/menu-paste.svg"));
        this.toolBar.add(pasteButton);
        this.toolBar.addSeparator();
        refreshButton.setToolTipText("Refresh");
        refreshButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/refresh.svg"));
        this.toolBar.add(refreshButton);
        this.toolBar.addSeparator();
        showToggleButton.setSelected(true);
        showToggleButton.setToolTipText("Show Details");
        showToggleButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/show.svg"));
        this.toolBar.add(showToggleButton);
        contentPane.add((Component)this.toolBar, "North");
        contentPanel.setLayout((LayoutManager)new MigLayout("insets dialog,hidemode 3", "[grow,fill]", "[grow,fill]"));
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addChangeListener(e -> this.selectedTabChanged());
        this.tabbedPane.addTab("Basic Components", basicComponentsPanel);
        this.tabbedPane.addTab("More Components", moreComponentsPanel);
        this.tabbedPane.addTab("Data Components", dataComponentsPanel);
        this.tabbedPane.addTab("Tabs", tabsPanel);
        this.tabbedPane.addTab("Option Pane", optionPanePanel);
        this.tabbedPane.addTab("Extras", extrasPanel1);
        contentPanel.add((Component)this.tabbedPane, "cell 0 0");
        contentPane.add((Component)contentPanel, "Center");
        contentPane.add((Component)this.controlBar, "South");
        contentPane.add((Component)this.themesPanel, "East");
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(radioButtonMenuItem1);
        buttonGroup1.add(radioButtonMenuItem2);
        buttonGroup1.add(radioButtonMenuItem3);
        FlatButton usersButton = new FlatButton();
        usersButton.setIcon(new FlatSVGIcon("com/formdev/flatlaf/demo/icons/users.svg"));
        usersButton.setButtonType(FlatButton.ButtonType.toolBarButton);
        usersButton.setFocusable(false);
        usersButton.addActionListener(e -> JOptionPane.showMessageDialog(null, "Hello User! How are you?", "User", 1));
        menuBar1.add(Box.createGlue());
        menuBar1.add(usersButton);
        cutMenuItem.addActionListener(new DefaultEditorKit.CutAction());
        copyMenuItem.addActionListener(new DefaultEditorKit.CopyAction());
        pasteMenuItem.addActionListener(new DefaultEditorKit.PasteAction());
        this.scrollingPopupMenu.add("Large menus are scrollable");
        this.scrollingPopupMenu.add("Use mouse wheel to scroll");
        this.scrollingPopupMenu.add("Or use up/down arrows at top/bottom");
        for (int i = 1; i <= 100; ++i) {
            this.scrollingPopupMenu.add("Item " + i);
        }
        if (FlatLaf.supportsNativeWindowDecorations() || SystemInfo.isLinux && JFrame.isDefaultLookAndFeelDecorated()) {
            if (SystemInfo.isLinux) {
                this.unsupported(this.windowDecorationsCheckBoxMenuItem);
            } else {
                this.windowDecorationsCheckBoxMenuItem.setSelected(FlatLaf.isUseNativeWindowDecorations());
            }
            this.menuBarEmbeddedCheckBoxMenuItem.setSelected(UIManager.getBoolean("TitlePane.menuBarEmbedded"));
            this.unifiedTitleBarMenuItem.setSelected(UIManager.getBoolean("TitlePane.unifiedBackground"));
            this.showTitleBarIconMenuItem.setSelected(UIManager.getBoolean("TitlePane.showIcon"));
            if (JBRCustomDecorations.isSupported()) {
                this.windowDecorationsCheckBoxMenuItem.setEnabled(false);
            }
        } else {
            this.unsupported(this.windowDecorationsCheckBoxMenuItem);
            this.unsupported(this.menuBarEmbeddedCheckBoxMenuItem);
            this.unsupported(this.unifiedTitleBarMenuItem);
            this.unsupported(this.showTitleBarIconMenuItem);
        }
        if (SystemInfo.isMacOS) {
            this.unsupported(this.underlineMenuSelectionMenuItem);
        }
        if ("false".equals(System.getProperty("flatlaf.animatedLafChange"))) {
            this.animatedLafChangeMenuItem.setSelected(false);
        }
        MigLayout layout = (MigLayout)contentPanel.getLayout();
        LC lc = ConstraintParser.parseLayoutConstraint((String)((String)layout.getLayoutConstraints()));
        UnitValue[] insets = lc.getInsets();
        lc.setInsets(new UnitValue[]{insets[0], insets[1], new UnitValue(0.0f, 0, null), insets[3]});
        layout.setLayoutConstraints((Object)lc);
    }

    private void unsupported(JCheckBoxMenuItem menuItem) {
        menuItem.setEnabled(false);
        menuItem.setSelected(false);
        menuItem.setToolTipText("Not supported on your system.");
    }

    private static class AccentColorIcon
    extends FlatAbstractIcon {
        private final String colorKey;

        AccentColorIcon(String colorKey) {
            super(16, 16, null);
            this.colorKey = colorKey;
        }

        @Override
        protected void paintIcon(Component c, Graphics2D g) {
            Color color = UIManager.getColor(this.colorKey);
            if (color == null) {
                color = Color.lightGray;
            } else if (!c.isEnabled()) {
                color = FlatLaf.isLafDark() ? ColorFunctions.shade(color, 0.5f) : ColorFunctions.tint(color, 0.6f);
            }
            g.setColor(color);
            g.fillRoundRect(1, 1, this.width - 2, this.height - 2, 5, 5);
        }
    }
}

