/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.FlatIconColors;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.SoftCache;
import com.formdev.flatlaf.util.UIScale;
import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class FlatSVGIcon
extends ImageIcon
implements FlatLaf.DisabledIconProvider {
    public static final /* synthetic */ SoftCache<String, SVGDocument> svgCache;
    public static final /* synthetic */ SVGLoader svgLoader;
    public final /* synthetic */ String name;
    public final /* synthetic */ int width;
    public final /* synthetic */ int height;
    public final /* synthetic */ float scale;
    public final /* synthetic */ boolean disabled;
    public final /* synthetic */ ClassLoader classLoader;
    public final /* synthetic */ URL url;
    public /* synthetic */ ColorFilter colorFilter;
    public /* synthetic */ SVGDocument document;
    public /* synthetic */ boolean dark;
    public /* synthetic */ boolean loadFailed;
    public static /* synthetic */ Boolean darkLaf;

    public FlatSVGIcon(String string) {
        this(string, -1, -1, 1.0f, false, null, null);
    }

    public FlatSVGIcon(String string, ClassLoader classLoader) {
        this(string, -1, -1, 1.0f, false, classLoader, null);
    }

    public FlatSVGIcon(String string, int n, int n2) {
        this(string, n, n2, 1.0f, false, null, null);
    }

    public FlatSVGIcon(String string, int n, int n2, ClassLoader classLoader) {
        this(string, n, n2, 1.0f, false, classLoader, null);
    }

    public FlatSVGIcon(String string, float f) {
        this(string, -1, -1, f, false, null, null);
    }

    public FlatSVGIcon(String string, float f, ClassLoader classLoader) {
        this(string, -1, -1, f, false, classLoader, null);
    }

    public FlatSVGIcon(URL uRL) {
        this(null, -1, -1, 1.0f, false, null, uRL);
    }

    public FlatSVGIcon(URI uRI) {
        this(null, -1, -1, 1.0f, false, null, FlatSVGIcon.uri2url(uRI));
    }

    public FlatSVGIcon(File file) {
        this(null, -1, -1, 1.0f, false, null, FlatSVGIcon.uri2url(file.toURI()));
    }

    public FlatSVGIcon(InputStream inputStream) throws IOException {
        this(null, -1, -1, 1.0f, false, null, null);
        try (InputStream inputStream2 = inputStream;){
            this.document = svgLoader.load(inputStream2);
            if (this.document == null) {
                this.loadFailed = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(1);
                LoggingFacade.INSTANCE.logSevere("FlatSVGIcon: failed to load SVG icon from input stream", null);
            }
        }
    }

    public FlatSVGIcon(FlatSVGIcon flatSVGIcon) {
        this(flatSVGIcon.name, flatSVGIcon.width, flatSVGIcon.height, flatSVGIcon.scale, FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(flatSVGIcon.disabled ? 1 : 0) != 0, flatSVGIcon.classLoader, flatSVGIcon.url);
        this.colorFilter = flatSVGIcon.colorFilter;
        this.document = flatSVGIcon.document;
        this.dark = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(flatSVGIcon.dark ? 1 : 0));
    }

    public FlatSVGIcon(String string, int n, int n2, float f, boolean bl, ClassLoader classLoader, URL uRL) {
        this.name = string;
        this.width = n;
        this.height = n2;
        this.scale = f;
        this.disabled = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(bl ? 1 : 0);
        this.classLoader = classLoader;
        this.url = uRL;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getScale() {
        return this.scale;
    }

    public boolean isDisabled() {
        return FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.disabled ? 1 : 0) != 0;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FlatSVGIcon derive(int n, int n2) {
        if (n == this.width && n2 == this.height) {
            return this;
        }
        int n3 = "\u69f0\u5455\u5314\u6088".length();
        int n4 = "\u64ca".length();
        int n5 = "\u50f3\u5dd8".length();
        FlatSVGIcon flatSVGIcon = new FlatSVGIcon(this.name, n, n2, this.scale, FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.disabled ? 1 : 0) != 0, this.classLoader, this.url);
        flatSVGIcon.colorFilter = this.colorFilter;
        flatSVGIcon.document = this.document;
        flatSVGIcon.dark = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.dark ? 1 : 0));
        return flatSVGIcon;
    }

    public FlatSVGIcon derive(float f) {
        if (f == this.scale) {
            return this;
        }
        int n = "\u5034\u5c65\u5de2\u633c\u6613".length();
        int n2 = "\u544d\u6dbf\u691d\u5fb6".length();
        int n3 = "\u56da\u549e\u5b17\u53ae".length();
        FlatSVGIcon flatSVGIcon = new FlatSVGIcon(this.name, this.width, this.height, f, FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.disabled ? 1 : 0) != 0, this.classLoader, this.url);
        flatSVGIcon.colorFilter = this.colorFilter;
        flatSVGIcon.document = this.document;
        flatSVGIcon.dark = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.dark ? 1 : 0));
        return flatSVGIcon;
    }

    @Override
    public Icon getDisabledIcon() {
        if (FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.disabled ? 1 : 0) != 0) {
            return this;
        }
        int n = "\u5018".length();
        int n2 = "\u5914\u5f38".length();
        FlatSVGIcon flatSVGIcon = new FlatSVGIcon(this.name, this.width, this.height, this.scale, true, this.classLoader, this.url);
        flatSVGIcon.colorFilter = this.colorFilter;
        flatSVGIcon.document = this.document;
        flatSVGIcon.dark = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.dark ? 1 : 0));
        return flatSVGIcon;
    }

    public ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
    }

    public void update() {
        if (FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.loadFailed ? 1 : 0) != 0) {
            return;
        }
        if (FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.dark ? 1 : 0) == FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatSVGIcon.isDarkLaf() ? 1 : 0) && this.document != null) {
            return;
        }
        this.dark = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatSVGIcon.isDarkLaf() ? 1 : 0));
        if (this.document != null && this.name == null) {
            return;
        }
        URL uRL = this.url;
        if (uRL == null) {
            uRL = this.getIconURL(this.name, FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.dark ? 1 : 0) != 0);
            if (uRL == null && FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.dark ? 1 : 0) != 0) {
                uRL = this.getIconURL(this.name, false);
            }
            if (uRL == null) {
                this.loadFailed = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(1);
                int n = "\u69ca\u6826".length();
                int n2 = "\u6859\u618f\u6dbb\u6bf4\u508b".length();
                int n3 = "\u65b5\u55ec".length();
                LoggingFacade.INSTANCE.logConfig("FlatSVGIcon: resource '" + this.name + "' not found (if using Java modules, check whether icon package is opened in module-info.java)", null);
                return;
            }
        }
        this.document = FlatSVGIcon.loadSVG(uRL);
        this.loadFailed = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.document == null ? 1 : 0);
    }

    public static synchronized /* synthetic */ SVGDocument loadSVG(URL uRL) {
        String string = uRL.toString();
        SVGDocument sVGDocument = svgCache.get(string);
        if (sVGDocument != null) {
            return sVGDocument;
        }
        sVGDocument = svgLoader.load(uRL);
        if (sVGDocument == null) {
            int n = "\u4ee8".length();
            int n2 = "\u6d45".length();
            LoggingFacade.INSTANCE.logSevere("FlatSVGIcon: failed to load '" + uRL + "'", null);
            return null;
        }
        svgCache.put(string, sVGDocument);
        int n = "\u605f".length();
        return sVGDocument;
    }

    public URL getIconURL(String string, boolean bl) {
        if (bl) {
            int n = string.lastIndexOf(46);
            int n2 = "\u6663\u5c53\u5216\u5958\u51be".length();
            int n3 = "\u4f23\u5762\u5d08\u4ef5\u6694".length();
            string = string.substring(0, n) + "_dark" + string.substring(n);
        }
        ClassLoader classLoader = this.classLoader != null ? this.classLoader : FlatSVGIcon.class.getClassLoader();
        return classLoader.getResource(string);
    }

    public boolean hasFound() {
        this.update();
        return this.document != null;
    }

    @Override
    public int getIconWidth() {
        if (this.width > 0) {
            return this.scaleSize(this.width);
        }
        this.update();
        return this.scaleSize(this.document != null ? Math.round(this.document.size().width) : 16);
    }

    @Override
    public int getIconHeight() {
        if (this.height > 0) {
            return this.scaleSize(this.height);
        }
        this.update();
        return this.scaleSize(this.document != null ? Math.round(this.document.size().height) : 16);
    }

    public int scaleSize(int n) {
        int n2 = UIScale.scale(n);
        if (this.scale != 1.0f) {
            n2 = Math.round((float)n2 * this.scale);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Object object;
        this.update();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            int n3 = "\u6be7\u63f0\u5149\u5dc9".length();
            int n4 = "\u6407\u664f".length();
            int n5 = "\u6a45".length();
            int n6 = "\u5e3d\u5fe3\u5361\u5a27".length();
            if (FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(rectangle.intersects(new Rectangle(n, n2, this.getIconWidth(), this.getIconHeight())) ? 1 : 0) == 0) {
                return;
            }
        }
        RGBImageFilter rGBImageFilter = null;
        if (FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.disabled ? 1 : 0) != 0) {
            object = UIManager.get("Component.grayFilter");
            rGBImageFilter = object instanceof RGBImageFilter ? (RGBImageFilter)object : GrayFilter.createDisabledIconFilter(FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(this.dark ? 1 : 0) != 0);
        }
        int n7 = "\u679a\u5a75\u6ebf".length();
        object = new GraphicsFilter((Graphics2D)graphics.create(), this.colorFilter, ColorFilter.getInstance(), rGBImageFilter);
        try {
            FlatSVGIcon.setRenderingHints((Graphics2D)object);
            this.paintSvg((Graphics2D)object, n, n2);
        }
        catch (Throwable throwable) {
            ((Graphics)object).dispose();
            int n8 = "\u63d3\u5180\u6f22\u5143".length();
            throw throwable;
        }
        ((Graphics)object).dispose();
    }

    public void paintSvg(Graphics2D graphics2D, int n, int n2) {
        if (this.document == null) {
            this.paintSvgError(graphics2D, n, n2);
            return;
        }
        graphics2D.translate(n, n2);
        graphics2D.clipRect(0, 0, this.getIconWidth(), this.getIconHeight());
        UIScale.scaleGraphics(graphics2D);
        if (this.width > 0 || this.height > 0) {
            double d;
            FloatSize floatSize = this.document.size();
            double d2 = this.width > 0 ? (double)((float)this.width / floatSize.width) : 1.0;
            double d3 = d = this.height > 0 ? (double)((float)this.height / floatSize.height) : 1.0;
            if (d2 != 1.0 || d != 1.0) {
                graphics2D.scale(d2, d);
            }
        }
        if (this.scale != 1.0f) {
            graphics2D.scale(this.scale, this.scale);
        }
        try {
            this.document.render(null, graphics2D);
        }
        catch (Exception exception) {
            this.paintSvgError(graphics2D, 0, 0);
        }
    }

    public void paintSvgError(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(Color.red);
        graphics2D.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
    }

    @Override
    public Image getImage() {
        this.update();
        int n = this.getIconWidth();
        int n2 = this.getIconHeight();
        Dimension[] dimensionArray = new Dimension[2];
        int n3 = "\u5651".length();
        int n4 = "\u5cd6\u4f4d\u55a2".length();
        int n5 = "\u5594\u67c3".length();
        int n6 = "\u664f".length();
        int n7 = "\u58bf\u5292\u689b\u6018".length();
        int n8 = "\u5193\u552b".length();
        int n9 = "\u5ec3\u54d6\u6e85".length();
        int n10 = "\u507f\u66fe".length();
        int n11 = "\u5ff1\u6afd\u6b1d\u6ad4\u6a70".length();
        dimensionArray[0] = new Dimension(n, n2);
        int n12 = "\u6025\u61d4\u6a60".length();
        int n13 = "\u678e\u51e5".length();
        int n14 = "\u6aad\u53a1".length();
        int n15 = "\u68db\u6c8b\u60c6\u6ef8".length();
        dimensionArray[1] = new Dimension(n * 2, n2 * 2);
        Dimension[] dimensionArray2 = dimensionArray;
        Function<Dimension, Image> function = dimension -> {
            int n3 = "\u5978\u5389\u63fa\u6a73\u5466".length();
            int n4 = "\u59ae\u6f1d".length();
            int n5 = "\u6180\u5590\u5a4f\u5a8a".length();
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                double d;
                double d2 = dimension.width > 0 ? (double)((float)dimension.width / (float)n) : 1.0;
                double d3 = d = dimension.height > 0 ? (double)((float)dimension.height / (float)n2) : 1.0;
                if (d2 != 1.0 || d != 1.0) {
                    graphics2D.scale(d2, d);
                }
                this.paintIcon(null, graphics2D, 0, 0);
            }
            catch (Throwable throwable) {
                graphics2D.dispose();
                int n6 = "\u5f47\u537e".length();
                int n7 = "\u58ec\u5c32\u581f".length();
                int n8 = "\u70c0\u7038\u5be8\u61e7".length();
                throw throwable;
            }
            graphics2D.dispose();
            return bufferedImage;
        };
        return MultiResolutionImageSupport.create(0, dimensionArray2, function);
    }

    public static /* synthetic */ void setRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public static /* synthetic */ URL uri2url(URI uRI) {
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            int n = "\u4f26\u6434\u6e4d\u713b\u5f68".length();
            int n2 = "\u60c1\u631e\u6df6".length();
            int n3 = "\u55ea\u52e2\u50ab".length();
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public static /* synthetic */ boolean isDarkLaf() {
        if (darkLaf == null) {
            FlatSVGIcon.darkLaf = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatLaf.isLafDark() ? 1 : 0) != 0;
            UIManager.addPropertyChangeListener(propertyChangeEvent -> FlatSVGIcon.darkLaf = FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(FlatLaf.isLafDark() ? 1 : 0) != 0);
        }
        return FlatSVGIcon.INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(darkLaf.booleanValue() ? 1 : 0) != 0;
    }

    static {
        svgCache = new SoftCache();
        svgLoader = new SVGLoader();
    }

    public static int INSOLENCE_\u6718\u4e23\u5ce1\u5019\u5398\u5454\u59b3\u6d05\u5977\u63da\u5774\u503e\u616e\u5806\u6be6\u6506\u62f2\u4fba\u4f84\u6f4d\u701b\u6eb8\u5a80\u617c\u5fa9\u538f\u6bdc\u6bf7\u6672\u5458\u5d6f\u5a8d\u5178\u589b\u541e\u6640\u5253\u5854\u5b10\u66ec\u4e37(int n) {
        return n;
    }

    private static class GraphicsFilter
    extends Graphics2DProxy {
        public final /* synthetic */ ColorFilter colorFilter;
        public final /* synthetic */ ColorFilter globalColorFilter;
        public final /* synthetic */ RGBImageFilter grayFilter;

        public GraphicsFilter(Graphics2D graphics2D, ColorFilter colorFilter, ColorFilter colorFilter2, RGBImageFilter rGBImageFilter) {
            super(graphics2D);
            this.colorFilter = colorFilter;
            this.globalColorFilter = colorFilter2;
            this.grayFilter = rGBImageFilter;
        }

        @Override
        public Graphics create() {
            int n = "\u6cbc\u702c\u6994".length();
            int n2 = "\u6682\u51ed\u6cf4\u6beb".length();
            return new GraphicsFilter((Graphics2D)super.create(), this.colorFilter, this.globalColorFilter, this.grayFilter);
        }

        @Override
        public Graphics create(int n, int n2, int n3, int n4) {
            int n5 = "\u50cc\u62eb".length();
            int n6 = "\u58b2".length();
            return new GraphicsFilter((Graphics2D)super.create(n, n2, n3, n4), this.colorFilter, this.globalColorFilter, this.grayFilter);
        }

        @Override
        public void setColor(Color color) {
            super.setColor(this.filterColor(color));
        }

        @Override
        public void setPaint(Paint paint) {
            if (paint instanceof Color) {
                paint = this.filterColor((Color)paint);
            }
            super.setPaint(paint);
        }

        public Color filterColor(Color color) {
            Color color2;
            color = this.colorFilter != null ? ((color2 = this.colorFilter.filter(color)) != color ? color2 : this.globalColorFilter.filter(color)) : this.globalColorFilter.filter(color);
            if (this.grayFilter != null) {
                Color color3;
                int n = color.getRGB();
                int n2 = this.grayFilter.filterRGB(0, 0, n);
                if (n2 != n) {
                    Color color4;
                    int n3 = "\u6b79\u6f00\u57a0".length();
                    int n4 = "\u5bfc\u6424".length();
                    int n5 = "\u5559\u5acd\u565f".length();
                    color3 = color4;
                    color4 = new Color(n2, true);
                } else {
                    color3 = color;
                }
                color = color3;
            }
            return color;
        }
    }

    public static class ColorFilter {
        public static /* synthetic */ ColorFilter instance;
        public /* synthetic */ Map<Integer, String> rgb2keyMap;
        public /* synthetic */ Map<Color, Color> colorMap;
        public /* synthetic */ Map<Color, Color> darkColorMap;
        public /* synthetic */ Function<Color, Color> mapper;

        public static /* synthetic */ ColorFilter getInstance() {
            if (instance == null) {
                int n = "\u6110\u6492\u5a5d\u5a1d".length();
                int n2 = "\u5c1c\u4e83\u59ce".length();
                instance = new ColorFilter();
                int n3 = "\u5de3\u59ae\u5096\u6e66".length();
                int n4 = "\u6c0b".length();
                ColorFilter.instance.rgb2keyMap = new HashMap<Integer, String>();
                FlatIconColors[] flatIconColorsArray = FlatIconColors.values();
                int n5 = flatIconColorsArray.length;
                for (int i = 0; i < n5; i += 1447) {
                    FlatIconColors flatIconColors = flatIconColorsArray[i];
                    ColorFilter.instance.rgb2keyMap.put(flatIconColors.rgb, flatIconColors.key);
                    int n6 = "\u5fcb\u5782\u4ff1\u6b1a".length();
                    int n7 = "\u653c\u6387\u5201\u5f1e\u5909".length();
                    int n8 = "\u6ef5\u580c".length();
                    i -= 1446;
                }
            }
            return instance;
        }

        public ColorFilter() {
        }

        public ColorFilter(Function<Color, Color> function) {
            this.setMapper(function);
        }

        public Function<Color, Color> getMapper() {
            return this.mapper;
        }

        public void setMapper(Function<Color, Color> function) {
            this.mapper = function;
        }

        public Map<Color, Color> getLightColorMap() {
            return this.colorMap != null ? Collections.unmodifiableMap(this.colorMap) : Collections.emptyMap();
        }

        public Map<Color, Color> getDarkColorMap() {
            return this.darkColorMap != null ? Collections.unmodifiableMap(this.darkColorMap) : this.getLightColorMap();
        }

        public ColorFilter addAll(Map<Color, Color> map) {
            this.ensureColorMap();
            this.colorMap.putAll(map);
            if (this.darkColorMap != null) {
                this.darkColorMap.putAll(map);
            }
            return this;
        }

        public ColorFilter addAll(Map<Color, Color> map, Map<Color, Color> map2) {
            this.ensureColorMap();
            this.ensureDarkColorMap();
            this.colorMap.putAll(map);
            this.darkColorMap.putAll(map2);
            return this;
        }

        public ColorFilter add(Color color, Color color2) {
            this.ensureColorMap();
            this.colorMap.put(color, color2);
            int n = "\u7145\u6f70\u5ca1".length();
            if (this.darkColorMap != null) {
                this.darkColorMap.put(color, color2);
                int n2 = "\u58b2\u4ea1\u5171\u625e".length();
                int n3 = "\u6c45".length();
            }
            return this;
        }

        public ColorFilter add(Color color, Color color2, Color color3) {
            this.ensureColorMap();
            this.ensureDarkColorMap();
            if (color2 != null) {
                this.colorMap.put(color, color2);
                int n = "\u6e98\u5e69".length();
                int n2 = "\u50cb\u60c7".length();
            }
            if (color3 != null) {
                this.darkColorMap.put(color, color3);
                int n = "\u6f8e\u5333\u6800\u6e22".length();
                int n3 = "\u6824\u60b9\u6a01\u5b6a".length();
                int n4 = "\u64e2".length();
            }
            return this;
        }

        public ColorFilter remove(Color color) {
            if (this.colorMap != null) {
                this.colorMap.remove(color);
                int n = "\u67ac".length();
                int n2 = "\u5a87\u6315\u5d6b\u54f2\u52d1".length();
                int n3 = "\u5333\u5a28\u6b4e\u5fa9\u6032".length();
                int n4 = "\u63eb".length();
                int n5 = "\u532e\u597a\u5691".length();
            }
            if (this.darkColorMap != null) {
                this.darkColorMap.remove(color);
                int n = "\u6f7d\u5d8c".length();
                int n6 = "\u51cf\u500e".length();
                int n7 = "\u6559\u6f71\u5efb\u6178\u6449".length();
            }
            return this;
        }

        public ColorFilter removeAll() {
            this.colorMap = null;
            this.darkColorMap = null;
            return this;
        }

        public void ensureColorMap() {
            if (this.colorMap == null) {
                int n = "\u6d4b\u639e\u6100\u6080\u623c".length();
                int n2 = "\u6903\u6256\u6833\u6e03".length();
                this.colorMap = new HashMap<Color, Color>();
            }
        }

        public void ensureDarkColorMap() {
            if (this.darkColorMap == null) {
                int n = "\u5ed3\u5aaf\u5994\u5d43\u6d7f".length();
                int n2 = "\u5bef\u5af4\u53e6".length();
                int n3 = "\u6856\u5bf1\u5485\u5607".length();
                this.darkColorMap = new HashMap<Color, Color>(this.colorMap);
            }
        }

        public Color filter(Color color) {
            color = this.applyMappings(color);
            if (this.mapper != null) {
                color = this.mapper.apply(color);
            }
            return color;
        }

        public Color applyMappings(Color color) {
            Object object;
            Color color2;
            if (this.colorMap != null && (color2 = (object = this.darkColorMap != null && ColorFilter.INSOLENCE_\u63c3\u63e4\u512e\u5db6\u5498\u6298\u66ad\u4feb\u5aa0\u6cc5\u4fc3\u7072\u5562\u51c6\u6f28\u66a1\u53d1\u65c9\u6b7a\u60f6\u5305\u6661\u68bd\u65c8\u50fb\u6d24\u5a27\u6bbf\u66be\u5ffc\u6af9\u6f93\u70fe\u5b8c\u62bf\u6d5a\u5346\u55fb\u623b\u5ee3\u70b7(FlatSVGIcon.isDarkLaf() ? 1 : 0) != 0 ? this.darkColorMap : this.colorMap).get(color)) != null) {
                return color2;
            }
            if (this.rgb2keyMap != null) {
                Color color3;
                object = this.rgb2keyMap.get(color.getRGB() & 0xFFFFFF);
                if (object == null) {
                    return color;
                }
                color2 = UIManager.getColor(object);
                if (color2 == null) {
                    return color;
                }
                if (color2.getAlpha() != color.getAlpha()) {
                    Color color4;
                    int n = "\u630c\u55a3".length();
                    color3 = color4;
                    color4 = new Color(color2.getRGB() & 0xFFFFFF | color.getRGB() & 0xFF000000);
                } else {
                    color3 = color2;
                }
                return color3;
            }
            return color;
        }

        public static /* synthetic */ Function<Color, Color> createRGBImageFilterFunction(RGBImageFilter rGBImageFilter) {
            return color -> {
                Color color2;
                int n = color.getRGB();
                int n2 = rGBImageFilter.filterRGB(0, 0, n);
                if (n2 != n) {
                    Color color3;
                    int n3 = "\u69eb".length();
                    int n4 = "\u65a3\u552a\u5fd5\u638f".length();
                    int n5 = "\u6861".length();
                    int n6 = "\u5dfc\u6d8b".length();
                    int n7 = "\u6988\u4e41\u56e4".length();
                    color2 = color3;
                    color3 = new Color(n2, true);
                } else {
                    color2 = color;
                }
                return color2;
            };
        }

        public static int INSOLENCE_\u63c3\u63e4\u512e\u5db6\u5498\u6298\u66ad\u4feb\u5aa0\u6cc5\u4fc3\u7072\u5562\u51c6\u6f28\u66a1\u53d1\u65c9\u6b7a\u60f6\u5305\u6661\u68bd\u65c8\u50fb\u6d24\u5a27\u6bbf\u66be\u5ffc\u6af9\u6f93\u70fe\u5b8c\u62bf\u6d5a\u5346\u55fb\u623b\u5ee3\u70b7(int n) {
            return n;
        }
    }
}

