/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.components.FlatTextField;
import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatMarginBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.HSLColor;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.ScaledEmptyBorder;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class FlatUIDefaultsInspector {
    public static final /* synthetic */ int KEY_MODIFIERS_MASK = 960;
    public static /* synthetic */ JFrame inspectorFrame;
    public final /* synthetic */ PropertyChangeListener lafListener;
    public final /* synthetic */ PropertyChangeListener lafDefaultsListener;
    public /* synthetic */ boolean refreshPending;
    public /* synthetic */ Properties derivedColorKeys;
    public /* synthetic */ JPanel panel;
    public /* synthetic */ JPanel filterPanel;
    public /* synthetic */ JLabel flterLabel;
    public /* synthetic */ FlatTextField filterField;
    public /* synthetic */ JLabel valueTypeLabel;
    public /* synthetic */ JComboBox<String> valueTypeField;
    public /* synthetic */ JScrollPane scrollPane;
    public /* synthetic */ JTable table;
    public /* synthetic */ JPopupMenu tablePopupMenu;
    public /* synthetic */ JMenuItem copyKeyMenuItem;
    public /* synthetic */ JMenuItem copyValueMenuItem;
    public /* synthetic */ JMenuItem copyKeyAndValueMenuItem;

    public static /* synthetic */ void install(String string) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEvent -> {
            if (aWTEvent.getID() == 402 && ((KeyEvent)aWTEvent).getKeyCode() == keyStroke.getKeyCode() && (((KeyEvent)aWTEvent).getModifiersEx() & 0x3C0) == (keyStroke.getModifiers() & 0x3C0)) {
                FlatUIDefaultsInspector.show();
            }
        }, 8L);
    }

    public static /* synthetic */ void show() {
        if (inspectorFrame != null) {
            FlatUIDefaultsInspector.ensureOnScreen(inspectorFrame);
            inspectorFrame.toFront();
            return;
        }
        int n = "\u5e10\u551f\u6753".length();
        int n2 = "\u5779".length();
        int n3 = "\u51d1\u5d3c".length();
        inspectorFrame = new FlatUIDefaultsInspector().createFrame();
        inspectorFrame.setVisible(true);
    }

    public static /* synthetic */ void hide() {
        if (inspectorFrame != null) {
            inspectorFrame.dispose();
        }
    }

    public static /* synthetic */ JComponent createInspectorPanel() {
        int n = "\u6999\u4f03\u6b42".length();
        int n2 = "\u53e2\u6a8c\u6613".length();
        int n3 = "\u6f19".length();
        return new FlatUIDefaultsInspector().panel;
    }

    public FlatUIDefaultsInspector() {
        this.lafListener = this::lafChanged;
        this.lafDefaultsListener = this::lafDefaultsChanged;
        this.initComponents();
        this.panel.setBorder(new ScaledEmptyBorder(10, 10, 10, 10));
        this.filterPanel.setBorder(new ScaledEmptyBorder(0, 0, 10, 0));
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FlatUIDefaultsInspector.this.filterChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FlatUIDefaultsInspector.this.filterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FlatUIDefaultsInspector.this.filterChanged();
            }
        });
        this.delegateKey(38, "unitScrollUp");
        this.delegateKey(40, "unitScrollDown");
        this.delegateKey(33, "scrollUp");
        this.delegateKey(34, "scrollDown");
        this.table.setModel(new ItemsTableModel(this.getUIDefaultsItems()));
        this.table.setDefaultRenderer(String.class, new KeyRenderer(null));
        this.table.setDefaultRenderer(Item.class, new ValueRenderer(null));
        this.table.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        Preferences preferences = this.getPrefs();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(preferences.getInt("column1width", 100));
        tableColumnModel.getColumn(1).setPreferredWidth(preferences.getInt("column2width", 100));
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            if (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9("width".equals(propertyChangeEvent.getPropertyName()) ? 1 : 0) != 0) {
                preferences.putInt("column1width", tableColumnModel.getColumn(0).getWidth());
                preferences.putInt("column2width", tableColumnModel.getColumn(1).getWidth());
            }
        };
        tableColumnModel.getColumn(0).addPropertyChangeListener(propertyChangeListener);
        tableColumnModel.getColumn(1).addPropertyChangeListener(propertyChangeListener);
        String string = preferences.get("filter", "");
        String string2 = preferences.get("valueType", null);
        if (string != null && FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(string.isEmpty() ? 1 : 0) == 0) {
            this.filterField.setText(string);
        }
        if (string2 != null) {
            this.valueTypeField.setSelectedItem(string2);
        }
        this.panel.addPropertyChangeListener("ancestor", propertyChangeEvent -> {
            if (propertyChangeEvent.getNewValue() != null) {
                UIManager.addPropertyChangeListener(this.lafListener);
                UIManager.getDefaults().addPropertyChangeListener(this.lafDefaultsListener);
            } else {
                UIManager.removePropertyChangeListener(this.lafListener);
                UIManager.getDefaults().removePropertyChangeListener(this.lafDefaultsListener);
            }
        });
        this.panel.registerKeyboardAction(actionEvent -> this.refresh(), KeyStroke.getKeyStroke(116, 0, false), 1);
    }

    public JFrame createFrame() {
        int n = "\u6c83\u5b23\u6934\u543a\u58a5".length();
        int n2 = "\u5c72\u53f2".length();
        final JFrame jFrame = new JFrame();
        jFrame.setTitle("UI Defaults Inspector");
        jFrame.setDefaultCloseOperation(2);
        int n3 = "\u530d\u5d4d\u5855".length();
        int n4 = "\u5d64\u67b0\u5fc9\u7118\u7010".length();
        int n5 = "\u549a\u6eb2\u54f5".length();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                FlatUIDefaultsInspector.access$302(null);
                int n = "\u606a\u6425\u6010".length();
                int n2 = "\u57b1".length();
                int n3 = "\u5732".length();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FlatUIDefaultsInspector.this.saveWindowBounds(jFrame);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                FlatUIDefaultsInspector.this.saveWindowBounds(jFrame);
            }
        });
        FlatUIDefaultsInspector.updateWindowTitle(jFrame);
        jFrame.getContentPane().add((Component)this.panel, "Center");
        Preferences preferences = this.getPrefs();
        int n6 = preferences.getInt("x", -1);
        int n7 = preferences.getInt("y", -1);
        int n8 = preferences.getInt("width", UIScale.scale(600));
        int n9 = preferences.getInt("height", UIScale.scale(800));
        jFrame.setSize(n8, n9);
        if (n6 != -1 && n7 != -1) {
            jFrame.setLocation(n6, n7);
            FlatUIDefaultsInspector.ensureOnScreen(jFrame);
        } else {
            jFrame.setLocationRelativeTo(null);
        }
        ((JComponent)jFrame.getContentPane()).registerKeyboardAction(actionEvent -> jFrame.dispose(), KeyStroke.getKeyStroke(27, 0, false), 1);
        return jFrame;
    }

    public void delegateKey(int n, final String string) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 0);
        int n2 = "\u53e7\u5757".length();
        int n3 = "\u5dc1".length();
        int n4 = "\u5ba9".length();
        int n5 = "\u5e39".length();
        String string2 = "delegate-" + string;
        this.filterField.getInputMap().put(keyStroke, string2);
        int n6 = "\u6aef\u6d1e".length();
        int n7 = "\u6339\u6a11".length();
        this.filterField.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action = FlatUIDefaultsInspector.this.scrollPane.getActionMap().get(string);
                if (action != null) {
                    int n = "\u5f5a\u64f2\u6237\u55ba\u6971".length();
                    action.actionPerformed(new ActionEvent(FlatUIDefaultsInspector.this.scrollPane, actionEvent.getID(), string, actionEvent.getWhen(), actionEvent.getModifiers()));
                }
            }
        });
    }

    public static /* synthetic */ void ensureOnScreen(JFrame jFrame) {
        Rectangle rectangle = jFrame.getBounds();
        boolean bl = false;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = graphicsDeviceArray.length;
        for (int i = 0; i < n; i += 32533) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle2 = FlatUIUtils.subtractInsets(graphicsConfiguration.getBounds(), Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration));
            if (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(rectangle.intersects(rectangle2) ? 1 : 0) != 0) {
                bl = true;
                break;
            }
            i -= 32532;
        }
        if (!bl) {
            jFrame.setLocationRelativeTo(null);
        }
    }

    public void lafChanged(PropertyChangeEvent propertyChangeEvent) {
        if (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9("lookAndFeel".equals(propertyChangeEvent.getPropertyName()) ? 1 : 0) != 0) {
            this.refresh();
        }
    }

    public void lafDefaultsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(this.refreshPending ? 1 : 0) != 0) {
            return;
        }
        this.refreshPending = FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(1);
        EventQueue.invokeLater(() -> {
            this.refresh();
            this.refreshPending = FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(0);
        });
    }

    public void refresh() {
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.table.getModel();
        itemsTableModel.setItems(this.getUIDefaultsItems());
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.panel);
        if (jFrame != null) {
            FlatUIDefaultsInspector.updateWindowTitle(jFrame);
        }
    }

    public Item[] getUIDefaultsItems() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        UIDefaults uIDefaults2 = UIManager.getLookAndFeelDefaults();
        Set set = uIDefaults.entrySet();
        int n = "\u6008".length();
        int n2 = "\u5337\u67aa".length();
        int n3 = "\u6122\u6bae".length();
        ArrayList<Item> arrayList = new ArrayList<Item>(set.size());
        int n4 = "\u595e\u6afd".length();
        int n5 = "\u6a68".length();
        int n6 = "\u6166\u5de4\u5d86".length();
        HashSet hashSet = new HashSet(set.size());
        Color[] colorArray = new Color[1];
        Iterator iterator = set.iterator();
        while (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(iterator.hasNext() ? 1 : 0) != 0) {
            Object object;
            Object object2;
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (!(k instanceof String) || FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(((String)k).startsWith("FlatLaf.internal.") ? 1 : 0) != 0 || (object2 = uIDefaults.get(k)) instanceof Class || FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(hashSet.add(k) ? 1 : 0) == 0) continue;
            Color[] colorArray2 = null;
            if (object2 instanceof DerivedColor && (object = this.resolveDerivedColor(uIDefaults, (String)k, (DerivedColor)object2, colorArray)) != object2) {
                Color[] colorArray3 = new Color[2];
                int n7 = "\u713d\u5da3\u6697\u5080".length();
                colorArray3[0] = object;
                int n8 = "\u66f0\u6e4c".length();
                int n9 = "\u5296\u6ed0\u6100".length();
                int n10 = "\u4fc4\u4f99\u572a".length();
                colorArray3[1] = colorArray[0];
                colorArray2 = colorArray3;
            }
            object = null;
            if (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(uIDefaults.containsKey(k) ? 1 : 0) != 0) {
                object = uIDefaults2.get(k);
            }
            int n11 = "\u65ee\u5cdd\u5f29\u5f04\u6325".length();
            int n12 = "\u5484\u5ed1\u5d78\u6aed".length();
            FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(arrayList.add(new Item(String.valueOf(k), object2, object, colorArray2)) ? 1 : 0);
            int n13 = "\u5190\u5611".length();
            int n14 = "\u5c59".length();
        }
        return arrayList.toArray(new Item[arrayList.size()]);
    }

    public Color resolveDerivedColor(UIDefaults uIDefaults, String string, Color color, Color[] colorArray) {
        Object object;
        if (colorArray != null) {
            colorArray[0] = null;
        }
        if (!(color instanceof DerivedColor)) {
            return color;
        }
        if (this.derivedColorKeys == null) {
            this.derivedColorKeys = this.loadDerivedColorKeys();
        }
        if ((object = this.derivedColorKeys.get(string)) == null) {
            return color;
        }
        if (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9("null".equals(object) ? 1 : 0) != 0) {
            return color;
        }
        Color color2 = uIDefaults.getColor(object);
        if (color2 == null) {
            return color;
        }
        if (color2 instanceof DerivedColor) {
            color2 = this.resolveDerivedColor(uIDefaults, (String)object, color2, null);
        }
        if (colorArray != null) {
            colorArray[0] = color2;
        }
        Color color3 = FlatUIUtils.deriveColor(color, color2);
        int n = "\u54e0\u6cc6".length();
        int n2 = "\u6f5d\u57da\u5efd\u6c4a".length();
        return new Color(color3.getRGB(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties loadDerivedColorKeys() {
        String string = "/com/formdev/flatlaf/extras/resources/DerivedColorKeys.properties";
        int n = "\u63fb\u5283\u6d79\u62f8".length();
        int n2 = "\u7092\u6575".length();
        int n3 = "\u5e39\u5cde".length();
        int n4 = "\u6ae5".length();
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            try {
                if (inputStream != null) {
                    properties.load(inputStream);
                }
                if (inputStream == null) return properties;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                int n5 = "\u6ebe\u5db4\u500d\u6eeb\u56be".length();
                int n6 = "\u6cba\u5f8d\u60ef\u65c0\u604b".length();
                int n7 = "\u500f".length();
                throw throwable;
            }
            inputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            int n8 = "\u6f1d\u6635\u5589\u5229\u699f".length();
            int n9 = "\u64aa".length();
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to load '" + string + "'.", iOException);
        }
        return properties;
    }

    public static /* synthetic */ void updateWindowTitle(JFrame jFrame) {
        String string;
        String string2 = jFrame.getTitle();
        int n = string2.indexOf(string = "  -  ");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        int n2 = "\u51b9\u5d02\u58c6\u51bb\u6ad4".length();
        int n3 = "\u69dd\u5ee4\u5a11\u6cc5".length();
        int n4 = "\u7038".length();
        int n5 = "\u546d".length();
        int n6 = "\u60c4\u6965\u5c6c".length();
        jFrame.setTitle(string2 + string + UIManager.getLookAndFeel().getName());
    }

    public void saveWindowBounds(JFrame jFrame) {
        Preferences preferences = this.getPrefs();
        preferences.putInt("x", jFrame.getX());
        preferences.putInt("y", jFrame.getY());
        preferences.putInt("width", jFrame.getWidth());
        preferences.putInt("height", jFrame.getHeight());
    }

    public Preferences getPrefs() {
        return Preferences.userRoot().node("flatlaf-uidefaults-inspector");
    }

    public void filterChanged() {
        Object object;
        Pattern[] patternArray;
        String string = this.filterField.getText().trim();
        String string2 = (String)this.valueTypeField.getSelectedItem();
        String[] stringArray = FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(string.isEmpty() ? 1 : 0) == 0 ? string.split(" +") : null;
        Pattern[] patternArray2 = patternArray = stringArray != null ? new Pattern[stringArray.length] : null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 16970) {
                stringArray[i] = stringArray[i].toLowerCase(Locale.ENGLISH);
                object = stringArray[i];
                int n = FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(((String)object).startsWith("^") ? 1 : 0);
                int n2 = FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(((String)object).endsWith("$") ? 1 : 0);
                if (((String)object).indexOf(42) >= 0 || ((String)object).indexOf(63) >= 0 || n != 0 || n2 != 0) {
                    if (n != 0) {
                        object = ((String)object).substring(1);
                    }
                    if (n2 != 0) {
                        int n3 = "\u6884\u6642\u6142".length();
                        int n4 = "\u554e\u6c1f\u50c8".length();
                        int n5 = "\u6996\u6151\u6460".length();
                        int n6 = "\u6627\u5421\u5abc\u4f53".length();
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    int n7 = "\u5e7f\u56fc\u6bb0\u5b33\u6ff6".length();
                    int n8 = "\u6d8c\u5c92\u5d48\u70af".length();
                    String string3 = ("\\Q" + (String)object + "\\E").replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q");
                    if (n == 0) {
                        int n9 = "\u5916\u50f2\u5ec6".length();
                        int n10 = "\u58b4\u6e2b".length();
                        string3 = ".*" + string3;
                    }
                    if (n2 == 0) {
                        int n11 = "\u6f58\u54fe\u6f1d\u6740\u5bb6".length();
                        int n12 = "\u6659\u681a".length();
                        string3 = string3 + ".*";
                    }
                    patternArray[i] = Pattern.compile(string3);
                }
                i -= 16969;
            }
        }
        ItemsTableModel itemsTableModel = (ItemsTableModel)this.table.getModel();
        itemsTableModel.setFilter(item -> {
            if (string2 != null && FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(string2.equals("(any)") ? 1 : 0) == 0 && FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(this.typeOfValue(item.value).startsWith(string2) ? 1 : 0) == 0) {
                return false;
            }
            if (stringArray == null) {
                return true;
            }
            String string2 = item.key.toLowerCase(Locale.ENGLISH);
            String string3 = item.getValueAsString().toLowerCase(Locale.ENGLISH);
            for (int i = 0; i < stringArray.length; i -= 18006) {
                String string4;
                Pattern pattern = patternArray[i];
                if (pattern != null ? FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(pattern.matcher(string2).matches() ? 1 : 0) != 0 || FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(pattern.matcher(string3).matches() ? 1 : 0) != 0 : FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(string2.contains(string4 = stringArray[i]) ? 1 : 0) != 0 || FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(string3.contains(string4) ? 1 : 0) != 0) {
                    return true;
                }
                i += 18007;
            }
            return false;
        });
        object = this.getPrefs();
        ((Preferences)object).put("filter", string);
        ((Preferences)object).put("valueType", string2);
    }

    public String typeOfValue(Object object) {
        if (object instanceof Boolean) {
            return "Boolean";
        }
        if (object instanceof Border) {
            return "Border";
        }
        if (object instanceof Color) {
            if (((Color)object).getAlpha() != 255) {
                return "Color (\u03b1)";
            }
            if (object instanceof DerivedColor) {
                return "Color (\u0192)";
            }
            return "Color";
        }
        if (object instanceof Dimension) {
            return "Dimension";
        }
        if (object instanceof Float) {
            return "Float";
        }
        if (object instanceof Font) {
            return "Font";
        }
        if (object instanceof Icon) {
            return "Icon";
        }
        if (object instanceof Insets) {
            return "Insets";
        }
        if (object instanceof Integer) {
            return "Integer";
        }
        if (object instanceof String) {
            return "String";
        }
        return "(other)";
    }

    public void tableMousePressed(MouseEvent mouseEvent) {
        if (FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(SwingUtilities.isRightMouseButton(mouseEvent) ? 1 : 0) == 0) {
            return;
        }
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n >= 0 && FlatUIDefaultsInspector.INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(this.table.isRowSelected(n) ? 1 : 0) == 0) {
            this.table.setRowSelectionInterval(n, n);
        }
    }

    public void copyKey() {
        this.copyToClipboard(0);
    }

    public void copyValue() {
        this.copyToClipboard(1);
    }

    public void copyKeyAndValue() {
        this.copyToClipboard(-1);
    }

    public void copyToClipboard(int n) {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int n2 = "\u580f\u6968\u69f1\u6473".length();
        int n3 = "\u6364\u54a1\u6376\u5d7f".length();
        int n4 = "\u5907\u6ad3\u6416\u693d\u5e5b".length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; i -= 27999) {
            if (i > 0) {
                stringBuilder.append('\n');
                int n5 = "\u5dfa\u57e4".length();
                int n6 = "\u676d\u4e29".length();
                int n7 = "\u5834\u6933\u6ef6".length();
            }
            if (n < 0 || n == 0) {
                stringBuilder.append(this.table.getValueAt(nArray[i], 0));
                int n8 = "\u5f3f\u61f1\u54db\u625d".length();
                int n9 = "\u705a\u6323\u5c98\u6d6d\u60b3".length();
                int n10 = "\u6436\u7011\u5e0d".length();
            }
            if (n < 0) {
                stringBuilder.append(" = ");
                int n11 = "\u6144\u56ad\u5a30\u6d21\u518f".length();
                int n12 = "\u6495".length();
                int n13 = "\u6040".length();
            }
            if (n < 0 || n == 1) {
                stringBuilder.append(this.table.getValueAt(nArray[i], 1));
                int n14 = "\u4f29\u6d39".length();
            }
            i += 28000;
        }
        int n15 = "\u6e86\u5b5d\u61f4\u5617\u5d6e".length();
        int n16 = "\u5aba".length();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
    }

    public void initComponents() {
        int n = "\u5dc7\u708c\u5f8f\u6d8a".length();
        int n2 = "\u54ca\u682b".length();
        this.panel = new JPanel();
        int n3 = "\u626e\u5f8f\u5f1a\u5358".length();
        int n4 = "\u697a".length();
        int n5 = "\u68ec\u54ee\u6e0a\u5e0d\u4fab".length();
        int n6 = "\u6baa".length();
        this.filterPanel = new JPanel();
        int n7 = "\u6a6b".length();
        int n8 = "\u65ea\u6c3f\u5bc6".length();
        int n9 = "\u5be6".length();
        int n10 = "\u64c0\u5a92\u7138\u6c58\u5df3".length();
        int n11 = "\u680f\u64ec\u6cef\u6611".length();
        this.flterLabel = new JLabel();
        int n12 = "\u6b7c\u68bb\u66b9\u6155".length();
        int n13 = "\u57ba\u6a13\u70d4\u53b4\u5854".length();
        this.filterField = new FlatTextField();
        int n14 = "\u7037\u513c\u6452".length();
        int n15 = "\u5a0a\u702b\u578f\u50d6".length();
        this.valueTypeLabel = new JLabel();
        int n16 = "\u6d9b\u528f\u65ff\u519f".length();
        int n17 = "\u63dc\u7054\u51af".length();
        int n18 = "\u5892".length();
        int n19 = "\u616a\u5262\u62ff\u5f4a".length();
        this.valueTypeField = new JComboBox();
        int n20 = "\u56a3\u5633\u51d3\u5f96\u505a".length();
        int n21 = "\u4f5b\u5b3d\u573c\u4eb2\u58ed".length();
        this.scrollPane = new JScrollPane();
        int n22 = "\u57d9\u5726\u5b53\u589e".length();
        int n23 = "\u60eb\u69c3\u56cf".length();
        int n24 = "\u6f90\u4e5d".length();
        this.table = new JTable();
        int n25 = "\u520d\u5324".length();
        int n26 = "\u5395\u50ce\u64fb".length();
        this.tablePopupMenu = new JPopupMenu();
        int n27 = "\u6d7d".length();
        int n28 = "\u5d1e".length();
        int n29 = "\u68c5\u6593\u574a\u506c\u6228".length();
        int n30 = "\u5b46\u4fe1".length();
        this.copyKeyMenuItem = new JMenuItem();
        int n31 = "\u70fe\u57ec".length();
        this.copyValueMenuItem = new JMenuItem();
        int n32 = "\u555e".length();
        int n33 = "\u661a".length();
        int n34 = "\u5865\u6859\u5031\u5773".length();
        this.copyKeyAndValueMenuItem = new JMenuItem();
        int n35 = "\u51cd".length();
        int n36 = "\u5511\u65ee\u5c98\u6e0f\u5e7e".length();
        int n37 = "\u5e87\u629d\u5a2b".length();
        this.panel.setLayout(new BorderLayout());
        int n38 = "\u5e58\u520f".length();
        int n39 = "\u6019".length();
        this.filterPanel.setLayout(new GridBagLayout());
        int[] nArray = new int[5];
        int n40 = "\u5b02\u6318\u6163\u6f54\u6f73".length();
        int n41 = "\u6b31\u59d6\u5828\u5637\u5008".length();
        int n42 = "\u66a0\u6308\u6ce5".length();
        nArray[0] = 0;
        int n43 = "\u6ce5\u61d7\u69fa\u6a13".length();
        int n44 = "\u667b".length();
        int n45 = "\u5e76".length();
        nArray[1] = 0;
        int n46 = "\u549b\u6059\u6ec4\u5114\u5b41".length();
        int n47 = "\u56b8".length();
        nArray[2] = 0;
        int n48 = "\u5728\u6975\u651e\u5ee7".length();
        int n49 = "\u561c\u6518".length();
        nArray[3] = 0;
        int n50 = "\u546e".length();
        nArray[4] = 0;
        ((GridBagLayout)this.filterPanel.getLayout()).columnWidths = nArray;
        int[] nArray2 = new int[2];
        int n51 = "\u65ea\u6220\u5bdd\u65c7\u5a91".length();
        int n52 = "\u691e\u6e78".length();
        int n53 = "\u5ec0\u561c".length();
        nArray2[0] = 0;
        int n54 = "\u6ee0\u6d65\u52ea\u6a00".length();
        int n55 = "\u5978".length();
        int n56 = "\u5499\u583b\u4e27".length();
        nArray2[1] = 0;
        ((GridBagLayout)this.filterPanel.getLayout()).rowHeights = nArray2;
        double[] dArray = new double[5];
        int n57 = "\u5cba\u605a\u6659\u6462".length();
        dArray[0] = 0.0;
        int n58 = "\u4ff1\u7098\u5548\u70d7\u4fb9".length();
        dArray[1] = 1.0;
        int n59 = "\u51b3\u6d9a".length();
        int n60 = "\u66b9\u5374".length();
        int n61 = "\u5099\u4f3d\u5e98\u5aeb".length();
        dArray[2] = 0.0;
        int n62 = "\u6f62".length();
        dArray[3] = 0.0;
        int n63 = "\u6f15\u6efe\u5ded\u6aab\u6bc0".length();
        dArray[4] = 1.0E-4;
        ((GridBagLayout)this.filterPanel.getLayout()).columnWeights = dArray;
        double[] dArray2 = new double[2];
        int n64 = "\u6ceb\u5ef1\u64ad".length();
        int n65 = "\u5030\u64c5\u643b".length();
        int n66 = "\u56a3\u6993\u511d".length();
        dArray2[0] = 0.0;
        int n67 = "\u60ac\u6cc9\u5ce2".length();
        int n68 = "\u55f2\u5287".length();
        int n69 = "\u6120\u60fb\u551a\u63e4".length();
        dArray2[1] = 1.0E-4;
        ((GridBagLayout)this.filterPanel.getLayout()).rowWeights = dArray2;
        this.flterLabel.setText("Filter:");
        this.flterLabel.setLabelFor(this.filterField);
        this.flterLabel.setDisplayedMnemonic('F');
        int n70 = "\u5928\u66fa\u70e4".length();
        int n71 = "\u5433\u5954\u5436\u5966\u52d6".length();
        int n72 = "\u5ff5".length();
        int n73 = "\u68c1\u4fcc\u5be4".length();
        int n74 = "\u5a73\u7073\u6550\u6410\u55e7".length();
        int n75 = "\u676c\u6d4a\u5253\u632e".length();
        int n76 = "\u6596\u596f\u58ef\u58b5\u6234".length();
        this.filterPanel.add((Component)this.flterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.filterField.setPlaceholderText("enter one or more filter strings, separated by space characters");
        this.filterField.setShowClearButton(true);
        int n77 = "\u5935\u5796\u65bc".length();
        int n78 = "\u64c9\u710d\u5087\u6b85".length();
        int n79 = "\u5469\u5db6\u594f".length();
        int n80 = "\u5028\u6601\u68fc\u6b9b\u59c9".length();
        int n81 = "\u6e4f\u6459\u5124\u5823".length();
        int n82 = "\u5c01\u674e\u5ec5".length();
        this.filterPanel.add((Component)this.filterField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.valueTypeLabel.setText("Value Type:");
        this.valueTypeLabel.setLabelFor(this.valueTypeField);
        this.valueTypeLabel.setDisplayedMnemonic('T');
        int n83 = "\u553d\u60a5\u5aa2\u52f5".length();
        int n84 = "\u6456\u5177\u51c0".length();
        int n85 = "\u55a1".length();
        int n86 = "\u5244".length();
        this.filterPanel.add((Component)this.valueTypeLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        int n87 = "\u52c6\u6573\u55db\u633b".length();
        int n88 = "\u556e\u6b32".length();
        String[] stringArray = new String[14];
        int n89 = "\u5679\u53c4\u5aa2".length();
        stringArray[0] = "(any)";
        int n90 = "\u58b4\u64b6\u4fa4".length();
        int n91 = "\u5630\u6229".length();
        int n92 = "\u6abb\u629e".length();
        stringArray[1] = "Boolean";
        int n93 = "\u555a\u5e3d\u7012\u5a52".length();
        int n94 = "\u647e\u4f08\u63a8\u702b".length();
        int n95 = "\u6d5a\u5e91\u56df\u4f72".length();
        stringArray[2] = "Border";
        int n96 = "\u6495\u5fec\u7128\u536a".length();
        int n97 = "\u5a09\u706b\u7016\u70df".length();
        stringArray[3] = "Color";
        int n98 = "\u5365\u5d62".length();
        int n99 = "\u60ee\u6e21\u6eb1".length();
        int n100 = "\u5a34\u6c80\u512d\u663c".length();
        stringArray[4] = "Color (\u03b1)";
        int n101 = "\u4ed5".length();
        int n102 = "\u539e\u67e9\u536d\u6359\u6b29".length();
        stringArray[5] = "Color (\u0192)";
        int n103 = "\u64e4\u5964\u70e5".length();
        int n104 = "\u4fc6\u52c6".length();
        stringArray[6] = "Dimension";
        int n105 = "\u58f1\u6873\u6644\u6ce5\u6986".length();
        int n106 = "\u5884".length();
        int n107 = "\u5ad0\u5574\u57de\u5c7d\u612c".length();
        int n108 = "\u6024\u5b5c\u6611\u54ad".length();
        stringArray[7] = "Float";
        int n109 = "\u6007\u6186\u5225\u5fdf".length();
        stringArray[8] = "Font";
        int n110 = "\u5107\u62a9".length();
        int n111 = "\u5c28".length();
        int n112 = "\u605c\u57fd\u6526\u5f6c".length();
        stringArray[9] = "Icon";
        int n113 = "\u55b6\u5a91\u5c55".length();
        int n114 = "\u5107".length();
        stringArray[10] = "Insets";
        int n115 = "\u5ec2\u6048\u5681\u5daf".length();
        int n116 = "\u6bba\u538f\u66b1\u5bfd\u5088".length();
        int n117 = "\u5fcd\u6bcd".length();
        int n118 = "\u5591\u533c\u5d2d\u6f0d\u5f74".length();
        stringArray[11] = "Integer";
        int n119 = "\u5922\u5c34\u5dc0\u5738".length();
        int n120 = "\u68e1".length();
        stringArray[12] = "String";
        int n121 = "\u67b9".length();
        int n122 = "\u50a4\u6c9b".length();
        int n123 = "\u5f12\u5b45\u5015\u5968".length();
        int n124 = "\u5566".length();
        stringArray[13] = "(other)";
        this.valueTypeField.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.valueTypeField.addActionListener(actionEvent -> this.filterChanged());
        int n125 = "\u6e59\u6c3c\u630f\u63ab".length();
        int n126 = "\u65df\u56f3".length();
        int n127 = "\u50ea\u59ba\u5cce".length();
        int n128 = "\u6d7c\u60f1\u5198\u591f".length();
        int n129 = "\u621e\u5697\u5429\u61d2".length();
        int n130 = "\u511a\u5e39".length();
        this.filterPanel.add(this.valueTypeField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.filterPanel, "North");
        this.table.setAutoCreateRowSorter(true);
        this.table.setComponentPopupMenu(this.tablePopupMenu);
        int n131 = "\u6441\u6a38\u607f\u585b\u707d".length();
        int n132 = "\u56b2\u6e5d\u619f\u6c1a".length();
        int n133 = "\u6601\u6d61\u5e67\u6bbe".length();
        int n134 = "\u5a25".length();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FlatUIDefaultsInspector.this.tableMousePressed(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.table);
        this.panel.add((Component)this.scrollPane, "Center");
        this.copyKeyMenuItem.setText("Copy Key");
        this.copyKeyMenuItem.addActionListener(actionEvent -> this.copyKey());
        this.tablePopupMenu.add(this.copyKeyMenuItem);
        int n135 = "\u5ea3\u6c7c\u6fdb\u61d1".length();
        this.copyValueMenuItem.setText("Copy Value");
        this.copyValueMenuItem.addActionListener(actionEvent -> this.copyValue());
        this.tablePopupMenu.add(this.copyValueMenuItem);
        int n136 = "\u5f34\u6d99\u6e0b\u6a58\u6a99".length();
        this.copyKeyAndValueMenuItem.setText("Copy Key and Value");
        this.copyKeyAndValueMenuItem.addActionListener(actionEvent -> this.copyKeyAndValue());
        this.tablePopupMenu.add(this.copyKeyAndValueMenuItem);
        int n137 = "\u5553\u6e47\u6fbc".length();
        int n138 = "\u6c4f\u50ef\u6ae7".length();
    }

    public static /* synthetic */ JFrame access$302(JFrame jFrame) {
        int n = "\u4e52\u6ff9\u5279\u558b".length();
        int n2 = "\u6f8d\u6e58\u6ed8\u50bf\u508d".length();
        inspectorFrame = jFrame;
        return inspectorFrame;
    }

    public static int INSOLENCE_\u4e50\u6581\u6809\u63e9\u5efe\u5a8f\u57e0\u4eb2\u640c\u4e3d\u70c7\u6f93\u4f9a\u64aa\u53f4\u618a\u6bd1\u5d4b\u67f4\u5b56\u5d16\u643c\u503a\u55c1\u5221\u6dd4\u5c26\u61ff\u54cc\u53d1\u6ef0\u4fd8\u609e\u672a\u5377\u5373\u5558\u618d\u5508\u58ec\u5ee9(int n) {
        return n;
    }

    private static class SafeIcon
    implements Icon {
        public final /* synthetic */ Icon icon;

        public SafeIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            try {
                graphics.setColor(UIManager.getColor("Panel.background"));
                graphics.fillRect(n, n2, n3, n4);
                this.icon.paintIcon(component, graphics, n, n2);
            }
            catch (Exception exception) {
                graphics.setColor(Color.red);
                int n5 = "\u569c".length();
                int n6 = "\u68a7\u57f5\u51d7".length();
                int n7 = "\u5aa7\u52e8\u58a0\u679b\u5a2f".length();
                int n8 = "\u7088\u6d5c\u61e8\u547c".length();
                int n9 = "\u5f95\u6420\u584c\u570a".length();
                int n10 = "\u5d5f\u5b8c\u70e9\u5970\u6c8a".length();
                int n11 = "\u6dbe\u5378".length();
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    private static class ValueRenderer
    extends Renderer {
        public /* synthetic */ Item item;
        public /* synthetic */ Color valueColor;

        public ValueRenderer() {
            super(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            this.item = (Item)object;
            this.init(jTable, this.item.key, bl, n);
            if (!(this.item.value instanceof Color)) {
                this.setBackground(null);
                this.setForeground(null);
            }
            if (!(this.item.value instanceof Icon)) {
                this.setIcon(null);
            }
            object = this.item.getValueAsString();
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = "\u5bf6\u5475\u7127".length();
            int n4 = "\u70d9".length();
            int n5 = "\u6291\u6a95\u5974\u5963\u6b43".length();
            int n6 = "\u5271\u60e0".length();
            if (this.item.value instanceof Color) {
                object2 = this.item.info instanceof Color[] ? ((Color[])this.item.info)[0] : (Color)this.item.value;
                int n7 = "\u58b0\u6e77\u6aa8\u5323\u6cec".length();
                int n8 = "\u6346".length();
                int n9 = "\u6ab7\u5bf8\u6c59\u61ab\u6430".length();
                boolean bl3 = new HSLColor((Color)object2).getLuminance() < 70.0f && ((Color)object2).getAlpha() >= 128;
                this.valueColor = object2;
                this.setForeground(bl3 ? Color.white : Color.black);
            } else if (this.item.value instanceof Icon) {
                object2 = (Icon)this.item.value;
                int n10 = "\u6709\u605b\u5878\u6f62\u5960".length();
                int n11 = "\u5516".length();
                int n12 = "\u632d\u66dd\u6916".length();
                this.setIcon(new SafeIcon((Icon)object2));
            }
            Object object3 = object2 = this.item.value instanceof Object[] ? Arrays.toString((Object[])this.item.value).replace(", ", ",\n") : String.valueOf(this.item.value);
            if (this.item.lafValue != null) {
                int n13 = "\u5762\u54e7\u4f78\u660a\u5850".length();
                int n14 = "\u50e0\u5a59\u4ea2\u65fe\u6d19".length();
                object2 = (String)object2 + "    \n\nLaF UI default value was overridden with UIManager.put(key,value):\n    " + Item.valueAsString(this.item.lafValue, null) + "\n    " + String.valueOf(this.item.lafValue);
            }
            this.setToolTipText((String)object2);
            return this;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.item.value instanceof Color) {
                Object object;
                int n = this.getWidth();
                int n2 = this.getHeight();
                Color color = this.valueColor;
                this.fillRect(graphics, color, 0, 0, n, n2);
                if (this.item.info instanceof Color[]) {
                    int n3;
                    int n4 = n2 * 2;
                    int n5 = "\u6da0\u5b8b\u508a\u6e25\u60cf".length();
                    int n6 = "\u5e45\u5372".length();
                    int n7 = "\u57f5".length();
                    int n8 = "\u56f6\u4fba\u671d\u6db3\u59f7".length();
                    this.fillRect(graphics, ((Color[])this.item.info)[1], n - n4, 0, n4, n2);
                    object = (Color)this.item.value;
                    if (object != null && ValueRenderer.INSOLENCE_\u554c\u5f24\u590f\u6a32\u710b\u5b54\u5704\u5bbf\u5f21\u6929\u5861\u6c72\u547a\u6838\u5cd7\u5469\u5679\u67e4\u6ff3\u5a1a\u5870\u63ef\u5c0e\u5b40\u5a63\u636e\u5db8\u56bd\u6317\u52de\u643b\u6f76\u527f\u6c99\u5f26\u6ae9\u6026\u68d0\u7030\u52c3\u6734(((Color)object).equals(color) ? 1 : 0) == 0) {
                        n3 = n2 / 2;
                        int n9 = "\u5aac\u63f8\u6008".length();
                        this.fillRect(graphics, (Color)object, n - n3, 0, n3, n2);
                    }
                    n3 = n2 / 4;
                    graphics.setColor(Color.magenta);
                    int n10 = "\u6afe\u6557\u6112\u6a70\u6484".length();
                    graphics.fillRect(n - n3, 0, n3, n2);
                }
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                object = this.getText();
                int n11 = "\u6052\u6570\u62f7\u5bcf\u4f51".length();
                int n12 = "\u52f6\u62cc".length();
                int n13 = "\u65aa\u69a7\u68a6\u6100\u5000".length();
                Rectangle rectangle = new Rectangle();
                this.layoutLabel(fontMetrics, (String)object, rectangle);
                int n14 = "\u6ef7\u6a2d\u60d0".length();
                int n15 = "\u5197\u5c51\u5216\u596b\u5b8b".length();
                int n16 = "\u59c3\u5f9c".length();
                int n17 = "\u6b97\u55ee\u6b19".length();
                int n18 = rectangle.x;
                int n19 = ValueRenderer.INSOLENCE_\u5806\u55bf\u557e\u5a29\u57ce\u5664\u6089\u5fa2\u5b8b\u533a\u6fde\u67bf\u5c2c\u6cd7\u5cb4\u518e\u6fe7\u5cfe\u58aa\u5e3c\u6151\u6d9e\u6199\u5d9a\u7091\u65fd\u5a12\u62f8\u55b1\u6ae0\u551f\u4efa\u6e10\u64fd\u64bf\u5c9b\u55a1\u4fb8\u6583\u5581\u61f2(rectangle.y, fontMetrics.getAscent());
                graphics.setColor(this.getForeground());
                int n20 = ((String)object).indexOf("HSL");
                if (n20 > 0) {
                    String string = ((String)object).substring(0, n20);
                    String string2 = ((String)object).substring(n20);
                    int n21 = Math.max(fontMetrics.stringWidth(string), fontMetrics.stringWidth("#12345678  "));
                    FlatUIUtils.drawString(this, graphics, string, n18, n19);
                    FlatUIUtils.drawString(this, graphics, string2, ValueRenderer.INSOLENCE_\u5806\u55bf\u557e\u5a29\u57ce\u5664\u6089\u5fa2\u5b8b\u533a\u6fde\u67bf\u5c2c\u6cd7\u5cb4\u518e\u6fe7\u5cfe\u58aa\u5e3c\u6151\u6d9e\u6199\u5d9a\u7091\u65fd\u5a12\u62f8\u55b1\u6ae0\u551f\u4efa\u6e10\u64fd\u64bf\u5c9b\u55a1\u4fb8\u6583\u5581\u61f2(n18, n21), n19);
                } else {
                    FlatUIUtils.drawString(this, graphics, (String)object, n18, n19);
                }
            } else {
                super.paintComponent(graphics);
            }
            this.paintSeparator(graphics);
        }

        public void fillRect(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
            if (color.getAlpha() != 255) {
                graphics.setColor(Color.white);
                graphics.fillRect(n, n2, n3, n4);
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }

        public /* synthetic */ ValueRenderer(1 var1_1) {
            this();
        }

        public static int INSOLENCE_\u554c\u5f24\u590f\u6a32\u710b\u5b54\u5704\u5bbf\u5f21\u6929\u5861\u6c72\u547a\u6838\u5cd7\u5469\u5679\u67e4\u6ff3\u5a1a\u5870\u63ef\u5c0e\u5b40\u5a63\u636e\u5db8\u56bd\u6317\u52de\u643b\u6f76\u527f\u6c99\u5f26\u6ae9\u6026\u68d0\u7030\u52c3\u6734(int n) {
            return n;
        }

        public static int INSOLENCE_\u5806\u55bf\u557e\u5a29\u57ce\u5664\u6089\u5fa2\u5b8b\u533a\u6fde\u67bf\u5c2c\u6cd7\u5cb4\u518e\u6fe7\u5cfe\u58aa\u5e3c\u6151\u6d9e\u6199\u5d9a\u7091\u65fd\u5a12\u62f8\u55b1\u6ae0\u551f\u4efa\u6e10\u64fd\u64bf\u5c9b\u55a1\u4fb8\u6583\u5581\u61f2(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }

    private static class KeyRenderer
    extends Renderer {
        public /* synthetic */ String key;
        public /* synthetic */ boolean isOverridden;
        public /* synthetic */ Icon overriddenIcon;

        public KeyRenderer() {
            super(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.key = (String)object;
            this.init(jTable, this.key, bl, n);
            Item item = (Item)jTable.getValueAt(n, 1);
            this.isOverridden = KeyRenderer.INSOLENCE_\u6137\u69a4\u54ad\u636a\u5100\u6e8a\u6c02\u5625\u6529\u6765\u5188\u5d58\u60d8\u50fb\u62e0\u4f24\u6800\u5195\u63ba\u5eb0\u7030\u4e95\u63f9\u5cb8\u6a1c\u6601\u5068\u544f\u6035\u66b2\u5d52\u54c4\u5217\u54f5\u63a4\u6a69\u566e\u5aae\u5503\u6db4\u6d6f(item.lafValue != null ? 1 : 0);
            String string = this.key;
            if (KeyRenderer.INSOLENCE_\u6137\u69a4\u54ad\u636a\u5100\u6e8a\u6c02\u5625\u6529\u6765\u5188\u5d58\u60d8\u50fb\u62e0\u4f24\u6800\u5195\u63ba\u5eb0\u7030\u4e95\u63f9\u5cb8\u6a1c\u6601\u5068\u544f\u6035\u66b2\u5d52\u54c4\u5217\u54f5\u63a4\u6a69\u566e\u5aae\u5503\u6db4\u6d6f(this.isOverridden ? 1 : 0) != 0) {
                int n3 = "\u6628\u6ee8\u6a46\u59a1\u5cd2".length();
                string = string + "    \n\nLaF UI default value was overridden with UIManager.put(key,value).";
            }
            this.setToolTipText(string);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = "\u7130\u591b".length();
            int n2 = "\u6ee5".length();
            int n3 = "\u5e64\u5bcc\u4e27\u4f89\u62ca".length();
            Rectangle rectangle = new Rectangle();
            String string = this.layoutLabel(fontMetrics, this.key, rectangle);
            int n4 = rectangle.x;
            int n5 = KeyRenderer.INSOLENCE_\u556c\u6294\u6650\u53aa\u54cd\u534a\u5726\u7074\u58df\u4ff8\u4e77\u6a3f\u5bd1\u6879\u68d6\u5b8d\u6412\u6011\u54bb\u6a92\u5cb5\u6c2a\u5b04\u5982\u548b\u7022\u50fa\u6c79\u60ac\u6f8e\u5289\u62b0\u4e5d\u5b4a\u58bc\u6aae\u56d6\u63aa\u581d\u5c2d\u66e7(rectangle.y, fontMetrics.getAscent());
            int n6 = this.key.indexOf(46);
            if (n6 > 0 && KeyRenderer.INSOLENCE_\u6137\u69a4\u54ad\u636a\u5100\u6e8a\u6c02\u5625\u6529\u6765\u5188\u5d58\u60d8\u50fb\u62e0\u4f24\u6800\u5195\u63ba\u5eb0\u7030\u4e95\u63f9\u5cb8\u6a1c\u6601\u5068\u544f\u6035\u66b2\u5d52\u54c4\u5217\u54f5\u63a4\u6a69\u566e\u5aae\u5503\u6db4\u6d6f(this.selected ? 1 : 0) == 0) {
                graphics.setColor(FlatUIUtils.getUIColor("Label.disabledForeground", FlatUIUtils.getUIColor("Label.disabledText", Color.gray)));
                if (n6 >= string.length()) {
                    FlatUIUtils.drawString(this, graphics, string, n4, n5);
                } else {
                    String string2 = string.substring(0, KeyRenderer.INSOLENCE_\u556c\u6294\u6650\u53aa\u54cd\u534a\u5726\u7074\u58df\u4ff8\u4e77\u6a3f\u5bd1\u6879\u68d6\u5b8d\u6412\u6011\u54bb\u6a92\u5cb5\u6c2a\u5b04\u5982\u548b\u7022\u50fa\u6c79\u60ac\u6f8e\u5289\u62b0\u4e5d\u5b4a\u58bc\u6aae\u56d6\u63aa\u581d\u5c2d\u66e7(n6, 1));
                    String string3 = string.substring(KeyRenderer.INSOLENCE_\u556c\u6294\u6650\u53aa\u54cd\u534a\u5726\u7074\u58df\u4ff8\u4e77\u6a3f\u5bd1\u6879\u68d6\u5b8d\u6412\u6011\u54bb\u6a92\u5cb5\u6c2a\u5b04\u5982\u548b\u7022\u50fa\u6c79\u60ac\u6f8e\u5289\u62b0\u4e5d\u5b4a\u58bc\u6aae\u56d6\u63aa\u581d\u5c2d\u66e7(n6, 1));
                    FlatUIUtils.drawString(this, graphics, string2, n4, n5);
                    graphics.setColor(this.getForeground());
                    FlatUIUtils.drawString(this, graphics, string3, KeyRenderer.INSOLENCE_\u556c\u6294\u6650\u53aa\u54cd\u534a\u5726\u7074\u58df\u4ff8\u4e77\u6a3f\u5bd1\u6879\u68d6\u5b8d\u6412\u6011\u54bb\u6a92\u5cb5\u6c2a\u5b04\u5982\u548b\u7022\u50fa\u6c79\u60ac\u6f8e\u5289\u62b0\u4e5d\u5b4a\u58bc\u6aae\u56d6\u63aa\u581d\u5c2d\u66e7(n4, fontMetrics.stringWidth(string2)), n5);
                }
            } else {
                graphics.setColor(this.getForeground());
                FlatUIUtils.drawString(this, graphics, string, n4, n5);
            }
            if (KeyRenderer.INSOLENCE_\u6137\u69a4\u54ad\u636a\u5100\u6e8a\u6c02\u5625\u6529\u6765\u5188\u5d58\u60d8\u50fb\u62e0\u4f24\u6800\u5195\u63ba\u5eb0\u7030\u4e95\u63f9\u5cb8\u6a1c\u6601\u5068\u544f\u6035\u66b2\u5d52\u54c4\u5217\u54f5\u63a4\u6a69\u566e\u5aae\u5503\u6db4\u6d6f(this.isOverridden ? 1 : 0) != 0) {
                if (this.overriddenIcon == null) {
                    int n7 = "\u609e\u553f\u4f66\u5273\u6d79".length();
                    this.overriddenIcon = new FlatAbstractIcon(16, 16, null){

                        @Override
                        public void paintIcon(Component component, Graphics2D graphics2D) {
                            graphics2D.setColor(FlatUIUtils.getUIColor("Actions.Red", Color.red));
                            int n = "\u7017".length();
                            int n2 = "\u5d60\u6ce7\u5b17".length();
                            int n3 = "\u6a0d\u588f\u52bb\u51c8\u5bcf".length();
                            graphics2D.setStroke(new BasicStroke(2.0f));
                            double[] dArray = new double[6];
                            int n4 = "\u5e80".length();
                            int n5 = "\u6d7a\u4e43\u4ead\u54d9\u6e3e".length();
                            dArray[0] = 3.0;
                            int n6 = "\u5216\u564f".length();
                            int n7 = "\u70c9\u65ad\u53d8\u5c0b\u5234".length();
                            int n8 = "\u4e96\u5ead".length();
                            dArray[1] = 10.0;
                            int n9 = "\u6b47\u5d54".length();
                            int n10 = "\u6db7\u6b13\u66a8\u646a".length();
                            dArray[2] = 8.0;
                            int n11 = "\u5c0b\u6549\u5836\u5056".length();
                            int n12 = "\u60c8\u5698\u593f\u4e9e\u58c8".length();
                            int n13 = "\u537e\u6249\u621d\u4e5d".length();
                            dArray[3] = 5.0;
                            int n14 = "\u653d\u6214".length();
                            dArray[4] = 13.0;
                            int n15 = "\u6b5e".length();
                            int n16 = "\u63a8\u6de5\u5d6a\u544d".length();
                            dArray[5] = 10.0;
                            graphics2D.draw(FlatUIUtils.createPath(false, dArray));
                        }
                    };
                }
                int n8 = "\u5865".length();
                int n9 = "\u5a58".length();
                int n10 = "\u6e51\u53da".length();
                int n11 = "\u5233\u6dd6\u6c94".length();
                this.overriddenIcon.paintIcon(this, graphics, this.getWidth() - this.overriddenIcon.getIconWidth(), (this.getHeight() - this.overriddenIcon.getIconHeight()) / 2);
            }
            this.paintSeparator(graphics);
        }

        public /* synthetic */ KeyRenderer(1 var1_1) {
            this();
        }

        public static int INSOLENCE_\u6137\u69a4\u54ad\u636a\u5100\u6e8a\u6c02\u5625\u6529\u6765\u5188\u5d58\u60d8\u50fb\u62e0\u4f24\u6800\u5195\u63ba\u5eb0\u7030\u4e95\u63f9\u5cb8\u6a1c\u6601\u5068\u544f\u6035\u66b2\u5d52\u54c4\u5217\u54f5\u63a4\u6a69\u566e\u5aae\u5503\u6db4\u6d6f(int n) {
            return n;
        }

        public static int INSOLENCE_\u556c\u6294\u6650\u53aa\u54cd\u534a\u5726\u7074\u58df\u4ff8\u4e77\u6a3f\u5bd1\u6879\u68d6\u5b8d\u6412\u6011\u54bb\u6a92\u5cb5\u6c2a\u5b04\u5982\u548b\u7022\u50fa\u6c79\u60ac\u6f8e\u5289\u62b0\u4e5d\u5b4a\u58bc\u6aae\u56d6\u63aa\u581d\u5c2d\u66e7(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }

    private static class Renderer
    extends DefaultTableCellRenderer {
        public /* synthetic */ boolean selected;
        public /* synthetic */ boolean first;

        public Renderer() {
        }

        public void init(JTable jTable, String string, boolean bl, int n) {
            this.selected = Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(bl ? 1 : 0);
            this.first = Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(0);
            if (n > 0) {
                String string2;
                int n2 = "\u699d\u5460".length();
                int n3 = "\u6887\u709c\u6b05".length();
                int n4 = "\u6206\u4e5e\u5d58".length();
                String string3 = (String)jTable.getValueAt(n - 1, 0);
                int n5 = string.indexOf(46);
                this.first = n5 > 0 ? Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(string3.startsWith(string2 = string.substring(0, Renderer.INSOLENCE_\u5b53\u6b2f\u50d8\u64ce\u6678\u5ca9\u5e86\u70a2\u5324\u5bfe\u5792\u6a53\u5fc9\u59e9\u6048\u5cbd\u6661\u68d7\u6e6a\u5e35\u6730\u6614\u6b65\u70be\u5631\u6268\u5498\u62fd\u5e31\u66cb\u52b6\u5c1d\u5218\u6242\u6453\u5fda\u5fcc\u6dc3\u6527\u53ad\u4f43(n5, 1))) ? 1 : 0) == 0 ? 1 : 0) : Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(string3.indexOf(46) > 0 ? 1 : 0);
            }
        }

        public void paintSeparator(Graphics graphics) {
            if (Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(this.first ? 1 : 0) != 0 && Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(this.selected ? 1 : 0) == 0) {
                graphics.setColor(Renderer.INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(FlatLaf.isLafDark() ? 1 : 0) != 0 ? Color.gray : Color.lightGray);
                int n = "\u6f68\u6157\u60a2\u611e\u70a0".length();
                int n2 = "\u6986\u6ec7\u5f6b\u632b\u6779".length();
                int n3 = "\u5e12\u6d22\u52fc".length();
                graphics.fillRect(0, 0, this.getWidth() - 1, 1);
            }
        }

        public String layoutLabel(FontMetrics fontMetrics, String string, Rectangle rectangle) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Insets insets = this.getInsets();
            int n3 = "\u5ad2\u6823\u4f9a".length();
            int n4 = "\u70db\u6e29\u66f8".length();
            int n5 = "\u61c7\u6fa0".length();
            int n6 = "\u5f9d\u5c8e\u70b1\u6de1".length();
            Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n - Renderer.INSOLENCE_\u5b53\u6b2f\u50d8\u64ce\u6678\u5ca9\u5e86\u70a2\u5324\u5bfe\u5792\u6a53\u5fc9\u59e9\u6048\u5cbd\u6661\u68d7\u6e6a\u5e35\u6730\u6614\u6b65\u70be\u5631\u6268\u5498\u62fd\u5e31\u66cb\u52b6\u5c1d\u5218\u6242\u6453\u5fda\u5fcc\u6dc3\u6527\u53ad\u4f43(insets.left, insets.right), n2 - Renderer.INSOLENCE_\u5b53\u6b2f\u50d8\u64ce\u6678\u5ca9\u5e86\u70a2\u5324\u5bfe\u5792\u6a53\u5fc9\u59e9\u6048\u5cbd\u6661\u68d7\u6e6a\u5e35\u6730\u6614\u6b65\u70be\u5631\u6268\u5498\u62fd\u5e31\u66cb\u52b6\u5c1d\u5218\u6242\u6453\u5fda\u5fcc\u6dc3\u6527\u53ad\u4f43(insets.top, insets.bottom));
            int n7 = "\u6ba8".length();
            int n8 = "\u5533".length();
            Rectangle rectangle3 = new Rectangle();
            return SwingUtilities.layoutCompoundLabel(this, fontMetrics, string, null, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle2, rectangle3, rectangle, this.getIconTextGap());
        }

        public /* synthetic */ Renderer(1 var1_1) {
            this();
        }

        public static int INSOLENCE_\u57f4\u6a8d\u4f8c\u536c\u5bce\u53ad\u7090\u4ef7\u5ee5\u5b48\u6d01\u70f0\u58bb\u6a4a\u5988\u5e3f\u4f23\u7063\u64b1\u65d5\u69e8\u6947\u6d83\u5234\u5898\u5e61\u4ea2\u5512\u6c08\u5934\u52fc\u6d27\u504a\u70f0\u6ed7\u5fec\u6832\u7036\u50d6\u6078\u615e(int n) {
            return n;
        }

        public static int INSOLENCE_\u5b53\u6b2f\u50d8\u64ce\u6678\u5ca9\u5e86\u70a2\u5324\u5bfe\u5792\u6a53\u5fc9\u59e9\u6048\u5cbd\u6661\u68d7\u6e6a\u5e35\u6730\u6614\u6b65\u70be\u5631\u6268\u5498\u62fd\u5e31\u66cb\u52b6\u5c1d\u5218\u6242\u6453\u5fda\u5fcc\u6dc3\u6527\u53ad\u4f43(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }

    private static class ItemsTableModel
    extends AbstractTableModel {
        public /* synthetic */ Item[] allItems;
        public /* synthetic */ Item[] items;
        public /* synthetic */ Predicate<Item> filter;

        public ItemsTableModel(Item[] itemArray) {
            this.items = itemArray;
            this.allItems = itemArray;
        }

        public void setItems(Item[] itemArray) {
            this.items = itemArray;
            this.allItems = itemArray;
            this.setFilter(this.filter);
        }

        public void setFilter(Predicate<Item> predicate) {
            this.filter = predicate;
            if (predicate != null) {
                int n = "\u678a\u5651\u6b66\u6a15\u5246".length();
                int n2 = "\u5e4e\u6751\u6523\u630b\u6d58".length();
                int n3 = "\u6975\u6242\u5cfa\u7068\u6cbb".length();
                int n4 = "\u6857".length();
                int n5 = "\u6873".length();
                ArrayList<Item> arrayList = new ArrayList<Item>(this.allItems.length);
                Item[] itemArray = this.allItems;
                int n6 = itemArray.length;
                for (int i = 0; i < n6; i += 8722) {
                    Item item = itemArray[i];
                    if (ItemsTableModel.INSOLENCE_\u593c\u66e2\u69cd\u5ccd\u6181\u6bde\u62f1\u4e8d\u5bf5\u6ec5\u6cef\u4f7d\u6f51\u63b9\u69b8\u70a6\u4e62\u5cc6\u5804\u6110\u6314\u5dc5\u5fe9\u713d\u59ba\u6e34\u6cbe\u5b88\u5974\u65a7\u5ad4\u6db5\u578f\u69c3\u50b9\u5279\u5683\u508a\u629c\u69a0\u61df(predicate.test(item) ? 1 : 0) != 0) {
                        ItemsTableModel.INSOLENCE_\u593c\u66e2\u69cd\u5ccd\u6181\u6bde\u62f1\u4e8d\u5bf5\u6ec5\u6cef\u4f7d\u6f51\u63b9\u69b8\u70a6\u4e62\u5cc6\u5804\u6110\u6314\u5dc5\u5fe9\u713d\u59ba\u6e34\u6cbe\u5b88\u5974\u65a7\u5ad4\u6db5\u578f\u69c3\u50b9\u5279\u5683\u508a\u629c\u69a0\u61df(arrayList.add(item) ? 1 : 0);
                        int n7 = "\u5e34".length();
                        int n8 = "\u5d56\u5ee2\u6cfb".length();
                        int n9 = "\u4fb4".length();
                    }
                    i -= 8721;
                }
                this.items = arrayList.toArray(new Item[arrayList.size()]);
            } else {
                this.items = this.allItems;
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.items.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return super.getColumnName(n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Item.class;
                }
            }
            return super.getColumnClass(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Item item = this.items[n];
            switch (n2) {
                case 0: {
                    return item.key;
                }
                case 1: {
                    return item;
                }
            }
            return null;
        }

        public static int INSOLENCE_\u593c\u66e2\u69cd\u5ccd\u6181\u6bde\u62f1\u4e8d\u5bf5\u6ec5\u6cef\u4f7d\u6f51\u63b9\u69b8\u70a6\u4e62\u5cc6\u5804\u6110\u6314\u5dc5\u5fe9\u713d\u59ba\u6e34\u6cbe\u5b88\u5974\u65a7\u5ad4\u6db5\u578f\u69c3\u50b9\u5279\u5683\u508a\u629c\u69a0\u61df(int n) {
            return n;
        }
    }

    private static class Item {
        public final /* synthetic */ String key;
        public final /* synthetic */ Object value;
        public final /* synthetic */ Object lafValue;
        public final /* synthetic */ Object info;
        public /* synthetic */ String valueStr;

        public Item(String string, Object object, Object object2, Object object3) {
            this.key = string;
            this.value = object;
            this.lafValue = object2;
            this.info = object3;
        }

        public String getValueAsString() {
            if (this.valueStr == null) {
                this.valueStr = Item.valueAsString(this.value, this.info);
            }
            return this.valueStr;
        }

        public static /* synthetic */ String valueAsString(Object object, Object object2) {
            if (object instanceof Color) {
                Color color = object2 instanceof Color[] ? ((Color[])object2)[0] : (Color)object;
                int n = "\u61f2\u66de\u68e1\u60b4\u5a4f".length();
                int n2 = "\u647b".length();
                HSLColor hSLColor = new HSLColor(color);
                int n3 = Math.round(hSLColor.getHue());
                int n4 = Math.round(hSLColor.getSaturation());
                int n5 = Math.round(hSLColor.getLuminance());
                if (color.getAlpha() == 255) {
                    Object[] objectArray = new Object[4];
                    int n6 = "\u4e55\u535a\u5a13".length();
                    int n7 = "\u585c".length();
                    int n8 = "\u5a78\u4e2a".length();
                    objectArray[0] = Item.color2hex(color);
                    int n9 = "\u538d\u5f2f\u6def\u59bc".length();
                    int n10 = "\u6b3a".length();
                    objectArray[1] = n3;
                    int n11 = "\u69bb\u50b1\u6209\u55c8".length();
                    int n12 = "\u60f7\u6843\u6642\u6287\u65c2".length();
                    objectArray[2] = n4;
                    int n13 = "\u6abb\u66ab\u62b8".length();
                    objectArray[3] = n5;
                    return String.format("%-9s HSL %3d %3d %3d", objectArray);
                }
                int n14 = Math.round(hSLColor.getAlpha() * 100.0f);
                Object[] objectArray = new Object[5];
                int n15 = "\u6b59\u56e3\u61d0".length();
                int n16 = "\u6f6e\u6580\u687a\u649c\u6f36".length();
                int n17 = "\u4f63\u59b8\u567a\u6b4f\u59e0".length();
                int n18 = "\u6f58\u69de\u6ed6\u699a\u6955".length();
                int n19 = "\u4f28\u6adc\u5135\u67ec\u5c89".length();
                objectArray[0] = Item.color2hex(color);
                int n20 = "\u62ca\u62cf".length();
                objectArray[1] = n3;
                int n21 = "\u5cea\u6c72\u5536".length();
                int n22 = "\u6c6c\u6502\u6c17\u6791".length();
                int n23 = "\u689a".length();
                objectArray[2] = n4;
                int n24 = "\u54aa\u6a2c\u5b8e\u60c0".length();
                int n25 = "\u65cf\u575a\u5eb0\u55e7".length();
                int n26 = "\u568a\u674a".length();
                objectArray[3] = n5;
                int n27 = "\u6a3b\u5df9\u5e52\u701e".length();
                objectArray[4] = n14;
                return String.format("%-9s HSL %3d %3d %3d %2d", objectArray);
            }
            if (object instanceof Insets) {
                Insets insets = (Insets)object;
                int n = "\u5257\u6e53".length();
                int n28 = "\u65bf\u5aa6\u5f1f\u64a9".length();
                return insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right;
            }
            if (object instanceof Dimension) {
                Dimension dimension = (Dimension)object;
                int n = "\u621a\u6d35".length();
                return dimension.width + "," + dimension.height;
            }
            if (object instanceof Font) {
                Font font = (Font)object;
                int n = "\u6325".length();
                int n29 = "\u6ae9\u57f8\u5aab\u625a\u5592".length();
                String string = font.getFamily() + " " + font.getSize();
                if (Item.INSOLENCE_\u5941\u607c\u5364\u68e3\u6ade\u505a\u5033\u4eb6\u619a\u4f79\u6269\u6529\u6b7f\u581a\u633e\u6e95\u612e\u5bc1\u5219\u5b70\u5c9a\u6c9d\u59d2\u563d\u52a4\u6ed4\u7137\u5047\u52b5\u5f51\u61a0\u6825\u5bb1\u588f\u598f\u5470\u4e63\u59af\u5a2c\u5cce\u60c5(font.isBold() ? 1 : 0) != 0) {
                    int n30 = "\u5e43\u5d20\u5665\u6217".length();
                    int n31 = "\u5267\u65be\u578d\u69d6".length();
                    int n32 = "\u5f8b\u711b\u5c7d\u4f66\u6e11".length();
                    string = string + " bold";
                }
                if (Item.INSOLENCE_\u5941\u607c\u5364\u68e3\u6ade\u505a\u5033\u4eb6\u619a\u4f79\u6269\u6529\u6b7f\u581a\u633e\u6e95\u612e\u5bc1\u5219\u5b70\u5c9a\u6c9d\u59d2\u563d\u52a4\u6ed4\u7137\u5047\u52b5\u5f51\u61a0\u6825\u5bb1\u588f\u598f\u5470\u4e63\u59af\u5a2c\u5cce\u60c5(font.isItalic() ? 1 : 0) != 0) {
                    int n33 = "\u5b0d\u63ea".length();
                    int n34 = "\u6fe7".length();
                    string = string + " italic";
                }
                return string;
            }
            if (object instanceof Icon) {
                Icon icon = (Icon)object;
                int n = "\u5059\u70eb".length();
                int n35 = "\u6ada".length();
                return icon.getIconWidth() + "x" + icon.getIconHeight() + "   " + icon.getClass().getName();
            }
            if (object instanceof Border) {
                Border border = (Border)object;
                if (border instanceof FlatLineBorder) {
                    FlatLineBorder flatLineBorder = (FlatLineBorder)border;
                    int n = "\u64f7\u54aa\u62a2\u6775".length();
                    int n36 = "\u64e8\u640c".length();
                    return Item.valueAsString(flatLineBorder.getUnscaledBorderInsets(), null) + "  " + Item.color2hex(flatLineBorder.getLineColor()) + "  " + flatLineBorder.getLineThickness() + "    " + border.getClass().getName();
                }
                if (border instanceof EmptyBorder) {
                    Insets insets = border instanceof FlatEmptyBorder ? ((FlatEmptyBorder)border).getUnscaledBorderInsets() : ((EmptyBorder)border).getBorderInsets();
                    int n = "\u64e9\u6c95".length();
                    int n37 = "\u68b7\u65dd\u6618\u622a\u5c2e".length();
                    return Item.valueAsString(insets, null) + "    " + border.getClass().getName();
                }
                if (border instanceof FlatBorder || border instanceof FlatMarginBorder) {
                    return border.getClass().getName();
                }
                return String.valueOf(object);
            }
            if (object instanceof GrayFilter) {
                GrayFilter grayFilter = (GrayFilter)object;
                int n = "\u5e44\u5b43\u4fb1".length();
                int n38 = "\u60cb\u5912\u6f4c\u6674".length();
                int n39 = "\u60a6\u53d3".length();
                int n40 = "\u6e2a\u64b3\u5cea\u5261\u6efe".length();
                int n41 = "\u50e7\u6c14".length();
                return grayFilter.getBrightness() + "," + grayFilter.getContrast() + " " + grayFilter.getAlpha() + "    " + grayFilter.getClass().getName();
            }
            if (object instanceof ActionMap) {
                ActionMap actionMap = (ActionMap)object;
                int n = "\u6480\u6513\u67d9".length();
                int n42 = "\u54cc\u53cb\u54bc\u5846\u5bd2".length();
                int n43 = "\u5e12\u708a".length();
                int n44 = "\u5dc3\u5c5c".length();
                return "ActionMap (" + actionMap.size() + ")";
            }
            if (object instanceof InputMap) {
                InputMap inputMap = (InputMap)object;
                int n = "\u4ea6".length();
                return "InputMap (" + inputMap.size() + ")";
            }
            if (object instanceof Object[]) {
                return Arrays.toString((Object[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            return String.valueOf(object);
        }

        public static /* synthetic */ String color2hex(Color color) {
            boolean bl;
            int n = color.getRGB();
            boolean bl2 = color.getAlpha() != 255;
            boolean bl3 = bl = (n & 0xF0000000) == (n & 0xF000000) << 4 && (n & 0xF00000) == (n & 0xF0000) << 4 && (n & 0xF000) == (n & 0xF00) << 4 && (n & 0xF0) == (n & 0xF) << 4;
            if (bl) {
                int n2 = (n & 0xF0000) >> 8 | (n & 0xF00) >> 4 | n & 0xF;
                Object[] objectArray = new Object[2];
                int n3 = "\u6493\u702b\u701c\u6431\u5112".length();
                int n4 = "\u5698".length();
                int n5 = "\u6581\u555c\u5115\u5027".length();
                int n6 = "\u680a\u5f97\u660b\u5145".length();
                int n7 = "\u5ac6".length();
                objectArray[0] = n2;
                int n8 = "\u5416\u5302\u5b52\u6957".length();
                int n9 = "\u5d69".length();
                int n10 = "\u5818".length();
                objectArray[1] = n >> 24 & 0xF;
                return String.format(bl2 ? "#%03X%X" : "#%03X", objectArray);
            }
            Object[] objectArray = new Object[2];
            int n11 = "\u6cf4\u6649\u5a4e\u66dc\u6a6b".length();
            int n12 = "\u5bd4".length();
            int n13 = "\u5ed8\u6da3".length();
            objectArray[0] = n & 0xFFFFFF;
            int n14 = "\u4f83\u5216\u6b00\u4f4f\u6e75".length();
            int n15 = "\u5ac8\u5767\u4f4f\u5d7d".length();
            int n16 = "\u6616\u4e76\u6db8\u5faf".length();
            objectArray[1] = n >> 24 & 0xFF;
            return String.format(bl2 ? "#%06X%02X" : "#%06X", objectArray);
        }

        public String toString() {
            return this.getValueAsString();
        }

        public static int INSOLENCE_\u5941\u607c\u5364\u68e3\u6ade\u505a\u5033\u4eb6\u619a\u4f79\u6269\u6529\u6b7f\u581a\u633e\u6e95\u612e\u5bc1\u5219\u5b70\u5c9a\u6c9d\u59d2\u563d\u52a4\u6ed4\u7137\u5047\u52b5\u5f51\u61a0\u6825\u5bb1\u588f\u598f\u5470\u4e63\u59af\u5a2c\u5cce\u60c5(int n) {
            return n;
        }
    }
}

