/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.json;

import com.formdev.flatlaf.json.JsonHandler;
import com.formdev.flatlaf.json.Location;
import com.formdev.flatlaf.json.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JsonParser {
    public static final /* synthetic */ int MAX_NESTING_LEVEL = 1000;
    public static final /* synthetic */ int MIN_BUFFER_SIZE = 10;
    public static final /* synthetic */ int DEFAULT_BUFFER_SIZE = 1024;
    public final /* synthetic */ JsonHandler<Object, Object> handler;
    public /* synthetic */ Reader reader;
    public /* synthetic */ char[] buffer;
    public /* synthetic */ int bufferOffset;
    public /* synthetic */ int index;
    public /* synthetic */ int fill;
    public /* synthetic */ int line;
    public /* synthetic */ int lineOffset;
    public /* synthetic */ int current;
    public /* synthetic */ StringBuilder captureBuffer;
    public /* synthetic */ int captureStart;
    public /* synthetic */ int nestingLevel;

    public JsonParser(JsonHandler<?, ?> jsonHandler) {
        if (jsonHandler == null) {
            throw new NullPointerException("handler is null");
        }
        this.handler = jsonHandler;
        jsonHandler.parser = this;
    }

    public void parse(String string) {
        if (string == null) {
            int n = "\u5f7b\u58aa".length();
            int n2 = "\u665f\u59af\u5760\u58ea".length();
            int n3 = "\u5a62\u5c8b\u6987\u58f2".length();
            int n4 = "\u6ae6\u51d2\u531b".length();
            throw new NullPointerException("string is null");
        }
        int n = Math.max(10, Math.min(1024, string.length()));
        try {
            int n5 = "\u54a0\u6120\u6734".length();
            int n6 = "\u6925".length();
            int n7 = "\u54ad\u4e98\u5f9b\u64da\u6459".length();
            int n8 = "\u5037\u6c19".length();
            this.parse(new StringReader(string), n);
        }
        catch (IOException iOException) {
            int n9 = "\u6e6a\u57df\u69b6\u58e9".length();
            int n10 = "\u5e7b\u6161\u5a93\u65ca".length();
            throw new RuntimeException(iOException);
        }
    }

    public void parse(Reader reader) throws IOException {
        this.parse(reader, 1024);
    }

    public void parse(Reader reader, int n) throws IOException {
        if (reader == null) {
            int n2 = "\u4f18\u6ee8\u554d\u5ad6\u51bc".length();
            int n3 = "\u5683\u690f\u7040".length();
            int n4 = "\u68a5".length();
            int n5 = "\u6713".length();
            int n6 = "\u708f\u54d1".length();
            int n7 = "\u7109".length();
            int n8 = "\u6b8a\u6e19\u678c\u579e".length();
            throw new NullPointerException("reader is null");
        }
        if (n <= 0) {
            int n9 = "\u547b\u68a4\u6e44\u69f9".length();
            int n10 = "\u50a2\u620f".length();
            int n11 = "\u62d6\u6bf6".length();
            int n12 = "\u5826\u5c23\u665f\u59a6\u708a".length();
            int n13 = "\u6dfc\u54bf\u4e32\u6a0f\u58ae".length();
            int n14 = "\u537e".length();
            int n15 = "\u6b66\u51bb\u590b\u5f90\u5b39".length();
            int n16 = "\u599b\u6ce9\u6514".length();
            throw new IllegalArgumentException("buffersize is zero or negative");
        }
        this.reader = reader;
        this.buffer = new char[n];
        this.bufferOffset = 0;
        this.index = 0;
        this.fill = 0;
        this.line = 1;
        this.lineOffset = 0;
        this.current = 0;
        this.captureStart = -1;
        this.read();
        this.skipWhiteSpace();
        this.readValue();
        this.skipWhiteSpace();
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.isEndOfText() ? 1 : 0) == 0) {
            int n17 = "\u70aa\u5fc8\u6852\u559a".length();
            throw this.error("Unexpected character");
        }
    }

    public void readValue() throws IOException {
        switch (this.current) {
            case 110: {
                this.readNull();
                break;
            }
            case 116: {
                this.readTrue();
                break;
            }
            case 102: {
                this.readFalse();
                break;
            }
            case 34: {
                this.readString();
                break;
            }
            case 91: {
                this.readArray();
                break;
            }
            case 123: {
                this.readObject();
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumber();
                break;
            }
            default: {
                int n = "\u6093".length();
                int n2 = "\u5682\u7122\u6f2a".length();
                int n3 = "\u5aff".length();
                throw this.expected("value");
            }
        }
    }

    public void readArray() throws IOException {
        Object object = this.handler.startArray();
        this.read();
        int n = "\u66b7\u64ee\u6b51\u5a4c\u5a05".length();
        int n2 = "\u6db4\u5e24".length();
        int n3 = "\u6851\u6e94".length();
        this.nestingLevel = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(this.nestingLevel, 1);
        if (this.nestingLevel > 1000) {
            int n4 = "\u62e4\u67af\u5b8d\u51ad".length();
            int n5 = "\u59c9\u5560\u6a97\u66d8\u5c31".length();
            throw this.error("Nesting too deep");
        }
        this.skipWhiteSpace();
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar(']') ? 1 : 0) != 0) {
            int n6 = "\u5219\u5958\u68b8\u5ab7\u5c62".length();
            int n7 = "\u62e3\u6413\u6364\u5677\u66b1".length();
            int n8 = "\u5368\u50c5\u5d0e\u6473\u6bb9".length();
            int n9 = "\u57bf\u5f35\u5b92".length();
            --this.nestingLevel;
            this.handler.endArray(object);
            return;
        }
        do {
            this.skipWhiteSpace();
            this.handler.startArrayValue(object);
            this.readValue();
            this.handler.endArrayValue(object);
            this.skipWhiteSpace();
        } while (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar(',') ? 1 : 0) != 0);
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar(']') ? 1 : 0) == 0) {
            int n10 = "\u5982\u613c\u558f\u6be5\u6484".length();
            throw this.expected("',' or ']'");
        }
        int n11 = "\u7086\u6d99\u4f2e\u4eab\u6654".length();
        int n12 = "\u594b\u6a9f\u5f5c".length();
        int n13 = "\u5600\u53fc".length();
        int n14 = "\u55b6\u5c42".length();
        int n15 = "\u6249\u5aa8\u52df\u54bc\u5ff7".length();
        --this.nestingLevel;
        this.handler.endArray(object);
    }

    public void readObject() throws IOException {
        Object object = this.handler.startObject();
        this.read();
        int n = "\u5a3e\u4e51\u5362\u5513\u7023".length();
        this.nestingLevel = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(this.nestingLevel, 1);
        if (this.nestingLevel > 1000) {
            int n2 = "\u6769".length();
            int n3 = "\u535a\u5bcf\u628b".length();
            throw this.error("Nesting too deep");
        }
        this.skipWhiteSpace();
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('}') ? 1 : 0) != 0) {
            int n4 = "\u5642".length();
            int n5 = "\u5651\u6679\u6787".length();
            int n6 = "\u5a72\u63ef".length();
            --this.nestingLevel;
            this.handler.endObject(object);
            return;
        }
        do {
            this.skipWhiteSpace();
            this.handler.startObjectName(object);
            String string = this.readName();
            this.handler.endObjectName(object, string);
            this.skipWhiteSpace();
            if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar(':') ? 1 : 0) == 0) {
                int n7 = "\u6ac7\u6f5c\u5386\u5767\u567f".length();
                int n8 = "\u64ee\u5e03\u5346\u5c59".length();
                throw this.expected("':'");
            }
            this.skipWhiteSpace();
            this.handler.startObjectValue(object, string);
            this.readValue();
            this.handler.endObjectValue(object, string);
            this.skipWhiteSpace();
        } while (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar(',') ? 1 : 0) != 0);
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('}') ? 1 : 0) == 0) {
            int n9 = "\u5367\u58bf\u5ea8\u5cbe".length();
            int n10 = "\u5962\u6b38\u55ff\u666a\u6fa8".length();
            throw this.expected("',' or '}'");
        }
        int n11 = "\u5b96\u513d".length();
        int n12 = "\u6c09\u70b3\u6754\u5633\u6bad".length();
        int n13 = "\u6599\u64b3\u70e4\u50d8\u5466".length();
        int n14 = "\u52cb\u6b7a".length();
        int n15 = "\u4f0a\u55fc\u4fd8\u70c8\u6812".length();
        int n16 = "\u70df\u5f30".length();
        --this.nestingLevel;
        this.handler.endObject(object);
    }

    public String readName() throws IOException {
        if (this.current != 34) {
            int n = "\u5aa3\u6712\u5701".length();
            int n2 = "\u61ca\u6969".length();
            int n3 = "\u6fec".length();
            throw this.expected("name");
        }
        return this.readStringInternal();
    }

    public void readNull() throws IOException {
        this.handler.startNull();
        this.read();
        this.readRequiredChar('u');
        this.readRequiredChar('l');
        this.readRequiredChar('l');
        this.handler.endNull();
    }

    public void readTrue() throws IOException {
        this.handler.startBoolean();
        this.read();
        this.readRequiredChar('r');
        this.readRequiredChar('u');
        this.readRequiredChar('e');
        this.handler.endBoolean(true);
    }

    public void readFalse() throws IOException {
        this.handler.startBoolean();
        this.read();
        this.readRequiredChar('a');
        this.readRequiredChar('l');
        this.readRequiredChar('s');
        this.readRequiredChar('e');
        this.handler.endBoolean(false);
    }

    public void readRequiredChar(char c) throws IOException {
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar(c) ? 1 : 0) == 0) {
            int n = "\u6a91\u5fb0\u676b\u5f7e".length();
            int n2 = "\u70c4\u64d8\u556f\u5dd6\u7127".length();
            int n3 = "\u5fde\u64f3".length();
            throw this.expected("'" + c + "'");
        }
    }

    public void readString() throws IOException {
        this.handler.startString();
        this.handler.endString(this.readStringInternal());
    }

    public String readStringInternal() throws IOException {
        this.read();
        this.startCapture();
        while (this.current != 34) {
            if (this.current == 92) {
                this.pauseCapture();
                this.readEscape();
                this.startCapture();
                continue;
            }
            if (this.current < 32) {
                int n = "\u67ab\u5eb4\u634b".length();
                int n2 = "\u5f9e\u5d4a".length();
                int n3 = "\u6b4d\u6539\u6385".length();
                int n4 = "\u6505".length();
                throw this.expected("valid string character");
            }
            this.read();
        }
        String string = this.endCapture();
        this.read();
        return string;
    }

    public void readEscape() throws IOException {
        this.read();
        switch (this.current) {
            case 34: 
            case 47: 
            case 92: {
                this.captureBuffer.append((char)this.current);
                int n = "\u7005".length();
                int n2 = "\u6cae\u64b3\u651f\u6c67".length();
                break;
            }
            case 98: {
                this.captureBuffer.append('\b');
                int n = "\u6f34\u70ee".length();
                int n3 = "\u64ae\u528d\u57ea\u5ce1".length();
                int n4 = "\u5a69\u5749".length();
                break;
            }
            case 102: {
                this.captureBuffer.append('\f');
                int n = "\u6211\u59dd".length();
                break;
            }
            case 110: {
                this.captureBuffer.append('\n');
                int n = "\u582f\u5a3a\u5c13\u4ec4\u5505".length();
                int n5 = "\u6248\u50bd".length();
                int n6 = "\u683a\u576f\u623c".length();
                break;
            }
            case 114: {
                this.captureBuffer.append('\r');
                int n = "\u5c0a".length();
                int n7 = "\u5c36\u5f8f\u5741".length();
                break;
            }
            case 116: {
                this.captureBuffer.append('\t');
                int n = "\u5d4f\u6cee\u60e3\u552d\u5702".length();
                int n8 = "\u6193\u6d78\u65cd\u538a".length();
                int n9 = "\u5cad\u705a\u5e3f".length();
                break;
            }
            case 117: {
                char[] cArray = new char[4];
                for (int i = 0; i < 4; i += 1619) {
                    this.read();
                    if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.isHexDigit() ? 1 : 0) == 0) {
                        int n = "\u594d\u56db\u6b76\u4e54\u649c".length();
                        int n10 = "\u70ae".length();
                        int n11 = "\u53d3\u5c43\u52a1\u6853\u55e3".length();
                        int n12 = "\u6ec2\u6dd9".length();
                        throw this.expected("hexadecimal digit");
                    }
                    cArray[i] = (char)this.current;
                    i -= 1618;
                }
                int n = "\u5531\u6e7e\u62f5".length();
                int n13 = "\u6cf1".length();
                this.captureBuffer.append((char)Integer.parseInt(new String(cArray), 16));
                int n14 = "\u6c8c\u6f6b\u6a71\u5684\u5096".length();
                int n15 = "\u60ca\u6af2\u6fe9\u4ff1".length();
                break;
            }
            default: {
                int n = "\u64ac\u52cf\u5d11\u5412\u6ba2".length();
                throw this.expected("valid escape sequence");
            }
        }
        this.read();
    }

    public void readNumber() throws IOException {
        this.handler.startNumber();
        this.startCapture();
        JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('-') ? 1 : 0);
        int n = "\u4f9e\u6760\u64d8\u50c8".length();
        int n2 = "\u6c0d\u6993\u596d\u5b51".length();
        int n3 = "\u5b00\u6e8f\u51bf".length();
        int n4 = this.current;
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readDigit() ? 1 : 0) == 0) {
            int n5 = "\u5bcc\u6d2e".length();
            int n6 = "\u666a\u5a23\u5363".length();
            int n7 = "\u5937\u50ca\u5bf0".length();
            int n8 = "\u5c6c".length();
            throw this.expected("digit");
        }
        if (n4 != 48) {
            while (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readDigit() ? 1 : 0) != 0) {
            }
        }
        JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readFraction() ? 1 : 0);
        int n9 = "\u691a\u69e8\u51c1\u5e98".length();
        JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readExponent() ? 1 : 0);
        int n10 = "\u6d2c\u56f1\u554f\u5bd4".length();
        int n11 = "\u5c7a\u5d73".length();
        this.handler.endNumber(this.endCapture());
    }

    public boolean readFraction() throws IOException {
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('.') ? 1 : 0) == 0) {
            return false;
        }
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readDigit() ? 1 : 0) == 0) {
            int n = "\u5892\u6f99\u5b65\u6af3\u605c".length();
            int n2 = "\u60ac\u6500\u6ef8".length();
            int n3 = "\u6704\u5a67\u5e81".length();
            throw this.expected("digit");
        }
        while (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readDigit() ? 1 : 0) != 0) {
        }
        return true;
    }

    public boolean readExponent() throws IOException {
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('e') ? 1 : 0) == 0 && JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('E') ? 1 : 0) == 0) {
            return false;
        }
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('+') ? 1 : 0) == 0) {
            JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readChar('-') ? 1 : 0);
            int n = "\u5ec5\u6e16\u646a".length();
        }
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readDigit() ? 1 : 0) == 0) {
            int n = "\u557c\u6ccb\u5b18\u52d5\u63cb".length();
            int n2 = "\u6e9e\u56b7\u64ae\u6563\u64df".length();
            throw this.expected("digit");
        }
        while (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.readDigit() ? 1 : 0) != 0) {
        }
        return true;
    }

    public boolean readChar(char c) throws IOException {
        if (this.current != c) {
            return false;
        }
        this.read();
        return true;
    }

    public boolean readDigit() throws IOException {
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.isDigit() ? 1 : 0) == 0) {
            return false;
        }
        this.read();
        return true;
    }

    public void skipWhiteSpace() throws IOException {
        while (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.isWhiteSpace() ? 1 : 0) != 0) {
            this.read();
        }
    }

    public void read() throws IOException {
        if (this.index == this.fill) {
            if (this.captureStart != -1) {
                int n = "\u5daf\u57e3".length();
                int n2 = "\u63fe\u4e9d".length();
                this.captureBuffer.append(this.buffer, this.captureStart, this.fill - this.captureStart);
                int n3 = "\u56a3\u6bff".length();
                this.captureStart = 0;
            }
            int n = "\u6fdc\u6203".length();
            int n4 = "\u5f52\u68c6\u6767\u56e5\u5097".length();
            int n5 = "\u6f3b\u6f39\u5520".length();
            this.bufferOffset = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(this.bufferOffset, this.fill);
            this.fill = this.reader.read(this.buffer, 0, this.buffer.length);
            this.index = 0;
            if (this.fill == -1) {
                this.current = -1;
                int n6 = "\u5454\u6d05\u4fd6".length();
                this.index = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(this.index, 1);
                return;
            }
        }
        if (this.current == 10) {
            int n = "\u651a\u5069\u6954\u5ca7\u59a7".length();
            this.line = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(this.line, 1);
            this.lineOffset = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(this.bufferOffset, this.index);
        }
        int n = "\u5db4\u61c2\u5c94\u5060\u4e79".length();
        int n7 = "\u6dd5\u6441\u641e".length();
        int n8 = this.index;
        this.index = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(n8, 1);
        this.current = this.buffer[n8];
    }

    public void startCapture() {
        if (this.captureBuffer == null) {
            int n = "\u6c72".length();
            int n2 = "\u4f45\u5ff2\u6c37\u70f5".length();
            int n3 = "\u654e\u5866\u50b6\u6e85".length();
            this.captureBuffer = new StringBuilder();
        }
        int n = "\u56a9\u6d69".length();
        this.captureStart = this.index - 1;
    }

    public void pauseCapture() {
        int n;
        if (this.current == -1) {
            n = this.index;
        } else {
            int n2 = "\u6386".length();
            int n3 = "\u5014\u5c11\u59ee\u5fed\u6542".length();
            n = this.index - 1;
        }
        int n4 = n;
        int n5 = "\u6e93\u5acd".length();
        int n6 = "\u55bd\u58c1\u5302\u6ca1\u4f2d".length();
        this.captureBuffer.append(this.buffer, this.captureStart, n4 - this.captureStart);
        int n7 = "\u6a2e\u684b".length();
        this.captureStart = -1;
    }

    public String endCapture() {
        int n = this.captureStart;
        int n2 = "\u5e04\u64ac".length();
        int n3 = "\u6466\u54c0\u69bc\u5658\u66cb".length();
        int n4 = "\u5c56\u56ef".length();
        int n5 = "\u576d\u64da\u60a0".length();
        int n6 = "\u569b".length();
        int n7 = this.index - 1;
        this.captureStart = -1;
        if (this.captureBuffer.length() > 0) {
            int n8 = "\u6b65".length();
            int n9 = "\u4f25\u4f67\u5731\u6e40\u528a".length();
            int n10 = "\u5c81\u5dce\u64cd".length();
            this.captureBuffer.append(this.buffer, n, n7 - n);
            int n11 = "\u5b89".length();
            int n12 = "\u6276\u552a".length();
            String string = this.captureBuffer.toString();
            this.captureBuffer.setLength(0);
            return string;
        }
        int n13 = "\u6e65".length();
        int n14 = "\u61fa\u61a2\u5f5d\u5dc3\u5515".length();
        int n15 = "\u68b4".length();
        int n16 = "\u50e6\u5fc3".length();
        int n17 = "\u5473\u6d41".length();
        return new String(this.buffer, n, n7 - n);
    }

    public Location getLocation() {
        int n = "\u5924\u6813".length();
        int n2 = "\u6665\u6141\u69e7\u706d".length();
        int n3 = "\u6271\u5e11\u6bb7\u5afc\u513a".length();
        int n4 = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(this.bufferOffset, this.index) - 1;
        int n5 = "\u64b8\u5487\u6659\u6e46\u54c1".length();
        int n6 = JsonParser.INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(n4 - this.lineOffset, 1);
        int n7 = "\u588d\u594d\u5077\u6770".length();
        return new Location(n4, this.line, n6);
    }

    public ParseException expected(String string) {
        if (JsonParser.INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(this.isEndOfText() ? 1 : 0) != 0) {
            return this.error("Unexpected end of input");
        }
        int n = "\u6d6c\u626c\u6c7f\u5370\u53d9".length();
        int n2 = "\u7035\u51d5\u5546\u6da1\u537f".length();
        return this.error("Expected " + string);
    }

    public ParseException error(String string) {
        int n = "\u5512".length();
        return new ParseException(string, this.getLocation());
    }

    public boolean isWhiteSpace() {
        return this.current == 32 || this.current == 9 || this.current == 10 || this.current == 13;
    }

    public boolean isDigit() {
        return this.current >= 48 && this.current <= 57;
    }

    public boolean isHexDigit() {
        return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
    }

    public boolean isEndOfText() {
        return this.current == -1;
    }

    public static int INSOLENCE_\u6b25\u5fa4\u5f14\u6ff2\u56c1\u58c4\u6343\u5d62\u66eb\u6006\u5f83\u5c55\u6614\u5808\u52ef\u5072\u693f\u525a\u5215\u5413\u561b\u65ce\u4fde\u6462\u55a6\u6cfe\u6f10\u6899\u5789\u654b\u57db\u6c15\u6743\u63c8\u4f66\u5239\u5acd\u59cc\u5f24\u539f\u6ccc(int n) {
        return n;
    }

    public static int INSOLENCE_\u503c\u6b4b\u684e\u5658\u5b03\u6c9a\u54f6\u6aee\u654e\u6f90\u57af\u5d45\u67a2\u68be\u6763\u6f05\u6067\u541e\u5b20\u5628\u5484\u6729\u6227\u6033\u4f81\u630c\u6a78\u4ebd\u5fb3\u5e13\u56e5\u5552\u5ca6\u6f8d\u62d1\u5eed\u5aab\u514b\u681f\u6274\u57f9(int n, int n2) {
        return ((n | n2) << 1) + ~(n ^ n2) + 1;
    }
}

