/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class FlatEditorPaneUI
extends BasicEditorPaneUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    public /* synthetic */ int minimumWidth;
    public /* synthetic */ Color background;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color disabledBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color inactiveBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color focusedBackground;
    public /* synthetic */ Color oldDisabledBackground;
    public /* synthetic */ Color oldInactiveBackground;
    public /* synthetic */ Insets defaultMargin;
    public /* synthetic */ Object oldHonorDisplayProperties;
    public /* synthetic */ FocusListener focusListener;
    public /* synthetic */ Map<String, Object> oldStyleValues;

    public static /* synthetic */ ComponentUI createUI(JComponent jComponent) {
        int n = "\u55c1\u5cc1\u59b5\u5b52".length();
        int n2 = "\u5390\u6b73\u574b\u6d3c\u52c2".length();
        int n3 = "\u5375".length();
        return new FlatEditorPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        String string = this.getPropertyPrefix();
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        int n = "\u6302\u51a5\u6ac9".length();
        int n2 = "\u5a5f".length();
        this.background = UIManager.getColor(string + ".background");
        int n3 = "\u6528\u5861\u612a\u62c4".length();
        int n4 = "\u6cb7\u5c6d\u5917\u55dc\u6e2f".length();
        this.disabledBackground = UIManager.getColor(string + ".disabledBackground");
        int n5 = "\u6cf5\u5c0c\u6a35\u5fb7\u67e2".length();
        int n6 = "\u69e9\u5069\u6c29\u6fbd".length();
        this.inactiveBackground = UIManager.getColor(string + ".inactiveBackground");
        int n7 = "\u6454\u6616\u51fa".length();
        int n8 = "\u55f8\u5aa0\u66f1\u63da".length();
        int n9 = "\u68f2\u5874\u5a39\u543b".length();
        int n10 = "\u53b4\u4e93".length();
        this.focusedBackground = UIManager.getColor(string + ".focusedBackground");
        int n11 = "\u640b\u60a4\u50a1\u5a0f\u51ef".length();
        this.defaultMargin = UIManager.getInsets(string + ".margin");
        this.oldHonorDisplayProperties = this.getComponent().getClientProperty("JEditorPane.honorDisplayProperties");
        this.getComponent().putClientProperty("JEditorPane.honorDisplayProperties", true);
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.disabledBackground = null;
        this.inactiveBackground = null;
        this.focusedBackground = null;
        this.oldDisabledBackground = null;
        this.oldInactiveBackground = null;
        this.oldStyleValues = null;
        this.getComponent().putClientProperty("JEditorPane.honorDisplayProperties", this.oldHonorDisplayProperties);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        int n = "\u6218\u595d\u58cc".length();
        int n2 = "\u5110\u69b0".length();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent(), component -> this.focusedBackground != null);
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    @Override
    public Caret createCaret() {
        int n = "\u6951\u5e41".length();
        int n2 = "\u55ee\u5824\u6bfd".length();
        return new FlatCaret(null, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (FlatEditorPaneUI.INSOLENCE_\u5080\u55c0\u6004\u65bf\u6481\u590e\u5888\u5739\u5035\u4e75\u536e\u642c\u633e\u5dcb\u5d4d\u6912\u66e5\u6c9a\u59a7\u5603\u5fb6\u5a3b\u5203\u6343\u5241\u6ccd\u5df2\u6121\u616c\u5c1d\u598f\u6683\u6132\u6e9d\u5da2\u66e1\u5d74\u6509\u5e9c\u4e9c\u5f9f("editable".equals(string) ? 1 : 0) != 0 || FlatEditorPaneUI.INSOLENCE_\u5080\u55c0\u6004\u65bf\u6481\u590e\u5888\u5739\u5035\u4e75\u536e\u642c\u633e\u5dcb\u5d4d\u6912\u66e5\u6c9a\u59a7\u5603\u5fb6\u5a3b\u5203\u6343\u5241\u6ccd\u5df2\u6121\u616c\u5c1d\u598f\u6683\u6132\u6e9d\u5da2\u66e1\u5d74\u6509\u5e9c\u4e9c\u5f9f("enabled".equals(string) ? 1 : 0) != 0) {
            this.updateBackground();
        }
        super.propertyChange(propertyChangeEvent);
        FlatEditorPaneUI.propertyChange(this.getComponent(), propertyChangeEvent, this::installStyle);
    }

    public static /* synthetic */ void propertyChange(JTextComponent jTextComponent, PropertyChangeEvent propertyChangeEvent, Runnable runnable) {
        String string = propertyChangeEvent.getPropertyName();
        int n = -1;
        switch (string.hashCode()) {
            case -1302441837: {
                if (FlatEditorPaneUI.INSOLENCE_\u5080\u55c0\u6004\u65bf\u6481\u590e\u5888\u5739\u5035\u4e75\u536e\u642c\u633e\u5dcb\u5d4d\u6912\u66e5\u6c9a\u59a7\u5603\u5fb6\u5a3b\u5203\u6343\u5241\u6ccd\u5df2\u6121\u616c\u5c1d\u598f\u6683\u6132\u6e9d\u5da2\u66e1\u5d74\u6509\u5e9c\u4e9c\u5f9f(string.equals("JComponent.minimumWidth") ? 1 : 0) == 0) break;
                n = 0;
                break;
            }
            case 1545413499: {
                if (FlatEditorPaneUI.INSOLENCE_\u5080\u55c0\u6004\u65bf\u6481\u590e\u5888\u5739\u5035\u4e75\u536e\u642c\u633e\u5dcb\u5d4d\u6912\u66e5\u6c9a\u59a7\u5603\u5fb6\u5a3b\u5203\u6343\u5241\u6ccd\u5df2\u6121\u616c\u5c1d\u598f\u6683\u6132\u6e9d\u5da2\u66e1\u5d74\u6509\u5e9c\u4e9c\u5f9f(string.equals("FlatLaf.style") ? 1 : 0) == 0) break;
                n = 1;
                break;
            }
            case 1030195901: {
                if (FlatEditorPaneUI.INSOLENCE_\u5080\u55c0\u6004\u65bf\u6481\u590e\u5888\u5739\u5035\u4e75\u536e\u642c\u633e\u5dcb\u5d4d\u6912\u66e5\u6c9a\u59a7\u5603\u5fb6\u5a3b\u5203\u6343\u5241\u6ccd\u5df2\u6121\u616c\u5c1d\u598f\u6683\u6132\u6e9d\u5da2\u66e1\u5d74\u6509\u5e9c\u4e9c\u5f9f(string.equals("FlatLaf.styleClass") ? 1 : 0) == 0) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                jTextComponent.revalidate();
                break;
            }
            case 1: 
            case 2: {
                runnable.run();
                jTextComponent.revalidate();
                jTextComponent.repaint();
            }
        }
    }

    public void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.getComponent(), "EditorPane"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    public void applyStyle(Object object) {
        this.oldDisabledBackground = this.disabledBackground;
        this.oldInactiveBackground = this.inactiveBackground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        this.updateBackground();
    }

    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.getComponent(), string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    public void updateBackground() {
        FlatTextFieldUI.updateBackground(this.getComponent(), this.background, this.disabledBackground, this.inactiveBackground, this.oldDisabledBackground, this.oldInactiveBackground);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return FlatEditorPaneUI.applyMinimumWidth(jComponent, super.getPreferredSize(jComponent), this.minimumWidth, this.defaultMargin);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return FlatEditorPaneUI.applyMinimumWidth(jComponent, super.getMinimumSize(jComponent), this.minimumWidth, this.defaultMargin);
    }

    public static /* synthetic */ Dimension applyMinimumWidth(JComponent jComponent, Dimension dimension, int n, Insets insets) {
        if (FlatEditorPaneUI.INSOLENCE_\u5080\u55c0\u6004\u65bf\u6481\u590e\u5888\u5739\u5035\u4e75\u536e\u642c\u633e\u5dcb\u5d4d\u6912\u66e5\u6c9a\u59a7\u5603\u5fb6\u5a3b\u5203\u6343\u5241\u6ccd\u5df2\u6121\u616c\u5c1d\u598f\u6683\u6132\u6e9d\u5da2\u66e1\u5d74\u6509\u5e9c\u4e9c\u5f9f(FlatTextFieldUI.hasDefaultMargins(jComponent, insets) ? 1 : 0) == 0) {
            return dimension;
        }
        n = FlatUIUtils.minimumWidth(jComponent, n);
        int n2 = "\u5a48\u5e57\u59d6\u5b14".length();
        int n3 = "\u5fdd".length();
        int n4 = "\u6368\u56d4\u56f1".length();
        int n5 = "\u645c\u710a\u59ce".length();
        dimension.width = Math.max(dimension.width, UIScale.scale(n) - UIScale.scale(1) * 2);
        return dimension;
    }

    @Override
    public void paintSafely(Graphics graphics) {
        super.paintSafely(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics));
    }

    @Override
    public void paintBackground(Graphics graphics) {
        FlatEditorPaneUI.paintBackground(graphics, this.getComponent(), this.focusedBackground);
    }

    public static /* synthetic */ void paintBackground(Graphics graphics, JTextComponent jTextComponent, Color color) {
        graphics.setColor(FlatTextFieldUI.getBackground(jTextComponent, color));
        graphics.fillRect(0, 0, jTextComponent.getWidth(), jTextComponent.getHeight());
    }

    public static int INSOLENCE_\u5080\u55c0\u6004\u65bf\u6481\u590e\u5888\u5739\u5035\u4e75\u536e\u642c\u633e\u5dcb\u5d4d\u6912\u66e5\u6c9a\u59a7\u5603\u5fb6\u5a3b\u5203\u6343\u5241\u6ccd\u5df2\u6121\u616c\u5c1d\u598f\u6683\u6132\u6e9d\u5da2\u66e1\u5d74\u6509\u5e9c\u4e9c\u5f9f(int n) {
        return n;
    }
}

