/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class FlatSpinnerUI
extends BasicSpinnerUI
implements FlatStylingSupport.StyleableUI {
    public /* synthetic */ Handler handler;
    @FlatStylingSupport.Styleable
    public /* synthetic */ int minimumWidth;
    @FlatStylingSupport.Styleable
    public /* synthetic */ String buttonStyle;
    @FlatStylingSupport.Styleable
    public /* synthetic */ String arrowType;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color disabledBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color disabledForeground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color focusedBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color buttonBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ float buttonSeparatorWidth;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color buttonSeparatorColor;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color buttonDisabledSeparatorColor;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color buttonArrowColor;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color buttonDisabledArrowColor;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color buttonHoverArrowColor;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color buttonPressedArrowColor;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Insets padding;
    public /* synthetic */ Map<String, Object> oldStyleValues;
    public /* synthetic */ AtomicBoolean borderShared;
    public static final /* synthetic */ int MAC_STEPPER_WIDTH = 15;
    public static final /* synthetic */ int MAC_STEPPER_GAP = 3;

    public static /* synthetic */ ComponentUI createUI(JComponent jComponent) {
        int n = "\u5d45\u65a8".length();
        return new FlatSpinnerUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.spinner, "opaque", false);
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.buttonStyle = UIManager.getString("Spinner.buttonStyle");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.disabledBackground = UIManager.getColor("Spinner.disabledBackground");
        this.disabledForeground = UIManager.getColor("Spinner.disabledForeground");
        this.focusedBackground = UIManager.getColor("Spinner.focusedBackground");
        this.buttonBackground = UIManager.getColor("Spinner.buttonBackground");
        this.buttonSeparatorWidth = FlatUIUtils.getUIFloat("Spinner.buttonSeparatorWidth", FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f));
        this.buttonSeparatorColor = UIManager.getColor("Spinner.buttonSeparatorColor");
        this.buttonDisabledSeparatorColor = UIManager.getColor("Spinner.buttonDisabledSeparatorColor");
        this.buttonArrowColor = UIManager.getColor("Spinner.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("Spinner.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("Spinner.buttonHoverArrowColor");
        this.buttonPressedArrowColor = UIManager.getColor("Spinner.buttonPressedArrowColor");
        this.padding = UIManager.getInsets("Spinner.padding");
        MigLayoutVisualPadding.install(this.spinner);
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.focusedBackground = null;
        this.buttonBackground = null;
        this.buttonSeparatorColor = null;
        this.buttonDisabledSeparatorColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        this.buttonPressedArrowColor = null;
        this.padding = null;
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(this.spinner);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.addEditorFocusListener(this.spinner.getEditor());
        this.spinner.addFocusListener(this.getHandler());
        this.spinner.addPropertyChangeListener(this.getHandler());
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.removeEditorFocusListener(this.spinner.getEditor());
        this.spinner.removeFocusListener(this.getHandler());
        this.spinner.removePropertyChangeListener(this.getHandler());
        this.handler = null;
    }

    public Handler getHandler() {
        if (this.handler == null) {
            int n = "\u52da\u6a89\u5312\u53c4".length();
            int n2 = "\u6e55\u4e99\u57c3".length();
            int n3 = "\u5817\u5811\u53e0".length();
            this.handler = new Handler(null);
        }
        return this.handler;
    }

    public void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.spinner, "Spinner"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    public void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        this.updateEditorPadding();
        this.updateArrowButtonsStyle();
    }

    public Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            int n = "\u4e7e\u6cd9\u56fb".length();
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.spinner, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.spinner.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.spinner.getBorder(), string);
    }

    @Override
    public JComponent createEditor() {
        JComponent jComponent = super.createEditor();
        this.configureEditor(jComponent);
        return jComponent;
    }

    @Override
    public void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        super.replaceEditor(jComponent, jComponent2);
        this.configureEditor(jComponent2);
        this.removeEditorFocusListener(jComponent);
        this.addEditorFocusListener(jComponent2);
    }

    public void configureEditor(JComponent jComponent) {
        jComponent.setOpaque(false);
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.setOpaque(false);
        }
        this.updateEditorPadding();
        this.updateEditorColors();
    }

    public void addEditorFocusListener(JComponent jComponent) {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.addFocusListener(this.getHandler());
        }
    }

    public void removeEditorFocusListener(JComponent jComponent) {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.removeFocusListener(this.getHandler());
        }
    }

    public void updateEditorPadding() {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.putClientProperty("JTextField.padding", this.padding);
        }
    }

    public void updateEditorColors() {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.setForeground(FlatUIUtils.nonUIResource(this.getForeground(true)));
            jTextField.setDisabledTextColor(FlatUIUtils.nonUIResource(this.getForeground(false)));
        }
    }

    public static /* synthetic */ JTextField getEditorTextField(JComponent jComponent) {
        return jComponent instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)jComponent).getTextField() : null;
    }

    public static /* synthetic */ boolean isPermanentFocusOwner(JSpinner jSpinner) {
        if (FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(FlatUIUtils.isPermanentFocusOwner(jSpinner) ? 1 : 0) != 0) {
            return true;
        }
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(jSpinner.getEditor());
        return jTextField != null && FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(FlatUIUtils.isPermanentFocusOwner(jTextField) ? 1 : 0) != 0;
    }

    public Color getBackground(boolean bl) {
        if (bl) {
            Color color = this.spinner.getBackground();
            if (!(color instanceof UIResource)) {
                return color;
            }
            if (this.focusedBackground != null && FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(FlatSpinnerUI.isPermanentFocusOwner(this.spinner) ? 1 : 0) != 0) {
                return this.focusedBackground;
            }
            return color;
        }
        return this.disabledBackground;
    }

    public Color getForeground(boolean bl) {
        return bl ? this.spinner.getForeground() : this.disabledForeground;
    }

    @Override
    public LayoutManager createLayout() {
        return this.getHandler();
    }

    @Override
    public Component createNextButton() {
        return this.createArrowButton(1, "Spinner.nextButton");
    }

    @Override
    public Component createPreviousButton() {
        return this.createArrowButton(5, "Spinner.previousButton");
    }

    public Component createArrowButton(int n, String string) {
        int n2 = "\u5793\u6e90\u6b62".length();
        int n3 = "\u5d36".length();
        int n4 = "\u60c9\u676d\u6cfb\u5432".length();
        FlatArrowButton flatArrowButton = new FlatArrowButton(n, this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null){

            @Override
            public int getArrowWidth() {
                return 1.INSOLENCE_\u53a0\u52ef\u5cd7\u6a68\u6449\u6c0b\u5c97\u5e15\u508f\u51ce\u6f24\u4fab\u6aaf\u63f3\u6513\u6ac6\u5bac\u5f5a\u67f8\u6d72\u6200\u5127\u57f6\u509d\u5d75\u5512\u52f9\u6fdc\u5805\u68a2\u69cc\u63a9\u611e\u6ecf\u4f0c\u6980\u7023\u5be1\u6200\u5f13\u6a86(FlatSpinnerUI.this.isMacStyle() ? 1 : 0) != 0 ? 7 : super.getArrowWidth();
            }

            @Override
            public float getArrowThickness() {
                return 1.INSOLENCE_\u53a0\u52ef\u5cd7\u6a68\u6449\u6c0b\u5c97\u5e15\u508f\u51ce\u6f24\u4fab\u6aaf\u63f3\u6513\u6ac6\u5bac\u5f5a\u67f8\u6d72\u6200\u5127\u57f6\u509d\u5d75\u5512\u52f9\u6fdc\u5805\u68a2\u69cc\u63a9\u611e\u6ecf\u4f0c\u6980\u7023\u5be1\u6200\u5f13\u6a86(FlatSpinnerUI.this.isMacStyle() ? 1 : 0) != 0 ? 1.5f : super.getArrowThickness();
            }

            @Override
            public float getYOffset() {
                return 1.INSOLENCE_\u53a0\u52ef\u5cd7\u6a68\u6449\u6c0b\u5c97\u5e15\u508f\u51ce\u6f24\u4fab\u6aaf\u63f3\u6513\u6ac6\u5bac\u5f5a\u67f8\u6d72\u6200\u5127\u57f6\u509d\u5d75\u5512\u52f9\u6fdc\u5805\u68a2\u69cc\u63a9\u611e\u6ecf\u4f0c\u6980\u7023\u5be1\u6200\u5f13\u6a86(FlatSpinnerUI.this.isMacStyle() ? 1 : 0) != 0 ? 0.0f : super.getYOffset();
            }

            @Override
            public boolean isRoundBorderAutoXOffset() {
                return (1.INSOLENCE_\u53a0\u52ef\u5cd7\u6a68\u6449\u6c0b\u5c97\u5e15\u508f\u51ce\u6f24\u4fab\u6aaf\u63f3\u6513\u6ac6\u5bac\u5f5a\u67f8\u6d72\u6200\u5127\u57f6\u509d\u5d75\u5512\u52f9\u6fdc\u5805\u68a2\u69cc\u63a9\u611e\u6ecf\u4f0c\u6980\u7023\u5be1\u6200\u5f13\u6a86(FlatSpinnerUI.this.isMacStyle() ? 1 : 0) != 0 ? 0 : 1.INSOLENCE_\u53a0\u52ef\u5cd7\u6a68\u6449\u6c0b\u5c97\u5e15\u508f\u51ce\u6f24\u4fab\u6aaf\u63f3\u6513\u6ac6\u5bac\u5f5a\u67f8\u6d72\u6200\u5127\u57f6\u509d\u5d75\u5512\u52f9\u6fdc\u5805\u68a2\u69cc\u63a9\u611e\u6ecf\u4f0c\u6980\u7023\u5be1\u6200\u5f13\u6a86(super.isRoundBorderAutoXOffset() ? 1 : 0)) != 0;
            }

            public static int INSOLENCE_\u53a0\u52ef\u5cd7\u6a68\u6449\u6c0b\u5c97\u5e15\u508f\u51ce\u6f24\u4fab\u6aaf\u63f3\u6513\u6ac6\u5bac\u5f5a\u67f8\u6d72\u6200\u5127\u57f6\u509d\u5d75\u5512\u52f9\u6fdc\u5805\u68a2\u69cc\u63a9\u611e\u6ecf\u4f0c\u6980\u7023\u5be1\u6200\u5f13\u6a86(int n) {
                return n;
            }
        };
        flatArrowButton.setName(string);
        flatArrowButton.setYOffset(n == 1 ? 1.25f : -1.25f);
        if (n == 1) {
            this.installNextButtonListeners(flatArrowButton);
        } else {
            this.installPreviousButtonListeners(flatArrowButton);
        }
        return flatArrowButton;
    }

    public void updateArrowButtonsStyle() {
        Component[] componentArray = this.spinner.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; i += 5341) {
            Component component = componentArray[i];
            if (component instanceof FlatArrowButton) {
                ((FlatArrowButton)component).updateStyle(this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null);
            }
            i -= 5340;
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f = FlatUIUtils.getBorderFocusWidth(jComponent);
        float f2 = FlatUIUtils.getBorderArc(jComponent);
        if (FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(jComponent.isOpaque() ? 1 : 0) != 0 && (f > 0.0f || f2 > 0.0f)) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics2D);
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        boolean bl = FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(this.spinner.isEnabled() ? 1 : 0);
        int n3 = FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(this.spinner.getComponentOrientation().isLeftToRight() ? 1 : 0);
        int n4 = FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(this.isMacStyle() ? 1 : 0);
        int n5 = n4 != 0 ? this.getMacStyleButtonsWidth() : 0;
        graphics2D.setColor(this.getBackground(bl));
        int n6 = "\u4e3f\u5dc8\u6595\u66e8\u6c15".length();
        int n7 = "\u6969\u65f4\u5a01\u4ef6".length();
        int n8 = "\u5e6a\u5762\u701f\u5169\u6ee5".length();
        FlatUIUtils.paintComponentBackground(graphics2D, n3 != 0 ? 0 : n5, 0, n - n5, n2, f, f2);
        boolean bl2 = FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244("none".equals(this.buttonStyle) ? 1 : 0) == 0;
        Handler handler = this.getHandler();
        if (bl2 && (handler.nextButton != null || handler.previousButton != null)) {
            Color color;
            Component component = handler.nextButton != null ? handler.nextButton : handler.previousButton;
            int n9 = component.getX();
            int n10 = component.getWidth();
            Color color2 = color = bl ? this.buttonSeparatorColor : this.buttonDisabledSeparatorColor;
            if (n4 != 0) {
                Insets insets = this.spinner.getInsets();
                int n11 = Math.round(FlatUIUtils.getBorderLineWidth(this.spinner));
                int n12 = n9;
                int n13 = "\u6434\u63ba\u666b\u6d08".length();
                int n14 = "\u6a2b\u5a4a".length();
                int n15 = "\u6b41\u6345\u6806".length();
                int n16 = insets.top - n11;
                int n17 = n10;
                int n18 = "\u62cd\u6d68\u51b1\u6a82\u52b8".length();
                int n19 = "\u6ead\u61bb".length();
                int n20 = "\u4e94\u70f1\u5035\u5e43\u5bd3".length();
                int n21 = "\u5841\u54d9\u6c42\u5323\u5f2e".length();
                int n22 = "\u6c6c\u6fc2\u54ac\u6177\u57a7".length();
                int n23 = FlatSpinnerUI.INSOLENCE_\u4e97\u5e33\u6ac3\u6106\u6757\u713f\u4ebe\u5305\u4f38\u524d\u5c03\u5d90\u5150\u5dea\u5b58\u69d1\u68dc\u659b\u5b0d\u5084\u7056\u5973\u6edd\u5a03\u5989\u50da\u54f8\u4f22\u6b23\u6b86\u5d67\u51e1\u55ad\u6925\u58de\u5ad9\u6817\u5dab\u6a41\u56b0\u513a(n2 - insets.top - insets.bottom, n11 * 2);
                float f3 = UIScale.scale(this.buttonSeparatorWidth);
                FlatUIUtils.paintOutlinedComponent(graphics2D, n12, n16, n17, n23, 0.0f, 0.0f, 0.0f, f3, UIScale.scale(12), null, color, this.buttonBackground);
                if (color != null) {
                    int n24 = UIScale.scale(1);
                    graphics2D.setColor(color);
                    int n25 = "\u5506\u5b69\u626c\u4fd4\u67d9".length();
                    int n26 = "\u6468".length();
                    int n27 = "\u5be7\u6a89\u5e72\u6b2a\u62e6".length();
                    int n28 = "\u6e34\u56cd\u5a8f".length();
                    int n29 = "\u66ec\u54bd\u4f04".length();
                    int n30 = "\u5479".length();
                    int n31 = "\u64e8\u697c".length();
                    graphics2D.fill(new Rectangle2D.Float((float)n12 + f3, (float)n16 + (float)(n23 - n24) / 2.0f, (float)n17 - f3 * 2.0f, n24));
                }
            } else {
                if (bl && this.buttonBackground != null) {
                    graphics2D.setColor(this.buttonBackground);
                    Shape shape = graphics2D.getClip();
                    if (n3 != 0) {
                        int n32 = "\u6852\u617a\u5f81".length();
                        int n33 = "\u696f\u5101\u597d\u6cf2\u5be0".length();
                        int n34 = "\u5f14\u4ed4".length();
                        int n35 = "\u634a\u518f".length();
                        graphics2D.clipRect(n9, 0, n - n9, n2);
                    } else {
                        graphics2D.clipRect(0, 0, FlatSpinnerUI.INSOLENCE_\u4e97\u5e33\u6ac3\u6106\u6757\u713f\u4ebe\u5305\u4f38\u524d\u5c03\u5d90\u5150\u5dea\u5b58\u69d1\u68dc\u659b\u5b0d\u5084\u7056\u5973\u6edd\u5a03\u5989\u50da\u54f8\u4f22\u6b23\u6b86\u5d67\u51e1\u55ad\u6925\u58de\u5ad9\u6817\u5dab\u6a41\u56b0\u513a(n9, n10), n2);
                    }
                    FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, n, n2, f, f2);
                    graphics2D.setClip(shape);
                }
                if (color != null && this.buttonSeparatorWidth > 0.0f) {
                    float f3;
                    graphics2D.setColor(color);
                    float f5 = UIScale.scale(this.buttonSeparatorWidth);
                    if (n3 != 0) {
                        f3 = n9;
                    } else {
                        int n36 = "\u57fa\u511f\u54c7\u6e4f".length();
                        int n37 = "\u643f\u6ec7\u7103\u660d".length();
                        f3 = (float)FlatSpinnerUI.INSOLENCE_\u4e97\u5e33\u6ac3\u6106\u6757\u713f\u4ebe\u5305\u4f38\u524d\u5c03\u5d90\u5150\u5dea\u5b58\u69d1\u68dc\u659b\u5b0d\u5084\u7056\u5973\u6edd\u5a03\u5989\u50da\u54f8\u4f22\u6b23\u6b86\u5d67\u51e1\u55ad\u6925\u58de\u5ad9\u6817\u5dab\u6a41\u56b0\u513a(n9, n10) - f5;
                    }
                    float f6 = f3;
                    int n38 = "\u58c5".length();
                    int n39 = "\u582a\u65f7\u5c74\u6ceb\u6d9e".length();
                    int n40 = "\u62a1".length();
                    int n41 = "\u5e57\u58a2".length();
                    int n42 = "\u550d".length();
                    graphics2D.fill(new Rectangle2D.Float(f6, f, f5, (float)(n2 - 1) - f * 2.0f));
                }
            }
        }
        this.paint(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    public boolean isMacStyle() {
        return FlatSpinnerUI.INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244("mac".equals(this.buttonStyle) ? 1 : 0) != 0;
    }

    public int getMacStyleButtonsWidth() {
        return this.handler.nextButton != null || this.handler.previousButton != null ? FlatSpinnerUI.INSOLENCE_\u4e97\u5e33\u6ac3\u6106\u6757\u713f\u4ebe\u5305\u4f38\u524d\u5c03\u5d90\u5150\u5dea\u5b58\u69d1\u68dc\u659b\u5b0d\u5084\u7056\u5973\u6edd\u5a03\u5989\u50da\u54f8\u4f22\u6b23\u6b86\u5d67\u51e1\u55ad\u6925\u58de\u5ad9\u6817\u5dab\u6a41\u56b0\u513a(UIScale.scale(3), UIScale.scale(15)) : 0;
    }

    public static int INSOLENCE_\u6dbb\u7080\u585d\u6398\u5521\u5e61\u54cd\u52ce\u5fcf\u566b\u6216\u54af\u503b\u69c5\u5d7d\u54d7\u630c\u62a0\u52f3\u63bb\u5341\u57fa\u68ee\u5412\u64c0\u6fef\u6232\u5103\u680c\u59c9\u60eb\u66d5\u5178\u54b9\u5517\u5bfe\u614b\u56df\u6272\u5b20\u6244(int n) {
        return n;
    }

    public static int INSOLENCE_\u4e97\u5e33\u6ac3\u6106\u6757\u713f\u4ebe\u5305\u4f38\u524d\u5c03\u5d90\u5150\u5dea\u5b58\u69d1\u68dc\u659b\u5b0d\u5084\u7056\u5973\u6edd\u5a03\u5989\u50da\u54f8\u4f22\u6b23\u6b86\u5d67\u51e1\u55ad\u6925\u58de\u5ad9\u6817\u5dab\u6a41\u56b0\u513a(int n, int n2) {
        return ((n | n2) << 1) + ~(n ^ n2) + 1;
    }

    private class Handler
    implements LayoutManager,
    FocusListener,
    PropertyChangeListener {
        public /* synthetic */ Component editor;
        public /* synthetic */ Component nextButton;
        public /* synthetic */ Component previousButton;

        public Handler() {
            this.editor = null;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            String string2 = string;
            int n = -1;
            switch (string2.hashCode()) {
                case 2071006605: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string2.equals("Editor") ? 1 : 0) == 0) break;
                    n = 0;
                    break;
                }
                case 2424595: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string2.equals("Next") ? 1 : 0) == 0) break;
                    n = 1;
                    break;
                }
                case -1209131241: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string2.equals("Previous") ? 1 : 0) == 0) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    this.editor = component;
                    break;
                }
                case 1: {
                    this.nextButton = component;
                    break;
                }
                case 2: {
                    this.previousButton = component;
                }
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.editor) {
                this.editor = null;
            } else if (component == this.nextButton) {
                this.nextButton = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Insets insets = container.getInsets();
            Insets insets2 = UIScale.scale(FlatSpinnerUI.this.padding);
            if (this.editor != null) {
                dimension = this.editor.getPreferredSize();
            } else {
                Dimension dimension2;
                int n = "\u68d9\u5832".length();
                int n2 = "\u62bd".length();
                int n3 = "\u6b52".length();
                int n4 = "\u5924\u5f51\u69b5\u6f73".length();
                dimension = dimension2;
                dimension2 = new Dimension(0, 0);
            }
            Dimension dimension3 = dimension;
            int n = FlatUIUtils.minimumWidth(FlatSpinnerUI.this.spinner, FlatSpinnerUI.this.minimumWidth);
            int n5 = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(dimension3.height, insets2.top), insets2.bottom);
            float f = FlatUIUtils.getBorderFocusWidth(FlatSpinnerUI.this.spinner);
            int n6 = "\u509c\u7033\u6fd4\u6dcb".length();
            int n7 = "\u6c46\u6774\u5b17".length();
            int n8 = "\u5f19\u53c2\u505e\u6824".length();
            return new Dimension(Math.max(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(insets.left, insets.right), dimension3.width), insets2.left), insets2.right), n5), Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(UIScale.scale(n), Math.round(f * 2.0f))), Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(insets.top, insets.bottom), n5));
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n3 = "\u6241".length();
            Rectangle rectangle = FlatUIUtils.subtractInsets(new Rectangle(dimension), insets);
            if (this.nextButton == null && this.previousButton == null) {
                if (this.editor != null) {
                    this.editor.setBounds(rectangle);
                }
                return;
            }
            int n4 = "\u663c\u4e3a".length();
            Rectangle rectangle2 = new Rectangle(rectangle);
            int n5 = "\u6973\u5a76".length();
            Rectangle rectangle3 = new Rectangle(rectangle);
            FontMetrics fontMetrics = FlatSpinnerUI.this.spinner.getFontMetrics(FlatSpinnerUI.this.spinner.getFont());
            int n6 = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(fontMetrics.getHeight(), UIScale.scale(FlatSpinnerUI.this.padding.top)), UIScale.scale(FlatSpinnerUI.this.padding.bottom));
            int n7 = n6 * 3 / 4;
            int n8 = Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(FlatSpinnerUI.this.isMacStyle() ? 1 : 0);
            int n9 = n8 != 0 ? UIScale.scale(3) : 0;
            int n10 = n8 != 0 ? UIScale.scale(15) : rectangle3.height;
            rectangle3.width = n2 = Math.min(Math.max(n10, n7), n6);
            int n11 = "\u583f".length();
            int n12 = "\u5dd8\u61ff\u6634\u6a91\u654c".length();
            int n13 = "\u6054\u5ef5\u5c09\u513a".length();
            rectangle2.width -= Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(n2, n9);
            int n14 = Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(container.getComponentOrientation().isLeftToRight() ? 1 : 0);
            if (n14 != 0) {
                int n15 = "\u6410".length();
                int n16 = "\u6921".length();
                int n17 = "\u710b\u53ea".length();
                rectangle3.x = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(rectangle3.x, Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(rectangle2.width, n9));
            } else {
                int n18 = "\u6e0c\u5390\u6813\u6b38".length();
                int n19 = "\u62f0\u6cb5\u59ad\u5ab5\u5489".length();
                rectangle2.x = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(rectangle2.x, Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(n2, n9));
            }
            if (n8 != 0 && (n = Math.round(FlatUIUtils.getBorderLineWidth(FlatSpinnerUI.this.spinner))) > 0) {
                int n20 = "\u500b".length();
                int n21 = "\u66de\u5ecd".length();
                rectangle3.x = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(rectangle3.x, n14 != 0 ? n : -n);
                int n22 = "\u6faa".length();
                int n23 = "\u6f0f".length();
                int n24 = "\u6a0a\u7137\u5539".length();
                rectangle3.y -= n;
                int n25 = "\u68f1\u701c".length();
                int n26 = "\u658d\u563d".length();
                int n27 = "\u588c".length();
                int n28 = "\u4ffa\u584f\u6db0\u4e22\u6fba".length();
                rectangle3.height = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(rectangle3.height, n * 2);
            }
            if (this.editor != null) {
                this.editor.setBounds(rectangle2);
            }
            n = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(rectangle3.height / 2, rectangle3.height % 2);
            if (this.nextButton != null) {
                this.nextButton.setBounds(rectangle3.x, rectangle3.y, rectangle3.width, n);
            }
            if (this.previousButton != null) {
                int n29 = "\u56aa\u6931\u6c00\u6d32".length();
                int n30 = "\u5753".length();
                int n31 = Handler.INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(rectangle3.y, rectangle3.height) - n;
                this.previousButton.setBounds(rectangle3.x, n31, rectangle3.width, n);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField;
            FlatSpinnerUI.this.spinner.repaint();
            if (focusEvent.getComponent() == FlatSpinnerUI.this.spinner && (jTextField = FlatSpinnerUI.getEditorTextField(FlatSpinnerUI.this.spinner.getEditor())) != null) {
                Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(jTextField.requestFocusInWindow() ? 1 : 0);
                int n = "\u598f\u6637".length();
                int n2 = "\u5884\u6de8".length();
                int n3 = "\u5a75".length();
                int n4 = "\u7085".length();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FlatSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            int n = -1;
            switch (string.hashCode()) {
                case 1984457027: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string.equals("foreground") ? 1 : 0) == 0) break;
                    n = 0;
                    break;
                }
                case -1609594047: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string.equals("enabled") ? 1 : 0) == 0) break;
                    n = 1;
                    break;
                }
                case -742334409: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string.equals("JComponent.roundRect") ? 1 : 0) == 0) break;
                    n = 2;
                    break;
                }
                case -691370713: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string.equals("JComponent.outline") ? 1 : 0) == 0) break;
                    n = 3;
                    break;
                }
                case -1302441837: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string.equals("JComponent.minimumWidth") ? 1 : 0) == 0) break;
                    n = 4;
                    break;
                }
                case 1545413499: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string.equals("FlatLaf.style") ? 1 : 0) == 0) break;
                    n = 5;
                    break;
                }
                case 1030195901: {
                    if (Handler.INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(string.equals("FlatLaf.styleClass") ? 1 : 0) == 0) break;
                    n = 6;
                }
            }
            switch (n) {
                case 0: 
                case 1: {
                    FlatSpinnerUI.this.updateEditorColors();
                    break;
                }
                case 2: 
                case 3: {
                    FlatSpinnerUI.this.spinner.repaint();
                    break;
                }
                case 4: {
                    FlatSpinnerUI.this.spinner.revalidate();
                    break;
                }
                case 5: 
                case 6: {
                    FlatSpinnerUI.this.installStyle();
                    FlatSpinnerUI.this.spinner.revalidate();
                    FlatSpinnerUI.this.spinner.repaint();
                }
            }
        }

        public /* synthetic */ Handler(1 var2_2) {
            this();
        }

        public static int INSOLENCE_\u68ec\u5049\u5e7e\u5e5d\u54eb\u6398\u5344\u543b\u6c95\u61dd\u5946\u53f1\u5066\u5c33\u5acb\u593d\u5ae6\u5c9e\u5884\u5ae9\u6fa6\u69ee\u6e06\u6232\u6475\u58c7\u5b92\u5902\u6d02\u5ed7\u5002\u691d\u6c87\u5050\u671a\u6fba\u69bf\u5a4f\u59e4\u6191\u65e8(int n) {
            return n;
        }

        public static int INSOLENCE_\u563c\u624c\u4eb7\u65a4\u6d2b\u5ea6\u5e7f\u4ec7\u654f\u5ec7\u6691\u6704\u57bb\u573f\u53b1\u5b56\u559f\u5d8a\u53d0\u6756\u70bc\u6922\u6909\u5ce1\u4f89\u5451\u509c\u6afa\u633b\u56b9\u6998\u6a2d\u68f5\u6ff6\u5d05\u7069\u5225\u6005\u6df1\u5c00\u50b1(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }
}

