/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatEditorPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;

public class FlatTextAreaUI
extends BasicTextAreaUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    public /* synthetic */ int minimumWidth;
    public /* synthetic */ Color background;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color disabledBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color inactiveBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color focusedBackground;
    public /* synthetic */ Color oldDisabledBackground;
    public /* synthetic */ Color oldInactiveBackground;
    public /* synthetic */ Insets defaultMargin;
    public /* synthetic */ FocusListener focusListener;
    public /* synthetic */ Map<String, Object> oldStyleValues;

    public static /* synthetic */ ComponentUI createUI(JComponent jComponent) {
        int n = "\u684e\u660b\u5cb6\u633d\u617b".length();
        return new FlatTextAreaUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatTextAreaUI.INSOLENCE_\u57e1\u5229\u66b5\u56bb\u64de\u6bec\u68eb\u4ebf\u627b\u56dd\u7115\u6a1e\u5469\u6f9c\u6797\u644a\u650a\u6ce4\u6fba\u64cb\u6cf0\u6ed4\u5a2e\u5bb9\u612b\u6a78\u4f65\u61e2\u6c2c\u51f8\u5faf\u617d\u696a\u4eaa\u5e6c\u65db\u5582\u5e8c\u6be1\u6443\u7010(FlatUIUtils.needsLightAWTPeer(jComponent) ? 1 : 0) != 0) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    public void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.background = UIManager.getColor("TextArea.background");
        this.disabledBackground = UIManager.getColor("TextArea.disabledBackground");
        this.inactiveBackground = UIManager.getColor("TextArea.inactiveBackground");
        this.focusedBackground = UIManager.getColor("TextArea.focusedBackground");
        this.defaultMargin = UIManager.getInsets("TextArea.margin");
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.disabledBackground = null;
        this.inactiveBackground = null;
        this.focusedBackground = null;
        this.oldDisabledBackground = null;
        this.oldInactiveBackground = null;
        this.oldStyleValues = null;
    }

    @Override
    public void installListeners() {
        super.installListeners();
        int n = "\u6248\u5db9\u70d6".length();
        int n2 = "\u5875\u6d65\u5ab6\u5ea8".length();
        int n3 = "\u6b99".length();
        int n4 = "\u5424".length();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent(), component -> this.focusedBackground != null);
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    @Override
    public Caret createCaret() {
        int n = "\u551f\u5871\u633f".length();
        int n2 = "\u61aa\u58c9\u6764\u4ea7".length();
        int n3 = "\u70eb\u676f\u6aca\u5a95".length();
        return new FlatCaret(null, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (FlatTextAreaUI.INSOLENCE_\u57e1\u5229\u66b5\u56bb\u64de\u6bec\u68eb\u4ebf\u627b\u56dd\u7115\u6a1e\u5469\u6f9c\u6797\u644a\u650a\u6ce4\u6fba\u64cb\u6cf0\u6ed4\u5a2e\u5bb9\u612b\u6a78\u4f65\u61e2\u6c2c\u51f8\u5faf\u617d\u696a\u4eaa\u5e6c\u65db\u5582\u5e8c\u6be1\u6443\u7010("editable".equals(string) ? 1 : 0) != 0 || FlatTextAreaUI.INSOLENCE_\u57e1\u5229\u66b5\u56bb\u64de\u6bec\u68eb\u4ebf\u627b\u56dd\u7115\u6a1e\u5469\u6f9c\u6797\u644a\u650a\u6ce4\u6fba\u64cb\u6cf0\u6ed4\u5a2e\u5bb9\u612b\u6a78\u4f65\u61e2\u6c2c\u51f8\u5faf\u617d\u696a\u4eaa\u5e6c\u65db\u5582\u5e8c\u6be1\u6443\u7010("enabled".equals(string) ? 1 : 0) != 0) {
            this.updateBackground();
        }
        super.propertyChange(propertyChangeEvent);
        FlatEditorPaneUI.propertyChange(this.getComponent(), propertyChangeEvent, this::installStyle);
    }

    public void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.getComponent(), "TextArea"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    public void applyStyle(Object object) {
        this.oldDisabledBackground = this.disabledBackground;
        this.oldInactiveBackground = this.inactiveBackground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        this.updateBackground();
    }

    public Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.getComponent(), string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    public void updateBackground() {
        FlatTextFieldUI.updateBackground(this.getComponent(), this.background, this.disabledBackground, this.inactiveBackground, this.oldDisabledBackground, this.oldInactiveBackground);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.applyMinimumWidth(jComponent, super.getPreferredSize(jComponent));
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.applyMinimumWidth(jComponent, super.getMinimumSize(jComponent));
    }

    public Dimension applyMinimumWidth(JComponent jComponent, Dimension dimension) {
        if (jComponent instanceof JTextArea && ((JTextArea)jComponent).getColumns() > 0) {
            return dimension;
        }
        return FlatEditorPaneUI.applyMinimumWidth(jComponent, dimension, this.minimumWidth, this.defaultMargin);
    }

    @Override
    public void paintSafely(Graphics graphics) {
        super.paintSafely(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics));
    }

    @Override
    public void paintBackground(Graphics graphics) {
        FlatEditorPaneUI.paintBackground(graphics, this.getComponent(), this.focusedBackground);
    }

    public static int INSOLENCE_\u57e1\u5229\u66b5\u56bb\u64de\u6bec\u68eb\u4ebf\u627b\u56dd\u7115\u6a1e\u5469\u6f9c\u6797\u644a\u650a\u6ce4\u6fba\u64cb\u6cf0\u6ed4\u5a2e\u5bb9\u612b\u6a78\u4f65\u61e2\u6c2c\u51f8\u5faf\u617d\u696a\u4eaa\u5e6c\u65db\u5582\u5e8c\u6be1\u6443\u7010(int n) {
        return n;
    }
}

