/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class FlatTextFieldUI
extends BasicTextFieldUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    public /* synthetic */ int minimumWidth;
    public /* synthetic */ Color background;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color disabledBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color inactiveBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color placeholderForeground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Color focusedBackground;
    @FlatStylingSupport.Styleable
    public /* synthetic */ int iconTextGap;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Icon leadingIcon;
    @FlatStylingSupport.Styleable
    public /* synthetic */ Icon trailingIcon;
    public /* synthetic */ JComponent leadingComponent;
    public /* synthetic */ JComponent trailingComponent;
    public /* synthetic */ JComponent clearButton;
    @FlatStylingSupport.Styleable
    public /* synthetic */ boolean showClearButton;
    public /* synthetic */ Color oldDisabledBackground;
    public /* synthetic */ Color oldInactiveBackground;
    public /* synthetic */ Insets defaultMargin;
    public /* synthetic */ FocusListener focusListener;
    public /* synthetic */ DocumentListener documentListener;
    public /* synthetic */ Map<String, Object> oldStyleValues;
    public /* synthetic */ AtomicBoolean borderShared;

    public static /* synthetic */ ComponentUI createUI(JComponent jComponent) {
        int n = "\u6e0f\u5379".length();
        int n2 = "\u5c29".length();
        return new FlatTextFieldUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(FlatUIUtils.needsLightAWTPeer(jComponent) ? 1 : 0) != 0) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    public void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.leadingIcon = FlatClientProperties.clientProperty(jComponent, "JTextField.leadingIcon", null, Icon.class);
        this.trailingIcon = FlatClientProperties.clientProperty(jComponent, "JTextField.trailingIcon", null, Icon.class);
        this.installLeadingComponent();
        this.installTrailingComponent();
        this.installClearButton();
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallLeadingComponent();
        this.uninstallTrailingComponent();
        this.uninstallClearButton();
        super.uninstallUI(jComponent);
        this.leadingIcon = null;
        this.trailingIcon = null;
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        String string = this.getPropertyPrefix();
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        int n = "\u6183\u6bb4\u5e88".length();
        int n2 = "\u5ef6\u5841\u5d3d".length();
        int n3 = "\u6607\u52b6\u6d53\u4f92".length();
        int n4 = "\u55c1".length();
        this.background = UIManager.getColor(string + ".background");
        int n5 = "\u6629\u55d4\u5f73\u6bd6".length();
        this.disabledBackground = UIManager.getColor(string + ".disabledBackground");
        int n6 = "\u661c\u70cb".length();
        int n7 = "\u5a77\u594b\u5bbe\u6ca2\u5571".length();
        int n8 = "\u4f4d\u5479\u6c0b".length();
        int n9 = "\u6ff9\u50bf\u696f\u5af8\u525d".length();
        this.inactiveBackground = UIManager.getColor(string + ".inactiveBackground");
        int n10 = "\u5133\u56d0\u5906".length();
        int n11 = "\u6531\u607c\u5051\u4ebc\u6eba".length();
        int n12 = "\u5514".length();
        this.placeholderForeground = UIManager.getColor(string + ".placeholderForeground");
        int n13 = "\u52ce\u58e4\u65db\u59ed\u6a44".length();
        int n14 = "\u6cb9\u53c6\u4e88\u7088".length();
        int n15 = "\u6559\u6b9e\u6be6\u6941\u521b".length();
        this.focusedBackground = UIManager.getColor(string + ".focusedBackground");
        int n16 = "\u6c08\u4f05".length();
        int n17 = "\u5042\u6cee".length();
        int n18 = "\u6698\u4fc8".length();
        this.iconTextGap = FlatUIUtils.getUIInt(string + ".iconTextGap", 4);
        int n19 = "\u6c17".length();
        int n20 = "\u6418\u62f8\u5597\u556c".length();
        int n21 = "\u6506\u68a9\u68d5".length();
        int n22 = "\u50f5\u6965".length();
        this.defaultMargin = UIManager.getInsets(string + ".margin");
        LookAndFeel.installProperty(this.getComponent(), "opaque", false);
        MigLayoutVisualPadding.install(this.getComponent());
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.disabledBackground = null;
        this.inactiveBackground = null;
        this.placeholderForeground = null;
        this.focusedBackground = null;
        this.oldDisabledBackground = null;
        this.oldInactiveBackground = null;
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(this.getComponent());
    }

    @Override
    public void installListeners() {
        super.installListeners();
        int n = "\u6af4\u52ba".length();
        int n2 = "\u6ea8".length();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent(), null);
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        if (this.documentListener != null) {
            this.getComponent().getDocument().removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
    }

    @Override
    public Caret createCaret() {
        int n = "\u5222\u5649\u6406\u6281\u6026".length();
        return new FlatCaret(UIManager.getString("TextComponent.selectAllOnFocusPolicy"), FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(UIManager.getBoolean("TextComponent.selectAllOnMouseClick") ? 1 : 0) != 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f("editable".equals(string) ? 1 : 0) != 0 || FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f("enabled".equals(string) ? 1 : 0) != 0) {
            this.updateBackground();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
        JTextComponent jTextComponent = this.getComponent();
        String string2 = propertyChangeEvent.getPropertyName();
        int n = -1;
        switch (string2.hashCode()) {
            case 151255029: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JTextField.placeholderText") ? 1 : 0) == 0) break;
                n = 0;
                break;
            }
            case -742334409: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JComponent.roundRect") ? 1 : 0) == 0) break;
                n = 1;
                break;
            }
            case -691370713: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JComponent.outline") ? 1 : 0) == 0) break;
                n = 2;
                break;
            }
            case 1373006790: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JTextField.padding") ? 1 : 0) == 0) break;
                n = 3;
                break;
            }
            case -1302441837: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JComponent.minimumWidth") ? 1 : 0) == 0) break;
                n = 4;
                break;
            }
            case 1545413499: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("FlatLaf.style") ? 1 : 0) == 0) break;
                n = 5;
                break;
            }
            case 1030195901: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("FlatLaf.styleClass") ? 1 : 0) == 0) break;
                n = 6;
                break;
            }
            case 645363156: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JTextField.leadingIcon") ? 1 : 0) == 0) break;
                n = 7;
                break;
            }
            case -1750549472: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JTextField.trailingIcon") ? 1 : 0) == 0) break;
                n = 8;
                break;
            }
            case 1636664450: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JTextField.leadingComponent") ? 1 : 0) == 0) break;
                n = 9;
                break;
            }
            case -68661834: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JTextField.trailingComponent") ? 1 : 0) == 0) break;
                n = 10;
                break;
            }
            case -1498561705: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("JTextField.showClearButton") ? 1 : 0) == 0) break;
                n = 11;
                break;
            }
            case -1609594047: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("enabled") ? 1 : 0) == 0) break;
                n = 12;
                break;
            }
            case 1602416228: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("editable") ? 1 : 0) == 0) break;
                n = 13;
                break;
            }
            case 861720859: {
                if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(string2.equals("document") ? 1 : 0) == 0) break;
                n = 14;
            }
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                jTextComponent.repaint();
                break;
            }
            case 4: {
                jTextComponent.revalidate();
                break;
            }
            case 5: 
            case 6: {
                this.installStyle();
                jTextComponent.revalidate();
                jTextComponent.repaint();
                break;
            }
            case 7: {
                this.leadingIcon = propertyChangeEvent.getNewValue() instanceof Icon ? (Icon)propertyChangeEvent.getNewValue() : null;
                jTextComponent.repaint();
                break;
            }
            case 8: {
                this.trailingIcon = propertyChangeEvent.getNewValue() instanceof Icon ? (Icon)propertyChangeEvent.getNewValue() : null;
                jTextComponent.repaint();
                break;
            }
            case 9: {
                this.uninstallLeadingComponent();
                this.installLeadingComponent();
                jTextComponent.revalidate();
                jTextComponent.repaint();
                break;
            }
            case 10: {
                this.uninstallTrailingComponent();
                this.installTrailingComponent();
                jTextComponent.revalidate();
                jTextComponent.repaint();
                break;
            }
            case 11: {
                this.uninstallClearButton();
                this.installClearButton();
                jTextComponent.revalidate();
                jTextComponent.repaint();
                break;
            }
            case 12: 
            case 13: {
                this.updateClearButton();
                break;
            }
            case 14: {
                if (this.documentListener == null) break;
                if (propertyChangeEvent.getOldValue() instanceof Document) {
                    ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(this.documentListener);
                }
                if (propertyChangeEvent.getNewValue() instanceof Document) {
                    ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this.documentListener);
                }
                this.updateClearButton();
            }
        }
    }

    public void installDocumentListener() {
        if (this.documentListener != null) {
            return;
        }
        int n = "\u59d2\u6846".length();
        int n2 = "\u6c0e\u4edb\u4fae\u69f3\u507d".length();
        int n3 = "\u70cb\u5992\u7115\u5096\u66e9".length();
        this.documentListener = new FlatDocumentListener(null);
        this.getComponent().getDocument().addDocumentListener(this.documentListener);
    }

    public void documentChanged(DocumentEvent documentEvent) {
        if (this.clearButton != null) {
            this.updateClearButton();
        }
    }

    public void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.getComponent(), this.getStyleType()));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    public String getStyleType() {
        return "TextField";
    }

    public void applyStyle(Object object) {
        this.oldDisabledBackground = this.disabledBackground;
        this.oldInactiveBackground = this.inactiveBackground;
        int n = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.showClearButton ? 1 : 0);
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        this.updateBackground();
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.showClearButton ? 1 : 0) != n) {
            this.uninstallClearButton();
            this.installClearButton();
        }
    }

    public Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            int n = "\u6efb\u504b\u6576".length();
            int n2 = "\u5095".length();
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.getComponent(), this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.getComponent().getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.getComponent().getBorder(), string);
    }

    public void updateBackground() {
        FlatTextFieldUI.updateBackground(this.getComponent(), this.background, this.disabledBackground, this.inactiveBackground, this.oldDisabledBackground, this.oldInactiveBackground);
    }

    public static /* synthetic */ void updateBackground(JTextComponent jTextComponent, Color color, Color color2, Color color3, Color color4, Color color5) {
        Color color6;
        Color color7 = jTextComponent.getBackground();
        if (!(color7 instanceof UIResource)) {
            return;
        }
        if (color7 != color && color7 != color2 && color7 != color3 && color7 != color4 && color7 != color5) {
            return;
        }
        Color color8 = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jTextComponent.isEnabled() ? 1 : 0) == 0 ? color2 : (color6 = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jTextComponent.isEditable() ? 1 : 0) == 0 ? color3 : color);
        if (color6 != color7) {
            jTextComponent.setBackground(color6);
        }
    }

    @Override
    public void paintSafely(Graphics graphics) {
        FlatTextFieldUI.paintBackground(graphics, this.getComponent(), this.focusedBackground);
        this.paintPlaceholder(graphics);
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.hasLeadingIcon() ? 1 : 0) != 0 || FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.hasTrailingIcon() ? 1 : 0) != 0) {
            int n = "\u5912\u6abb\u5c8d".length();
            int n2 = "\u58c7\u6375\u6abf\u6b5c".length();
            int n3 = "\u6a27\u6394\u54f2\u6914".length();
            int n4 = "\u5eb7\u705a\u65b8\u5a03".length();
            this.paintIcons(graphics, new Rectangle(this.getIconsRect()));
        }
        super.paintSafely(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics));
    }

    @Override
    public void paintBackground(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ void paintBackground(Graphics graphics, JTextComponent jTextComponent, Color color) {
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jTextComponent.isOpaque() ? 1 : 0) == 0 && FlatUIUtils.getOutsideFlatBorder(jTextComponent) == null && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(FlatUIUtils.hasOpaqueBeenExplicitlySet(jTextComponent) ? 1 : 0) != 0) {
            return;
        }
        float f = FlatUIUtils.getBorderFocusWidth(jTextComponent);
        float f2 = FlatUIUtils.getBorderArc(jTextComponent);
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jTextComponent.isOpaque() ? 1 : 0) != 0 && (f > 0.0f || f2 > 0.0f)) {
            FlatUIUtils.paintParentBackground(graphics, jTextComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            int n = "\u5938\u5199\u62d9\u6e08\u564d".length();
            int n2 = "\u5855\u683d\u513f\u58d0".length();
            graphics2D.setColor(FlatTextFieldUI.getBackground(jTextComponent, color));
            FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, jTextComponent.getWidth(), jTextComponent.getHeight(), f, f2);
        }
        catch (Throwable throwable) {
            graphics2D.dispose();
            int n = "\u62fc\u6261".length();
            throw throwable;
        }
        graphics2D.dispose();
    }

    public static /* synthetic */ Color getBackground(JTextComponent jTextComponent, Color color) {
        Color color2 = jTextComponent.getBackground();
        if (!(color2 instanceof UIResource)) {
            return color2;
        }
        if (color != null && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(FlatUIUtils.isPermanentFocusOwner(jTextComponent) ? 1 : 0) != 0) {
            return color;
        }
        return color2;
    }

    public void paintPlaceholder(Graphics graphics) {
        int n;
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.getDocument().getLength() > 0) {
            return;
        }
        Container container = jTextComponent.getParent();
        JComponent jComponent = container instanceof JComboBox ? (JComboBox)container : jTextComponent;
        String string = FlatClientProperties.clientProperty(jComponent, "JTextField.placeholderText", null, String.class);
        if (string == null) {
            return;
        }
        Rectangle rectangle = this.getVisibleEditorRect();
        FontMetrics fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
        int n2 = rectangle.x;
        int n3 = "\u51ed".length();
        int n4 = "\u549f".length();
        int n5 = "\u50b1".length();
        int n6 = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.y, fontMetrics.getAscent()), (rectangle.height - fontMetrics.getHeight()) / 2);
        String string2 = JavaCompatibility.getClippedString(jTextComponent, fontMetrics, string, rectangle.width);
        int n7 = fontMetrics.stringWidth(string2);
        int n8 = n = jTextComponent instanceof JTextField ? ((JTextField)jTextComponent).getHorizontalAlignment() : 10;
        if (n == 10) {
            n = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.isLeftToRight() ? 1 : 0) != 0 ? 2 : 4;
        } else if (n == 11) {
            int n9 = n = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.isLeftToRight() ? 1 : 0) != 0 ? 4 : 2;
        }
        if (n == 4) {
            int n10 = "\u6003\u6929\u60c2\u5ae4\u6047".length();
            int n11 = "\u6d6f".length();
            int n12 = "\u6972\u64e4\u5355".length();
            int n13 = "\u6d90\u70a4\u56c1\u6f9c".length();
            n2 = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(n2, rectangle.width - n7);
        } else if (n == 0) {
            int n14 = "\u6555\u57a1\u6cc7\u59f2".length();
            int n15 = "\u65f7\u603c\u5d25\u5f1b\u60a5".length();
            int n16 = "\u57fd\u565b\u5fb0".length();
            n2 = Math.max(0, FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(n2, rectangle.width / 2) - n7 / 2);
        }
        graphics.setColor(this.placeholderForeground);
        FlatUIUtils.drawString(jTextComponent, graphics, string2, n2, n6);
    }

    public void paintIcons(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        Icon icon;
        int n4 = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.isLeftToRight() ? 1 : 0);
        Icon icon2 = n4 != 0 ? this.leadingIcon : this.trailingIcon;
        Icon icon3 = icon = n4 != 0 ? this.trailingIcon : this.leadingIcon;
        if (icon2 != null) {
            n3 = rectangle.x;
            int n5 = "\u70e9\u630a".length();
            int n6 = "\u50b0".length();
            n2 = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.y, Math.round((float)(rectangle.height - icon2.getIconHeight()) / 2.0f));
            icon2.paintIcon(this.getComponent(), graphics, n3, n2);
            n = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(icon2.getIconWidth(), UIScale.scale(this.iconTextGap));
            int n7 = "\u61dd\u5cc8".length();
            int n8 = "\u6547\u5c7d".length();
            rectangle.x = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.x, n);
            int n9 = "\u636b\u7101\u4f2c\u5007".length();
            int n10 = "\u7031\u64a3\u63c9\u5063\u541b".length();
            rectangle.width -= n;
        }
        if (icon != null) {
            n3 = icon.getIconWidth();
            int n11 = "\u6444\u6b69\u66a7\u6005".length();
            int n12 = "\u5394".length();
            int n13 = "\u6ce9\u6d1b".length();
            int n14 = "\u6bac\u5caa\u6c45\u523c".length();
            int n15 = "\u6fb4\u5ed2".length();
            n2 = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.x, rectangle.width) - n3;
            int n16 = "\u6450\u6ad4\u5ef5\u5c44".length();
            int n17 = "\u5bae\u6b6a\u5c1f\u5767".length();
            n = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.y, Math.round((float)(rectangle.height - icon.getIconHeight()) / 2.0f));
            icon.paintIcon(this.getComponent(), graphics, n2, n);
            int n18 = "\u6bca".length();
            int n19 = "\u6e42\u573a\u531a".length();
            int n20 = "\u70a8\u6902".length();
            int n21 = "\u5263".length();
            int n22 = "\u615b\u6cfc\u5e8e\u562b\u6807".length();
            int n23 = "\u53d7".length();
            rectangle.width -= FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(n3, UIScale.scale(this.iconTextGap));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.applyMinimumWidth(jComponent, this.applyExtraSize(super.getPreferredSize(jComponent)), this.minimumWidth);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.applyMinimumWidth(jComponent, this.applyExtraSize(super.getMinimumSize(jComponent)), this.minimumWidth);
    }

    public Dimension applyExtraSize(Dimension dimension) {
        JComponent jComponent;
        int n;
        int n2 = "\u5eb2".length();
        int n3 = "\u6449\u5a6d\u6eaf".length();
        dimension.width = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(dimension.width, FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(this.getLeadingIconWidth(), this.getTrailingIconWidth()));
        JComponent[] jComponentArray = this.getLeadingComponents();
        int n4 = jComponentArray.length;
        for (n = 0; n < n4; n += 5001) {
            jComponent = jComponentArray[n];
            if (jComponent != null && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jComponent.isVisible() ? 1 : 0) != 0) {
                int n5 = "\u5cb0".length();
                int n6 = "\u5aa1\u6c2e\u6452".length();
                int n7 = "\u6264\u5b96\u534d\u5349".length();
                int n8 = "\u5252\u6f98".length();
                dimension.width = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(dimension.width, jComponent.getPreferredSize().width);
            }
            n -= 5000;
        }
        jComponentArray = this.getTrailingComponents();
        n4 = jComponentArray.length;
        for (n = 0; n < n4; n += 23235) {
            jComponent = jComponentArray[n];
            if (jComponent != null && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jComponent.isVisible() ? 1 : 0) != 0) {
                int n9 = "\u5ece\u5ca6".length();
                int n10 = "\u542a\u6bda\u548c".length();
                int n11 = "\u50bb\u69e3\u52f4\u66e4\u5a80".length();
                dimension.width = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(dimension.width, jComponent.getPreferredSize().width);
            }
            n -= 23234;
        }
        return dimension;
    }

    public Dimension applyMinimumWidth(JComponent jComponent, Dimension dimension, int n) {
        if (jComponent instanceof JTextField && ((JTextField)jComponent).getColumns() > 0) {
            return dimension;
        }
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(FlatTextFieldUI.hasDefaultMargins(jComponent, this.defaultMargin) ? 1 : 0) == 0) {
            return dimension;
        }
        Container container = jComponent.getParent();
        if (container instanceof JComboBox || container instanceof JSpinner || container != null && container.getParent() instanceof JSpinner) {
            return dimension;
        }
        n = FlatUIUtils.minimumWidth(jComponent, n);
        float f = FlatUIUtils.getBorderFocusWidth(jComponent);
        dimension.width = Math.max(dimension.width, FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(UIScale.scale(n), Math.round(f * 2.0f)));
        return dimension;
    }

    public static /* synthetic */ boolean hasDefaultMargins(JComponent jComponent, Insets insets) {
        Insets insets2 = ((JTextComponent)jComponent).getMargin();
        return insets2 instanceof UIResource && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(Objects.equals(insets2, insets) ? 1 : 0) != 0;
    }

    @Override
    public Rectangle getVisibleEditorRect() {
        Insets insets;
        Rectangle rectangle = this.getIconsRect();
        if (rectangle == null) {
            return null;
        }
        int n = this.getLeadingIconWidth();
        int n2 = this.getTrailingIconWidth();
        if (n != 0 || n2 != 0) {
            int n3 = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.isLeftToRight() ? 1 : 0);
            int n4 = n3 != 0 ? n : n2;
            int n5 = n3 != 0 ? n2 : n;
            int n6 = "\u51e9\u6898\u60b4\u5417".length();
            int n7 = "\u587c\u6d36\u6c94".length();
            rectangle.x = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.x, n4);
            int n8 = "\u5640\u6cf4\u5fc9".length();
            int n9 = "\u502c".length();
            int n10 = "\u5950\u58f2\u6269\u676f".length();
            int n11 = "\u50ea\u5a3e\u5f61\u589e\u5339".length();
            int n12 = "\u64c0\u711d\u66e1".length();
            rectangle.width -= FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(n4, n5);
        }
        if ((insets = this.getPadding()) != null) {
            rectangle = FlatUIUtils.subtractInsets(rectangle, insets);
        }
        rectangle.width = Math.max(rectangle.width, 0);
        rectangle.height = Math.max(rectangle.height, 0);
        return rectangle;
    }

    public Rectangle getIconsRect() {
        JComponent jComponent;
        int n;
        Rectangle rectangle = super.getVisibleEditorRect();
        if (rectangle == null) {
            return null;
        }
        int n2 = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.isLeftToRight() ? 1 : 0);
        JComponent[] jComponentArray = n2 != 0 ? this.getLeadingComponents() : this.getTrailingComponents();
        JComponent[] jComponentArray2 = n2 != 0 ? this.getTrailingComponents() : this.getLeadingComponents();
        boolean bl = false;
        boolean bl2 = false;
        Object object = jComponentArray;
        int n3 = ((JComponent[])object).length;
        for (n = 0; n < n3; n += 1126) {
            jComponent = object[n];
            if (jComponent != null && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jComponent.isVisible() ? 1 : 0) != 0) {
                int n4 = jComponent.getPreferredSize().width;
                int n5 = "\u594a\u6a24\u6123".length();
                int n6 = "\u6652\u6e0f".length();
                int n7 = "\u6592\u52ae\u648b\u640e\u617d".length();
                int n8 = "\u5dcf\u62b9\u6254\u5bf9".length();
                rectangle.x = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.x, n4);
                int n9 = "\u560f\u703e".length();
                int n10 = "\u60bf\u62fa".length();
                int n11 = "\u6c8b\u6f12".length();
                int n12 = "\u6bea\u64fb\u62af".length();
                int n13 = "\u540b\u65e1\u5948\u66de\u67ec".length();
                rectangle.width -= n4;
                bl = true;
            }
            n -= 1125;
        }
        object = jComponentArray2;
        n3 = ((JComponent[])object).length;
        for (n = 0; n < n3; n -= 21961) {
            jComponent = object[n];
            if (jComponent != null && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jComponent.isVisible() ? 1 : 0) != 0) {
                int n14 = "\u4fe1\u6169\u5926\u6425\u4e58".length();
                int n15 = "\u6f64\u5237\u5f3c\u57d8\u5d9a".length();
                int n16 = "\u586c".length();
                int n17 = "\u54e8\u620b".length();
                int n18 = "\u6ae2\u6468\u5d87\u63f4\u6661".length();
                int n19 = "\u5711".length();
                rectangle.width -= jComponent.getPreferredSize().width;
                bl2 = true;
            }
            n += 21962;
        }
        if (bl || (n2 != 0 ? FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.hasLeadingIcon() ? 1 : 0) != 0 : FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.hasTrailingIcon() ? 1 : 0) != 0)) {
            object = this.getComponent().getMargin();
            n3 = Math.min(object.left, object.top);
            if (n3 < object.left) {
                int n20 = "\u50bc\u5317".length();
                int n21 = "\u502f\u6c5d".length();
                int n22 = "\u54bf\u57b1\u570a\u6580".length();
                n = UIScale.scale(object.left - n3);
                int n23 = "\u5283\u6280".length();
                int n24 = "\u539c\u5f77\u5d56".length();
                int n25 = "\u6e5b\u6c87\u6207\u54eb".length();
                int n26 = "\u6542".length();
                int n27 = "\u6ce5\u62dc\u58f3\u6328\u64ce".length();
                int n28 = "\u5113".length();
                int n29 = "\u52de".length();
                rectangle.x -= n;
                int n30 = "\u4e8e".length();
                int n31 = "\u5520\u6d1d".length();
                int n32 = "\u5c24\u5db6\u52a7".length();
                int n33 = "\u5234\u5ab0".length();
                rectangle.width = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.width, n);
            }
        }
        if (bl2 || (n2 != 0 ? FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.hasTrailingIcon() ? 1 : 0) != 0 : FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.hasLeadingIcon() ? 1 : 0) != 0)) {
            object = this.getComponent().getMargin();
            n3 = Math.min(object.right, object.top);
            if (n3 < object.left) {
                int n34 = "\u6fc4\u54f5".length();
                int n35 = "\u6665\u6c0a".length();
                int n36 = "\u64dc\u61ff\u58b5".length();
                rectangle.width = FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(rectangle.width, UIScale.scale(object.right - n3));
            }
        }
        rectangle.width = Math.max(rectangle.width, 0);
        rectangle.height = Math.max(rectangle.height, 0);
        return rectangle;
    }

    public boolean hasLeadingIcon() {
        return this.leadingIcon != null;
    }

    public boolean hasTrailingIcon() {
        return this.trailingIcon != null;
    }

    public int getLeadingIconWidth() {
        return this.leadingIcon != null ? FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(this.leadingIcon.getIconWidth(), UIScale.scale(this.iconTextGap)) : 0;
    }

    public int getTrailingIconWidth() {
        return this.trailingIcon != null ? FlatTextFieldUI.INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(this.trailingIcon.getIconWidth(), UIScale.scale(this.iconTextGap)) : 0;
    }

    public boolean isLeftToRight() {
        return FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.getComponent().getComponentOrientation().isLeftToRight() ? 1 : 0) != 0;
    }

    public Insets getPadding() {
        return UIScale.scale(FlatClientProperties.clientProperty(this.getComponent(), "JTextField.padding", null, Insets.class));
    }

    public void scrollCaretToVisible() {
        Caret caret = this.getComponent().getCaret();
        if (caret instanceof FlatCaret) {
            ((FlatCaret)caret).scrollCaretToVisible();
        }
    }

    public void installLeadingComponent() {
        JTextComponent jTextComponent = this.getComponent();
        this.leadingComponent = FlatClientProperties.clientProperty(jTextComponent, "JTextField.leadingComponent", null, JComponent.class);
        if (this.leadingComponent != null) {
            this.prepareLeadingOrTrailingComponent(this.leadingComponent);
            this.installLayout();
            jTextComponent.add(this.leadingComponent);
            int n = "\u6dc7\u6595\u5499\u58c1\u505a".length();
            int n2 = "\u50f7\u53b9\u617b".length();
        }
    }

    public void installTrailingComponent() {
        JTextComponent jTextComponent = this.getComponent();
        this.trailingComponent = FlatClientProperties.clientProperty(jTextComponent, "JTextField.trailingComponent", null, JComponent.class);
        if (this.trailingComponent != null) {
            this.prepareLeadingOrTrailingComponent(this.trailingComponent);
            this.installLayout();
            jTextComponent.add(this.trailingComponent);
            int n = "\u56ad\u5003\u5724\u5a8b".length();
            int n2 = "\u6907\u62c1\u524b\u6bdc".length();
        }
    }

    public void uninstallLeadingComponent() {
        if (this.leadingComponent != null) {
            this.getComponent().remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    public void uninstallTrailingComponent() {
        if (this.trailingComponent != null) {
            this.getComponent().remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    public void installClearButton() {
        JTextComponent jTextComponent = this.getComponent();
        if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(FlatClientProperties.clientPropertyBoolean(jTextComponent, "JTextField.showClearButton", FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.showClearButton ? 1 : 0) != 0) ? 1 : 0) != 0) {
            this.clearButton = this.createClearButton();
            this.updateClearButton();
            this.installDocumentListener();
            this.installLayout();
            jTextComponent.add(this.clearButton);
            int n = "\u4f12\u67b8".length();
            int n2 = "\u663f\u5ce0\u6073\u5607\u63e6".length();
            int n3 = "\u6aa0\u677f\u6779".length();
            int n4 = "\u53d4\u6363\u5713\u64e2".length();
        }
    }

    public void uninstallClearButton() {
        if (this.clearButton != null) {
            this.getComponent().remove(this.clearButton);
            this.clearButton = null;
        }
    }

    public JComponent createClearButton() {
        int n = "\u56e4\u5e0c".length();
        int n2 = "\u6fe1".length();
        int n3 = "\u6315\u58f8\u50d3".length();
        JButton jButton = new JButton();
        jButton.setName("TextField.clearButton");
        jButton.putClientProperty("FlatLaf.styleClass", "clearButton");
        jButton.putClientProperty("JButton.buttonType", "toolBarButton");
        jButton.setCursor(Cursor.getDefaultCursor());
        jButton.addActionListener(actionEvent -> this.clearButtonClicked());
        return jButton;
    }

    public void clearButtonClicked() {
        JTextComponent jTextComponent = this.getComponent();
        Object object = jTextComponent.getClientProperty("JTextField.clearCallback");
        if (object instanceof Runnable) {
            ((Runnable)object).run();
        } else if (object instanceof Consumer) {
            ((Consumer)object).accept(jTextComponent);
        } else {
            jTextComponent.setText("");
        }
    }

    public void updateClearButton() {
        int n;
        if (this.clearButton == null) {
            return;
        }
        JTextComponent jTextComponent = this.getComponent();
        int n2 = n = FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jTextComponent.isEnabled() ? 1 : 0) != 0 && FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jTextComponent.isEditable() ? 1 : 0) != 0 && jTextComponent.getDocument().getLength() > 0;
        if (n != FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(this.clearButton.isVisible() ? 1 : 0)) {
            this.clearButton.setVisible(n != 0);
            jTextComponent.revalidate();
            jTextComponent.repaint();
        }
    }

    public JComponent[] getLeadingComponents() {
        JComponent[] jComponentArray = new JComponent[1];
        int n = "\u69cf\u5013\u6fda\u70a6".length();
        int n2 = "\u5a3c\u65d7\u5a3c".length();
        int n3 = "\u68a2\u5396".length();
        int n4 = "\u67bd\u6b7f\u6178\u6d55".length();
        jComponentArray[0] = this.leadingComponent;
        return jComponentArray;
    }

    public JComponent[] getTrailingComponents() {
        JComponent[] jComponentArray = new JComponent[2];
        int n = "\u51a8\u6508\u5216\u60a5".length();
        int n2 = "\u50ad\u4f80\u5e97".length();
        int n3 = "\u5dc6".length();
        jComponentArray[0] = this.trailingComponent;
        int n4 = "\u4e56".length();
        int n5 = "\u502c\u5ffa\u6d51".length();
        jComponentArray[1] = this.clearButton;
        return jComponentArray;
    }

    public void prepareLeadingOrTrailingComponent(JComponent jComponent) {
        jComponent.putClientProperty("FlatLaf.styleClass", "inTextField");
        if (jComponent instanceof JButton || jComponent instanceof JToggleButton) {
            jComponent.putClientProperty("JButton.buttonType", "toolBarButton");
            if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jComponent.isCursorSet() ? 1 : 0) == 0) {
                jComponent.setCursor(Cursor.getDefaultCursor());
            }
        } else if (jComponent instanceof JToolBar) {
            Component[] componentArray = jComponent.getComponents();
            int n = componentArray.length;
            for (int i = 0; i < n; i -= 5443) {
                Component component = componentArray[i];
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty("FlatLaf.styleClass", "inTextField");
                }
                i += 5444;
            }
            if (FlatTextFieldUI.INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(jComponent.isCursorSet() ? 1 : 0) == 0) {
                jComponent.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void installLayout() {
        JTextComponent jTextComponent = this.getComponent();
        LayoutManager layoutManager = jTextComponent.getLayout();
        if (!(layoutManager instanceof FlatTextFieldLayout)) {
            int n = "\u6cce\u5239\u52dd\u4f86\u52be".length();
            int n2 = "\u5eba\u664f\u512d".length();
            int n3 = "\u59e4\u5dc3".length();
            jTextComponent.setLayout(new FlatTextFieldLayout(layoutManager));
        }
    }

    public static int INSOLENCE_\u63f0\u6d70\u51aa\u5aac\u5492\u6231\u4f86\u5e7e\u6d7c\u6a31\u4e7d\u6bd2\u60ac\u591d\u5791\u6cb0\u52fe\u6075\u5f05\u6441\u6490\u58e9\u5d31\u70d3\u525b\u6c6b\u6eea\u56c6\u5d26\u5e07\u6289\u573f\u56ae\u5f22\u54cd\u5899\u6faf\u5657\u5e7b\u605a\u530f(int n) {
        return n;
    }

    public static int INSOLENCE_\u5f9b\u6cf8\u6bc9\u6897\u68cb\u5301\u5dad\u5a78\u5dd2\u6b91\u62cf\u6daa\u5c04\u5ebb\u6a23\u651e\u4e8e\u541b\u5a40\u4e6a\u54e5\u6315\u4f84\u5134\u5ebe\u6e9e\u68e0\u5b1a\u66b5\u65d9\u65d4\u6b86\u5429\u58fb\u52a4\u649e\u5922\u4f1a\u5f2b\u52bb\u6c76(int n, int n2) {
        return ((n | n2) << 1) + ~(n ^ n2) + 1;
    }

    private class FlatDocumentListener
    implements DocumentListener {
        public FlatDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            FlatTextFieldUI.this.documentChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            FlatTextFieldUI.this.documentChanged(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            FlatTextFieldUI.this.documentChanged(documentEvent);
        }

        public /* synthetic */ FlatDocumentListener(1 var2_2) {
            this();
        }
    }

    private class FlatTextFieldLayout
    implements LayoutManager2,
    UIResource {
        public final /* synthetic */ LayoutManager delegate;

        public FlatTextFieldLayout(LayoutManager layoutManager) {
            this.delegate = layoutManager;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (this.delegate != null) {
                this.delegate.addLayoutComponent(string, component);
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (this.delegate != null) {
                this.delegate.removeLayoutComponent(component);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.delegate != null ? this.delegate.preferredLayoutSize(container) : null;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.delegate != null ? this.delegate.minimumLayoutSize(container) : null;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            JComponent jComponent;
            int n2;
            if (this.delegate != null) {
                this.delegate.layoutContainer(container);
            }
            int n3 = FlatUIUtils.getBorderFocusAndLineWidth(FlatTextFieldUI.this.getComponent());
            int n4 = "\u4f63\u6efd\u6aad\u705f\u643b".length();
            int n5 = "\u5950\u5632\u6490".length();
            int n6 = "\u6ba4\u6845\u6e95\u5490".length();
            int n7 = "\u5a8d\u5464".length();
            int n8 = "\u527e\u5baf\u6167\u54c6".length();
            int n9 = "\u60e5\u676f\u5dbc\u6311\u6e4b".length();
            int n10 = "\u5f6f\u5818".length();
            int n11 = container.getHeight() - n3 - n3;
            int n12 = FlatTextFieldLayout.INSOLENCE_\u5c22\u68ae\u5130\u5c03\u6560\u6869\u6f80\u51ae\u70f9\u6754\u566e\u6a23\u5c05\u6b0f\u64ab\u6398\u7006\u606c\u6882\u5790\u7073\u694e\u6cd3\u5998\u6d0b\u57d9\u6df1\u5f6b\u4ee0\u6671\u53e1\u5889\u4fcb\u5525\u6e07\u67e0\u6b38\u6915\u552e\u4ef1\u63aa(FlatTextFieldUI.this.isLeftToRight() ? 1 : 0);
            JComponent[] jComponentArray = n12 != 0 ? FlatTextFieldUI.this.getLeadingComponents() : FlatTextFieldUI.this.getTrailingComponents();
            JComponent[] jComponentArray2 = n12 != 0 ? FlatTextFieldUI.this.getTrailingComponents() : FlatTextFieldUI.this.getLeadingComponents();
            int n13 = n3;
            JComponent[] jComponentArray3 = jComponentArray;
            int n14 = jComponentArray3.length;
            for (n2 = 0; n2 < n14; n2 -= 24166) {
                jComponent = jComponentArray3[n2];
                if (jComponent != null && FlatTextFieldLayout.INSOLENCE_\u5c22\u68ae\u5130\u5c03\u6560\u6869\u6f80\u51ae\u70f9\u6754\u566e\u6a23\u5c05\u6b0f\u64ab\u6398\u7006\u606c\u6882\u5790\u7073\u694e\u6cd3\u5998\u6d0b\u57d9\u6df1\u5f6b\u4ee0\u6671\u53e1\u5889\u4fcb\u5525\u6e07\u67e0\u6b38\u6915\u552e\u4ef1\u63aa(jComponent.isVisible() ? 1 : 0) != 0) {
                    n = jComponent.getPreferredSize().width;
                    jComponent.setBounds(n13, n3, n, n11);
                    n13 = FlatTextFieldLayout.INSOLENCE_\u6e7f\u5a75\u5937\u6a91\u50ba\u5a15\u565d\u6d72\u6fea\u5c06\u665a\u6a72\u6eb6\u62ca\u5f1b\u5d35\u5164\u572b\u515c\u61f0\u6f0b\u5058\u540d\u6901\u6446\u6752\u6654\u5910\u6000\u70ac\u5a3a\u4f9e\u62e7\u564e\u4f27\u6cc7\u5f9f\u6070\u58ed\u6c9a\u5572(n13, n);
                }
                n2 += 24167;
            }
            int n15 = "\u53a0".length();
            n13 = container.getWidth() - n3;
            jComponentArray3 = jComponentArray2;
            n14 = jComponentArray3.length;
            for (n2 = 0; n2 < n14; n2 -= 2470) {
                jComponent = jComponentArray3[n2];
                if (jComponent != null && FlatTextFieldLayout.INSOLENCE_\u5c22\u68ae\u5130\u5c03\u6560\u6869\u6f80\u51ae\u70f9\u6754\u566e\u6a23\u5c05\u6b0f\u64ab\u6398\u7006\u606c\u6882\u5790\u7073\u694e\u6cd3\u5998\u6d0b\u57d9\u6df1\u5f6b\u4ee0\u6671\u53e1\u5889\u4fcb\u5525\u6e07\u67e0\u6b38\u6915\u552e\u4ef1\u63aa(jComponent.isVisible() ? 1 : 0) != 0) {
                    n = jComponent.getPreferredSize().width;
                    int n16 = "\u66e2\u6072".length();
                    jComponent.setBounds(n13 -= n, n3, n, n11);
                }
                n2 += 2471;
            }
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            if (this.delegate instanceof LayoutManager2) {
                ((LayoutManager2)this.delegate).addLayoutComponent(component, object);
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).maximumLayoutSize(container) : null;
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).getLayoutAlignmentX(container) : 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).getLayoutAlignmentY(container) : 0.5f;
        }

        @Override
        public void invalidateLayout(Container container) {
            if (this.delegate instanceof LayoutManager2) {
                ((LayoutManager2)this.delegate).invalidateLayout(container);
            }
        }

        public static int INSOLENCE_\u5c22\u68ae\u5130\u5c03\u6560\u6869\u6f80\u51ae\u70f9\u6754\u566e\u6a23\u5c05\u6b0f\u64ab\u6398\u7006\u606c\u6882\u5790\u7073\u694e\u6cd3\u5998\u6d0b\u57d9\u6df1\u5f6b\u4ee0\u6671\u53e1\u5889\u4fcb\u5525\u6e07\u67e0\u6b38\u6915\u552e\u4ef1\u63aa(int n) {
            return n;
        }

        public static int INSOLENCE_\u6e7f\u5a75\u5937\u6a91\u50ba\u5a15\u565d\u6d72\u6fea\u5c06\u665a\u6a72\u6eb6\u62ca\u5f1b\u5d35\u5164\u572b\u515c\u61f0\u6f0b\u5058\u540d\u6901\u6446\u6752\u6654\u5910\u6000\u70ac\u5a3a\u4f9e\u62e7\u564e\u4f27\u6cc7\u5f9f\u6070\u58ed\u6c9a\u5572(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }
}

