/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.CubicBezierEasing;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public interface AnimatedIcon
extends Icon {
    @Override
    default public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        AnimationSupport.paintIcon(this, component, graphics, n, n2);
    }

    public void paintIconAnimated(Component var1, Graphics var2, int var3, int var4, float var5);

    public float getValue(Component var1);

    default public boolean isAnimationEnabled() {
        return true;
    }

    default public int getAnimationDuration() {
        return 150;
    }

    default public int getAnimationResolution() {
        return 10;
    }

    default public Animator.Interpolator getAnimationInterpolator() {
        return CubicBezierEasing.STANDARD_EASING;
    }

    default public Object getClientPropertyKey() {
        return this.getClass();
    }

    public static class AnimationSupport {
        public /* synthetic */ float startValue;
        public /* synthetic */ float targetValue;
        public /* synthetic */ float animatedValue;
        public /* synthetic */ float fraction;
        public /* synthetic */ Animator animator;
        public /* synthetic */ int x;
        public /* synthetic */ int y;

        public static /* synthetic */ void paintIcon(AnimatedIcon animatedIcon, Component component, Graphics graphics, int n, int n2) {
            if (AnimationSupport.INSOLENCE_\u5e67\u6875\u5c29\u6a7a\u6fdb\u5bf3\u693e\u4f1d\u65ec\u52e7\u6f1b\u5a24\u5c72\u6e87\u63e9\u6067\u5c39\u5fe7\u4f32\u5eb7\u6740\u5094\u5e67\u6faf\u53b0\u6dab\u5bc8\u6bac\u6a45\u68f4\u6d8f\u5c22\u6b35\u66de\u5472\u5c82\u6b1a\u5526\u5450\u68d6\u5b43(AnimationSupport.isAnimationEnabled(animatedIcon, component) ? 1 : 0) == 0) {
                AnimationSupport.paintIconImpl(animatedIcon, component, graphics, n, n2, null);
                return;
            }
            JComponent jComponent = (JComponent)component;
            Object object = animatedIcon.getClientPropertyKey();
            AnimationSupport animationSupport = (AnimationSupport)jComponent.getClientProperty(object);
            if (animationSupport == null) {
                int n3 = "\u58fb\u6630\u6735".length();
                int n4 = "\u4ff0\u67ee\u61a0\u6dd4\u5033".length();
                animationSupport = new AnimationSupport();
                animationSupport.targetValue = animationSupport.animatedValue = animatedIcon.getValue(component);
                animationSupport.startValue = animationSupport.animatedValue;
                animationSupport.x = n;
                animationSupport.y = n2;
                jComponent.putClientProperty(object, animationSupport);
            } else {
                float f2 = animatedIcon.getValue(component);
                if (f2 != animationSupport.targetValue) {
                    if (animationSupport.animator == null) {
                        AnimationSupport animationSupport2 = animationSupport;
                        int n5 = "\u5049\u6138".length();
                        animationSupport.animator = new Animator(animatedIcon.getAnimationDuration(), f -> {
                            if (AnimationSupport.INSOLENCE_\u5e67\u6875\u5c29\u6a7a\u6fdb\u5bf3\u693e\u4f1d\u65ec\u52e7\u6f1b\u5a24\u5c72\u6e87\u63e9\u6067\u5c39\u5fe7\u4f32\u5eb7\u6740\u5094\u5e67\u6faf\u53b0\u6dab\u5bc8\u6bac\u6a45\u68f4\u6d8f\u5c22\u6b35\u66de\u5472\u5c82\u6b1a\u5526\u5450\u68d6\u5b43(component.isDisplayable() ? 1 : 0) == 0) {
                                animationSupport.animator.stop();
                                return;
                            }
                            int n = "\u5cf0\u61ce\u5e2b\u5554\u70d4".length();
                            int n2 = "\u5963\u69dc\u5317".length();
                            int n3 = "\u5a34".length();
                            animationSupport.animatedValue = animationSupport.startValue + (animationSupport.targetValue - animationSupport.startValue) * f;
                            animationSupport.fraction = f;
                            component.repaint(animationSupport.x, animationSupport.y, animatedIcon.getIconWidth(), animatedIcon.getIconHeight());
                        }, () -> {
                            animationSupport.startValue = animationSupport.animatedValue = animationSupport.targetValue;
                            animationSupport.animator = null;
                        });
                    }
                    if (AnimationSupport.INSOLENCE_\u5e67\u6875\u5c29\u6a7a\u6fdb\u5bf3\u693e\u4f1d\u65ec\u52e7\u6f1b\u5a24\u5c72\u6e87\u63e9\u6067\u5c39\u5fe7\u4f32\u5eb7\u6740\u5094\u5e67\u6faf\u53b0\u6dab\u5bc8\u6bac\u6a45\u68f4\u6d8f\u5c22\u6b35\u66de\u5472\u5c82\u6b1a\u5526\u5450\u68d6\u5b43(animationSupport.animator.isRunning() ? 1 : 0) != 0) {
                        animationSupport.animator.cancel();
                        int n6 = (int)((float)animatedIcon.getAnimationDuration() * animationSupport.fraction);
                        if (n6 > 0) {
                            animationSupport.animator.setDuration(n6);
                        }
                        animationSupport.startValue = animationSupport.animatedValue;
                    } else {
                        animationSupport.animator.setDuration(animatedIcon.getAnimationDuration());
                        animationSupport.animator.setResolution(animatedIcon.getAnimationResolution());
                        animationSupport.animator.setInterpolator(animatedIcon.getAnimationInterpolator());
                        animationSupport.animatedValue = animationSupport.startValue;
                    }
                    animationSupport.targetValue = f2;
                    animationSupport.animator.start();
                }
                animationSupport.x = n;
                animationSupport.y = n2;
            }
            AnimationSupport.paintIconImpl(animatedIcon, component, graphics, n, n2, animationSupport);
        }

        public static /* synthetic */ void paintIconImpl(AnimatedIcon animatedIcon, Component component, Graphics graphics, int n, int n2, AnimationSupport animationSupport) {
            float f = animationSupport != null ? animationSupport.animatedValue : animatedIcon.getValue(component);
            animatedIcon.paintIconAnimated(component, graphics, n, n2, f);
        }

        public static /* synthetic */ boolean isAnimationEnabled(AnimatedIcon animatedIcon, Component component) {
            return AnimationSupport.INSOLENCE_\u5e67\u6875\u5c29\u6a7a\u6fdb\u5bf3\u693e\u4f1d\u65ec\u52e7\u6f1b\u5a24\u5c72\u6e87\u63e9\u6067\u5c39\u5fe7\u4f32\u5eb7\u6740\u5094\u5e67\u6faf\u53b0\u6dab\u5bc8\u6bac\u6a45\u68f4\u6d8f\u5c22\u6b35\u66de\u5472\u5c82\u6b1a\u5526\u5450\u68d6\u5b43(Animator.useAnimation() ? 1 : 0) != 0 && AnimationSupport.INSOLENCE_\u5e67\u6875\u5c29\u6a7a\u6fdb\u5bf3\u693e\u4f1d\u65ec\u52e7\u6f1b\u5a24\u5c72\u6e87\u63e9\u6067\u5c39\u5fe7\u4f32\u5eb7\u6740\u5094\u5e67\u6faf\u53b0\u6dab\u5bc8\u6bac\u6a45\u68f4\u6d8f\u5c22\u6b35\u66de\u5472\u5c82\u6b1a\u5526\u5450\u68d6\u5b43(animatedIcon.isAnimationEnabled() ? 1 : 0) != 0 && component instanceof JComponent;
        }

        public static /* synthetic */ void saveIconLocation(AnimatedIcon animatedIcon, Component component, int n, int n2) {
            if (AnimationSupport.INSOLENCE_\u5e67\u6875\u5c29\u6a7a\u6fdb\u5bf3\u693e\u4f1d\u65ec\u52e7\u6f1b\u5a24\u5c72\u6e87\u63e9\u6067\u5c39\u5fe7\u4f32\u5eb7\u6740\u5094\u5e67\u6faf\u53b0\u6dab\u5bc8\u6bac\u6a45\u68f4\u6d8f\u5c22\u6b35\u66de\u5472\u5c82\u6b1a\u5526\u5450\u68d6\u5b43(AnimationSupport.isAnimationEnabled(animatedIcon, component) ? 1 : 0) == 0) {
                return;
            }
            AnimationSupport animationSupport = (AnimationSupport)((JComponent)component).getClientProperty(animatedIcon.getClientPropertyKey());
            if (animationSupport != null) {
                animationSupport.x = n;
                animationSupport.y = n2;
            }
        }

        public static int INSOLENCE_\u5e67\u6875\u5c29\u6a7a\u6fdb\u5bf3\u693e\u4f1d\u65ec\u52e7\u6f1b\u5a24\u5c72\u6e87\u63e9\u6067\u5c39\u5fe7\u4f32\u5eb7\u6740\u5094\u5e67\u6faf\u53b0\u6dab\u5bc8\u6bac\u6a45\u68f4\u6d8f\u5c22\u6b35\u66de\u5472\u5c82\u6b1a\u5526\u5450\u68d6\u5b43(int n) {
            return n;
        }
    }
}

