/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.HSLColor;
import java.awt.Color;

public class ColorFunctions {
    public static /* synthetic */ Color lighten(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 2, true);
    }

    public static /* synthetic */ Color darken(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 2, false);
    }

    public static /* synthetic */ Color saturate(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 1, true);
    }

    public static /* synthetic */ Color desaturate(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 1, false);
    }

    public static /* synthetic */ Color spin(Color color, float f) {
        return ColorFunctions.hslIncreaseDecrease(color, f, 0, true);
    }

    public static /* synthetic */ Color hslIncreaseDecrease(Color color, float f, int n, boolean bl) {
        float f2;
        float[] fArray = HSLColor.fromRGB(color);
        float f3 = (float)color.getAlpha() / 255.0f;
        float f4 = f2 = bl ? f : -f;
        if (n == 0) {
            fArray[0] = (fArray[0] + f2) % 360.0f;
        } else {
            fArray[n] = ColorFunctions.clamp(fArray[n] + f2 * 100.0f);
        }
        return HSLColor.toRGB(fArray[0], fArray[1], fArray[2], f3);
    }

    public static /* synthetic */ Color fade(Color color, float f) {
        int n = Math.round(255.0f * f);
        int n2 = "\u6129\u5d9c\u6423\u51d6".length();
        int n3 = "\u5c5e\u6d3f".length();
        return new Color(color.getRGB() & 0xFFFFFF | n << 24, true);
    }

    public static /* synthetic */ Color mix(Color color, Color color2, float f) {
        if (f >= 1.0f) {
            return color;
        }
        if (f <= 0.0f) {
            return color2;
        }
        if (ColorFunctions.INSOLENCE_\u6c1a\u4fb4\u64d7\u5768\u64c6\u5701\u63ed\u6946\u6367\u4fd5\u60ab\u6704\u54fd\u5dec\u5ade\u5716\u5db7\u5ffc\u5f1c\u58a2\u693c\u6278\u5a5e\u5de9\u570b\u5520\u713d\u546d\u6cbb\u5565\u5b8e\u7114\u5bf2\u6608\u64ac\u6f06\u5973\u5855\u5f25\u5ce2\u5340(color.equals(color2) ? 1 : 0) != 0) {
            return color;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = color2.getRed();
        int n6 = color2.getGreen();
        int n7 = color2.getBlue();
        int n8 = color2.getAlpha();
        int n9 = "\u5e01\u58d6\u5423".length();
        int n10 = "\u6d89\u6c37".length();
        int n11 = "\u4fe7\u5f84\u59ce".length();
        int n12 = "\u6c90\u6ee2".length();
        int n13 = "\u4e41\u6471\u5ea4\u6608".length();
        int n14 = "\u6c7e\u6eae".length();
        int n15 = "\u50f2\u554e\u5942\u6708\u6f17".length();
        int n16 = "\u6b6f\u5239".length();
        int n17 = "\u6690\u62f4\u592c\u6464\u63e9".length();
        int n18 = "\u5fb9\u5ef3\u528c\u5c74\u6143".length();
        int n19 = "\u641d\u5c2a".length();
        int n20 = "\u6626\u550c".length();
        int n21 = "\u53d2\u4e84\u5d5c".length();
        int n22 = "\u5258\u6ea6\u5462\u6bf6\u6d62".length();
        int n23 = "\u692a\u654d\u51b0".length();
        return new Color(Math.round((float)n5 + (float)(n - n5) * f), Math.round((float)n6 + (float)(n2 - n6) * f), Math.round((float)n7 + (float)(n3 - n7) * f), Math.round((float)n8 + (float)(n4 - n8) * f));
    }

    public static /* synthetic */ Color tint(Color color, float f) {
        return ColorFunctions.mix(Color.white, color, f);
    }

    public static /* synthetic */ Color shade(Color color, float f) {
        return ColorFunctions.mix(Color.black, color, f);
    }

    public static /* synthetic */ float luma(Color color) {
        float f = ColorFunctions.gammaCorrection((float)color.getRed() / 255.0f);
        float f2 = ColorFunctions.gammaCorrection((float)color.getGreen() / 255.0f);
        float f3 = ColorFunctions.gammaCorrection((float)color.getBlue() / 255.0f);
        return 0.2126f * f + 0.7152f * f2 + 0.0722f * f3;
    }

    public static /* synthetic */ float gammaCorrection(float f) {
        return f <= 0.03928f ? f / 12.92f : (float)Math.pow(((double)f + 0.055) / 1.055, 2.4);
    }

    public static /* synthetic */ Color applyFunctions(Color color, ColorFunction[] colorFunctionArray) {
        if (colorFunctionArray.length == 1 && colorFunctionArray[0] instanceof Mix) {
            Mix mix = (Mix)colorFunctionArray[0];
            return ColorFunctions.mix(color, mix.color2, mix.weight / 100.0f);
        }
        float[] fArray = HSLColor.fromRGB(color);
        float f = (float)color.getAlpha() / 255.0f;
        float[] fArray2 = new float[4];
        int n = "\u5856\u4ee7\u6d41\u6176\u5393".length();
        int n2 = "\u61d0\u5354\u5f55\u654a".length();
        fArray2[0] = fArray[0];
        int n3 = "\u537b\u5039\u6f93\u674d".length();
        int n4 = "\u4f07".length();
        fArray2[1] = fArray[1];
        int n5 = "\u639f\u64d1".length();
        int n6 = "\u5971".length();
        fArray2[2] = fArray[2];
        int n7 = "\u569f".length();
        int n8 = "\u6b36\u50d0\u6c48\u6074".length();
        int n9 = "\u6933\u5269".length();
        int n10 = "\u6877\u5568".length();
        fArray2[3] = f * 100.0f;
        float[] fArray3 = fArray2;
        ColorFunction[] colorFunctionArray2 = colorFunctionArray;
        int n11 = colorFunctionArray2.length;
        for (int i = 0; i < n11; i += 27434) {
            ColorFunction colorFunction = colorFunctionArray2[i];
            colorFunction.apply(fArray3);
            i -= 27433;
        }
        return HSLColor.toRGB(fArray3[0], fArray3[1], fArray3[2], fArray3[3] / 100.0f);
    }

    public static /* synthetic */ float clamp(float f) {
        return f < 0.0f ? 0.0f : (f > 100.0f ? 100.0f : f);
    }

    public static int INSOLENCE_\u6c1a\u4fb4\u64d7\u5768\u64c6\u5701\u63ed\u6946\u6367\u4fd5\u60ab\u6704\u54fd\u5dec\u5ade\u5716\u5db7\u5ffc\u5f1c\u58a2\u693c\u6278\u5a5e\u5de9\u570b\u5520\u713d\u546d\u6cbb\u5565\u5b8e\u7114\u5bf2\u6608\u64ac\u6f06\u5973\u5855\u5f25\u5ce2\u5340(int n) {
        return n;
    }

    public static class Mix
    implements ColorFunction {
        public final /* synthetic */ Color color2;
        public final /* synthetic */ float weight;

        public Mix(Color color, float f) {
            this.color2 = color;
            this.weight = f;
        }

        @Override
        public void apply(float[] fArray) {
            Color color = HSLColor.toRGB(fArray[0], fArray[1], fArray[2], fArray[3] / 100.0f);
            Color color2 = ColorFunctions.mix(color, this.color2, this.weight / 100.0f);
            float[] fArray2 = HSLColor.fromRGB(color2);
            System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            fArray[3] = (float)color2.getAlpha() / 255.0f * 100.0f;
        }

        public String toString() {
            Object[] objectArray = new Object[2];
            int n = "\u4efe\u5709\u5403\u5258\u5ec4".length();
            int n2 = "\u600b\u6282".length();
            objectArray[0] = this.color2.getRGB();
            int n3 = "\u4fef".length();
            int n4 = "\u5891\u5629\u6aa2\u6021".length();
            objectArray[1] = Float.valueOf(this.weight);
            return String.format("mix(#%08x,%.0f%%)", objectArray);
        }
    }

    public static class Fade
    implements ColorFunction {
        public final /* synthetic */ float amount;

        public Fade(float f) {
            this.amount = f;
        }

        @Override
        public void apply(float[] fArray) {
            fArray[3] = ColorFunctions.clamp(this.amount);
        }

        public String toString() {
            Object[] objectArray = new Object[1];
            int n = "\u65ba\u65cd\u5d8c".length();
            objectArray[0] = Float.valueOf(this.amount);
            return String.format("fade(%.0f%%)", objectArray);
        }
    }

    public static class HSLChange
    implements ColorFunction {
        public final /* synthetic */ int hslIndex;
        public final /* synthetic */ float value;

        public HSLChange(int n, float f) {
            this.hslIndex = n;
            this.value = f;
        }

        @Override
        public void apply(float[] fArray) {
            fArray[this.hslIndex] = this.hslIndex == 0 ? this.value % 360.0f : ColorFunctions.clamp(this.value);
        }

        public String toString() {
            String string;
            switch (this.hslIndex) {
                case 0: {
                    string = "changeHue";
                    break;
                }
                case 1: {
                    string = "changeSaturation";
                    break;
                }
                case 2: {
                    string = "changeLightness";
                    break;
                }
                case 3: {
                    string = "changeAlpha";
                    break;
                }
                default: {
                    int n = "\u5e28\u55d6\u4f98".length();
                    int n2 = "\u599f\u50dd\u4ef3".length();
                    int n3 = "\u6b4a\u6f71\u6a9b\u5e82".length();
                    throw new IllegalArgumentException();
                }
            }
            Object[] objectArray = new Object[3];
            int n = "\u65fb\u6d5b".length();
            int n4 = "\u5223".length();
            int n5 = "\u56a3".length();
            int n6 = "\u5b16\u65de".length();
            objectArray[0] = string;
            int n7 = "\u6801".length();
            int n8 = "\u5b19".length();
            objectArray[1] = Float.valueOf(this.value);
            int n9 = "\u4eef\u6343".length();
            int n10 = "\u6ac1\u6371\u4e4f\u557e".length();
            objectArray[2] = this.hslIndex == 0 ? "" : "%";
            return String.format("%s(%.0f%s)", objectArray);
        }
    }

    public static class HSLIncreaseDecrease
    implements ColorFunction {
        public final /* synthetic */ int hslIndex;
        public final /* synthetic */ boolean increase;
        public final /* synthetic */ float amount;
        public final /* synthetic */ boolean relative;
        public final /* synthetic */ boolean autoInverse;

        public HSLIncreaseDecrease(int n, boolean bl, float f, boolean bl2, boolean bl3) {
            this.hslIndex = n;
            this.increase = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(bl ? 1 : 0);
            this.amount = f;
            this.relative = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(bl2 ? 1 : 0);
            this.autoInverse = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(bl3 ? 1 : 0);
        }

        @Override
        public void apply(float[] fArray) {
            float f;
            float f2 = f = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.increase ? 1 : 0) != 0 ? this.amount : -this.amount;
            if (this.hslIndex == 0) {
                fArray[0] = (fArray[0] + f) % 360.0f;
                return;
            }
            f = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.autoInverse ? 1 : 0) != 0 && HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.shouldInverse(fArray) ? 1 : 0) != 0 ? -f : f;
            fArray[this.hslIndex] = ColorFunctions.clamp(HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.relative ? 1 : 0) != 0 ? fArray[this.hslIndex] * ((100.0f + f) / 100.0f) : fArray[this.hslIndex] + f);
        }

        public boolean shouldInverse(float[] fArray) {
            return HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.increase ? 1 : 0) != 0 ? fArray[this.hslIndex] > 65.0f : fArray[this.hslIndex] < 35.0f;
        }

        public String toString() {
            String string;
            switch (this.hslIndex) {
                case 0: {
                    string = "spin";
                    break;
                }
                case 1: {
                    string = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.increase ? 1 : 0) != 0 ? "saturate" : "desaturate";
                    break;
                }
                case 2: {
                    string = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.increase ? 1 : 0) != 0 ? "lighten" : "darken";
                    break;
                }
                case 3: {
                    string = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.increase ? 1 : 0) != 0 ? "fadein" : "fadeout";
                    break;
                }
                default: {
                    int n = "\u68af\u6bc3".length();
                    int n2 = "\u6bfb\u4f89\u6fb3\u5db1\u60a3".length();
                    int n3 = "\u4f42\u703d".length();
                    throw new IllegalArgumentException();
                }
            }
            Object[] objectArray = new Object[4];
            int n = "\u51ba\u5beb\u6297\u60a1\u6ff7".length();
            int n4 = "\u6e20\u6763\u554b\u5e1f".length();
            int n5 = "\u558c\u5e59\u702b".length();
            objectArray[0] = string;
            int n6 = "\u6888\u619c\u6033\u6549".length();
            int n7 = "\u588c\u592f\u6807\u598b".length();
            int n8 = "\u56fe\u6471\u5609\u5f37\u682b".length();
            int n9 = "\u5e41\u5cc9".length();
            objectArray[1] = Float.valueOf(this.amount);
            int n10 = "\u54ba\u5ad0".length();
            int n11 = "\u60bb\u5393\u6ba6\u4e87\u5702".length();
            int n12 = "\u63c9\u551d\u6317\u5a81\u5916".length();
            objectArray[2] = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.relative ? 1 : 0) != 0 ? " relative" : "";
            int n13 = "\u70dd\u6892\u62e7\u5121".length();
            objectArray[3] = HSLIncreaseDecrease.INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(this.autoInverse ? 1 : 0) != 0 ? " autoInverse" : "";
            return String.format("%s(%.0f%%%s%s)", objectArray);
        }

        public static int INSOLENCE_\u63b8\u6354\u5ffb\u5c4c\u6f93\u5ccf\u6a60\u4ec6\u5e8d\u66d0\u6ba8\u4f0e\u4fa3\u5d17\u6512\u5570\u5a9b\u51eb\u4e41\u5178\u5bbe\u6375\u523c\u5836\u6a99\u53e2\u667b\u4eec\u5add\u5247\u6f00\u6482\u6647\u5b8a\u70ab\u581b\u5549\u6bd0\u53d3\u57ad\u59ef(int n) {
            return n;
        }
    }

    public static interface ColorFunction {
        public void apply(float[] var1);
    }
}

