/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.awt.Color;

public class HSLColor {
    public final /* synthetic */ Color rgb;
    public final /* synthetic */ float[] hsl;
    public final /* synthetic */ float alpha;

    public HSLColor(Color color) {
        this.rgb = color;
        this.hsl = HSLColor.fromRGB(color);
        this.alpha = (float)color.getAlpha() / 255.0f;
    }

    public HSLColor(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public HSLColor(float f, float f2, float f3, float f4) {
        this.hsl = new float[]{f, f2, f3};
        this.alpha = f4;
        this.rgb = HSLColor.toRGB(this.hsl[0], this.hsl[1], this.hsl[2], f4);
    }

    public HSLColor(float[] fArray) {
        this(fArray, 1.0f);
    }

    public HSLColor(float[] fArray, float f) {
        this.hsl = fArray;
        this.alpha = f;
        this.rgb = HSLColor.toRGB(fArray[0], fArray[1], fArray[2], f);
    }

    public Color adjustHue(float f) {
        return HSLColor.toRGB(f, this.hsl[1], this.hsl[2], this.alpha);
    }

    public Color adjustLuminance(float f) {
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f, this.alpha);
    }

    public Color adjustSaturation(float f) {
        return HSLColor.toRGB(this.hsl[0], f, this.hsl[2], this.alpha);
    }

    public Color adjustShade(float f) {
        int n = "\u6bad\u5e84\u5c7d".length();
        int n2 = "\u519c\u58b2\u5c05\u4ede\u6f5c".length();
        float f2 = (100.0f - f) / 100.0f;
        float f3 = Math.max(0.0f, this.hsl[2] * f2);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f3, this.alpha);
    }

    public Color adjustTone(float f) {
        float f2 = (100.0f + f) / 100.0f;
        float f3 = Math.min(100.0f, this.hsl[2] * f2);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f3, this.alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color getComplementary() {
        float f = (this.hsl[0] + 180.0f) % 360.0f;
        return HSLColor.toRGB(f, this.hsl[1], this.hsl[2], 1.0f);
    }

    public float getHue() {
        return this.hsl[0];
    }

    public float[] getHSL() {
        return this.hsl;
    }

    public float getLuminance() {
        return this.hsl[2];
    }

    public Color getRGB() {
        return this.rgb;
    }

    public float getSaturation() {
        return this.hsl[1];
    }

    public String toString() {
        int n = "\u4e40\u67e0\u6827".length();
        int n2 = "\u54b6\u4e80\u6ead".length();
        String string = "HSLColor[h=" + this.hsl[0] + ",s=" + this.hsl[1] + ",l=" + this.hsl[2] + ",alpha=" + this.alpha + "]";
        return string;
    }

    public static /* synthetic */ float[] fromRGB(Color color) {
        float f;
        float[] fArray = color.getRGBColorComponents(null);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = Math.min(f2, Math.min(f3, f4));
        float f6 = Math.max(f2, Math.max(f3, f4));
        float f7 = 0.0f;
        if (f6 == f5) {
            f7 = 0.0f;
        } else if (f6 == f2) {
            int n = "\u690b\u68c6".length();
            int n2 = "\u6151\u57b4".length();
            int n3 = "\u61f3\u5e60\u6828".length();
            int n4 = "\u5ae2\u5c04".length();
            f7 = (60.0f * (f3 - f4) / (f6 - f5) + 360.0f) % 360.0f;
        } else if (f6 == f3) {
            int n = "\u57a0".length();
            int n5 = "\u6221\u640d\u58ac".length();
            int n6 = "\u4f27\u5151\u5f77".length();
            int n7 = "\u552d\u7117\u5f35".length();
            f7 = 60.0f * (f4 - f2) / (f6 - f5) + 120.0f;
        } else if (f6 == f4) {
            int n = "\u6880\u5ff2\u6331\u64b3".length();
            int n8 = "\u6953\u5392".length();
            int n9 = "\u691d\u6574\u5a32\u6a98".length();
            int n10 = "\u5dcc".length();
            f7 = 60.0f * (f2 - f3) / (f6 - f5) + 240.0f;
        }
        float f8 = (f6 + f5) / 2.0f;
        if (f6 == f5) {
            f = 0.0f;
        } else if (f8 <= 0.5f) {
            int n = "\u5b10".length();
            int n11 = "\u63c7\u521b\u56ef\u5deb".length();
            int n12 = "\u6fae\u5bca\u6cb6".length();
            f = (f6 - f5) / (f6 + f5);
        } else {
            int n = "\u564a\u50a0\u682e\u578b\u5ab7".length();
            int n13 = "\u5d43\u5159\u6313\u630d".length();
            int n14 = "\u697c\u5fba\u70df".length();
            int n15 = "\u6346".length();
            int n16 = "\u5596\u66d4\u5947".length();
            int n17 = "\u5937\u5401\u70ad\u50c5".length();
            int n18 = "\u6423\u5daf\u6418".length();
            int n19 = "\u5b30\u6241\u56b1".length();
            f = (f6 - f5) / (2.0f - f6 - f5);
        }
        float[] fArray2 = new float[3];
        int n = "\u6cf9\u537f\u6dd0\u66c3".length();
        int n20 = "\u67a8\u53f8\u66e1\u701e\u65ca".length();
        fArray2[0] = f7;
        int n21 = "\u6ab1\u5e5e\u6845\u6159".length();
        fArray2[1] = f * 100.0f;
        int n22 = "\u504d\u6988\u5ad6".length();
        fArray2[2] = f8 * 100.0f;
        return fArray2;
    }

    public static /* synthetic */ Color toRGB(float[] fArray) {
        return HSLColor.toRGB(fArray[0], fArray[1], fArray[2], 1.0f);
    }

    public static /* synthetic */ Color toRGB(float f, float f2, float f3, float f4) {
        float f5;
        if (f2 < 0.0f || f2 > 100.0f) {
            String string = "Color parameter outside of expected range - Saturation";
            int n = "\u50a7\u637d\u5904\u6b64\u64d0".length();
            int n2 = "\u57ff\u6197\u6264".length();
            int n3 = "\u6a49".length();
            int n4 = "\u512e\u5d99".length();
            int n5 = "\u619b\u4e6c".length();
            int n6 = "\u510b\u5238\u4ea0\u5290\u60a9".length();
            throw new IllegalArgumentException(string);
        }
        if (f3 < 0.0f || f3 > 100.0f) {
            String string = "Color parameter outside of expected range - Luminance";
            int n = "\u5595\u5115\u670e".length();
            int n7 = "\u51bd\u6971\u6656\u69a5\u6f39".length();
            int n8 = "\u553f\u6a29\u5bd3\u5025".length();
            int n9 = "\u664d".length();
            int n10 = "\u5051\u5d51\u57f3".length();
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f || f4 > 1.0f) {
            String string = "Color parameter outside of expected range - Alpha";
            int n = "\u5cc4".length();
            int n11 = "\u525c".length();
            int n12 = "\u65f4\u5d22\u50cf\u645a".length();
            int n13 = "\u4fa7\u54f9\u51f9\u6dff\u5691".length();
            int n14 = "\u64eb".length();
            throw new IllegalArgumentException(string);
        }
        f %= 360.0f;
        f /= 360.0f;
        f2 /= 100.0f;
        if ((double)(f3 /= 100.0f) < 0.5) {
            f5 = f3 * (1.0f + f2);
        } else {
            int n = "\u657b\u626d\u545d\u5c04".length();
            int n15 = "\u51bf\u5925\u70a2\u538a".length();
            int n16 = "\u58c5".length();
            int n17 = "\u511a\u5e55\u56c3".length();
            int n18 = "\u5dc6".length();
            f5 = f3 + f2 - f2 * f3;
        }
        int n = "\u6694\u69fc\u5447\u550e".length();
        int n19 = "\u5df4\u50ad\u5089\u6e12\u5906".length();
        int n20 = "\u6147\u5075\u5f25".length();
        float f6 = 2.0f * f3 - f5;
        float f7 = Math.max(0.0f, HSLColor.HueToRGB(f6, f5, f + 0.33333334f));
        float f8 = Math.max(0.0f, HSLColor.HueToRGB(f6, f5, f));
        int n21 = "\u66da\u627a".length();
        int n22 = "\u6d1d\u6751\u694d\u5b5f".length();
        float f9 = Math.max(0.0f, HSLColor.HueToRGB(f6, f5, f - 0.33333334f));
        f7 = Math.min(f7, 1.0f);
        f8 = Math.min(f8, 1.0f);
        f9 = Math.min(f9, 1.0f);
        int n23 = "\u6739".length();
        int n24 = "\u4f25\u58e4\u4f7d\u51c5".length();
        int n25 = "\u5964\u5cfd\u5ff0".length();
        return new Color(f7, f8, f9, f4);
    }

    public static /* synthetic */ float HueToRGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            int n = "\u6460\u5954\u57b9".length();
            int n2 = "\u54e2\u56a7".length();
            int n3 = "\u5cc7\u6bca\u60f5\u50b4\u6077".length();
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            int n = "\u584a".length();
            int n4 = "\u5cbf\u5cd0\u5326\u51dd".length();
            int n5 = "\u64c8\u69f4\u6308\u4f77".length();
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            int n = "\u69b4\u66dd\u5c57".length();
            int n6 = "\u5a72\u6f3f".length();
            int n7 = "\u6eed\u4fa7\u6527".length();
            int n8 = "\u5ad8\u5446\u5fb4".length();
            int n9 = "\u692c\u679a\u633d".length();
            int n10 = "\u666a\u6752".length();
            return f + (f2 - f) * 6.0f * (0.6666667f - f3);
        }
        return f;
    }
}

