/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.MultiResolutionImageSupport;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ScaledImageIcon
implements Icon {
    public final /* synthetic */ ImageIcon imageIcon;
    public final /* synthetic */ int iconWidth;
    public final /* synthetic */ int iconHeight;
    public /* synthetic */ double lastSystemScaleFactor;
    public /* synthetic */ float lastUserScaleFactor;
    public /* synthetic */ Image lastImage;

    public ScaledImageIcon(ImageIcon imageIcon) {
        this(imageIcon, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    public ScaledImageIcon(ImageIcon imageIcon, int n, int n2) {
        this.imageIcon = imageIcon;
        this.iconWidth = n;
        this.iconHeight = n2;
    }

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.iconWidth);
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.iconHeight);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        float f;
        double d = UIScale.getSystemScaleFactor((Graphics2D)graphics);
        double d2 = d * (double)(f = UIScale.getUserScaleFactor());
        if (d2 == 1.0 && this.imageIcon != null && this.iconWidth == this.imageIcon.getIconWidth() && this.iconHeight == this.imageIcon.getIconHeight()) {
            this.imageIcon.paintIcon(component, graphics, n, n2);
            return;
        }
        if (d == this.lastSystemScaleFactor && f == this.lastUserScaleFactor && this.lastImage != null) {
            this.paintLastImage(graphics, n, n2);
            return;
        }
        int n3 = (int)Math.round((double)this.iconWidth * d2);
        int n4 = (int)Math.round((double)this.iconHeight * d2);
        Image image = this.getResolutionVariant(n3, n4);
        int n5 = -1;
        int n6 = -1;
        if (image != null) {
            n5 = image.getWidth(null);
            n6 = image.getHeight(null);
        }
        if (n5 < 0 || n6 < 0) {
            graphics.setColor(Color.red);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            return;
        }
        if (n5 != n3 || n6 != n4) {
            Object object = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            float f2 = (float)n3 / (float)n5;
            if ((float)((int)f2) == f2 && f2 > 1.0f && n5 <= 16 && n6 <= 16) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            BufferedImage bufferedImage = this.image2bufferedImage(image);
            image = this.scaleImage(bufferedImage, n3, n4, object);
        }
        this.lastSystemScaleFactor = d;
        this.lastUserScaleFactor = f;
        this.lastImage = image;
        this.paintLastImage(graphics, n, n2);
    }

    public Image getResolutionVariant(int n, int n2) {
        return MultiResolutionImageSupport.getResolutionVariant(this.imageIcon.getImage(), n, n2);
    }

    public void paintLastImage(Graphics graphics, int n5, int n6) {
        if (this.lastSystemScaleFactor > 1.0) {
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, n5, n6, 100, 100, (graphics2D, n, n2, n3, n4, d) -> {
                ScaledImageIcon.INSOLENCE_\u682c\u5f22\u61fd\u566a\u5be1\u6e0e\u4f18\u6303\u5159\u5efe\u5d8f\u664d\u6507\u5082\u6425\u6c42\u6684\u4ef5\u57b3\u55e0\u702c\u6ca1\u56eb\u6731\u54be\u55a3\u5c1a\u6283\u6951\u55d3\u67b0\u5670\u5445\u6302\u60f7\u57cf\u658a\u5e72\u69a9\u57a0\u62e0(graphics2D.drawImage(this.lastImage, n, n2, null) ? 1 : 0);
                int n5 = "\u5ff3\u5d56\u5503\u4e73\u6b84".length();
                int n6 = "\u5e82\u5a97\u5533\u6fa4\u50d4".length();
                int n7 = "\u67c2".length();
                int n8 = "\u4fa1\u66d7\u6d48\u50db\u61c7".length();
            });
        } else {
            ScaledImageIcon.INSOLENCE_\u682c\u5f22\u61fd\u566a\u5be1\u6e0e\u4f18\u6303\u5159\u5efe\u5d8f\u664d\u6507\u5082\u6425\u6c42\u6684\u4ef5\u57b3\u55e0\u702c\u6ca1\u56eb\u6731\u54be\u55a3\u5c1a\u6283\u6951\u55d3\u67b0\u5670\u5445\u6302\u60f7\u57cf\u658a\u5e72\u69a9\u57a0\u62e0(graphics.drawImage(this.lastImage, n5, n6, null) ? 1 : 0);
            int n7 = "\u6cd0\u617a\u5e91\u6b2e".length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2, Object object) {
        int n3 = "\u5965\u6a56\u56da\u587a\u6817".length();
        int n4 = "\u5577\u5a4a\u6189\u6f6d\u5f9b".length();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            ScaledImageIcon.INSOLENCE_\u682c\u5f22\u61fd\u566a\u5be1\u6e0e\u4f18\u6303\u5159\u5efe\u5d8f\u664d\u6507\u5082\u6425\u6c42\u6684\u4ef5\u57b3\u55e0\u702c\u6ca1\u56eb\u6731\u54be\u55a3\u5c1a\u6283\u6951\u55d3\u67b0\u5670\u5445\u6302\u60f7\u57cf\u658a\u5e72\u69a9\u57a0\u62e0(graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null) ? 1 : 0);
            int n5 = "\u50cb\u6dce\u565a".length();
            int n6 = "\u5a0c\u6814".length();
        }
        catch (Throwable throwable) {
            graphics2D.dispose();
            int n7 = "\u6d3b".length();
            int n8 = "\u5f94\u52fa\u5068\u6c55\u4e90".length();
            int n9 = "\u5050\u605a\u5598".length();
            throw throwable;
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage image2bufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int n = "\u54dd\u533e\u67e1\u64ed".length();
        int n2 = "\u5526\u566b\u555a".length();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            ScaledImageIcon.INSOLENCE_\u682c\u5f22\u61fd\u566a\u5be1\u6e0e\u4f18\u6303\u5159\u5efe\u5d8f\u664d\u6507\u5082\u6425\u6c42\u6684\u4ef5\u57b3\u55e0\u702c\u6ca1\u56eb\u6731\u54be\u55a3\u5c1a\u6283\u6951\u55d3\u67b0\u5670\u5445\u6302\u60f7\u57cf\u658a\u5e72\u69a9\u57a0\u62e0(graphics2D.drawImage(image, 0, 0, null) ? 1 : 0);
            int n3 = "\u5efc\u5622\u54ce\u6de3\u6176".length();
            int n4 = "\u61ee\u6cca\u665b\u51f1\u53e6".length();
            int n5 = "\u7069\u603a\u7062\u65fa\u4f82".length();
        }
        catch (Throwable throwable) {
            graphics2D.dispose();
            int n6 = "\u504f\u66a4".length();
            int n7 = "\u6f32".length();
            throw throwable;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static int INSOLENCE_\u682c\u5f22\u61fd\u566a\u5be1\u6e0e\u4f18\u6303\u5159\u5efe\u5d8f\u664d\u6507\u5082\u6425\u6c42\u6684\u4ef5\u57b3\u55e0\u702c\u6ca1\u56eb\u6731\u54be\u55a3\u5c1a\u6283\u6951\u55d3\u67b0\u5670\u5445\u6302\u60f7\u57cf\u658a\u5e72\u69a9\u57a0\u62e0(int n) {
        return n;
    }
}

