/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class SoftCache<K, V>
implements Map<K, V> {
    public final /* synthetic */ Map<K, CacheReference<K, V>> map;
    public final /* synthetic */ ReferenceQueue<V> queue;

    public SoftCache() {
        this.queue = new ReferenceQueue();
        this.map = new HashMap<K, CacheReference<K, V>>();
    }

    public SoftCache(int n) {
        this.queue = new ReferenceQueue();
        this.map = new HashMap<K, CacheReference<K, V>>(n);
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.expungeStaleEntries();
        return SoftCache.INSOLENCE_\u6630\u5f99\u5c5c\u5c1f\u681b\u6ae0\u53e5\u5ea1\u6c43\u4e40\u5455\u62bf\u53dd\u4f0f\u6115\u5f85\u59bb\u6903\u50c4\u6f30\u55a2\u6a53\u5f37\u557e\u6e88\u64fd\u4f9c\u634d\u5b3e\u6157\u618e\u4e7d\u6036\u62bb\u5fc8\u68ad\u5316\u6730\u5119\u56ac\u5473(this.map.isEmpty() ? 1 : 0) != 0;
    }

    @Override
    public boolean containsKey(Object object) {
        this.expungeStaleEntries();
        return SoftCache.INSOLENCE_\u6630\u5f99\u5c5c\u5c1f\u681b\u6ae0\u53e5\u5ea1\u6c43\u4e40\u5455\u62bf\u53dd\u4f0f\u6115\u5f85\u59bb\u6903\u50c4\u6f30\u55a2\u6a53\u5f37\u557e\u6e88\u64fd\u4f9c\u634d\u5b3e\u6157\u618e\u4e7d\u6036\u62bb\u5fc8\u68ad\u5316\u6730\u5119\u56ac\u5473(this.map.containsKey(object) ? 1 : 0) != 0;
    }

    @Override
    public boolean containsValue(Object object) {
        int n = "\u6bf0".length();
        int n2 = "\u5c70\u50e7\u6452\u6e56\u6210".length();
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object object) {
        this.expungeStaleEntries();
        return this.getRef(this.map.get(object));
    }

    @Override
    public V put(K k, V v) {
        this.expungeStaleEntries();
        int n = "\u6e78\u5949\u51a3\u5fa1".length();
        return this.getRef(this.map.put(k, new CacheReference<K, V>(k, v, this.queue)));
    }

    @Override
    public V remove(Object object) {
        this.expungeStaleEntries();
        return this.getRef(this.map.remove(object));
    }

    public V getRef(CacheReference<K, V> cacheReference) {
        return cacheReference != null ? (V)cacheReference.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.expungeStaleEntries();
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (SoftCache.INSOLENCE_\u6630\u5f99\u5c5c\u5c1f\u681b\u6ae0\u53e5\u5ea1\u6c43\u4e40\u5455\u62bf\u53dd\u4f0f\u6115\u5f85\u59bb\u6903\u50c4\u6f30\u55a2\u6a53\u5f37\u557e\u6e88\u64fd\u4f9c\u634d\u5b3e\u6157\u618e\u4e7d\u6036\u62bb\u5fc8\u68ad\u5316\u6730\u5119\u56ac\u5473(iterator.hasNext() ? 1 : 0) != 0) {
            Map.Entry<K, V> entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
            int n = "\u7113".length();
            int n2 = "\u5fc9\u56a2".length();
            int n3 = "\u53c9\u5f0c\u6e9d\u5c60".length();
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.expungeStaleEntries();
    }

    @Override
    public Set<K> keySet() {
        this.expungeStaleEntries();
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        int n = "\u6130\u6b6f".length();
        int n2 = "\u536c\u6286\u528a\u63a4".length();
        int n3 = "\u6e1c\u5cd7\u6371\u5902".length();
        int n4 = "\u5217\u62ac\u4f76\u5d5f".length();
        int n5 = "\u5a52".length();
        int n6 = "\u5f3f\u62b7\u6b9d\u5191".length();
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        int n = "\u5dce\u6b3a\u622e\u6ed8".length();
        int n2 = "\u7020\u664d\u630c".length();
        int n3 = "\u5cb5\u6ffb\u7055\u5c2d".length();
        int n4 = "\u617c\u67eb".length();
        int n5 = "\u60cb".length();
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        int n = "\u5234\u5381".length();
        int n2 = "\u5c7c\u5e68".length();
        int n3 = "\u6cec\u502a\u6f98\u63c2\u4ffb".length();
        int n4 = "\u6713\u5b3f\u6cac".length();
        int n5 = "\u69e8\u6b25\u6360\u646f\u666c".length();
        int n6 = "\u6551".length();
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        int n = "\u648e\u651c\u6f67\u6cac\u6b61".length();
        int n2 = "\u69d8\u6d9e".length();
        int n3 = "\u5741\u699e\u52a1\u5379".length();
        int n4 = "\u6e98\u4e83".length();
        throw new UnsupportedOperationException();
    }

    public void expungeStaleEntries() {
        while (true) {
            int n = "\u6513\u70dd".length();
            int n2 = "\u5972".length();
            int n3 = "\u7086\u5ac1\u5660".length();
            Reference<V> reference = this.queue.poll();
            if (reference == null) break;
            this.map.remove(((CacheReference)reference).key);
            int n4 = "\u6940\u7076\u6246\u59dd".length();
        }
    }

    public static int INSOLENCE_\u6630\u5f99\u5c5c\u5c1f\u681b\u6ae0\u53e5\u5ea1\u6c43\u4e40\u5455\u62bf\u53dd\u4f0f\u6115\u5f85\u59bb\u6903\u50c4\u6f30\u55a2\u6a53\u5f37\u557e\u6e88\u64fd\u4f9c\u634d\u5b3e\u6157\u618e\u4e7d\u6036\u62bb\u5fc8\u68ad\u5316\u6730\u5119\u56ac\u5473(int n) {
        return n;
    }

    private static class CacheReference<K, V>
    extends SoftReference<V> {
        public final /* synthetic */ K key;

        public CacheReference(K k, V v, ReferenceQueue<? super V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }
    }
}

