/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg;

import com.github.weisj.jsvg.SVGRenderingHints;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.SVG;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SVGDocument {
    public static final /* synthetic */ boolean DEBUG = false;
    @NotNull
    public final /* synthetic */ SVG root;
    @NotNull
    public final /* synthetic */ FloatSize size;

    public SVGDocument(@NotNull SVG sVG) {
        this.root = sVG;
        float f = SVGFont.defaultFontSize();
        this.size = sVG.sizeForTopLevel(f, SVGFont.exFromEm(f));
    }

    @NotNull
    public FloatSize size() {
        return this.size;
    }

    public void render(@Nullable JComponent jComponent, @NotNull Graphics2D graphics2D) {
        this.render(jComponent, graphics2D, null);
    }

    public void render(@Nullable JComponent jComponent, @NotNull Graphics2D graphics2D, @Nullable ViewBox viewBox) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.setupSVGRenderingHints(graphics2D2);
        Font font = graphics2D2.getFont();
        if (font == null && jComponent != null) {
            font = jComponent.getFont();
        }
        float f = font != null ? font.getSize2D() : SVGFont.defaultFontSize();
        float f2 = SVGFont.exFromEm(f);
        MeasureContext measureContext = viewBox != null ? MeasureContext.createInitial(viewBox.size(), f, f2) : MeasureContext.createInitial(this.root.sizeForTopLevel(f, f2), f, f2);
        RenderContext renderContext = RenderContext.createInitial(jComponent, measureContext);
        if (viewBox == null) {
            int n = "\u4f6a".length();
            int n2 = "\u507e".length();
            int n3 = "\u5695\u5554\u7001\u5cbb\u5b83".length();
            viewBox = new ViewBox(this.root.size(renderContext));
        }
        this.root.applyTransform(graphics2D2, renderContext);
        graphics2D2.clip(viewBox);
        graphics2D2.translate(viewBox.x, viewBox.y);
        NodeRenderer.Info info = NodeRenderer.createRenderInfo(this.root, renderContext, graphics2D2, null);
        try {
            Objects.requireNonNull(info);
            int n = "\u58f6\u671c".length();
            int n4 = "\u6ea6\u609c\u5f1c\u7094\u6762".length();
            int n5 = "\u685b".length();
            this.root.renderWithSize(viewBox.size(), this.root.viewBox(renderContext), info.context, info.g);
            if (info != null) {
                info.close();
            }
        }
        catch (Throwable throwable) {
            if (info != null) {
                try {
                    info.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            int n = "\u6ed0\u57ec\u61df\u64f3\u5b80".length();
            int n6 = "\u62b5\u5475\u5e52\u5931\u6891".length();
            int n7 = "\u5621\u6e21\u54ca".length();
            throw throwable;
        }
        graphics2D2.dispose();
    }

    public void setupSVGRenderingHints(@NotNull Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (object != RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
            this.setSVGRenderingHint(graphics2D, SVGRenderingHints.KEY_IMAGE_ANTIALIASING, object == RenderingHints.VALUE_ANTIALIAS_ON ? SVGRenderingHints.VALUE_IMAGE_ANTIALIASING_ON : SVGRenderingHints.VALUE_IMAGE_ANTIALIASING_OFF);
        }
    }

    public void setSVGRenderingHint(@NotNull Graphics2D graphics2D, @NotNull RenderingHints.Key key, @NotNull Object object) {
        if (graphics2D.getRenderingHint(key) == null) {
            graphics2D.setRenderingHint(key, object);
        }
    }
}

