/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes.font;

import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.text.Glyph;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AWTSVGFont
implements SVGFont {
    @NotNull
    public final /* synthetic */ Font font;
    public final /* synthetic */ FontRenderContext frc;
    public final /* synthetic */ HashMap<Character, Glyph> glyphCache;
    @Nullable
    public /* synthetic */ LineMetrics lineMetrics;
    public /* synthetic */ float[] baselineOffsets;
    public /* synthetic */ float exHeight;
    public /* synthetic */ float mathBaseline;

    public AWTSVGFont(@NotNull Font font) {
        this.frc = new FontRenderContext(null, true, true);
        this.exHeight = Float.NaN;
        this.mathBaseline = Float.NaN;
        this.font = font;
        this.glyphCache = new HashMap();
    }

    @Override
    @NotNull
    public Glyph codepointGlyph(char c) {
        Glyph glyph = this.glyphCache.get(Character.valueOf(c));
        if (glyph != null) {
            return glyph;
        }
        glyph = this.createGlyph(c);
        this.glyphCache.put(Character.valueOf(c), glyph);
        int n = "\u5f1b\u4f71".length();
        return glyph;
    }

    @Override
    @NotNull
    public String family() {
        return this.font.getFamily();
    }

    @Override
    public int size() {
        return this.font.getSize();
    }

    @NotNull
    public LineMetrics lineMetrics() {
        if (this.lineMetrics == null) {
            this.lineMetrics = this.font.getLineMetrics("Ax-", 0, 1, this.frc);
        }
        return this.lineMetrics;
    }

    @Override
    public float effectiveExHeight() {
        if (AWTSVGFont.INSOLENCE_\u63c4\u4fb3\u6848\u6c2e\u5ac2\u5459\u666e\u605a\u54ab\u56e4\u59eb\u69d3\u5aa7\u5b26\u59f2\u6712\u546c\u615c\u5b93\u668a\u5740\u531b\u6b35\u6b41\u6beb\u6ba0\u66f8\u5812\u60ec\u63bf\u5b3a\u68c9\u5f16\u58d0\u602e\u696a\u6ce5\u63cf\u70d6\u6208\u5a01(Length.isUnspecified(this.exHeight) ? 1 : 0) != 0) {
            this.exHeight = (float)this.codepointGlyph('x').glyphOutline().getBounds2D().getHeight();
        }
        return this.exHeight;
    }

    @Override
    public float effectiveEmHeight() {
        return this.font.getSize2D();
    }

    @Override
    public float mathematicalBaseline() {
        if (AWTSVGFont.INSOLENCE_\u63c4\u4fb3\u6848\u6c2e\u5ac2\u5459\u666e\u605a\u54ab\u56e4\u59eb\u69d3\u5aa7\u5b26\u59f2\u6712\u546c\u615c\u5b93\u668a\u5740\u531b\u6b35\u6b41\u6beb\u6ba0\u66f8\u5812\u60ec\u63bf\u5b3a\u68c9\u5f16\u58d0\u602e\u696a\u6ce5\u63cf\u70d6\u6208\u5a01(Length.isUnspecified(this.mathBaseline) ? 1 : 0) != 0) {
            this.mathBaseline = -this.effectiveExHeight() / 2.0f;
        }
        return this.mathBaseline;
    }

    public float[] baselineOffsets() {
        if (this.baselineOffsets == null) {
            this.baselineOffsets = this.lineMetrics().getBaselineOffsets();
        }
        return this.baselineOffsets;
    }

    @Override
    public float hangingBaseline() {
        return this.baselineOffsets()[2];
    }

    @Override
    public float romanBaseline() {
        return this.baselineOffsets()[0];
    }

    @Override
    public float centerBaseline() {
        return this.baselineOffsets()[1];
    }

    @Override
    public float middleBaseline() {
        int n = "\u67bb\u5a62\u535d\u597e\u5186".length();
        int n2 = "\u4f76\u6159\u687f\u6e6c".length();
        int n3 = "\u5e59\u5e11".length();
        return (this.romanBaseline() - this.effectiveExHeight()) / 2.0f;
    }

    @Override
    public float textUnderBaseline() {
        return this.lineMetrics().getUnderlineOffset();
    }

    @Override
    public float textOverBaseline() {
        int n = "\u69e0\u5986".length();
        int n2 = "\u66aa\u6a21".length();
        return this.textUnderBaseline() - this.effectiveEmHeight();
    }

    @NotNull
    public Glyph createGlyph(char c) {
        char[] cArray = new char[1];
        int n = "\u7061\u605f".length();
        int n2 = "\u618d\u688a\u56f3".length();
        int n3 = "\u63db\u5dce".length();
        int n4 = "\u6c79\u6b30\u5288\u6c63".length();
        cArray[0] = c;
        char[] cArray2 = cArray;
        GlyphVector glyphVector = this.font.createGlyphVector(this.frc, cArray2);
        GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
        float f = glyphMetrics.getAdvanceX();
        Shape shape = glyphVector.getGlyphOutline(0);
        int n5 = "\u5c3b\u6f76\u6a7c".length();
        int n6 = "\u6e74\u5351\u6046\u6c8c".length();
        int n7 = "\u6ac4\u6b79".length();
        return new Glyph(shape, f, AWTSVGFont.INSOLENCE_\u63c4\u4fb3\u6848\u6c2e\u5ac2\u5459\u666e\u605a\u54ab\u56e4\u59eb\u69d3\u5aa7\u5b26\u59f2\u6712\u546c\u615c\u5b93\u668a\u5740\u531b\u6b35\u6b41\u6beb\u6ba0\u66f8\u5812\u60ec\u63bf\u5b3a\u68c9\u5f16\u58d0\u602e\u696a\u6ce5\u63cf\u70d6\u6208\u5a01(glyphMetrics.getBounds2D().isEmpty() ? 1 : 0) != 0);
    }

    public static int INSOLENCE_\u63c4\u4fb3\u6848\u6c2e\u5ac2\u5459\u666e\u605a\u54ab\u56e4\u59eb\u69d3\u5aa7\u5b26\u59f2\u6712\u546c\u615c\u5b93\u668a\u5740\u531b\u6b35\u6b41\u6beb\u6ba0\u66f8\u5812\u60ec\u63bf\u5b3a\u68c9\u5f16\u58d0\u602e\u696a\u6ce5\u63cf\u70d6\u6208\u5a01(int n) {
        return n;
    }
}

