/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes.font;

import com.github.weisj.jsvg.attributes.font.AttributeFontSpec;
import com.github.weisj.jsvg.attributes.font.FontSize;
import com.github.weisj.jsvg.attributes.font.FontStretch;
import com.github.weisj.jsvg.attributes.font.FontStyle;
import com.github.weisj.jsvg.attributes.font.FontWeight;
import com.github.weisj.jsvg.attributes.font.LengthFontSize;
import com.github.weisj.jsvg.attributes.font.NumberFontWeight;
import com.github.weisj.jsvg.attributes.font.PredefinedFontSize;
import com.github.weisj.jsvg.attributes.font.PredefinedFontWeight;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.SeparatorMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FontParser {
    @NotNull
    public static /* synthetic */ AttributeFontSpec parseFontSpec(@NotNull AttributeNode attributeNode) {
        String[] stringArray = attributeNode.getStringList("font-family", SeparatorMode.COMMA_ONLY);
        @Nullable FontWeight fontWeight = FontParser.parseWeight(attributeNode);
        @Nullable FontSize fontSize = FontParser.parseFontSize(attributeNode);
        @Nullable Length length = attributeNode.getLength("font-size-adjust");
        @Nullable FontStyle fontStyle = FontParser.parseFontStyle(attributeNode);
        float f = FontParser.parseStretch(attributeNode);
        int n = "\u5538".length();
        int n2 = "\u594d\u4e56".length();
        return new AttributeFontSpec(stringArray, fontStyle, length, f, fontSize, fontWeight);
    }

    @Nullable
    public static /* synthetic */ FontWeight parseWeight(@NotNull AttributeNode attributeNode) {
        String string = "font-weight";
        FontWeight fontWeight = attributeNode.getEnum("font-weight", PredefinedFontWeight.Number);
        if (fontWeight == PredefinedFontWeight.Number) {
            if (FontParser.INSOLENCE_\u6996\u66d4\u6a0b\u70a8\u6ac4\u571d\u6977\u690c\u6a32\u591e\u6a2b\u6491\u5b04\u5fca\u6722\u5fe2\u52b3\u653c\u66f8\u5f40\u68af\u60db\u654e\u54c4\u5688\u638f\u5d25\u4fa2\u56c7\u5c32\u5ae2\u512b\u541d\u6635\u6a4a\u705e\u60bd\u4e27\u5038\u6e34\u575a(attributeNode.hasAttribute("font-weight") ? 1 : 0) != 0) {
                int n = "\u67ce".length();
                int n2 = "\u5457\u69ed\u602c\u50fa\u5b19".length();
                int n3 = "\u6741\u5390\u509d".length();
                int n4 = "\u5486".length();
                fontWeight = new NumberFontWeight(Math.max(1.0f, Math.min(1000.0f, attributeNode.getFloat("font-weight", 400.0f))));
            } else {
                fontWeight = null;
            }
        }
        return fontWeight;
    }

    public static /* synthetic */ float parseStretch(@NotNull AttributeNode attributeNode) {
        FontStretch fontStretch = attributeNode.getEnum("font-stretch", FontStretch.Percentage);
        return fontStretch == FontStretch.Percentage ? attributeNode.parser().parsePercentage(attributeNode.getValue("font-stretch"), Float.NaN, 0.5f, 2.0f) : fontStretch.percentage();
    }

    @Nullable
    public static /* synthetic */ FontSize parseFontSize(@NotNull AttributeNode attributeNode) {
        FontSize fontSize = attributeNode.getEnum("font-size", PredefinedFontSize.Number);
        if (fontSize == PredefinedFontSize.Number) {
            LengthFontSize lengthFontSize;
            Length length = attributeNode.getLength("font-size", Length.UNSPECIFIED);
            if (FontParser.INSOLENCE_\u6996\u66d4\u6a0b\u70a8\u6ac4\u571d\u6977\u690c\u6a32\u591e\u6a2b\u6491\u5b04\u5fca\u6722\u5fe2\u52b3\u653c\u66f8\u5f40\u68af\u60db\u654e\u54c4\u5688\u638f\u5d25\u4fa2\u56c7\u5c32\u5ae2\u512b\u541d\u6635\u6a4a\u705e\u60bd\u4e27\u5038\u6e34\u575a(length.isSpecified() ? 1 : 0) != 0) {
                LengthFontSize lengthFontSize2;
                int n = "\u5a79\u566b\u5593\u6ac1\u52a7".length();
                int n2 = "\u6d15".length();
                lengthFontSize = lengthFontSize2;
                lengthFontSize2 = new LengthFontSize(length);
            } else {
                lengthFontSize = null;
            }
            fontSize = lengthFontSize;
        }
        return fontSize;
    }

    @Nullable
    public static /* synthetic */ FontStyle parseFontStyle(@NotNull AttributeNode attributeNode) {
        FontStyle fontStyle = null;
        String string = attributeNode.getValue("font-style");
        if (FontParser.INSOLENCE_\u6996\u66d4\u6a0b\u70a8\u6ac4\u571d\u6977\u690c\u6a32\u591e\u6a2b\u6491\u5b04\u5fca\u6722\u5fe2\u52b3\u653c\u66f8\u5f40\u68af\u60db\u654e\u54c4\u5688\u638f\u5d25\u4fa2\u56c7\u5c32\u5ae2\u512b\u541d\u6635\u6a4a\u705e\u60bd\u4e27\u5038\u6e34\u575a("normal".equalsIgnoreCase(string) ? 1 : 0) != 0) {
            fontStyle = FontStyle.normal();
        } else if (FontParser.INSOLENCE_\u6996\u66d4\u6a0b\u70a8\u6ac4\u571d\u6977\u690c\u6a32\u591e\u6a2b\u6491\u5b04\u5fca\u6722\u5fe2\u52b3\u653c\u66f8\u5f40\u68af\u60db\u654e\u54c4\u5688\u638f\u5d25\u4fa2\u56c7\u5c32\u5ae2\u512b\u541d\u6635\u6a4a\u705e\u60bd\u4e27\u5038\u6e34\u575a("italic".equalsIgnoreCase(string) ? 1 : 0) != 0) {
            fontStyle = FontStyle.italic();
        } else if (string != null && FontParser.INSOLENCE_\u6996\u66d4\u6a0b\u70a8\u6ac4\u571d\u6977\u690c\u6a32\u591e\u6a2b\u6491\u5b04\u5fca\u6722\u5fe2\u52b3\u653c\u66f8\u5f40\u68af\u60db\u654e\u54c4\u5688\u638f\u5d25\u4fa2\u56c7\u5c32\u5ae2\u512b\u541d\u6635\u6a4a\u705e\u60bd\u4e27\u5038\u6e34\u575a(string.startsWith("oblique") ? 1 : 0) != 0) {
            String[] stringArray = string.split(" ", 2);
            if (stringArray.length == 2) {
                int n = "\u5f62\u653d\u6a10".length();
                int n2 = "\u51bd\u514c\u5c66\u5dc9\u5fc7".length();
                fontStyle = new FontStyle.Oblique(attributeNode.parser().parseAngle(stringArray[1], FontStyle.Oblique.DEFAULT_ANGLE));
            } else {
                fontStyle = FontStyle.oblique();
            }
        }
        return fontStyle;
    }

    public static int INSOLENCE_\u6996\u66d4\u6a0b\u70a8\u6ac4\u571d\u6977\u690c\u6a32\u591e\u6a2b\u6491\u5b04\u5fca\u6722\u5fe2\u52b3\u653c\u66f8\u5f40\u68af\u60db\u654e\u54c4\u5688\u638f\u5d25\u4fa2\u56c7\u5c32\u5ae2\u512b\u541d\u6635\u6a4a\u705e\u60bd\u4e27\u5038\u6e34\u575a(int n) {
        return n;
    }
}

