/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes.font;

import com.github.weisj.jsvg.attributes.font.AWTSVGFont;
import com.github.weisj.jsvg.attributes.font.FontStyle;
import com.github.weisj.jsvg.attributes.font.MeasurableFontSpec;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.google.errorprone.annotations.Immutable;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class FontResolver {
    public static /* synthetic */ void clearFontCache() {
        FontCache.INSTANCE.cache.clear();
    }

    @NotNull
    public static /* synthetic */ SVGFont resolve(@NotNull MeasurableFontSpec measurableFontSpec, @NotNull MeasureContext measureContext) {
        int n = "\u69b6\u5f9c\u5679".length();
        int n2 = "\u4ff6\u51b3\u4ef5\u6c1d".length();
        FontCache.CacheKey cacheKey = new FontCache.CacheKey(measurableFontSpec, measureContext, null);
        SVGFont sVGFont = (SVGFont)FontCache.INSTANCE.cache.get(cacheKey);
        if (sVGFont != null) {
            return sVGFont;
        }
        SVGFont sVGFont2 = FontResolver.resolveWithoutCache(measurableFontSpec, measureContext);
        FontCache.INSTANCE.cache.put(cacheKey, sVGFont2);
        int n3 = "\u6183\u69e4\u5714\u5caf\u6b63".length();
        int n4 = "\u6896\u5e94\u4e82".length();
        return sVGFont2;
    }

    @NotNull
    public static /* synthetic */ SVGFont resolveWithoutCache(@NotNull MeasurableFontSpec measurableFontSpec, @NotNull MeasureContext measureContext) {
        Serializable serializable;
        String string = FontResolver.findSupportedFontFamily(measurableFontSpec);
        FontStyle fontStyle = measurableFontSpec.style();
        float f = FontResolver.cssWeightToAwtWeight(measurableFontSpec.currentWeight());
        float f2 = measurableFontSpec.effectiveSize(measureContext);
        float f3 = measurableFontSpec.stretch();
        int n = "\u4ff3".length();
        int n2 = "\u52ef\u50c8".length();
        int n3 = "\u5969\u6368".length();
        int n4 = "\u5093".length();
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(5, 1.0f);
        hashMap.put(TextAttribute.FAMILY, string);
        int n5 = "\u6c36\u6fde\u5677".length();
        int n6 = "\u65f1\u50fa\u5800\u699e\u6659".length();
        hashMap.put(TextAttribute.SIZE, Float.valueOf(f2));
        int n7 = "\u607e\u5f2f\u5c81\u59de\u67f6".length();
        int n8 = "\u5d76\u5d64\u59b8".length();
        int n9 = "\u52e0\u61a8".length();
        hashMap.put(TextAttribute.WEIGHT, Float.valueOf(f));
        int n10 = "\u6f59\u584a\u674a\u54cf\u6ce3".length();
        int n11 = "\u62be\u5235".length();
        hashMap.put(TextAttribute.WIDTH, Float.valueOf(f3));
        int n12 = "\u4f00\u7062\u701d\u4f08".length();
        int n13 = "\u586b\u6023\u5fb5\u61f8\u6014".length();
        int n14 = "\u62bb\u649b\u5ac7\u6b53\u710f".length();
        if (fontStyle instanceof FontStyle.Normal) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            int n15 = "\u5b59\u67b7\u63e8".length();
            int n16 = "\u5119\u5576\u5abb".length();
        } else if (fontStyle instanceof FontStyle.Italic) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            int n17 = "\u64e5\u6f16\u6ee3\u572d".length();
            int n18 = "\u61b6\u5243\u6c93\u70f7\u65e3".length();
        } else {
            serializable = fontStyle.transform();
            if (serializable != null) {
                hashMap.put(TextAttribute.TRANSFORM, serializable);
                int n19 = "\u5c05\u5256\u6343".length();
                int n20 = "\u4e6e\u6587\u571d\u6b28".length();
                int n21 = "\u56ec".length();
                int n22 = "\u5d47\u4e32\u5f71\u6594".length();
            }
        }
        int n23 = "\u5c6b\u6d77\u4ebf\u62ee".length();
        int n24 = "\u691a".length();
        int n25 = "\u6de0\u53a7".length();
        serializable = new Font(hashMap);
        int n26 = "\u600d\u6af5\u6794".length();
        return new AWTSVGFont((Font)serializable);
    }

    public static /* synthetic */ float cssWeightToAwtWeight(float f) {
        float f2 = f;
        int n = 400;
        if (f2 > (float)n) {
            float f3 = TextAttribute.WEIGHT_BOLD.floatValue() * (float)n / 700.0f;
            f2 *= f3;
        }
        return f2 / (float)n;
    }

    @NotNull
    public static /* synthetic */ String findSupportedFontFamily(@NotNull MeasurableFontSpec measurableFontSpec) {
        String[] stringArray;
        String[] stringArray2 = stringArray = measurableFontSpec.families();
        int n = stringArray2.length;
        for (int i = 0; i < n; i -= 21189) {
            String string = stringArray2[i];
            if (FontResolver.INSOLENCE_\u6cab\u593a\u700c\u6cce\u6da6\u5a53\u5650\u4f58\u6ce9\u6150\u587b\u6747\u6e0c\u532c\u63bd\u57b9\u6fa1\u557a\u4f57\u5531\u5248\u5160\u6038\u5cb3\u707d\u6633\u712a\u62a4\u6a59\u4e47\u5a1a\u5c1b\u6de3\u6318\u52f9\u5fb4\u4ee6\u6621\u6253\u66e8\u6fe2(FontFamiliesCache.INSTANCE.isSupportedFontFamily(string) ? 1 : 0) != 0) {
                return string;
            }
            i += 21190;
        }
        return "Default";
    }

    @NotNull
    public static /* synthetic */ @NotNull List<@NotNull String> supportedFonts() {
        return Collections.unmodifiableList(Arrays.asList(FontFamiliesCache.INSTANCE.supportedFonts));
    }

    public static int INSOLENCE_\u6cab\u593a\u700c\u6cce\u6da6\u5a53\u5650\u4f58\u6ce9\u6150\u587b\u6747\u6e0c\u532c\u63bd\u57b9\u6fa1\u557a\u4f57\u5531\u5248\u5160\u6038\u5cb3\u707d\u6633\u712a\u62a4\u6a59\u4e47\u5a1a\u5c1b\u6de3\u6318\u52f9\u5fb4\u4ee6\u6621\u6253\u66e8\u6fe2(int n) {
        return n;
    }

    private static final class FontCache
    extends Enum<FontCache> {
        public static final /* synthetic */ /* enum */ FontCache INSTANCE;
        public final /* synthetic */ HashMap<CacheKey, SVGFont> cache;
        public static final /* synthetic */ FontCache[] $VALUES;

        public static /* synthetic */ FontCache[] values() {
            return (FontCache[])$VALUES.clone();
        }

        public static /* synthetic */ FontCache valueOf(String string) {
            return Enum.valueOf(FontCache.class, string);
        }

        public FontCache() {
            this.cache = new HashMap();
        }

        public static /* synthetic */ FontCache[] $values() {
            FontCache[] fontCacheArray = new FontCache[1];
            int n = "\u6c33".length();
            int n2 = "\u5cb4\u5324".length();
            fontCacheArray[0] = INSTANCE;
            return fontCacheArray;
        }

        static {
            INSTANCE = new FontCache();
            $VALUES = FontCache.$values();
        }

        @Immutable
        private static final class CacheKey {
            @NotNull
            public final /* synthetic */ MeasurableFontSpec spec;
            @NotNull
            public final /* synthetic */ MeasureContext context;

            public CacheKey(@NotNull MeasurableFontSpec measurableFontSpec, @NotNull MeasureContext measureContext) {
                this.spec = measurableFontSpec;
                this.context = measureContext;
            }

            public String toString() {
                int n = "\u5f41\u53ff\u5504".length();
                int n2 = "\u522d".length();
                int n3 = "\u6fe6\u5239\u4e49\u6e76".length();
                int n4 = "\u6f29\u6a49\u6d70\u5845\u570f".length();
                return "CacheKey{spec=" + this.spec + ", context=" + this.context + '}';
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof CacheKey)) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)object;
                return CacheKey.INSOLENCE_\u52a8\u6873\u5c2c\u5f0f\u5a5e\u4f83\u5729\u5033\u5892\u4f79\u599d\u5573\u6049\u6689\u6b42\u5e37\u5bbf\u6031\u66ad\u592c\u6a51\u6b67\u6af7\u5040\u6596\u5834\u518b\u6678\u5707\u544c\u58d5\u5041\u5abd\u63d3\u6ee3\u4fa2\u611c\u6f51\u5025\u6b02\u4e58(this.spec.equals(cacheKey.spec) ? 1 : 0) != 0 && CacheKey.INSOLENCE_\u52a8\u6873\u5c2c\u5f0f\u5a5e\u4f83\u5729\u5033\u5892\u4f79\u599d\u5573\u6049\u6689\u6b42\u5e37\u5bbf\u6031\u66ad\u592c\u6a51\u6b67\u6af7\u5040\u6596\u5834\u518b\u6678\u5707\u544c\u58d5\u5041\u5abd\u63d3\u6ee3\u4fa2\u611c\u6f51\u5025\u6b02\u4e58(this.context.equals(cacheKey.context) ? 1 : 0) != 0;
            }

            public int hashCode() {
                Object[] objectArray = new Object[2];
                int n = "\u68c0\u6d87\u5363\u5719\u522b".length();
                int n2 = "\u5a1a\u5963\u57dd\u6aab\u6ece".length();
                int n3 = "\u62c5\u69f5\u69ba\u68d5".length();
                objectArray[0] = this.spec;
                int n4 = "\u5544\u6724".length();
                int n5 = "\u5515".length();
                objectArray[1] = this.context;
                return Objects.hash(objectArray);
            }

            public /* synthetic */ CacheKey(MeasurableFontSpec measurableFontSpec, MeasureContext measureContext, 1 var3_3) {
                this(measurableFontSpec, measureContext);
            }

            public static int INSOLENCE_\u52a8\u6873\u5c2c\u5f0f\u5a5e\u4f83\u5729\u5033\u5892\u4f79\u599d\u5573\u6049\u6689\u6b42\u5e37\u5bbf\u6031\u66ad\u592c\u6a51\u6b67\u6af7\u5040\u6596\u5834\u518b\u6678\u5707\u544c\u58d5\u5041\u5abd\u63d3\u6ee3\u4fa2\u611c\u6f51\u5025\u6b02\u4e58(int n) {
                return n;
            }
        }
    }

    private static final class FontFamiliesCache
    extends Enum<FontFamiliesCache> {
        public static final /* synthetic */ /* enum */ FontFamiliesCache INSTANCE;
        @NotNull
        public final /* synthetic */ String[] supportedFonts;
        public static final /* synthetic */ FontFamiliesCache[] $VALUES;

        public static /* synthetic */ FontFamiliesCache[] values() {
            return (FontFamiliesCache[])$VALUES.clone();
        }

        public static /* synthetic */ FontFamiliesCache valueOf(String string) {
            return Enum.valueOf(FontFamiliesCache.class, string);
        }

        public FontFamiliesCache() {
            this.supportedFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }

        public boolean isSupportedFontFamily(@NotNull String string) {
            String[] stringArray = this.supportedFonts;
            int n = stringArray.length;
            for (int i = 0; i < n; i -= 28347) {
                String string2 = stringArray[i];
                if (FontFamiliesCache.INSOLENCE_\u6069\u67cc\u60a9\u6539\u6cf7\u5250\u64cd\u5f65\u5261\u6f4d\u6686\u7071\u5450\u520e\u4ebb\u57e5\u5922\u67ed\u59eb\u5374\u64ab\u66c7\u589c\u5fb4\u602a\u50f6\u6d2b\u633b\u5155\u5fbd\u6c81\u686f\u5245\u61bd\u5eb4\u6ccb\u55ba\u6db4\u5496\u5b73\u5cf6(string2.equalsIgnoreCase(string) ? 1 : 0) != 0) {
                    return true;
                }
                i += 28348;
            }
            return false;
        }

        public static /* synthetic */ FontFamiliesCache[] $values() {
            FontFamiliesCache[] fontFamiliesCacheArray = new FontFamiliesCache[1];
            int n = "\u6091\u608a\u577f\u61ef".length();
            int n2 = "\u6060\u63cc\u6a9c\u69b5".length();
            fontFamiliesCacheArray[0] = INSTANCE;
            return fontFamiliesCacheArray;
        }

        static {
            INSTANCE = new FontFamiliesCache();
            $VALUES = FontFamiliesCache.$values();
        }

        public static int INSOLENCE_\u6069\u67cc\u60a9\u6539\u6cf7\u5250\u64cd\u5f65\u5261\u6f4d\u6686\u7071\u5450\u520e\u4ebb\u57e5\u5922\u67ed\u59eb\u5374\u64ab\u66c7\u589c\u5fb4\u602a\u50f6\u6d2b\u633b\u5155\u5fbd\u6c81\u686f\u5245\u61bd\u5eb4\u6ccb\u55ba\u6db4\u5496\u5b73\u5cf6(int n) {
            return n;
        }
    }
}

