/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry;

import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.geometry.SVGEllipse;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class AWTSVGShape<T extends Shape>
implements MeasurableShape {
    public static final /* synthetic */ Rectangle2D EMPTY_SHAPE;
    @NotNull
    public final /* synthetic */ T shape;
    public /* synthetic */ Rectangle2D bounds;
    public /* synthetic */ double pathLength;

    public AWTSVGShape(@NotNull T t) {
        this(t, Double.NaN);
    }

    public AWTSVGShape(@NotNull T t, double d) {
        this.shape = t;
        this.pathLength = d;
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext renderContext, boolean bl) {
        return this.shape;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext renderContext, boolean bl) {
        if (this.bounds == null) {
            this.bounds = this.shape.getBounds2D();
        }
        return this.bounds;
    }

    @Override
    public double pathLength(@NotNull MeasureContext measureContext) {
        if (AWTSVGShape.INSOLENCE_\u5f71\u57ba\u6c4e\u6c52\u691e\u5da2\u517f\u6e0c\u610e\u6b99\u6b34\u5a09\u503e\u5e0d\u6216\u6b74\u5587\u6ac7\u5b60\u5a60\u5bcc\u6f2f\u565b\u65e1\u624f\u69ca\u50fe\u6cf6\u5f96\u6fae\u6915\u6ede\u641b\u5008\u60b1\u6116\u637a\u6f7e\u625b\u58c6\u6b44(Double.isNaN(this.pathLength) ? 1 : 0) != 0) {
            this.pathLength = this.computePathLength();
        }
        return this.pathLength;
    }

    public double computePathLength() {
        if (this.shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)this.shape;
            return 2.0 * (rectangle2D.getWidth() + rectangle2D.getHeight());
        }
        if (this.shape instanceof Ellipse2D) {
            double d;
            Ellipse2D ellipse2D = (Ellipse2D)this.shape;
            double d2 = ellipse2D.getWidth();
            if (d2 == (d = ellipse2D.getHeight())) {
                return Math.PI * d2;
            }
            return SVGEllipse.ellipseCircumference(d2 / 2.0, d / 2.0);
        }
        return this.computeGenericPathLength();
    }

    public double computeGenericPathLength() {
        return GeometryUtil.pathLength(this.shape);
    }

    static {
        EMPTY_SHAPE = new Rectangle();
    }

    public static int INSOLENCE_\u5f71\u57ba\u6c4e\u6c52\u691e\u5da2\u517f\u6e0c\u610e\u6b99\u6b34\u5a09\u503e\u5e0d\u6216\u6b74\u5587\u6ac7\u5b60\u5a60\u5bcc\u6f2f\u565b\u65e1\u624f\u69ca\u50fe\u6cf6\u5f96\u6fae\u6915\u6ede\u641b\u5008\u60b1\u6116\u637a\u6f7e\u625b\u58c6\u6b44(int n) {
        return n;
    }
}

