/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.SVGRenderingHints;
import com.github.weisj.jsvg.attributes.Overflow;
import com.github.weisj.jsvg.attributes.PreserveAspectRatio;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.RenderableSVGNode;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.UIFuture;
import com.github.weisj.jsvg.parser.ValueUIFuture;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={Category.Graphic, Category.GraphicsReferencing})
@PermittedContent(categories={Category.Animation, Category.Descriptive})
public final class Image
extends RenderableSVGNode {
    public static final /* synthetic */ Logger LOGGER;
    public static final /* synthetic */ String TAG = "image";
    public /* synthetic */ Length x;
    public /* synthetic */ Length y;
    public /* synthetic */ Length width;
    public /* synthetic */ Length height;
    public /* synthetic */ PreserveAspectRatio preserveAspectRatio;
    public /* synthetic */ Overflow overflow;
    public /* synthetic */ UIFuture<BufferedImage> imgResource;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public boolean isVisible(@NotNull RenderContext renderContext) {
        return this.imgResource != null && Image.INSOLENCE_\u6499\u6716\u6f7c\u5543\u5532\u528a\u6427\u70f8\u6a3d\u6153\u5824\u51d9\u5c61\u666c\u580c\u4fc1\u6e39\u5a01\u6bdd\u6604\u6449\u5f22\u5da1\u5a51\u5948\u57ef\u5124\u50dc\u705b\u5893\u6d25\u55aa\u696c\u67c3\u4e3b\u60e2\u6519\u6121\u6825\u6cd9\u5837(super.isVisible(renderContext) ? 1 : 0) != 0;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.x = attributeNode.getLength("x", 0.0f);
        this.y = attributeNode.getLength("y", 0.0f);
        this.width = attributeNode.getLength("width", Length.UNSPECIFIED);
        this.height = attributeNode.getLength("height", Length.UNSPECIFIED);
        this.preserveAspectRatio = PreserveAspectRatio.parse(attributeNode.getValue("preserveAspectRatio"), attributeNode.parser());
        this.overflow = attributeNode.getEnum("overflow", Overflow.Hidden);
        String string = attributeNode.parser().parseUrl(attributeNode.getHref());
        if (string != null) {
            try {
                int n = "\u595a\u60c4\u5cf9\u53d2".length();
                int n2 = "\u51e7".length();
                this.imgResource = attributeNode.resourceLoader().loadImage(new URI(string));
            }
            catch (IOException | URISyntaxException exception) {
                LOGGER.log(Level.INFO, exception.getMessage(), exception);
                this.imgResource = null;
            }
        }
    }

    @Nullable
    public BufferedImage fetchImage(@NotNull RenderContext renderContext) {
        if (this.imgResource == null) {
            return null;
        }
        if (this.imgResource instanceof ValueUIFuture) {
            return this.imgResource.get();
        }
        if (Image.INSOLENCE_\u6499\u6716\u6f7c\u5543\u5532\u528a\u6427\u70f8\u6a3d\u6153\u5824\u51d9\u5c61\u666c\u580c\u4fc1\u6e39\u5a01\u6bdd\u6604\u6449\u5f22\u5da1\u5a51\u5948\u57ef\u5124\u50dc\u705b\u5893\u6d25\u55aa\u696c\u67c3\u4e3b\u60e2\u6519\u6121\u6825\u6cd9\u5837(this.imgResource.checkIfReady(renderContext.targetComponent()) ? 1 : 0) == 0) {
            return null;
        }
        BufferedImage bufferedImage = this.imgResource.get();
        if (bufferedImage != null) {
            int n = "\u5cc3\u5d94\u6c74".length();
            int n2 = "\u6307\u69de\u6b73".length();
            int n3 = "\u680f\u4f07\u5b1a\u51ac".length();
            this.imgResource = new ValueUIFuture<BufferedImage>(bufferedImage);
        }
        return bufferedImage;
    }

    @Override
    public void render(@NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.fetchImage(renderContext);
        if (bufferedImage == null) {
            return;
        }
        MeasureContext measureContext = renderContext.measureContext();
        int n = bufferedImage.getWidth(renderContext.targetComponent());
        int n2 = bufferedImage.getHeight(renderContext.targetComponent());
        if (n == 0 || n2 == 0) {
            return;
        }
        float f = this.width.orElseIfUnspecified(n).resolveWidth(measureContext);
        float f2 = this.height.orElseIfUnspecified(n2).resolveHeight(measureContext);
        int n3 = "\u599f\u5752".length();
        int n4 = "\u5136\u6ee9\u6002".length();
        int n5 = "\u5729\u6960\u4e84".length();
        ViewBox viewBox = new ViewBox(n, n2);
        graphics2D.translate(this.x.resolveWidth(measureContext), this.y.resolveHeight(measureContext));
        if (Image.INSOLENCE_\u6499\u6716\u6f7c\u5543\u5532\u528a\u6427\u70f8\u6a3d\u6153\u5824\u51d9\u5c61\u666c\u580c\u4fc1\u6e39\u5a01\u6bdd\u6604\u6449\u5f22\u5da1\u5a51\u5948\u57ef\u5124\u50dc\u705b\u5893\u6d25\u55aa\u696c\u67c3\u4e3b\u60e2\u6519\u6121\u6825\u6cd9\u5837(this.overflow.establishesClip() ? 1 : 0) != 0) {
            int n6 = "\u5269\u6b38\u547e".length();
            int n7 = "\u5af0\u5ae6".length();
            graphics2D.clip(new ViewBox(f, f2));
        }
        int n8 = "\u5486\u62d7\u5471\u6271\u4f87".length();
        int n9 = "\u5c04\u5b21\u60f8\u66d7\u55ed".length();
        int n10 = "\u61df".length();
        int n11 = "\u610f\u4fe6\u6ac8".length();
        AffineTransform affineTransform = this.preserveAspectRatio.computeViewPortTransform(new FloatSize(f, f2), viewBox);
        Object object = graphics2D.getRenderingHint(SVGRenderingHints.KEY_IMAGE_ANTIALIASING);
        if (object == SVGRenderingHints.VALUE_IMAGE_ANTIALIASING_OFF) {
            Image.INSOLENCE_\u6499\u6716\u6f7c\u5543\u5532\u528a\u6427\u70f8\u6a3d\u6153\u5824\u51d9\u5c61\u666c\u580c\u4fc1\u6e39\u5a01\u6bdd\u6604\u6449\u5f22\u5da1\u5a51\u5948\u57ef\u5124\u50dc\u705b\u5893\u6d25\u55aa\u696c\u67c3\u4e3b\u60e2\u6519\u6121\u6825\u6cd9\u5837(graphics2D.drawImage(bufferedImage, affineTransform, renderContext.targetComponent()) ? 1 : 0);
            int n12 = "\u70d6\u5948\u530f\u5320\u6820".length();
            int n13 = "\u6186\u5a7f\u6522\u510f\u5e81".length();
        } else {
            graphics2D.transform(affineTransform);
            int n14 = "\u552a\u6894".length();
            int n15 = "\u5f9c\u5e1b".length();
            Rectangle rectangle = new Rectangle(0, 0, n, n2);
            int n16 = "\u5d49\u5d00".length();
            int n17 = "\u6c3c".length();
            int n18 = "\u526c\u66f3\u5b53".length();
            int n19 = "\u50f3".length();
            GraphicsUtil.safelySetPaint(graphics2D, new TexturePaint(bufferedImage, rectangle));
            graphics2D.fill(rectangle);
        }
    }

    static {
        LOGGER = Logger.getLogger(Image.class.getName());
    }

    public static int INSOLENCE_\u6499\u6716\u6f7c\u5543\u5532\u528a\u6427\u70f8\u6a3d\u6153\u5824\u51d9\u5c61\u666c\u580c\u4fc1\u6e39\u5a01\u6bdd\u6604\u6449\u5f22\u5da1\u5a51\u5948\u57ef\u5124\u50dc\u705b\u5893\u6d25\u55aa\u696c\u67c3\u4e3b\u60e2\u6519\u6121\u6825\u6cd9\u5837(int n) {
        return n;
    }
}

