/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.Anchor;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Image;
import com.github.weisj.jsvg.nodes.Marker;
import com.github.weisj.jsvg.nodes.Pattern;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.Style;
import com.github.weisj.jsvg.nodes.View;
import com.github.weisj.jsvg.nodes.container.CommonRenderableContainerNode;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.prototype.Instantiator;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.nodes.text.Text;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.MaskedPaint;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.BlittableImage;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.Container})
@PermittedContent(categories={Category.Animation, Category.Descriptive, Category.Shape, Category.Structural, Category.Gradient}, anyOf={Anchor.class, ClipPath.class, Filter.class, Image.class, Marker.class, Mask.class, Pattern.class, Style.class, Text.class, View.class})
public final class Mask
extends CommonRenderableContainerNode
implements Instantiator {
    public static final /* synthetic */ boolean DEBUG = false;
    public static final /* synthetic */ String TAG = "mask";
    public /* synthetic */ Length x;
    public /* synthetic */ Length y;
    public /* synthetic */ Length width;
    public /* synthetic */ Length height;
    public /* synthetic */ UnitType maskContentUnits;
    public /* synthetic */ UnitType maskUnits;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.x = attributeNode.getLength("x", Unit.PERCENTAGE.valueOf(-10.0f));
        this.y = attributeNode.getLength("y", Unit.PERCENTAGE.valueOf(-10.0f));
        this.width = attributeNode.getLength("width", Unit.PERCENTAGE.valueOf(120.0f));
        this.height = attributeNode.getLength("height", Unit.PERCENTAGE.valueOf(120.0f));
        this.maskContentUnits = attributeNode.getEnum("maskContentUnits", UnitType.UserSpaceOnUse);
        this.maskUnits = attributeNode.getEnum("maskUnits", UnitType.ObjectBoundingBox);
    }

    @NotNull
    public Paint createMaskPaint(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext, @NotNull Rectangle2D rectangle2D) {
        Rectangle2D.Double double_ = this.maskUnits.computeViewBounds(renderContext.measureContext(), rectangle2D, this.x, this.y, this.width, this.height);
        BlittableImage blittableImage = BlittableImage.create(ImageUtil::createLuminosityBuffer, renderContext, graphics2D.getClipBounds(), double_.createIntersection(rectangle2D), rectangle2D, this.maskContentUnits);
        Rectangle2D rectangle2D2 = blittableImage.boundsInUserSpace();
        if (Mask.INSOLENCE_\u5838\u6d56\u5c5f\u5a52\u53cc\u5be1\u5de0\u5ab7\u6116\u68aa\u55f2\u5afa\u5375\u6e5b\u650b\u5750\u6d44\u52ef\u6bc8\u5ba0\u4f9a\u6ff5\u5781\u67ef\u58b9\u57a4\u521a\u6e59\u52a4\u523d\u68c1\u5d83\u5999\u561e\u6153\u6923\u5417\u61f1\u7078\u66ed\u5c87(this.isInvalidMaskingArea(rectangle2D2) ? 1 : 0) != 0) {
            return PaintParser.DEFAULT_COLOR;
        }
        blittableImage.renderNode(graphics2D, this, this);
        int n = "\u6993\u50f1".length();
        int n2 = "\u67a0\u5fa1\u67f0\u68d8".length();
        int n3 = "\u66c4\u5bb1\u5bb2\u6662\u706a".length();
        int n4 = "\u6e6c\u6b52\u6150".length();
        Point2D.Double double_2 = new Point2D.Double(rectangle2D2.getX(), rectangle2D2.getY());
        renderContext.rootTransform().transform(double_2, double_2);
        int n5 = "\u682a\u5e0c\u4e30\u56a5".length();
        int n6 = "\u55ac\u51da\u528b".length();
        int n7 = "\u5057\u535c\u5c6c\u5aea".length();
        int n8 = "\u6b3a\u64fb\u5743".length();
        int n9 = "\u50af\u5e0f\u5812\u6e1b\u5a94".length();
        return new MaskedPaint(PaintParser.DEFAULT_COLOR, blittableImage.image().getRaster(), double_2);
    }

    public boolean isInvalidMaskingArea(@NotNull Rectangle2D rectangle2D) {
        return Mask.INSOLENCE_\u5838\u6d56\u5c5f\u5a52\u53cc\u5be1\u5de0\u5ab7\u6116\u68aa\u55f2\u5afa\u5375\u6e5b\u650b\u5750\u6d44\u52ef\u6bc8\u5ba0\u4f9a\u6ff5\u5781\u67ef\u58b9\u57a4\u521a\u6e59\u52a4\u523d\u68c1\u5d83\u5999\u561e\u6153\u6923\u5417\u61f1\u7078\u66ed\u5c87(rectangle2D.isEmpty() ? 1 : 0) != 0 || Mask.INSOLENCE_\u5838\u6d56\u5c5f\u5a52\u53cc\u5be1\u5de0\u5ab7\u6116\u68aa\u55f2\u5afa\u5375\u6e5b\u650b\u5750\u6d44\u52ef\u6bc8\u5ba0\u4f9a\u6ff5\u5781\u67ef\u58b9\u57a4\u521a\u6e59\u52a4\u523d\u68c1\u5d83\u5999\u561e\u6153\u6923\u5417\u61f1\u7078\u66ed\u5c87(Double.isNaN(rectangle2D.getWidth()) ? 1 : 0) != 0 || Mask.INSOLENCE_\u5838\u6d56\u5c5f\u5a52\u53cc\u5be1\u5de0\u5ab7\u6116\u68aa\u55f2\u5afa\u5375\u6e5b\u650b\u5750\u6d44\u52ef\u6bc8\u5ba0\u4f9a\u6ff5\u5781\u67ef\u58b9\u57a4\u521a\u6e59\u52a4\u523d\u68c1\u5d83\u5999\u561e\u6153\u6923\u5417\u61f1\u7078\u66ed\u5c87(Double.isNaN(rectangle2D.getHeight()) ? 1 : 0) != 0;
    }

    @Override
    public boolean requiresInstantiation() {
        return true;
    }

    @Override
    public boolean canInstantiate(@NotNull SVGNode sVGNode) {
        return sVGNode == this;
    }

    public static int INSOLENCE_\u5838\u6d56\u5c5f\u5a52\u53cc\u5be1\u5de0\u5ab7\u6116\u68aa\u55f2\u5afa\u5375\u6e5b\u650b\u5750\u6d44\u52ef\u6bc8\u5ba0\u4f9a\u6ff5\u5781\u67ef\u58b9\u57a4\u521a\u6e59\u52a4\u523d\u68c1\u5d83\u5999\u561e\u6153\u6923\u5417\u61f1\u7078\u66ed\u5c87(int n) {
        return n;
    }
}

