/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.attributes.Overflow;
import com.github.weisj.jsvg.attributes.PreserveAspectRatio;
import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.Anchor;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Image;
import com.github.weisj.jsvg.nodes.Marker;
import com.github.weisj.jsvg.nodes.Mask;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.Style;
import com.github.weisj.jsvg.nodes.View;
import com.github.weisj.jsvg.nodes.container.BaseInnerViewContainer;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.prototype.ShapedContainer;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.nodes.text.Text;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.TransformedPaint;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={Category.Container})
@PermittedContent(categories={Category.Animation, Category.Descriptive, Category.Shape, Category.Structural, Category.Gradient}, anyOf={Anchor.class, ClipPath.class, Filter.class, Image.class, Mask.class, Marker.class, Pattern.class, Style.class, Text.class, View.class})
public final class Pattern
extends BaseInnerViewContainer
implements SVGPaint,
ShapedContainer<SVGNode> {
    public static final /* synthetic */ String TAG = "pattern";
    public /* synthetic */ Length x;
    public /* synthetic */ Length y;
    public /* synthetic */ Length width;
    public /* synthetic */ Length height;
    public /* synthetic */ UnitType patternUnits;
    public /* synthetic */ UnitType patternContentUnits;
    public /* synthetic */ AffineTransform patternTransform;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    @NotNull
    public Point2D outerLocation(@NotNull MeasureContext measureContext) {
        int n = "\u6378".length();
        int n2 = "\u6e19".length();
        int n3 = "\u6a86".length();
        return new Point2D.Float(0.0f, 0.0f);
    }

    @Override
    @Nullable
    public Point2D anchorLocation(@NotNull MeasureContext measureContext) {
        return null;
    }

    @Override
    @NotNull
    public Overflow defaultOverflow() {
        return Overflow.Hidden;
    }

    @Override
    @NotNull
    public FloatSize size(@NotNull RenderContext renderContext) {
        int n = "\u5d8d\u5a2d\u59bd".length();
        int n2 = "\u5a1a\u5dc0\u580d".length();
        int n3 = "\u56ad\u67db".length();
        int n4 = "\u4fe5\u4ea6\u4f1f\u6eaa\u5ba4".length();
        return new FloatSize(this.width.resolveWidth(renderContext.measureContext()), this.height.resolveHeight(renderContext.measureContext()));
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        Pattern pattern = this.parseTemplate(attributeNode);
        if (this.viewBox == null && pattern != null) {
            this.viewBox = pattern.viewBox;
        }
        this.preserveAspectRatio = pattern != null ? pattern.preserveAspectRatio : this.preserveAspectRatio;
        this.x = attributeNode.getLength("x", pattern != null ? pattern.x : Length.ZERO);
        this.y = attributeNode.getLength("y", pattern != null ? pattern.y : Length.ZERO);
        this.width = attributeNode.getLength("width", pattern != null ? pattern.width : Length.ZERO).coerceNonNegative();
        this.height = attributeNode.getLength("height", pattern != null ? pattern.height : Length.ZERO).coerceNonNegative();
        this.patternTransform = attributeNode.parseTransform("patternTransform");
        if (this.patternTransform == null && pattern != null) {
            this.patternTransform = pattern.patternTransform;
        }
        this.patternUnits = attributeNode.getEnum("patternUnits", pattern != null ? pattern.patternUnits : UnitType.ObjectBoundingBox);
        this.patternContentUnits = attributeNode.getEnum("patternContentUnits", pattern != null ? pattern.patternContentUnits : UnitType.UserSpaceOnUse);
    }

    @Nullable
    public Pattern parseTemplate(@NotNull AttributeNode attributeNode) {
        Pattern pattern = attributeNode.getElementByHref(Pattern.class, attributeNode.getHref());
        return pattern != this ? pattern : null;
    }

    @Override
    public boolean isVisible() {
        return Pattern.INSOLENCE_\u6198\u6d68\u4f23\u6c47\u59cb\u5493\u6b5c\u56ce\u6125\u54e2\u6548\u519c\u5e40\u5cd1\u557d\u6dda\u587f\u6257\u641a\u5d42\u6496\u5f6b\u5beb\u510b\u5213\u6ee2\u6ff9\u501f\u51d3\u58ae\u51ec\u57e9\u6739\u6215\u67d5\u5969\u5d5c\u58a5\u56f1\u5095\u6023(this.width.isZero() ? 1 : 0) == 0 && Pattern.INSOLENCE_\u6198\u6d68\u4f23\u6c47\u59cb\u5493\u6b5c\u56ce\u6125\u54e2\u6548\u519c\u5e40\u5cd1\u557d\u6dda\u587f\u6257\u641a\u5d42\u6496\u5f6b\u5beb\u510b\u5213\u6ee2\u6ff9\u501f\u51d3\u58ae\u51ec\u57e9\u6739\u6215\u67d5\u5969\u5d5c\u58a5\u56f1\u5095\u6023(this.height.isZero() ? 1 : 0) == 0 && Pattern.INSOLENCE_\u6198\u6d68\u4f23\u6c47\u59cb\u5493\u6b5c\u56ce\u6125\u54e2\u6548\u519c\u5e40\u5cd1\u557d\u6dda\u587f\u6257\u641a\u5d42\u6496\u5f6b\u5beb\u510b\u5213\u6ee2\u6ff9\u501f\u51d3\u58ae\u51ec\u57e9\u6739\u6215\u67d5\u5969\u5d5c\u58a5\u56f1\u5095\u6023(SVGPaint.super.isVisible() ? 1 : 0) != 0;
    }

    @Override
    public boolean requiresInstantiation() {
        return true;
    }

    @Override
    public void fillShape(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext, @NotNull Shape shape, @Nullable Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = rectangle2D != null ? rectangle2D : shape.getBounds2D();
        GraphicsUtil.safelySetPaint(graphics2D, this.paintForBounds(graphics2D, renderContext, rectangle2D2));
        graphics2D.fill(shape);
    }

    @Override
    public void drawShape(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext, @NotNull Shape shape, @Nullable Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = rectangle2D != null ? rectangle2D : shape.getBounds2D();
        GraphicsUtil.safelySetPaint(graphics2D, this.paintForBounds(graphics2D, renderContext, rectangle2D2));
        graphics2D.setPaint(this.paintForBounds(graphics2D, renderContext, rectangle2D2));
        graphics2D.draw(shape);
    }

    @NotNull
    public Paint paintForBounds(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext, @NotNull Rectangle2D rectangle2D) {
        Paint paint;
        FloatSize floatSize;
        MeasureContext measureContext = renderContext.measureContext();
        Rectangle2D.Double double_ = this.patternUnits.computeViewBounds(measureContext, rectangle2D, this.x, this.y, this.width, this.height);
        BufferedImage bufferedImage = ImageUtil.createCompatibleTransparentImage(graphics2D, double_.width, double_.height);
        Graphics2D graphics2D2 = GraphicsUtil.createGraphics(bufferedImage);
        graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
        graphics2D2.scale((double)bufferedImage.getWidth() / double_.width, (double)bufferedImage.getHeight() / double_.height);
        RenderContext renderContext2 = RenderContext.createInitial(null, this.patternContentUnits.deriveMeasure(measureContext));
        renderContext2.setRootTransform(graphics2D2.getTransform());
        ViewBox viewBox = this.viewBox;
        PreserveAspectRatio preserveAspectRatio = this.preserveAspectRatio;
        if (viewBox == null && this.patternContentUnits == UnitType.ObjectBoundingBox) {
            int n = "\u5260".length();
            int n2 = "\u5ea1".length();
            floatSize = new FloatSize(bufferedImage.getWidth(), bufferedImage.getHeight());
            int n3 = "\u55c7".length();
            viewBox = new ViewBox(0.0f, 0.0f, 1.0f, 1.0f);
            preserveAspectRatio = PreserveAspectRatio.none();
        } else {
            int n = "\u56b5\u59b3\u6411\u6b70\u6fdc".length();
            int n4 = "\u575c".length();
            floatSize = new FloatSize((float)double_.getWidth(), (float)double_.getHeight());
        }
        this.renderWithSize(floatSize, viewBox, preserveAspectRatio, renderContext2, graphics2D2);
        graphics2D2.dispose();
        if (this.patternTransform != null) {
            TransformedPaint transformedPaint;
            int n = "\u6298\u6a28\u5974".length();
            int n5 = "\u4f5b\u70bf\u6eaf\u5e09".length();
            int n6 = "\u5dc1".length();
            paint = transformedPaint;
            int n7 = "\u5872\u6f26\u4e4d\u6308\u6804".length();
            int n8 = "\u6e7a".length();
            int n9 = "\u5c15\u56bd\u6191\u6d9f".length();
            transformedPaint = new TransformedPaint(new TexturePaint(bufferedImage, double_), this.patternTransform);
        } else {
            TexturePaint texturePaint;
            int n = "\u5d4a\u5c72\u712a\u6520\u6b6f".length();
            int n10 = "\u5e16".length();
            paint = texturePaint;
            texturePaint = new TexturePaint(bufferedImage, double_);
        }
        return paint;
    }

    public static int INSOLENCE_\u6198\u6d68\u4f23\u6c47\u59cb\u5493\u6b5c\u56ce\u6125\u54e2\u6548\u519c\u5e40\u5cd1\u557d\u6dda\u587f\u6257\u641a\u5d42\u6496\u5f6b\u5beb\u510b\u5213\u6ee2\u6ff9\u501f\u51d3\u58ae\u51ec\u57e9\u6739\u6215\u67d5\u5969\u5d5c\u58a5\u56f1\u5095\u6023(int n) {
        return n;
    }
}

