/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.attributes.PaintOrder;
import com.github.weisj.jsvg.attributes.VectorEffect;
import com.github.weisj.jsvg.attributes.font.FontParser;
import com.github.weisj.jsvg.attributes.font.FontSize;
import com.github.weisj.jsvg.attributes.font.MeasurableFontSpec;
import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.Marker;
import com.github.weisj.jsvg.nodes.RenderableSVGNode;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.prototype.HasFontContext;
import com.github.weisj.jsvg.nodes.prototype.HasPaintContext;
import com.github.weisj.jsvg.nodes.prototype.HasShape;
import com.github.weisj.jsvg.nodes.prototype.HasVectorEffects;
import com.github.weisj.jsvg.nodes.prototype.Instantiator;
import com.github.weisj.jsvg.nodes.prototype.Mutator;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.PaintContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.ShapeRenderer;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ShapeNode
extends RenderableSVGNode
implements HasShape,
HasPaintContext,
HasFontContext,
HasVectorEffects,
Instantiator {
    public /* synthetic */ PaintOrder paintOrder;
    public /* synthetic */ PaintContext paintContext;
    public /* synthetic */ FontSize fontSize;
    public /* synthetic */ Length fontSizeAdjust;
    public /* synthetic */ Length pathLength;
    public /* synthetic */ MeasurableShape shape;
    public /* synthetic */ Marker markerStart;
    public /* synthetic */ Marker markerMid;
    public /* synthetic */ Marker markerEnd;
    public /* synthetic */ Set<VectorEffect> vectorEffects;

    @NotNull
    public PaintContext paintContext() {
        return this.paintContext;
    }

    @Override
    @NotNull
    public Mutator<MeasurableFontSpec> fontSpec() {
        return measurableFontSpec -> measurableFontSpec.withFontSize(this.fontSize, this.fontSizeAdjust);
    }

    @NotNull
    public MeasurableShape shape() {
        return this.shape;
    }

    @Override
    @NotNull
    public Set<VectorEffect> vectorEffects() {
        return this.vectorEffects;
    }

    @Override
    public final void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.paintOrder = PaintOrder.parse(attributeNode);
        this.paintContext = PaintContext.parse(attributeNode);
        this.fontSize = FontParser.parseFontSize(attributeNode);
        this.fontSizeAdjust = FontParser.parseSizeAdjust(attributeNode);
        this.shape = this.buildShape(attributeNode);
        this.pathLength = attributeNode.getLength("pathLength", Length.UNSPECIFIED);
        Marker marker = attributeNode.getElementByHref(Marker.class, attributeNode.getValue("marker"));
        this.markerStart = attributeNode.getElementByHref(Marker.class, attributeNode.getValue("marker-start"));
        if (this.markerStart == null) {
            this.markerStart = marker;
        }
        this.markerMid = attributeNode.getElementByHref(Marker.class, attributeNode.getValue("marker-mid"));
        if (this.markerMid == null) {
            this.markerMid = marker;
        }
        this.markerEnd = attributeNode.getElementByHref(Marker.class, attributeNode.getValue("marker-end"));
        if (this.markerEnd == null) {
            this.markerEnd = marker;
        }
        this.vectorEffects = VectorEffect.parse(attributeNode);
    }

    @NotNull
    public abstract MeasurableShape buildShape(@NotNull AttributeNode var1);

    @Override
    @NotNull
    public Shape untransformedElementShape(@NotNull RenderContext renderContext) {
        return this.shape.shape(renderContext);
    }

    @Override
    @NotNull
    public Rectangle2D untransformedElementBounds(@NotNull RenderContext renderContext) {
        return this.shape.bounds(renderContext, true);
    }

    @Override
    public boolean isVisible(@NotNull RenderContext renderContext) {
        return ShapeNode.INSOLENCE_\u6f71\u657f\u5d91\u50db\u67bc\u5bd9\u6169\u5570\u5f10\u5d54\u600c\u5f0e\u5d52\u63c4\u5372\u5f5d\u51ec\u66e9\u6914\u6aca\u60fc\u5b5e\u51bb\u5f27\u6b6b\u601b\u6dd0\u6101\u4e59\u5285\u5ad4\u5eb0\u60af\u55dc\u5bc8\u5406\u6196\u5e36\u57c8\u5528\u6ea7(super.isVisible(renderContext) ? 1 : 0) != 0;
    }

    @Override
    public boolean canInstantiate(@NotNull SVGNode sVGNode) {
        return sVGNode instanceof Marker;
    }

    @Override
    public final void render(@NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D) {
        MeasureContext measureContext = renderContext.measureContext();
        Shape shape = this.shape.shape(renderContext);
        Rectangle2D rectangle2D = ShapeNode.INSOLENCE_\u6f71\u657f\u5d91\u50db\u67bc\u5bd9\u6169\u5570\u5f10\u5d54\u600c\u5f0e\u5d52\u63c4\u5372\u5f5d\u51ec\u66e9\u6914\u6aca\u60fc\u5b5e\u51bb\u5f27\u6b6b\u601b\u6dd0\u6101\u4e59\u5285\u5ad4\u5eb0\u60af\u55dc\u5bc8\u5406\u6196\u5e36\u57c8\u5528\u6ea7(this.shape.usesOptimizedBoundsCalculation() ? 1 : 0) != 0 ? this.shape.bounds(renderContext, false) : null;
        float f = 1.0f;
        if (ShapeNode.INSOLENCE_\u6f71\u657f\u5d91\u50db\u67bc\u5bd9\u6169\u5570\u5f10\u5d54\u600c\u5f0e\u5d52\u63c4\u5372\u5f5d\u51ec\u66e9\u6914\u6aca\u60fc\u5b5e\u51bb\u5f27\u6b6b\u601b\u6dd0\u6101\u4e59\u5285\u5ad4\u5eb0\u60af\u55dc\u5bc8\u5406\u6196\u5e36\u57c8\u5528\u6ea7(this.pathLength.isSpecified() ? 1 : 0) != 0) {
            double d = this.pathLength.resolveLength(measureContext);
            double d2 = this.shape.pathLength(measureContext);
            f = (float)(d2 / d);
        }
        Stroke stroke = renderContext.stroke(f);
        int n = "\u6cd3\u6c2a\u5066\u6bf6\u62b1".length();
        int n2 = "\u5fcc\u4f47\u59c3\u65f3".length();
        int n3 = "\u6dc1".length();
        int n4 = "\u6f74\u6fba\u69d3\u566a".length();
        int n5 = "\u527a".length();
        int n6 = "\u68f2\u5b28\u669c\u6b9c\u706e".length();
        int n7 = "\u588c\u5aa0".length();
        int n8 = "\u60d4\u6b73".length();
        ShapeRenderer.renderWithPaintOrder(graphics2D, ShapeNode.INSOLENCE_\u6f71\u657f\u5d91\u50db\u67bc\u5bd9\u6169\u5570\u5f10\u5d54\u600c\u5f0e\u5d52\u63c4\u5372\u5f5d\u51ec\u66e9\u6914\u6aca\u60fc\u5b5e\u51bb\u5f27\u6b6b\u601b\u6dd0\u6101\u4e59\u5285\u5ad4\u5eb0\u60af\u55dc\u5bc8\u5406\u6196\u5e36\u57c8\u5528\u6ea7(this.shape.canBeFilled() ? 1 : 0) != 0, this.paintOrder, new ShapeRenderer.ShapePaintContext(renderContext, this.vectorEffects(), stroke, this.transform()), new ShapeRenderer.PaintShape(shape, rectangle2D), new ShapeRenderer.ShapeMarkerInfo(this, this.markerStart, this.markerMid, this.markerEnd, ShapeNode.INSOLENCE_\u6f71\u657f\u5d91\u50db\u67bc\u5bd9\u6169\u5570\u5f10\u5d54\u600c\u5f0e\u5d52\u63c4\u5372\u5f5d\u51ec\u66e9\u6914\u6aca\u60fc\u5b5e\u51bb\u5f27\u6b6b\u601b\u6dd0\u6101\u4e59\u5285\u5ad4\u5eb0\u60af\u55dc\u5bc8\u5406\u6196\u5e36\u57c8\u5528\u6ea7(this.shouldPaintStartEndMarkersInMiddle() ? 1 : 0) != 0));
    }

    public boolean shouldPaintStartEndMarkersInMiddle() {
        return true;
    }

    public static int INSOLENCE_\u6f71\u657f\u5d91\u50db\u67bc\u5bd9\u6169\u5570\u5f10\u5d54\u600c\u5f0e\u5d52\u63c4\u5372\u5f5d\u51ec\u66e9\u6914\u6aca\u60fc\u5b5e\u51bb\u5f27\u6b6b\u601b\u6dd0\u6101\u4e59\u5285\u5ad4\u5eb0\u60af\u55dc\u5bc8\u5406\u6196\u5e36\u57c8\u5528\u6ea7(int n) {
        return n;
    }
}

