/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.ColorChannel;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.filter.AbstractFilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.PixelProvider;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={Animate.class, Set.class})
public final class FeDisplacementMap
extends AbstractFilterPrimitive {
    public static final /* synthetic */ String TAG = "fedisplacementmap";
    public /* synthetic */ ColorChannel xChannelSelector;
    public /* synthetic */ ColorChannel yChannelSelector;
    public /* synthetic */ float scale;
    public /* synthetic */ FilterChannelKey inputChannel2;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.xChannelSelector = attributeNode.getEnum("xChannelSelector", ColorChannel.A);
        this.yChannelSelector = attributeNode.getEnum("yChannelSelector", ColorChannel.A);
        this.scale = attributeNode.getFloat("scale", 0.0f);
        this.inputChannel2 = attributeNode.getFilterChannelKey("in2", DefaultFilterChannel.LastResult);
    }

    @Override
    public void layoutFilter(@NotNull RenderContext renderContext, @NotNull FilterLayoutContext filterLayoutContext) {
        this.impl().saveLayoutResult(this.impl().layoutInput(filterLayoutContext), filterLayoutContext);
    }

    @Override
    public void applyFilter(@NotNull RenderContext renderContext, @NotNull FilterContext filterContext) {
        if (this.scale == 0.0f) {
            this.impl().noop(filterContext);
            return;
        }
        Channel channel = this.impl().inputChannel(filterContext);
        Channel channel2 = filterContext.getChannel(this.inputChannel2);
        int n = "\u5467\u62ae\u6bda".length();
        int n2 = "\u5760\u686e".length();
        int n3 = "\u51a4".length();
        int n4 = "\u5736\u5ca7\u6491\u545d\u60fa".length();
        int n5 = "\u533a".length();
        int n6 = "\u6e25\u588d\u6422\u688a".length();
        int n7 = "\u6806\u55ec\u5057".length();
        int n8 = "\u6ffa\u51dc".length();
        BufferedImageFilter bufferedImageFilter = new BufferedImageFilter(new DisplacementOp(channel2.pixels(renderContext), filterContext.info().tile()));
        this.impl().saveResult(channel.applyFilter(bufferedImageFilter), filterContext);
    }

    private final class DisplacementOp
    implements BufferedImageOp {
        @NotNull
        public final /* synthetic */ PixelProvider displacementChannel;
        public final /* synthetic */ Rectangle2D sourceBounds;

        public DisplacementOp(PixelProvider pixelProvider, Rectangle2D rectangle2D) {
            this.displacementChannel = pixelProvider;
            this.sourceBounds = rectangle2D;
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
            if (colorModel == null) {
                colorModel = bufferedImage.getColorModel();
            }
            int n = "\u5bd2\u6dd4\u5399\u5be9".length();
            int n2 = "\u5b33\u70f1\u6d9e\u6330\u5e8d".length();
            return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), DisplacementOp.INSOLENCE_\u6437\u4ed4\u4f8b\u4f51\u4ec5\u6d50\u6fed\u631c\u6b0b\u69eb\u6e40\u6294\u5dce\u5b5c\u6439\u59ac\u58bd\u629e\u5efc\u56a6\u67c8\u521c\u6f5a\u63dc\u6e93\u5d37\u6a77\u549a\u5d89\u5bfe\u54fb\u6f36\u64c0\u57be\u6e8b\u50eb\u5a13\u5f67\u6e08\u54c8\u66f4(colorModel.isAlphaPremultiplied() ? 1 : 0) != 0, null);
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
            int n = "\u55a2\u6af4\u680c\u5052\u6ba3".length();
            int n2 = "\u66e4\u52f8\u6fcb\u672d".length();
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        @Override
        public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
            return (Point2D)point2D.clone();
        }

        @Override
        public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            Object object;
            if (bufferedImage == null) {
                int n = "\u630a".length();
                int n2 = "\u5d9f\u614e\u5e71".length();
                int n3 = "\u5790".length();
                int n4 = "\u6c27\u674e".length();
                throw new NullPointerException("src image is null");
            }
            if (bufferedImage == bufferedImage2) {
                int n = "\u705c\u57a8\u50a0".length();
                int n5 = "\u6d2b\u6618\u5751\u630e".length();
                int n6 = "\u566c\u5df4\u506f".length();
                int n7 = "\u50bb\u6d28".length();
                throw new IllegalArgumentException("src image cannot be the same as the dst image");
            }
            BufferedImage bufferedImage3 = bufferedImage2;
            if (bufferedImage3 == null) {
                object = ColorSpace.getInstance(1000);
                int n = "\u67cd\u6d50\u64ed\u5eb8".length();
                int n8 = "\u585f\u5b33".length();
                int n9 = "\u5b4b".length();
                DirectColorModel directColorModel = new DirectColorModel((ColorSpace)object, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                bufferedImage3 = this.createCompatibleDestImage(bufferedImage, directColorModel);
            }
            object = bufferedImage3.getRaster();
            int n = ((Raster)object).getWidth();
            int n10 = ((Raster)object).getHeight();
            double d = this.sourceBounds.getWidth() / (double)n;
            double d2 = this.sourceBounds.getHeight() / (double)n10;
            double d3 = this.sourceBounds.getX();
            double d4 = this.sourceBounds.getY();
            WritableRaster writableRaster = bufferedImage.getRaster();
            Rectangle rectangle = writableRaster.getBounds();
            int[] nArray = ImageUtil.getINT_RGBA_DataBank((Raster)object);
            int n11 = ImageUtil.getINT_RGBA_DataAdjust((Raster)object);
            int n12 = ImageUtil.getINT_RGBA_DataOffset((Raster)object);
            double d5 = d4;
            int n13 = 0;
            for (int i = 0; i < n10; i += 6633) {
                int n14 = 0;
                double d6 = d3;
                int n15 = DisplacementOp.INSOLENCE_\u509f\u6b7c\u7092\u5186\u57e1\u6954\u57b0\u631c\u6170\u4fc4\u6f0e\u5cc1\u4f5b\u5cc5\u67a0\u52d4\u604b\u610a\u5d73\u59fb\u68e3\u5a51\u696f\u5678\u58f6\u67b5\u6e92\u6a53\u7097\u4ee9\u4e49\u6663\u69b7\u63ac\u70ea\u5acc\u70c6\u6033\u5d4a\u68c0\u68e6(n12, n);
                while (n12 < n15) {
                    int n16;
                    int n17 = this.displacementChannel.pixelAt(d6, d5);
                    int n18 = "\u5f70\u6a62\u6295\u50af\u681e".length();
                    int n19 = "\u55ed\u66ef".length();
                    int n20 = "\u6920".length();
                    double d7 = (double)FeDisplacementMap.this.xChannelSelector.value(n17) / 255.0 - 0.5;
                    int n21 = "\u6589".length();
                    int n22 = "\u639b".length();
                    double d8 = (double)FeDisplacementMap.this.yChannelSelector.value(n17) / 255.0 - 0.5;
                    int n23 = (int)((double)n14 + (double)FeDisplacementMap.this.scale * d7 / d);
                    nArray[n12] = DisplacementOp.INSOLENCE_\u6437\u4ed4\u4f8b\u4f51\u4ec5\u6d50\u6fed\u631c\u6b0b\u69eb\u6e40\u6294\u5dce\u5b5c\u6439\u59ac\u58bd\u629e\u5efc\u56a6\u67c8\u521c\u6f5a\u63dc\u6e93\u5d37\u6a77\u549a\u5d89\u5bfe\u54fb\u6f36\u64c0\u57be\u6e8b\u50eb\u5a13\u5f67\u6e08\u54c8\u66f4(rectangle.contains(n23, n16 = (int)((double)n13 + (double)FeDisplacementMap.this.scale * d8 / d2)) ? 1 : 0) != 0 ? bufferedImage.getRGB(n23, n16) : 0;
                    d6 += d;
                    n14 += 28951;
                    n14 -= 28950;
                    n12 += 3828;
                    n12 -= 3827;
                }
                d5 += d2;
                n12 = DisplacementOp.INSOLENCE_\u509f\u6b7c\u7092\u5186\u57e1\u6954\u57b0\u631c\u6170\u4fc4\u6f0e\u5cc1\u4f5b\u5cc5\u67a0\u52d4\u604b\u610a\u5d73\u59fb\u68e3\u5a51\u696f\u5678\u58f6\u67b5\u6e92\u6a53\u7097\u4ee9\u4e49\u6663\u69b7\u63ac\u70ea\u5acc\u70c6\u6033\u5d4a\u68c0\u68e6(n12, n11);
                n13 -= 28713;
                n13 += 28714;
                i -= 6632;
            }
            return bufferedImage3;
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }

        public static int INSOLENCE_\u6437\u4ed4\u4f8b\u4f51\u4ec5\u6d50\u6fed\u631c\u6b0b\u69eb\u6e40\u6294\u5dce\u5b5c\u6439\u59ac\u58bd\u629e\u5efc\u56a6\u67c8\u521c\u6f5a\u63dc\u6e93\u5d37\u6a77\u549a\u5d89\u5bfe\u54fb\u6f36\u64c0\u57be\u6e8b\u50eb\u5a13\u5f67\u6e08\u54c8\u66f4(int n) {
            return n;
        }

        public static int INSOLENCE_\u509f\u6b7c\u7092\u5186\u57e1\u6954\u57b0\u631c\u6170\u4fc4\u6f0e\u5cc1\u4f5b\u5cc5\u67a0\u52d4\u604b\u610a\u5d73\u59fb\u68e3\u5a51\u696f\u5678\u58f6\u67b5\u6e92\u6a53\u7097\u4ee9\u4e49\u6663\u69b7\u63ac\u70ea\u5acc\u70c6\u6033\u5d4a\u68c0\u68e6(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }
}

