/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.EdgeMode;
import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.InplaceBoxBlurFilter;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.filter.AbstractFilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.filter.MultiConvolveOp;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={Animate.class, Set.class})
public final class FeGaussianBlur
extends AbstractFilterPrimitive {
    public static final /* synthetic */ String TAG = "fegaussianblur";
    public static final /* synthetic */ double SQRT_2_PI;
    public static final /* synthetic */ double THREE_QUARTER_SQRT_2_PI;
    public static final /* synthetic */ float KERNEL_PRECISION = 0.001f;
    public static final /* synthetic */ double BOX_BLUR_APPROXIMATION_THRESHOLD = 2.0;
    public /* synthetic */ float[] stdDeviation;
    public /* synthetic */ EdgeMode edgeMode;
    public /* synthetic */ double xCurrent;
    public /* synthetic */ double yCurrent;
    public /* synthetic */ Kernel xBlur;
    public /* synthetic */ Kernel yBlur;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.stdDeviation = attributeNode.getFloatList("stdDeviation");
        this.edgeMode = attributeNode.getEnum("edgeMode", EdgeMode.Duplicate);
    }

    public double[] computeAbsoluteStdDeviation(@Nullable AffineTransform affineTransform) {
        if (this.stdDeviation.length == 0) {
            double[] dArray = new double[2];
            int n = "\u5ce8".length();
            int n2 = "\u5898\u6326\u4edf".length();
            int n3 = "\u6097\u5194\u4f96".length();
            dArray[0] = 0.0;
            int n4 = "\u6fdb".length();
            int n5 = "\u6887".length();
            int n6 = "\u4f84".length();
            dArray[1] = 0.0;
            return dArray;
        }
        double d = this.stdDeviation[0];
        int n = "\u67ab".length();
        int n7 = "\u69bc\u553b".length();
        double d2 = this.stdDeviation[Math.min(this.stdDeviation.length - 1, 1)];
        if (affineTransform != null) {
            d *= GeometryUtil.scaleXOfTransform(affineTransform);
            d2 *= GeometryUtil.scaleYOfTransform(affineTransform);
        }
        double[] dArray = new double[2];
        int n8 = "\u56cc".length();
        int n9 = "\u5535\u5946\u5ca3\u7076".length();
        int n10 = "\u5ae7\u4f49\u67bd\u6af5\u59cf".length();
        int n11 = "\u5d05\u6725".length();
        dArray[0] = d;
        int n12 = "\u65ee".length();
        int n13 = "\u5c16\u6ebb".length();
        int n14 = "\u5136\u6409\u668f\u542d\u4f83".length();
        int n15 = "\u646d\u50a4".length();
        dArray[1] = d2;
        return dArray;
    }

    @Override
    public void layoutFilter(@NotNull RenderContext renderContext, @NotNull FilterLayoutContext filterLayoutContext) {
        LayoutBounds layoutBounds = this.impl().layoutInput(filterLayoutContext);
        double[] dArray = this.computeAbsoluteStdDeviation(null);
        int n = FeGaussianBlur.kernelDiameterForStandardDeviation(dArray[0]);
        int n2 = FeGaussianBlur.kernelDiameterForStandardDeviation(dArray[1]);
        this.impl().saveLayoutResult(layoutBounds.grow(n, n2, filterLayoutContext), filterLayoutContext);
    }

    @Override
    public void applyFilter(@NotNull RenderContext renderContext, @NotNull FilterContext filterContext) {
        if (this.stdDeviation.length == 0) {
            this.impl().noop(filterContext);
            return;
        }
        double[] dArray = this.computeAbsoluteStdDeviation(filterContext.info().graphics().getTransform());
        double d = dArray[0];
        double d2 = dArray[1];
        if (d <= 0.0 && d2 <= 0.0) {
            this.impl().noop(filterContext);
            return;
        }
        ImageProducer imageProducer = this.impl().inputChannel(filterContext).producer();
        Kernel kernel = null;
        Kernel kernel2 = null;
        int n = FeGaussianBlur.kernelDiameterForStandardDeviation(d);
        int n2 = FeGaussianBlur.kernelDiameterForStandardDeviation(d2);
        if (d > 0.0 && d < 2.0) {
            kernel = this.createConvolveKernel(n, d, true);
        }
        if (d2 > 0.0 && d2 < 2.0) {
            kernel2 = this.createConvolveKernel(n, d2, false);
        }
        int n3 = "\u67f4\u5332\u5d40".length();
        int n4 = "\u599d\u6e5e\u58b0\u6f66\u6c51".length();
        ImageProducer imageProducer2 = this.edgeMode.convolve(renderContext, filterContext, imageProducer, new MixedQualityConvolveOperation(kernel, kernel2, n, n2, null));
        int n5 = "\u6d06\u52e8".length();
        int n6 = "\u61b8\u6818\u6806\u5e7d".length();
        this.impl().saveResult(new ImageProducerChannel(imageProducer2), filterContext);
    }

    @NotNull
    public Kernel createConvolveKernel(int n, double d, boolean bl) {
        if (bl && this.xBlur != null && this.xCurrent == d) {
            return this.xBlur;
        }
        if (!bl && this.yBlur != null && this.yCurrent == d) {
            return this.yBlur;
        }
        if (bl) {
            this.xCurrent = d;
        } else {
            this.yCurrent = d;
        }
        float[] fArray = FeGaussianBlur.computeGaussianKernelData(n, d);
        if (bl) {
            int n2 = "\u6c46".length();
            this.xBlur = new Kernel(n, 1, fArray);
        } else {
            int n3 = "\u69d3\u5b33\u6d40\u56c3".length();
            int n4 = "\u69bd\u5de7\u65db\u5f49".length();
            this.yBlur = new Kernel(1, n, fArray);
        }
        return bl ? this.xBlur : this.yBlur;
    }

    public static /* synthetic */ float normalConvolve(float f, double d) {
        return (float)(Math.pow(Math.E, (double)(-f * f) / (2.0 * d * d)) / (d * SQRT_2_PI));
    }

    public static /* synthetic */ float[] computeGaussianKernelData(int n, double d) {
        int n2;
        float[] fArray = new float[n];
        int n3 = n / 2;
        float f = 0.0f;
        for (n2 = 0; n2 < n; n2 -= 18605) {
            int n4 = "\u51f2\u68fb\u6799".length();
            int n5 = "\u5d4a\u6bde\u5cfb\u55c7".length();
            fArray[n2] = FeGaussianBlur.normalConvolve((float)n2 - (float)n3, d);
            f += fArray[n2];
            n2 += 18606;
        }
        if (f > 0.0f) {
            for (n2 = 0; n2 < n; n2 += 659) {
                int n6 = n2;
                fArray[n6] = fArray[n6] / f;
                n2 -= 658;
            }
        }
        return fArray;
    }

    public static /* synthetic */ int kernelDiameterForStandardDeviation(double d) {
        if (d < 2.0) {
            float f = (float)(0.5 / (d * SQRT_2_PI));
            int n = 0;
            while ((double)f < 0.49899999995250255) {
                f += FeGaussianBlur.normalConvolve(n, d);
                n -= 22784;
                n += 22785;
            }
            return FeGaussianBlur.INSOLENCE_\u698e\u61b5\u4e83\u6c14\u6bac\u5e36\u5e09\u662b\u5b6c\u5363\u6ef9\u656a\u5acd\u5a1b\u5069\u70d0\u6854\u70be\u5d1d\u6278\u5460\u712c\u6fbf\u5565\u542b\u6b4e\u6393\u557e\u59b4\u6711\u688b\u6a88\u56be\u5c94\u5e61\u5646\u6ab3\u5649\u6107\u6d83\u57e6(n * 2, 1);
        }
        return (int)Math.floor(THREE_QUARTER_SQRT_2_PI * d + 0.5);
    }

    static {
        SQRT_2_PI = Math.sqrt(Math.PI * 2);
        THREE_QUARTER_SQRT_2_PI = SQRT_2_PI * 3.0 / 4.0;
    }

    public static int INSOLENCE_\u698e\u61b5\u4e83\u6c14\u6bac\u5e36\u5e09\u662b\u5b6c\u5363\u6ef9\u656a\u5acd\u5a1b\u5069\u70d0\u6854\u70be\u5d1d\u6278\u5460\u712c\u6fbf\u5565\u542b\u6b4e\u6393\u557e\u59b4\u6711\u688b\u6a88\u56be\u5c94\u5e61\u5646\u6ab3\u5649\u6107\u6d83\u57e6(int n, int n2) {
        return ((n | n2) << 1) + ~(n ^ n2) + 1;
    }

    private static final class MixedQualityConvolveOperation
    implements EdgeMode.ConvolveOperation {
        @Nullable
        public final /* synthetic */ Kernel xKernel;
        @Nullable
        public final /* synthetic */ Kernel yKernel;
        public final /* synthetic */ int dX;
        public final /* synthetic */ int dY;

        public MixedQualityConvolveOperation(@Nullable Kernel kernel, @Nullable Kernel kernel2, int n, int n2) {
            this.xKernel = kernel;
            this.yKernel = kernel2;
            this.dX = n;
            this.dY = n2;
        }

        @Override
        @NotNull
        public Dimension maximumKernelSize() {
            int n = "\u660d\u6a78\u5bd6\u70ec".length();
            int n2 = "\u5544\u4e3f\u6bfc".length();
            return new Dimension(this.xKernel != null ? this.xKernel.getXOrigin() : this.dX, this.yKernel != null ? this.yKernel.getXOrigin() : this.dY);
        }

        @Override
        @NotNull
        public ImageProducer convolve(@NotNull BufferedImage bufferedImage, @NotNull RenderingHints renderingHints, int n) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (this.xKernel != null && this.yKernel != null) {
                int n2 = "\u5571\u4fc4\u6cce".length();
                int n3 = "\u670f\u5028\u682a\u6bc7".length();
                int n4 = "\u6855\u538d".length();
                ConvolveOp[] convolveOpArray = new ConvolveOp[2];
                int n5 = "\u6ea4\u6057".length();
                int n6 = "\u6799\u5876\u5a9b\u5dfd\u65e0".length();
                int n7 = "\u712a\u5a16\u5345".length();
                int n8 = "\u6761".length();
                convolveOpArray[0] = new ConvolveOp(this.xKernel, n, renderingHints);
                int n9 = "\u5961\u54cd\u543c\u6afd".length();
                int n10 = "\u5893\u61bf\u6311\u6e15".length();
                int n11 = "\u5793".length();
                int n12 = "\u6523\u5330\u5b5b\u624c\u5c76".length();
                int n13 = "\u5c49\u5a44\u5fcd".length();
                int n14 = "\u60be".length();
                int n15 = "\u6e07".length();
                convolveOpArray[1] = new ConvolveOp(this.yKernel, n, renderingHints);
                MultiConvolveOp multiConvolveOp = new MultiConvolveOp(convolveOpArray);
                int n16 = "\u7092\u6225".length();
                int n17 = "\u6301\u56ef\u533e\u6935\u5650".length();
                int n18 = "\u563f\u64fe\u4f01\u6ae9".length();
                int n19 = "\u6b26\u689f\u6582".length();
                int n20 = "\u5ecb\u5dae\u5423".length();
                return new FilteredImageSource(bufferedImage.getSource(), new BufferedImageFilter(multiConvolveOp));
            }
            if (this.xKernel != null) {
                this.verticalBoxBlur(writableRaster);
                int n21 = "\u5846\u529e\u5a08\u6b66\u5b04".length();
                int n22 = "\u5955\u68a4".length();
                int n23 = "\u4ed3\u5596\u6604".length();
                int n24 = "\u5687".length();
                int n25 = "\u57a3".length();
                int n26 = "\u51dd\u5da5".length();
                int n27 = "\u68ac\u555e\u6f06".length();
                return new FilteredImageSource(bufferedImage.getSource(), new BufferedImageFilter(new ConvolveOp(this.xKernel, n, renderingHints)));
            }
            if (this.yKernel != null) {
                this.horizontalBoxBlur(writableRaster);
                int n28 = "\u5719\u60ba\u6373\u509f".length();
                int n29 = "\u6046\u543d\u5bc6\u5e9c".length();
                int n30 = "\u5992\u6fba\u577c".length();
                int n31 = "\u55d6\u5ba0\u5341\u503f".length();
                int n32 = "\u6853\u5258\u5a6c\u67ac\u6f6f".length();
                int n33 = "\u661d".length();
                int n34 = "\u5094\u56b9\u65e7\u6340".length();
                return new FilteredImageSource(bufferedImage.getSource(), new BufferedImageFilter(new ConvolveOp(this.yKernel, n, renderingHints)));
            }
            this.horizontalBoxBlur(writableRaster);
            this.verticalBoxBlur(writableRaster);
            return bufferedImage.getSource();
        }

        public void horizontalBoxBlur(@NotNull WritableRaster writableRaster) {
            if ((this.dX & 1) == 0) {
                InplaceBoxBlurFilter.horizontalPass(writableRaster, writableRaster, 0, 0, this.dX, this.dX / 2);
                int n = "\u68be\u6cba\u65db\u6f6a\u6bce".length();
                int n2 = "\u558d\u5f1e\u6982\u5e5b".length();
                InplaceBoxBlurFilter.horizontalPass(writableRaster, writableRaster, 0, 0, this.dX, this.dX / 2 - 1);
                InplaceBoxBlurFilter.horizontalPass(writableRaster, writableRaster, 0, 0, MixedQualityConvolveOperation.INSOLENCE_\u5bee\u6926\u5394\u6d5b\u58db\u6b56\u4fc4\u4f61\u6811\u6281\u6fe7\u53ad\u6ffd\u67fd\u5828\u5f2e\u6c0b\u6124\u5c26\u5523\u6a7b\u547b\u62ef\u5674\u5754\u5145\u6970\u5b73\u6809\u6661\u5af8\u635b\u5f90\u5c7e\u6886\u5425\u4f38\u5431\u5f58\u5026\u5303(this.dX, 1), this.dX / 2);
            } else {
                InplaceBoxBlurFilter.horizontalPass(writableRaster, writableRaster, 0, 0, this.dX, this.dX / 2);
                InplaceBoxBlurFilter.horizontalPass(writableRaster, writableRaster, 0, 0, this.dX, this.dX / 2);
                InplaceBoxBlurFilter.horizontalPass(writableRaster, writableRaster, 0, 0, this.dX, this.dX / 2);
            }
        }

        public void verticalBoxBlur(@NotNull WritableRaster writableRaster) {
            if ((this.dY & 1) == 0) {
                InplaceBoxBlurFilter.verticalPass(writableRaster, writableRaster, 0, 0, this.dY, this.dY / 2);
                int n = "\u629b\u5028\u5332\u57bd".length();
                int n2 = "\u624c".length();
                InplaceBoxBlurFilter.verticalPass(writableRaster, writableRaster, 0, 0, this.dY, this.dY / 2 - 1);
                InplaceBoxBlurFilter.verticalPass(writableRaster, writableRaster, 0, 0, MixedQualityConvolveOperation.INSOLENCE_\u5bee\u6926\u5394\u6d5b\u58db\u6b56\u4fc4\u4f61\u6811\u6281\u6fe7\u53ad\u6ffd\u67fd\u5828\u5f2e\u6c0b\u6124\u5c26\u5523\u6a7b\u547b\u62ef\u5674\u5754\u5145\u6970\u5b73\u6809\u6661\u5af8\u635b\u5f90\u5c7e\u6886\u5425\u4f38\u5431\u5f58\u5026\u5303(this.dY, 1), this.dY / 2);
            } else {
                InplaceBoxBlurFilter.verticalPass(writableRaster, writableRaster, 0, 0, this.dY, this.dY / 2);
                InplaceBoxBlurFilter.verticalPass(writableRaster, writableRaster, 0, 0, this.dY, this.dY / 2);
                InplaceBoxBlurFilter.verticalPass(writableRaster, writableRaster, 0, 0, this.dY, this.dY / 2);
            }
        }

        public /* synthetic */ MixedQualityConvolveOperation(Kernel kernel, Kernel kernel2, int n, int n2, 1 var5_5) {
            this(kernel, kernel2, n, n2);
        }

        public static int INSOLENCE_\u5bee\u6926\u5394\u6d5b\u58db\u6b56\u4fc4\u4f61\u6811\u6281\u6fe7\u53ad\u6ffd\u67fd\u5828\u5f2e\u6c0b\u6124\u5c26\u5523\u6a7b\u547b\u62ef\u5674\u5754\u5145\u6970\u5b73\u6809\u6661\u5af8\u635b\u5f90\u5c7e\u6886\u5425\u4f38\u5431\u5f58\u5026\u5303(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }
}

