/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.noise.PerlinTurbulence;
import com.github.weisj.jsvg.geometry.size.FloatInsets;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.filter.AbstractFilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.filter.PixelProvider;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={Animate.class, Set.class})
public final class FeTurbulence
extends AbstractFilterPrimitive {
    public static final /* synthetic */ String TAG = "feturbulence";
    public /* synthetic */ float seed;
    public /* synthetic */ float[] baseFrequency;
    public /* synthetic */ int numOctaves;
    public /* synthetic */ Type type;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.seed = attributeNode.getFloat("seed", 0.0f);
        this.baseFrequency = attributeNode.getFloatList("baseFrequency");
        if (this.baseFrequency.length == 0) {
            float[] fArray = new float[1];
            int n = "\u51d7\u64d7\u4e3e\u6dd3".length();
            fArray[0] = 0.0f;
            this.baseFrequency = fArray;
        }
        this.numOctaves = attributeNode.getInt("numOctaves", 1);
        this.numOctaves = Math.min(this.numOctaves, 8);
        this.type = attributeNode.getEnum("type", Type.fractalNoise);
    }

    @Override
    public void layoutFilter(@NotNull RenderContext renderContext, @NotNull FilterLayoutContext filterLayoutContext) {
        int n = "\u5576".length();
        int n2 = "\u6a3c\u61d1\u5441\u652a".length();
        this.impl().saveLayoutResult(new LayoutBounds(filterLayoutContext.filterPrimitiveRegion(renderContext.measureContext(), this), new FloatInsets()), filterLayoutContext);
    }

    @Override
    public void applyFilter(@NotNull RenderContext renderContext, @NotNull FilterContext filterContext) {
        Filter.FilterInfo filterInfo = filterContext.info();
        int n = "\u6bda\u6413".length();
        int n2 = "\u5cf6".length();
        TurbulenceChannel turbulenceChannel = new TurbulenceChannel(filterInfo.imageBounds(), filterInfo.imageWidth, filterInfo.imageHeight, this.seed, this.numOctaves, this.baseFrequency[0], this.baseFrequency.length > 1 ? (double)this.baseFrequency[1] : (double)this.baseFrequency[0], this.type);
        this.impl().saveResult(turbulenceChannel, filterContext);
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* synthetic */ /* enum */ Type fractalNoise;
        public static final /* synthetic */ /* enum */ Type Turbulence;
        public static final /* synthetic */ Type[] $VALUES;

        public static /* synthetic */ Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static /* synthetic */ Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        public static /* synthetic */ Type[] $values() {
            Type[] typeArray = new Type[2];
            int n = "\u6208\u5a9c".length();
            int n2 = "\u546a\u5fa7".length();
            typeArray[0] = fractalNoise;
            int n3 = "\u5ef7\u68a7".length();
            int n4 = "\u6446".length();
            typeArray[1] = Turbulence;
            return typeArray;
        }

        static {
            fractalNoise = new Type();
            Turbulence = new Type();
            $VALUES = Type.$values();
        }
    }

    public static final class TurbulenceChannel
    implements Channel,
    PixelProvider {
        public final /* synthetic */ PerlinTurbulence perlinTurbulence;
        public final /* synthetic */ double[] channels;
        public final /* synthetic */ int imageWidth;
        public final /* synthetic */ int imageHeight;
        public final /* synthetic */ Type type;
        public final /* synthetic */ Rectangle2D tileBounds;
        public /* synthetic */ BufferedImage bufferedImage;

        public TurbulenceChannel(@NotNull Rectangle2D rectangle2D, int n, int n2, float f, int n3, double d, double d2, Type type) {
            this.channels = new double[4];
            this.tileBounds = rectangle2D;
            this.imageWidth = n;
            this.imageHeight = n2;
            this.type = type;
            this.perlinTurbulence = new PerlinTurbulence((int)f, n3, d, d2);
        }

        @NotNull
        public BufferedImage ensureImageBackingStore() {
            if (this.bufferedImage == null) {
                ColorSpace colorSpace = ColorSpace.getInstance(1004);
                int n = "\u6f8f".length();
                int n2 = "\u5e7a\u63b0\u5950\u6fbf".length();
                int n3 = "\u60a2\u6f5d\u56a6\u6bc4\u64f1".length();
                int n4 = "\u60ee\u6114\u5a88\u6680".length();
                DirectColorModel directColorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                WritableRaster writableRaster = ((ColorModel)directColorModel).createCompatibleWritableRaster(this.imageWidth, this.imageHeight);
                int n5 = "\u5622\u6aa3\u60a1\u5994\u56fc".length();
                int n6 = "\u58c2\u6325\u52b2\u5085".length();
                int n7 = "\u5a55".length();
                int n8 = "\u670b\u5c6c".length();
                this.bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
                int n9 = writableRaster.getWidth();
                int n10 = writableRaster.getHeight();
                double d = this.tileBounds.getWidth() / (double)n9;
                double d2 = this.tileBounds.getHeight() / (double)n10;
                double d3 = this.tileBounds.getX();
                double d4 = this.tileBounds.getY();
                boolean bl = this.type == Type.fractalNoise;
                int[] nArray = ImageUtil.getINT_RGBA_DataBank(writableRaster);
                int n11 = ImageUtil.getINT_RGBA_DataAdjust(writableRaster);
                int n12 = ImageUtil.getINT_RGBA_DataOffset(writableRaster);
                double d5 = d4;
                for (int i = 0; i < n10; i -= 13191) {
                    double d6 = d3;
                    int n13 = TurbulenceChannel.INSOLENCE_\u709b\u5776\u629e\u5435\u68d4\u4e40\u58cd\u52bc\u6b26\u680a\u6afc\u6e3a\u5512\u5a15\u53d7\u56bc\u706b\u68f5\u5743\u5114\u64aa\u63bd\u66c0\u5cc6\u53f5\u6b02\u4fac\u524c\u5d95\u61a8\u65c9\u635b\u5620\u713e\u55ca\u61fb\u5e09\u61e2\u5043\u6c51\u6313(n12, n9);
                    while (n12 < n13) {
                        this.perlinTurbulence.turbulence(this.channels, d6, d5, bl, null, null);
                        nArray[n12] = ((ColorModel)directColorModel).getRGB(TurbulenceChannel.channelsToRGB(this.channels));
                        d6 += d;
                        n12 += 18969;
                        n12 -= 18968;
                    }
                    d5 += d2;
                    n12 = TurbulenceChannel.INSOLENCE_\u709b\u5776\u629e\u5435\u68d4\u4e40\u58cd\u52bc\u6b26\u680a\u6afc\u6e3a\u5512\u5a15\u53d7\u56bc\u706b\u68f5\u5743\u5114\u64aa\u63bd\u66c0\u5cc6\u53f5\u6b02\u4fac\u524c\u5d95\u61a8\u65c9\u635b\u5620\u713e\u55ca\u61fb\u5e09\u61e2\u5043\u6c51\u6313(n12, n11);
                    i += 13192;
                }
            }
            return this.bufferedImage;
        }

        @Override
        @NotNull
        public ImageProducer producer() {
            return this.ensureImageBackingStore().getSource();
        }

        @Override
        @NotNull
        public BufferedImage toBufferedImageNonAliased(@NotNull RenderContext renderContext) {
            BufferedImage bufferedImage = this.ensureImageBackingStore();
            ColorModel colorModel = bufferedImage.getColorModel();
            WritableRaster writableRaster = bufferedImage.copyData(null);
            int n = "\u631b".length();
            int n2 = "\u4f4f".length();
            int n3 = "\u5b83\u6c6a\u6f44".length();
            return new BufferedImage(colorModel, writableRaster, TurbulenceChannel.INSOLENCE_\u4f49\u63b3\u4ed5\u5bfd\u5847\u5bfd\u6b10\u5bba\u54ed\u6dda\u5216\u6d4e\u67e8\u5c47\u6e54\u5de9\u669d\u561b\u6495\u67e9\u6388\u6386\u6d03\u5be3\u5d33\u5749\u684d\u5265\u4f7e\u51f5\u67b8\u67aa\u6ced\u628a\u6d14\u5035\u613c\u6c93\u4e38\u6b3b\u5a19(colorModel.isAlphaPremultiplied() ? 1 : 0) != 0, null);
        }

        @Override
        @NotNull
        public Channel applyFilter(@NotNull ImageFilter imageFilter) {
            int n = "\u5bf9".length();
            int n2 = "\u4f51".length();
            int n3 = "\u558f\u5d5b\u4ea5".length();
            int n4 = "\u682f".length();
            int n5 = "\u6616\u60d4\u7020\u5ad4\u5d4e".length();
            int n6 = "\u675d\u70ff".length();
            return new ImageProducerChannel(new FilteredImageSource(this.producer(), imageFilter));
        }

        @Override
        @NotNull
        public PixelProvider pixels(@NotNull RenderContext renderContext) {
            return this;
        }

        @Override
        public int pixelAt(double d, double d2) {
            this.perlinTurbulence.turbulence(this.channels, d, d2, this.type == Type.fractalNoise, null, null);
            return TurbulenceChannel.channelsToRGB(this.channels);
        }

        public static /* synthetic */ int channelsToRGB(double[] dArray) {
            int n = (int)dArray[0];
            int n2 = (n & 0xFFFFFF00) == 0 ? n << 16 : ((n & Integer.MIN_VALUE) != 0 ? 0 : 0xFF0000);
            n = (int)dArray[1];
            n2 = (n & 0xFFFFFF00) == 0 ? (n2 |= n << 8) : (n2 |= (n & Integer.MIN_VALUE) != 0 ? 0 : 65280);
            n = (int)dArray[2];
            n2 = (n & 0xFFFFFF00) == 0 ? (n2 |= n) : (n2 |= (n & Integer.MIN_VALUE) != 0 ? 0 : 255);
            n = (int)dArray[3];
            n2 = (n & 0xFFFFFF00) == 0 ? (n2 |= n << 24) : (n2 |= (n & Integer.MIN_VALUE) != 0 ? 0 : -16777216);
            return n2;
        }

        public static int INSOLENCE_\u4f49\u63b3\u4ed5\u5bfd\u5847\u5bfd\u6b10\u5bba\u54ed\u6dda\u5216\u6d4e\u67e8\u5c47\u6e54\u5de9\u669d\u561b\u6495\u67e9\u6388\u6386\u6d03\u5be3\u5d33\u5749\u684d\u5265\u4f7e\u51f5\u67b8\u67aa\u6ced\u628a\u6d14\u5035\u613c\u6c93\u4e38\u6b3b\u5a19(int n) {
            return n;
        }

        public static int INSOLENCE_\u709b\u5776\u629e\u5435\u68d4\u4e40\u58cd\u52bc\u6b26\u680a\u6afc\u6e3a\u5512\u5a15\u53d7\u56bc\u706b\u68f5\u5743\u5114\u64aa\u63bd\u66c0\u5cc6\u53f5\u6b02\u4fac\u524c\u5d95\u61a8\u65c9\u635b\u5620\u713e\u55ca\u61fb\u5e09\u61e2\u5043\u6c51\u6313(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }
}

