/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.size.FloatInsets;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.IllegalFilterStateException;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.BlittableImage;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={})
@PermittedContent(categories={Category.Descriptive, Category.FilterPrimitive}, anyOf={Animate.class, Set.class})
public final class Filter
extends ContainerNode {
    public static final /* synthetic */ boolean DEBUG = false;
    public static final /* synthetic */ String TAG = "filter";
    public static final /* synthetic */ Length DEFAULT_FILTER_COORDINATE;
    public static final /* synthetic */ Length DEFAULT_FILTER_SIZE;
    public /* synthetic */ Length x;
    public /* synthetic */ Length y;
    public /* synthetic */ Length width;
    public /* synthetic */ Length height;
    public /* synthetic */ UnitType filterUnits;
    public /* synthetic */ UnitType filterPrimitiveUnits;
    public /* synthetic */ boolean isValid;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public boolean hasEffect() {
        return Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(this.isValid ? 1 : 0) != 0 && Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(this.children().isEmpty() ? 1 : 0) == 0;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.isValid = Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(1);
        Iterator<? extends SVGNode> iterator = this.children().iterator();
        while (Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(iterator.hasNext() ? 1 : 0) != 0) {
            SVGNode sVGNode = iterator.next();
            FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
            if (Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(filterPrimitive.isValid() ? 1 : 0) != 0) continue;
            this.isValid = Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(0);
            break;
        }
        this.filterUnits = attributeNode.getEnum("filterUnits", UnitType.ObjectBoundingBox);
        this.filterPrimitiveUnits = attributeNode.getEnum("primitiveUnits", UnitType.UserSpaceOnUse);
        this.x = attributeNode.getLength("x", DEFAULT_FILTER_COORDINATE);
        this.y = attributeNode.getLength("y", DEFAULT_FILTER_COORDINATE);
        this.width = attributeNode.getLength("width", DEFAULT_FILTER_SIZE);
        this.height = attributeNode.getLength("height", DEFAULT_FILTER_SIZE);
        if (this.filterUnits == UnitType.ObjectBoundingBox) {
            this.x = this.coerceToPercentage(this.x);
            this.y = this.coerceToPercentage(this.y);
            this.width = this.coerceToPercentage(this.width);
            this.height = this.coerceToPercentage(this.height);
        }
    }

    @NotNull
    public Length coerceToPercentage(@NotNull Length length) {
        if (length.unit() == Unit.PERCENTAGE) {
            return length;
        }
        int n = "\u5ae4\u610b\u64e7\u4f40".length();
        int n2 = "\u52e0\u56b0\u67f3\u6bc5".length();
        int n3 = "\u5d6c\u60a3\u539d\u5eb4\u54a0".length();
        return new Length(Unit.PERCENTAGE, length.raw() * 100.0f);
    }

    @NotNull
    public FilterInfo createFilterInfo(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext, @NotNull Rectangle2D rectangle2D) {
        Object object;
        Object object2;
        Rectangle2D.Double double_ = this.filterUnits.computeViewBounds(renderContext.measureContext(), rectangle2D, this.x, this.y, this.width, this.height);
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = "\u4ecd\u5238\u5038\u5eb2\u6bb4".length();
        int n2 = "\u69ff\u6aa4".length();
        FilterLayoutContext filterLayoutContext = new FilterLayoutContext(this.filterPrimitiveUnits, rectangle2D, rectangle);
        Rectangle2D rectangle2D2 = rectangle2D.createIntersection(rectangle);
        Rectangle2D rectangle2D3 = double_.createIntersection(rectangle);
        int n3 = "\u5ec1\u6e81\u5be5".length();
        int n4 = "\u63a9\u5477\u5873".length();
        int n5 = "\u6d91\u5e30\u63f1\u62b1".length();
        int n6 = "\u6c7f\u5971\u52a6".length();
        int n7 = "\u5396\u5927".length();
        LayoutBounds layoutBounds = new LayoutBounds(rectangle2D3, new FloatInsets());
        int n8 = "\u4f0d".length();
        int n9 = "\u5d1d".length();
        int n10 = "\u5820\u6be3\u5342\u6ab9\u6e45".length();
        LayoutBounds layoutBounds2 = new LayoutBounds(rectangle2D2, new FloatInsets());
        LayoutBounds layoutBounds3 = layoutBounds.transform((data, computeFlags) -> Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(computeFlags.operatesOnWholeFilterRegion ? 1 : 0) != 0 ? data : layoutBounds2.resolve((LayoutBounds.ComputeFlags)computeFlags));
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.LastResult, layoutBounds);
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceGraphic, layoutBounds3);
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceAlpha, layoutBounds3);
        Object object3 = this.children().iterator();
        while (Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(object3.hasNext() ? 1 : 0) != 0) {
            object2 = object3.next();
            try {
                object = (FilterPrimitive)object2;
                object.layoutFilter(renderContext, filterLayoutContext);
            }
            catch (IllegalFilterStateException illegalFilterStateException) {}
        }
        object3 = filterLayoutContext.resultChannels().get(DefaultFilterChannel.LastResult).resolve(LayoutBounds.ComputeFlags.INITIAL);
        object2 = ((LayoutBounds.Data)object3).clipBoundsEscapeInsets();
        object = ((LayoutBounds.Data)object3).bounds().createIntersection(GeometryUtil.grow(rectangle, (FloatInsets)object2));
        BlittableImage blittableImage = BlittableImage.create(ImageUtil::createCompatibleTransparentImage, renderContext, (Rectangle2D)object, double_, rectangle2D, UnitType.UserSpaceOnUse);
        int n11 = "\u6521\u6ca4\u54b9\u6410".length();
        int n12 = "\u6efe\u5cc7\u5582\u4f4f".length();
        int n13 = "\u512d\u5633\u618a\u6165".length();
        int n14 = "\u60bb\u504a\u56c8\u57c3\u6738".length();
        return new FilterInfo(graphics2D, blittableImage, rectangle2D, null);
    }

    public void applyFilter(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext, @NotNull FilterInfo filterInfo) {
        ImageProducer imageProducer = filterInfo.blittableImage.image().getSource();
        int n = "\u630d\u51de\u5ca5\u552a".length();
        int n2 = "\u5d4f".length();
        int n3 = "\u69af\u53f0\u5553\u6593\u53f3".length();
        FilterContext filterContext = new FilterContext(filterInfo, this.filterPrimitiveUnits, graphics2D.getRenderingHints());
        int n4 = "\u669f".length();
        int n5 = "\u5b78\u6eca\u5605\u6868".length();
        int n6 = "\u6d36\u5b50\u52a7".length();
        int n7 = "\u4f37\u6507\u5aa0\u6cd2\u68d8".length();
        ImageProducerChannel imageProducerChannel = new ImageProducerChannel(imageProducer);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceGraphic, imageProducerChannel);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.LastResult, imageProducerChannel);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceAlpha, () -> {
            int n = "\u6d8d\u6787".length();
            int n2 = "\u5930\u57b9\u7059\u59f6".length();
            int n3 = "\u56eb".length();
            int n4 = "\u6000\u693f\u6512\u6679\u522f".length();
            return imageProducerChannel.applyFilter(new AlphaImageFilter(null));
        });
        Iterator<? extends SVGNode> iterator = this.children().iterator();
        while (Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(iterator.hasNext() ? 1 : 0) != 0) {
            SVGNode sVGNode = iterator.next();
            try {
                FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
                filterPrimitive.applyFilter(renderContext, filterContext);
            }
            catch (IllegalFilterStateException illegalFilterStateException) {}
        }
        filterInfo.producer = Objects.requireNonNull(filterContext.getChannel(DefaultFilterChannel.LastResult)).producer();
        int n8 = "\u5ce3\u5020\u5a70".length();
        int n9 = "\u6862\u6996\u684b\u56c4".length();
    }

    @Override
    public boolean acceptChild(@Nullable String string, @NotNull SVGNode sVGNode) {
        return sVGNode instanceof FilterPrimitive && Filter.INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(super.acceptChild(string, sVGNode) ? 1 : 0) != 0;
    }

    static {
        DEFAULT_FILTER_COORDINATE = Unit.PERCENTAGE.valueOf(-10.0f);
        DEFAULT_FILTER_SIZE = Unit.PERCENTAGE.valueOf(120.0f);
    }

    public static int INSOLENCE_\u60d3\u6880\u5c3f\u56e1\u5765\u4ed9\u6a87\u61b7\u660e\u65ed\u5469\u68fe\u5331\u4fce\u5558\u709f\u57cb\u554d\u5d0b\u5730\u5eac\u6740\u54b9\u55db\u61bc\u55c4\u5cf0\u6a90\u60eb\u5ce8\u6ccf\u5cfb\u68a4\u5bc3\u5c5f\u6878\u65c8\u5465\u5742\u6af6\u6457(int n) {
        return n;
    }

    public static final class FilterInfo {
        public final /* synthetic */ int imageWidth;
        public final /* synthetic */ int imageHeight;
        @NotNull
        public final /* synthetic */ Rectangle2D elementBounds;
        @NotNull
        public final /* synthetic */ Graphics2D imageGraphics;
        @NotNull
        public final /* synthetic */ BlittableImage blittableImage;
        public /* synthetic */ ImageProducer producer;

        public FilterInfo(@NotNull Graphics2D graphics2D, @NotNull BlittableImage blittableImage, @NotNull Rectangle2D rectangle2D) {
            this.blittableImage = blittableImage;
            this.elementBounds = rectangle2D;
            BufferedImage bufferedImage = blittableImage.image();
            this.imageWidth = bufferedImage.getWidth();
            this.imageHeight = bufferedImage.getHeight();
            this.imageGraphics = blittableImage.createGraphics();
            this.imageGraphics.setRenderingHints(graphics2D.getRenderingHints());
        }

        @NotNull
        public Rectangle2D imageBounds() {
            return this.blittableImage.boundsInUserSpace();
        }

        @NotNull
        public Rectangle2D elementBounds() {
            return this.elementBounds;
        }

        @NotNull
        public Graphics2D graphics() {
            return this.imageGraphics;
        }

        @NotNull
        public Rectangle2D tile() {
            Rectangle2D rectangle2D = this.imageBounds();
            int n = "\u5785\u6178\u63b4\u6ac7".length();
            int n2 = "\u6bd3\u70b0\u5ee5\u6916".length();
            int n3 = "\u5c93\u55bf\u6827".length();
            int n4 = "\u6427\u5591\u64f7\u681b\u5a0c".length();
            int n5 = "\u5535".length();
            int n6 = "\u6ad0\u54e8\u558e".length();
            int n7 = "\u6fa1".length();
            int n8 = "\u5539\u6e86\u5228\u62cb".length();
            int n9 = "\u50d5\u5616\u669d".length();
            int n10 = "\u6d4d".length();
            return new Rectangle2D.Double(rectangle2D.getX() - this.elementBounds.getX(), rectangle2D.getY() - this.elementBounds.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }

        public void blitImage(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext) {
            Rectangle2D rectangle2D = this.imageBounds();
            this.blittableImage.prepareForBlitting(graphics2D, renderContext);
            FilterInfo.INSOLENCE_\u4f35\u70f6\u5f23\u5fc2\u677e\u6542\u5f1f\u567e\u643d\u5721\u5547\u632c\u5f5b\u6865\u5ef2\u5511\u5960\u6391\u70b4\u6554\u5d1d\u70dc\u625e\u5250\u6361\u4e91\u55d2\u6f11\u6d77\u5b4a\u669b\u6e60\u53ba\u5cd8\u4e21\u5729\u56a1\u5660\u69a2\u702c\u704f(graphics2D.drawImage(renderContext.createImage(this.producer), 0, 0, renderContext.targetComponent()) ? 1 : 0);
            int n = "\u4f0b\u5f61\u54de\u514c".length();
            int n2 = "\u573f\u57c0\u4e6a\u5470".length();
            int n3 = "\u6666".length();
            int n4 = "\u5a55\u6d7a\u67b8\u5332".length();
        }

        public void close() {
            this.imageGraphics.dispose();
        }

        public /* synthetic */ FilterInfo(Graphics2D graphics2D, BlittableImage blittableImage, Rectangle2D rectangle2D, 1 var4_4) {
            this(graphics2D, blittableImage, rectangle2D);
        }

        public static int INSOLENCE_\u4f35\u70f6\u5f23\u5fc2\u677e\u6542\u5f1f\u567e\u643d\u5721\u5547\u632c\u5f5b\u6865\u5ef2\u5511\u5960\u6391\u70b4\u6554\u5d1d\u70dc\u625e\u5250\u6361\u4e91\u55d2\u6f11\u6d77\u5b4a\u669b\u6e60\u53ba\u5cd8\u4e21\u5729\u56a1\u5660\u69a2\u702c\u704f(int n) {
            return n;
        }
    }

    private static final class AlphaImageFilter
    extends RGBImageFilter {
        public final /* synthetic */ ColorModel model;

        public AlphaImageFilter() {
            this.model = ColorModel.getRGBdefault();
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            return this.model.getAlpha(n3) << 24;
        }

        public /* synthetic */ AlphaImageFilter(1 var1_1) {
            this();
        }
    }
}

