/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.ChannelStorage;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.annotations.NotNull;

public final class FilterPrimitiveBase {
    @NotNull
    public final /* synthetic */ Length x;
    @NotNull
    public final /* synthetic */ Length y;
    @NotNull
    public final /* synthetic */ Length width;
    @NotNull
    public final /* synthetic */ Length height;
    @NotNull
    public final /* synthetic */ FilterChannelKey inputChannel;
    @NotNull
    public final /* synthetic */ FilterChannelKey resultChannel;

    public FilterPrimitiveBase(@NotNull AttributeNode attributeNode) {
        this.x = attributeNode.getLength("x", Unit.PERCENTAGE.valueOf(0.0f));
        this.y = attributeNode.getLength("y", Unit.PERCENTAGE.valueOf(0.0f));
        this.width = attributeNode.getLength("width", Unit.PERCENTAGE.valueOf(100.0f));
        this.height = attributeNode.getLength("height", Unit.PERCENTAGE.valueOf(100.0f));
        this.inputChannel = attributeNode.getFilterChannelKey("in", DefaultFilterChannel.LastResult);
        this.resultChannel = attributeNode.getFilterChannelKey("result", DefaultFilterChannel.LastResult);
    }

    @NotNull
    public Channel channel(@NotNull FilterChannelKey filterChannelKey, @NotNull FilterContext filterContext) {
        return filterContext.getChannel(filterChannelKey);
    }

    @NotNull
    public Channel inputChannel(@NotNull FilterContext filterContext) {
        return this.channel(this.inputChannel, filterContext);
    }

    @NotNull
    public LayoutBounds layoutInput(@NotNull FilterLayoutContext filterLayoutContext) {
        return filterLayoutContext.resultChannels().get(this.inputChannel);
    }

    public void noop(@NotNull FilterContext filterContext) {
        this.saveResult(this.inputChannel(filterContext), filterContext);
    }

    public void saveLayoutResult(@NotNull LayoutBounds layoutBounds, @NotNull FilterLayoutContext filterLayoutContext) {
        this.saveResultImpl(layoutBounds, filterLayoutContext.resultChannels());
    }

    public void saveResult(@NotNull Channel channel, @NotNull FilterContext filterContext) {
        this.saveResultImpl(channel, filterContext.resultChannels());
    }

    public <T> void saveResultImpl(@NotNull T t, @NotNull ChannelStorage<T> channelStorage) {
        channelStorage.addResult(this.resultChannel, t);
        if (this.resultChannel != DefaultFilterChannel.LastResult) {
            channelStorage.addResult((FilterChannelKey)DefaultFilterChannel.LastResult, t);
        }
    }
}

