/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.mesh;

import com.github.weisj.jsvg.geometry.mesh.CoonPatch;
import com.github.weisj.jsvg.geometry.mesh.CoonValues;
import com.github.weisj.jsvg.geometry.mesh.Subdivided;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.Stop;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={})
@PermittedContent(categories={Category.Descriptive}, anyOf={Stop.class})
public final class MeshPatch
extends ContainerNode {
    public static final /* synthetic */ String TAG = "meshpatch";
    public static final /* synthetic */ int MAX_DEPTH = 10;
    public /* synthetic */ Color north;
    public /* synthetic */ Color east;
    public /* synthetic */ Color south;
    public /* synthetic */ Color west;
    @NotNull
    public final /* synthetic */ CoonPatch coonPatch;

    public MeshPatch() {
        this.coonPatch = CoonPatch.createUninitialized();
    }

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public void renderPath(@NotNull Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        float f = (float)GeometryUtil.scaleYOfTransform(affineTransform);
        float f2 = (float)GeometryUtil.scaleYOfTransform(affineTransform);
        int n = Math.max(Math.max(this.coonPatch.north.estimateStepCount(f, f2), this.coonPatch.east.estimateStepCount(f, f2)), Math.max(this.coonPatch.south.estimateStepCount(f, f2), this.coonPatch.west.estimateStepCount(f, f2)));
        this.renderPath(graphics2D, this.coonPatch, f, f2, Math.min(10, n));
    }

    public void renderPath(@NotNull Graphics2D graphics2D, @NotNull CoonPatch coonPatch, float f, float f2, int n) {
        CoonValues coonValues = coonPatch.coonValues;
        if (n == 0 || GeometryUtil.distanceSquared(coonValues.north, coonValues.south, f, f2) * GeometryUtil.distanceSquared(coonValues.east, coonValues.west, f, f2) < 1.0E-6) {
            float f3 = (coonValues.north.x + coonValues.east.x + coonValues.south.x + coonValues.west.x) / 4.0f;
            float f4 = (coonValues.north.y + coonValues.east.y + coonValues.south.y + coonValues.west.y) / 4.0f;
            GraphicsUtil.safelySetPaint(graphics2D, this.bilinearInterpolation(f3, f4));
            Shape shape = coonPatch.toShape();
            graphics2D.fill(shape.getBounds2D());
        } else {
            Subdivided<CoonPatch> subdivided = coonPatch.subdivide();
            int n2 = "\u559d\u5c72\u56c7\u6953\u6a74".length();
            int n3 = "\u697a\u624a\u536d\u6401\u6d38".length();
            int n4 = "\u5ced\u4ed6".length();
            this.renderPath(graphics2D, (CoonPatch)subdivided.northWest, f, f2, n - 1);
            int n5 = "\u549a\u6321\u6d1a".length();
            int n6 = "\u582c".length();
            int n7 = "\u6b1f\u5a51\u60a1".length();
            this.renderPath(graphics2D, (CoonPatch)subdivided.northEast, f, f2, n - 1);
            int n8 = "\u6650\u553f\u5494\u5f80\u7100".length();
            int n9 = "\u6380\u6fed\u6022\u583a".length();
            this.renderPath(graphics2D, (CoonPatch)subdivided.southEast, f, f2, n - 1);
            int n10 = "\u6577".length();
            int n11 = "\u5eee\u5007\u63ff".length();
            int n12 = "\u6cbb\u55e0".length();
            this.renderPath(graphics2D, (CoonPatch)subdivided.southWest, f, f2, n - 1);
        }
    }

    @NotNull
    public Color bilinearInterpolation(float f, float f2) {
        float f3 = GeometryUtil.lerp(f2, GeometryUtil.lerp(f, this.north.getRed(), this.east.getRed()), GeometryUtil.lerp(f, this.west.getRed(), this.south.getRed()));
        float f4 = GeometryUtil.lerp(f2, GeometryUtil.lerp(f, this.north.getGreen(), this.east.getGreen()), GeometryUtil.lerp(f, this.west.getGreen(), this.south.getGreen()));
        float f5 = GeometryUtil.lerp(f2, GeometryUtil.lerp(f, this.north.getBlue(), this.east.getBlue()), GeometryUtil.lerp(f, this.west.getBlue(), this.south.getBlue()));
        float f6 = GeometryUtil.lerp(f2, GeometryUtil.lerp(f, this.north.getAlpha(), this.east.getAlpha()), GeometryUtil.lerp(f, this.west.getAlpha(), this.south.getAlpha()));
        int n = "\u69ca\u51d0\u5aa8\u5236".length();
        int n2 = "\u6dda\u57e3\u6593\u50c3".length();
        int n3 = "\u65f5".length();
        return new Color(this.clampColor(f3), this.clampColor(f4), this.clampColor(f5), this.clampColor(f6));
    }

    public int clampColor(float f) {
        return Math.max(Math.min(255, (int)f), 0);
    }
}

