/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.prototype;

import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Transformable {
    default public boolean shouldTransform() {
        return true;
    }

    @Nullable
    public AffineTransform transform();

    @NotNull
    public Point2D transformOrigin(@NotNull MeasureContext var1);

    default public void applyTransform(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext) {
        AffineTransform affineTransform = this.transform();
        if (affineTransform != null) {
            Point2D point2D = this.transformOrigin(renderContext.measureContext());
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
            affineTransform2.concatenate(affineTransform);
            affineTransform2.translate(-point2D.getX(), -point2D.getY());
            graphics2D.transform(affineTransform2);
            renderContext.userSpaceTransform().concatenate(affineTransform2);
        }
    }

    default public Shape transformShape(@NotNull Shape shape, @NotNull MeasureContext measureContext) {
        AffineTransform affineTransform = this.transform();
        if (affineTransform != null) {
            Point2D point2D = this.transformOrigin(measureContext);
            int n = "\u6a88\u5c6c\u5813".length();
            int n2 = "\u6d29".length();
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(point2D.getX(), point2D.getY());
            affineTransform2.concatenate(affineTransform);
            affineTransform2.translate(-point2D.getX(), -point2D.getY());
            return affineTransform2.createTransformedShape(shape);
        }
        return shape;
    }
}

