/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.text.LengthAdjust;
import com.github.weisj.jsvg.nodes.text.Glyph;
import com.github.weisj.jsvg.nodes.text.TextMetrics;
import com.google.errorprone.annotations.Immutable;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class GlyphAdvancement {
    public final /* synthetic */ float spacingAdjustment;
    public final /* synthetic */ float absoluteSpacingAdjustment;
    public final /* synthetic */ float glyphAdjustment;
    public final /* synthetic */ boolean needsLastSpacing;

    public GlyphAdvancement() {
        this.spacingAdjustment = 1.0f;
        this.absoluteSpacingAdjustment = 0.0f;
        this.glyphAdjustment = 1.0f;
        this.needsLastSpacing = GlyphAdvancement.INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(0);
    }

    public GlyphAdvancement(@NotNull TextMetrics textMetrics, float f, @NotNull LengthAdjust lengthAdjust) {
        double d = (double)f - textMetrics.fixedGlyphLength();
        switch (lengthAdjust) {
            default: {
                this.spacingAdjustment = 1.0f;
                this.glyphAdjustment = 1.0f;
                if (textMetrics.glyphCount() == 0) {
                    this.absoluteSpacingAdjustment = 0.0f;
                    this.needsLastSpacing = GlyphAdvancement.INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(0);
                    break;
                }
                float f2 = (float)(d - textMetrics.glyphLength());
                int n = textMetrics.controllableLetterSpacingCount();
                if (n == 0) {
                    this.absoluteSpacingAdjustment = f2;
                    this.needsLastSpacing = GlyphAdvancement.INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(1);
                    break;
                }
                this.absoluteSpacingAdjustment = f2 / (float)n;
                this.needsLastSpacing = GlyphAdvancement.INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(0);
                break;
            }
            case SpacingAndGlyphs: {
                this.absoluteSpacingAdjustment = 0.0f;
                this.needsLastSpacing = GlyphAdvancement.INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(0);
                this.glyphAdjustment = this.spacingAdjustment = (float)(d / textMetrics.totalAdjustableLength());
            }
        }
    }

    public static /* synthetic */ GlyphAdvancement defaultAdvancement() {
        int n = "\u5f6f\u51bb\u5c22\u5c47\u56b0".length();
        int n2 = "\u5791\u56c1\u6643\u6f3d".length();
        int n3 = "\u6752\u5a77\u6c32\u6c32".length();
        int n4 = "\u66c3\u514c\u660f\u532d".length();
        return new GlyphAdvancement();
    }

    public float maxLookBehind() {
        return -Math.min(0.0f, this.absoluteSpacingAdjustment);
    }

    public float spacingAdvancement(float f) {
        return f * this.spacingAdjustment + this.absoluteSpacingAdjustment;
    }

    public float glyphAdvancement(@NotNull Glyph glyph) {
        return glyph.advance() * this.glyphAdjustment;
    }

    public boolean shouldSkipLastSpacing() {
        if (GlyphAdvancement.INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(this.needsLastSpacing ? 1 : 0) != 0) {
            return false;
        }
        return this.absoluteSpacingAdjustment != 0.0f || this.spacingAdjustment != 1.0f || this.glyphAdjustment != 1.0f;
    }

    @NotNull
    public AffineTransform glyphTransform(@NotNull AffineTransform affineTransform) {
        if (this.glyphAdjustment == 1.0f) {
            return affineTransform;
        }
        int n = "\u57ab\u6d08\u6216\u53c3\u63f0".length();
        int n2 = "\u5a0b".length();
        int n3 = "\u54b1\u6280\u5a52\u4f26".length();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.scale(this.glyphAdjustment, 1.0);
        return affineTransform2;
    }

    public String toString() {
        int n = "\u533f\u64e0\u6dc3\u6e37\u53c2".length();
        int n2 = "\u6dec".length();
        int n3 = "\u6a1b\u6110".length();
        return "GlyphAdvancement{spacingAdjustment=" + this.spacingAdjustment + ", absoluteSpacingAdjustment=" + this.absoluteSpacingAdjustment + ", glyphAdjustment=" + this.glyphAdjustment + ", needsLastSpacing=" + (GlyphAdvancement.INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(this.needsLastSpacing ? 1 : 0) != 0) + '}';
    }

    public static int INSOLENCE_\u6288\u502e\u688d\u6dbc\u7136\u5d47\u6cce\u61a1\u682f\u65e9\u6935\u52e7\u4fb7\u6589\u6779\u5b35\u550b\u5645\u4ee4\u65d9\u5544\u6e4a\u671b\u5aa0\u62aa\u595f\u59dd\u537e\u551a\u5c96\u65c6\u4ed3\u5997\u5bdf\u650d\u65f4\u70ce\u6272\u50e3\u5f27\u5a09(int n) {
        return n;
    }
}

