/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.PaintOrder;
import com.github.weisj.jsvg.attributes.VectorEffect;
import com.github.weisj.jsvg.attributes.font.AttributeFontSpec;
import com.github.weisj.jsvg.attributes.font.FontParser;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.attributes.text.LengthAdjust;
import com.github.weisj.jsvg.attributes.text.TextAnchor;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.container.BaseContainerNode;
import com.github.weisj.jsvg.nodes.prototype.HasContext;
import com.github.weisj.jsvg.nodes.prototype.HasShape;
import com.github.weisj.jsvg.nodes.prototype.HasVectorEffects;
import com.github.weisj.jsvg.nodes.prototype.Renderable;
import com.github.weisj.jsvg.nodes.prototype.impl.HasContextImpl;
import com.github.weisj.jsvg.nodes.text.GlyphAdvancement;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.GlyphRenderer;
import com.github.weisj.jsvg.nodes.text.StringTextSegment;
import com.github.weisj.jsvg.nodes.text.TextMetrics;
import com.github.weisj.jsvg.nodes.text.TextSegment;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextContainer
extends BaseContainerNode<TextSegment>
implements TextSegment.RenderableSegment,
HasShape,
HasContext.ByDelegate,
HasVectorEffects,
Renderable {
    public final /* synthetic */ List<@NotNull TextSegment> segments;
    public /* synthetic */ PaintOrder paintOrder;
    public /* synthetic */ AttributeFontSpec fontSpec;
    public /* synthetic */ LengthAdjust lengthAdjust;
    public /* synthetic */ Length textLength;
    public /* synthetic */ boolean isVisible;
    public /* synthetic */ HasContext context;
    public /* synthetic */ Set<VectorEffect> vectorEffects;

    public TextContainer() {
        this.segments = new ArrayList<TextSegment>();
    }

    @Override
    @MustBeInvokedByOverriders
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.paintOrder = PaintOrder.parse(attributeNode);
        this.fontSpec = FontParser.parseFontSpec(attributeNode);
        this.lengthAdjust = attributeNode.getEnum("lengthAdjust", LengthAdjust.Spacing);
        this.textLength = attributeNode.getLength("textLength", Length.UNSPECIFIED);
        if (this.textLength.raw() < 0.0f) {
            this.textLength = Length.UNSPECIFIED;
        }
        this.isVisible = TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.parseIsVisible(attributeNode) ? 1 : 0));
        this.context = HasContextImpl.parse(attributeNode);
        this.vectorEffects = VectorEffect.parse(attributeNode);
    }

    @Override
    @NotNull
    public Set<VectorEffect> vectorEffects() {
        return this.vectorEffects;
    }

    @Override
    @NotNull
    public HasContext contextDelegate() {
        return this.context;
    }

    @Override
    public boolean acceptChild(@Nullable String string, @NotNull SVGNode sVGNode) {
        return sVGNode instanceof TextSegment;
    }

    @Override
    public void doAdd(@NotNull SVGNode sVGNode) {
        TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.segments.add((TextSegment)((Object)sVGNode)) ? 1 : 0);
        int n = "\u6f54\u5099\u5e71".length();
        int n2 = "\u6255\u6134".length();
    }

    @Override
    public final void addContent(char[] cArray) {
        if (cArray.length == 0) {
            return;
        }
        int n = "\u703c\u5255\u6ec9\u5507\u69a1".length();
        int n2 = "\u6549\u6099\u5f9b".length();
        TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.segments.add(new StringTextSegment(this, this.segments.size(), cArray)) ? 1 : 0);
        int n3 = "\u67b6\u560e\u5a8c\u5d81".length();
    }

    @Override
    public List<? extends @NotNull TextSegment> children() {
        return this.segments;
    }

    public abstract GlyphCursor createLocalCursor(@NotNull RenderContext var1, @NotNull GlyphCursor var2);

    public abstract void cleanUpLocalCursor(@NotNull GlyphCursor var1, @NotNull GlyphCursor var2);

    public final void renderSegment(@NotNull GlyphCursor glyphCursor, @NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D) {
        this.prepareSegmentForRendering(glyphCursor, renderContext);
        double d = this.textAnchorOffset(renderContext.fontRenderContext().textAnchor(), glyphCursor);
        renderContext.translate(graphics2D, -d, 0.0);
        this.renderSegmentWithoutLayout(glyphCursor, renderContext, graphics2D);
    }

    public double textAnchorOffset(@NotNull TextAnchor textAnchor, @NotNull GlyphCursor glyphCursor) {
        switch (textAnchor) {
            default: {
                return 0.0;
            }
            case Middle: {
                return glyphCursor.completeGlyphRunBounds.getWidth() / 2.0;
            }
            case End: 
        }
        return glyphCursor.completeGlyphRunBounds.getWidth();
    }

    public void forEachSegment(@NotNull RenderContext renderContext, @NotNull BiConsumer<StringTextSegment, RenderContext> biConsumer, @NotNull BiConsumer<TextSegment.RenderableSegment, RenderContext> biConsumer2) {
        Iterator<? extends TextSegment> iterator = this.children().iterator();
        while (TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(iterator.hasNext() ? 1 : 0) != 0) {
            TextSegment textSegment = iterator.next();
            RenderContext renderContext2 = renderContext;
            if (textSegment instanceof Renderable) {
                renderContext2 = NodeRenderer.setupRenderContext(textSegment, renderContext);
            }
            if (textSegment instanceof StringTextSegment) {
                biConsumer.accept((StringTextSegment)textSegment, renderContext2);
                continue;
            }
            if (textSegment instanceof TextSegment.RenderableSegment) {
                biConsumer2.accept((TextSegment.RenderableSegment)textSegment, renderContext2);
                continue;
            }
            int n = "\u61d8\u5a92\u68da".length();
            int n2 = "\u5b83\u6f62\u5d32".length();
            int n3 = "\u5fef\u6d29\u671d".length();
            int n4 = "\u5386\u5f0d\u556e\u586a".length();
            int n5 = "\u6880".length();
            throw new IllegalStateException("Unexpected segment " + textSegment);
        }
    }

    @Override
    @NotNull
    public TextMetrics computeTextMetrics(@NotNull RenderContext renderContext, @NotNull TextSegment.RenderableSegment.UseTextLengthForCalculation useTextLengthForCalculation) {
        if (useTextLengthForCalculation == TextSegment.RenderableSegment.UseTextLengthForCalculation.YES && TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.hasFixedLength() ? 1 : 0) != 0) {
            int n = "\u61f7\u65a3\u5b33".length();
            return new TextMetrics(0.0, 0.0, 0, this.textLength.resolveLength(renderContext.measureContext()), 0);
        }
        SVGFont sVGFont = renderContext.font();
        float f = renderContext.fontRenderContext().letterSpacing().resolveLength(renderContext.measureContext());
        int n = "\u700d\u5422\u6677".length();
        int n2 = "\u6086\u6f85\u5019\u7068".length();
        IntermediateTextMetrics intermediateTextMetrics = new IntermediateTextMetrics(null);
        int n3 = 0;
        Iterator<? extends TextSegment> iterator = this.children().iterator();
        while (TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(iterator.hasNext() ? 1 : 0) != 0) {
            TextSegment textSegment = iterator.next();
            RenderContext renderContext2 = renderContext;
            if (textSegment instanceof Renderable) {
                renderContext2 = NodeRenderer.setupRenderContext(textSegment, renderContext);
            }
            if (textSegment instanceof StringTextSegment) {
                StringTextSegment stringTextSegment = (StringTextSegment)textSegment;
                this.accumulateSegmentMetrics(intermediateTextMetrics, stringTextSegment, sVGFont, f, n3);
            } else if (textSegment instanceof TextSegment.RenderableSegment) {
                this.accumulateRenderableSegmentMetrics((TextSegment.RenderableSegment)textSegment, intermediateTextMetrics, renderContext2);
            } else {
                int n4 = "\u5d3a\u4fb2".length();
                int n5 = "\u6874\u6196\u6043\u679f".length();
                int n6 = "\u510d\u57be\u595b\u6818\u5e66".length();
                int n7 = "\u6bba\u661e\u7067\u5751\u7017".length();
                int n8 = "\u6c4b".length();
                int n9 = "\u6f5d".length();
                int n10 = "\u6f0c\u5ed7\u63a9\u61b6\u5a54".length();
                int n11 = "\u63bc".length();
                throw new IllegalStateException("Unexpected segment " + textSegment);
            }
            n3 += 27151;
            n3 -= 27150;
        }
        int n12 = "\u5d95\u5190".length();
        int n13 = "\u663e".length();
        int n14 = "\u5aa6\u6ad3\u629f\u66aa\u5739".length();
        return new TextMetrics(intermediateTextMetrics.letterSpacingLength, intermediateTextMetrics.glyphLength, intermediateTextMetrics.glyphCount, intermediateTextMetrics.fixedGlyphLength, intermediateTextMetrics.controllableLetterSpacingCount);
    }

    public void accumulateRenderableSegmentMetrics(@NotNull TextSegment.RenderableSegment renderableSegment, @NotNull IntermediateTextMetrics intermediateTextMetrics, @NotNull RenderContext renderContext) {
        TextMetrics textMetrics = renderableSegment.computeTextMetrics(renderContext, TextSegment.RenderableSegment.UseTextLengthForCalculation.YES);
        int n = "\u6f37\u5997\u6419\u645f".length();
        int n2 = "\u5ef7\u6907\u52c1\u6c0a\u6891".length();
        int n3 = "\u62b7".length();
        intermediateTextMetrics.letterSpacingLength += textMetrics.letterSpacingLength();
        int n4 = "\u66f7".length();
        int n5 = "\u4f03".length();
        intermediateTextMetrics.glyphLength += textMetrics.glyphLength();
        int n6 = "\u51bb\u608a\u61aa\u66a9".length();
        int n7 = "\u52e9".length();
        intermediateTextMetrics.glyphCount = TextContainer.INSOLENCE_\u5ffd\u5752\u56b0\u60b6\u56cf\u60ee\u595a\u6e66\u590f\u64d7\u67dc\u5b50\u6082\u538a\u5fd5\u6c95\u6d49\u558e\u6b77\u5486\u6bde\u6088\u63b6\u6f22\u6585\u53fc\u65bd\u7114\u6dcd\u553b\u6a54\u50a6\u6e76\u69c2\u5017\u5c09\u65a3\u532c\u6534\u5f08\u6190(intermediateTextMetrics.glyphCount, textMetrics.glyphCount());
        int n8 = "\u53f4".length();
        intermediateTextMetrics.fixedGlyphLength += textMetrics.fixedGlyphLength();
        int n9 = "\u5798\u6e52\u5cca".length();
        int n10 = "\u57b7\u6d9c\u53ab\u52d9\u61a7".length();
        int n11 = "\u533b\u6e18\u6f09".length();
        int n12 = "\u4fc8\u5c1c\u6b5b".length();
        intermediateTextMetrics.controllableLetterSpacingCount = TextContainer.INSOLENCE_\u5ffd\u5752\u56b0\u60b6\u56cf\u60ee\u595a\u6e66\u590f\u64d7\u67dc\u5b50\u6082\u538a\u5fd5\u6c95\u6d49\u558e\u6b77\u5486\u6bde\u6088\u63b6\u6f22\u6585\u53fc\u65bd\u7114\u6dcd\u553b\u6a54\u50a6\u6e76\u69c2\u5017\u5c09\u65a3\u532c\u6534\u5f08\u6190(intermediateTextMetrics.controllableLetterSpacingCount, textMetrics.controllableLetterSpacingCount());
    }

    public void accumulateSegmentMetrics(@NotNull IntermediateTextMetrics intermediateTextMetrics, @NotNull StringTextSegment stringTextSegment, @NotNull SVGFont sVGFont, float f, int n) {
        int n2;
        boolean bl;
        int n3 = stringTextSegment.codepoints().length;
        int n4 = "\u5ef0".length();
        int n5 = "\u5e39".length();
        int n6 = "\u6cae\u65b4\u5e5b".length();
        boolean bl2 = bl = n == this.children().size() - 1;
        if (bl) {
            int n7 = "\u55e5\u69af\u68a9\u65e6".length();
            n2 = n3 - 1;
        } else {
            n2 = n3;
        }
        int n8 = n2;
        int n9 = "\u6b1e\u6bf4\u5395\u5c47\u55ff".length();
        int n10 = "\u56f1\u55eb\u555e\u542e".length();
        intermediateTextMetrics.glyphCount = TextContainer.INSOLENCE_\u5ffd\u5752\u56b0\u60b6\u56cf\u60ee\u595a\u6e66\u590f\u64d7\u67dc\u5b50\u6082\u538a\u5fd5\u6c95\u6d49\u558e\u6b77\u5486\u6bde\u6088\u63b6\u6f22\u6585\u53fc\u65bd\u7114\u6dcd\u553b\u6a54\u50a6\u6e76\u69c2\u5017\u5c09\u65a3\u532c\u6534\u5f08\u6190(intermediateTextMetrics.glyphCount, n3);
        int n11 = "\u6965\u696f\u5d72\u6826".length();
        int n12 = "\u5183\u5ed0".length();
        int n13 = "\u5f07\u7146\u67bd\u4fd5\u5056".length();
        int n14 = "\u623d\u575f\u63e8\u5d2d\u55ac".length();
        intermediateTextMetrics.letterSpacingLength += (double)((float)n8 * f);
        int n15 = "\u6c8a\u65cc\u6f87\u6e84\u67f6".length();
        int n16 = "\u577d".length();
        intermediateTextMetrics.controllableLetterSpacingCount = TextContainer.INSOLENCE_\u5ffd\u5752\u56b0\u60b6\u56cf\u60ee\u595a\u6e66\u590f\u64d7\u67dc\u5b50\u6082\u538a\u5fd5\u6c95\u6d49\u558e\u6b77\u5486\u6bde\u6088\u63b6\u6f22\u6585\u53fc\u65bd\u7114\u6dcd\u553b\u6a54\u50a6\u6e76\u69c2\u5017\u5c09\u65a3\u532c\u6534\u5f08\u6190(intermediateTextMetrics.controllableLetterSpacingCount, n8);
        char[] cArray = stringTextSegment.codepoints();
        int n17 = cArray.length;
        for (int i = 0; i < n17; i -= 2443) {
            char c = cArray[i];
            int n18 = "\u5618\u6767\u5b0d\u651b".length();
            int n19 = "\u5630\u68e4\u6179\u616f\u52ae".length();
            intermediateTextMetrics.glyphLength += (double)sVGFont.codepointGlyph(c).advance();
            i += 2444;
        }
    }

    @Override
    public boolean hasFixedLength() {
        return TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.textLength.isSpecified() ? 1 : 0) != 0;
    }

    @Override
    public void renderSegmentWithoutLayout(@NotNull GlyphCursor glyphCursor, @NotNull RenderContext renderContext2, @NotNull Graphics2D graphics2D) {
        this.forEachSegment(renderContext2, (stringTextSegment, renderContext) -> {
            if (TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.isVisible((RenderContext)renderContext) ? 1 : 0) != 0) {
                GlyphRenderer.renderGlyphRun(graphics2D, this.paintOrder, this.vectorEffects(), stringTextSegment, glyphCursor.completeGlyphRunBounds);
            }
        }, (renderableSegment, renderContext) -> renderableSegment.renderSegmentWithoutLayout(glyphCursor, (RenderContext)renderContext, graphics2D));
    }

    @Override
    public void prepareSegmentForRendering(@NotNull GlyphCursor glyphCursor, @NotNull RenderContext renderContext2) {
        SVGFont sVGFont = renderContext2.font();
        GlyphCursor glyphCursor2 = this.createLocalCursor(renderContext2, glyphCursor);
        glyphCursor2.setAdvancement(this.localGlyphAdvancement(renderContext2, glyphCursor));
        this.forEachSegment(renderContext2, (stringTextSegment, renderContext) -> GlyphRenderer.prepareGlyphRun(stringTextSegment, glyphCursor2, sVGFont, renderContext), (renderableSegment, renderContext) -> renderableSegment.prepareSegmentForRendering(glyphCursor2, (RenderContext)renderContext));
        this.cleanUpLocalCursor(glyphCursor, glyphCursor2);
    }

    @Override
    public void appendTextShape(@NotNull GlyphCursor glyphCursor, @NotNull Path2D path2D, @NotNull RenderContext renderContext2) {
        SVGFont sVGFont = renderContext2.font();
        GlyphCursor glyphCursor2 = this.createLocalCursor(renderContext2, glyphCursor);
        glyphCursor2.setAdvancement(this.localGlyphAdvancement(renderContext2, glyphCursor));
        this.forEachSegment(renderContext2, (stringTextSegment, renderContext) -> path2D.append(GlyphRenderer.layoutGlyphRun(stringTextSegment, glyphCursor2, sVGFont, renderContext.measureContext(), renderContext.fontRenderContext()), false), (renderableSegment, renderContext) -> renderableSegment.appendTextShape(glyphCursor2, path2D, (RenderContext)renderContext));
        this.cleanUpLocalCursor(glyphCursor, glyphCursor2);
    }

    @NotNull
    public GlyphAdvancement localGlyphAdvancement(@NotNull RenderContext renderContext, @NotNull GlyphCursor glyphCursor) {
        if (TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.hasFixedLength() ? 1 : 0) != 0) {
            int n = "\u4e4c\u5669\u608e".length();
            int n2 = "\u5dc8\u4f22".length();
            int n3 = "\u5e7b\u59d6\u55d6".length();
            return new GlyphAdvancement(this.computeTextMetrics(renderContext, TextSegment.RenderableSegment.UseTextLengthForCalculation.NO), this.textLength.resolveWidth(renderContext.measureContext()), this.lengthAdjust);
        }
        return glyphCursor.advancement();
    }

    @Override
    @NotNull
    public Rectangle2D untransformedElementBounds(@NotNull RenderContext renderContext) {
        return this.untransformedElementShape(renderContext).getBounds2D();
    }

    @Override
    public boolean isVisible(@NotNull RenderContext renderContext) {
        return TextContainer.INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(this.isVisible ? 1 : 0) != 0;
    }

    public static int INSOLENCE_\u65c7\u51fd\u5e29\u6c95\u549a\u566a\u5e03\u5639\u6ca8\u713d\u6f3e\u5548\u56cf\u5fb6\u6589\u5105\u68d5\u4e7d\u5e2e\u5355\u594b\u59f8\u5eb0\u6d81\u645f\u6596\u6117\u6b07\u66c3\u4eec\u55d7\u58c5\u65b9\u6cdd\u6bb7\u68e9\u6af9\u7032\u57ed\u5d2f\u5eb4(int n) {
        return n;
    }

    public static int INSOLENCE_\u5ffd\u5752\u56b0\u60b6\u56cf\u60ee\u595a\u6e66\u590f\u64d7\u67dc\u5b50\u6082\u538a\u5fd5\u6c95\u6d49\u558e\u6b77\u5486\u6bde\u6088\u63b6\u6f22\u6585\u53fc\u65bd\u7114\u6dcd\u553b\u6a54\u50a6\u6e76\u69c2\u5017\u5c09\u65a3\u532c\u6534\u5f08\u6190(int n, int n2) {
        return ((n | n2) << 1) + ~(n ^ n2) + 1;
    }

    private static final class IntermediateTextMetrics {
        public /* synthetic */ double letterSpacingLength;
        public /* synthetic */ double glyphLength;
        public /* synthetic */ double fixedGlyphLength;
        public /* synthetic */ int glyphCount;
        public /* synthetic */ int controllableLetterSpacingCount;

        public IntermediateTextMetrics() {
            this.letterSpacingLength = 0.0;
            this.glyphLength = 0.0;
            this.fixedGlyphLength = 0.0;
            this.glyphCount = 0;
            this.controllableLetterSpacingCount = 0;
        }

        public /* synthetic */ IntermediateTextMetrics(1 var1_1) {
            this();
        }
    }
}

