/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.attributes.text.GlyphRenderMethod;
import com.github.weisj.jsvg.attributes.text.Side;
import com.github.weisj.jsvg.attributes.text.Spacing;
import com.github.weisj.jsvg.geometry.SVGShape;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.geometry.util.ReversePathIterator;
import com.github.weisj.jsvg.nodes.Anchor;
import com.github.weisj.jsvg.nodes.ShapeNode;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.AnimateTransform;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.PathGlyphCursor;
import com.github.weisj.jsvg.nodes.text.TextContainer;
import com.github.weisj.jsvg.nodes.text.TextSpan;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.PathUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.Graphic, Category.TextContent, Category.TextContentChild})
@PermittedContent(categories={Category.Descriptive}, anyOf={Anchor.class, TextSpan.class, Animate.class, AnimateTransform.class, Set.class}, charData=true)
public final class TextPath
extends TextContainer {
    public static final /* synthetic */ String TAG = "textpath";
    public static final /* synthetic */ boolean DEBUG = false;
    public /* synthetic */ SVGShape pathShape;
    public /* synthetic */ Spacing spacing;
    public /* synthetic */ GlyphRenderMethod renderMethod;
    public /* synthetic */ Side side;
    public /* synthetic */ Length startOffset;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.renderMethod = attributeNode.getEnum("method", GlyphRenderMethod.Align);
        this.side = attributeNode.getEnum("side", Side.Left);
        this.spacing = attributeNode.getEnum("spacing", Spacing.Auto);
        this.startOffset = attributeNode.getLength("startOffset", 0.0f);
        String string = attributeNode.getValue("path");
        if (string != null) {
            this.pathShape = PathUtil.parseFromPathData(string, FillRule.EvenOdd);
        } else {
            String string2 = attributeNode.getHref();
            ShapeNode shapeNode = attributeNode.getElementByHref(ShapeNode.class, Category.Shape, string2);
            if (shapeNode != null) {
                this.pathShape = shapeNode.shape();
            }
        }
    }

    @Override
    public boolean isVisible(@NotNull RenderContext renderContext) {
        return this.pathShape != null && TextPath.INSOLENCE_\u6567\u4e85\u6c13\u6b49\u69dd\u53d8\u53f5\u60c0\u58cf\u685f\u56b9\u70b3\u5e7c\u644c\u7028\u5a48\u6c23\u572d\u504a\u4f8b\u5e18\u6008\u585e\u5c00\u5db3\u6e53\u6a1a\u651c\u6e82\u643a\u6891\u571d\u6c87\u577d\u538a\u6d54\u6d57\u6d1f\u50cc\u6695\u5645(super.isVisible(renderContext) ? 1 : 0) != 0;
    }

    @Override
    @NotNull
    public Shape untransformedElementShape(@NotNull RenderContext renderContext) {
        int n = "\u6685\u5a67".length();
        int n2 = "\u5942\u4eb6\u5656\u5591\u6670".length();
        int n3 = "\u6cfd".length();
        Path2D.Float float_ = new Path2D.Float();
        this.appendTextShape(this.createCursor(renderContext), float_, renderContext);
        return float_;
    }

    @Override
    public void render(@NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D) {
        this.renderSegment(this.createCursor(renderContext), renderContext, graphics2D);
    }

    @NotNull
    public PathGlyphCursor createCursor(@NotNull RenderContext renderContext) {
        int n = "\u711d\u6ec8".length();
        int n2 = "\u6fae".length();
        int n3 = "\u5a55\u5f2c\u5ef3\u5f62\u5ac3".length();
        return new PathGlyphCursor(this.createPathIterator(renderContext), this.startOffset.resolveLength(renderContext.measureContext()));
    }

    public void paintDebugPath(@NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D) {
        PathIterator pathIterator = this.createPathIterator(renderContext);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = "\u5ef6".length();
        int n2 = "\u64db\u58ed\u5fce\u4e90\u63c3".length();
        graphics2D.setStroke(new BasicStroke(0.5f));
        float[] fArray = new float[2];
        while (TextPath.INSOLENCE_\u6567\u4e85\u6c13\u6b49\u69dd\u53d8\u53f5\u60c0\u58cf\u685f\u56b9\u70b3\u5e7c\u644c\u7028\u5a48\u6c23\u572d\u504a\u4f8b\u5e18\u6008\u585e\u5c00\u5db3\u6e53\u6a1a\u651c\u6e82\u643a\u6891\u571d\u6c87\u577d\u538a\u6d54\u6d57\u6d1f\u50cc\u6695\u5645(pathIterator.isDone() ? 1 : 0) == 0) {
            switch (pathIterator.currentSegment(fArray)) {
                case 1: {
                    graphics2D.setColor(Color.MAGENTA);
                    int n3 = "\u5b39\u65e7\u520e\u6108".length();
                    int n4 = "\u4e58\u5347\u5d17\u5f7f\u5ec1".length();
                    int n5 = "\u685b\u5386\u5b54\u6da5".length();
                    graphics2D.draw(new Line2D.Float(f3, f4, fArray[0], fArray[1]));
                    graphics2D.setColor(Color.RED);
                    int n6 = "\u6351\u5b88".length();
                    int n7 = "\u547c\u5209\u4f78".length();
                    int n8 = "\u4f90\u562d\u65b7\u59dc\u505c".length();
                    int n9 = "\u60d9\u6cfe\u6203\u6dc0\u645e".length();
                    graphics2D.fillRect((int)f3 - 2, (int)f4 - 2, 4, 4);
                    int n10 = "\u670d\u7087\u61ef".length();
                    int n11 = "\u5010".length();
                    int n12 = "\u5cc5".length();
                    int n13 = "\u50a8\u6d52\u5cb8\u567f\u6259".length();
                    graphics2D.fillRect((int)fArray[0] - 2, (int)fArray[1] - 2, 4, 4);
                    f3 = fArray[0];
                    f4 = fArray[1];
                    break;
                }
                case 0: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    f = f3;
                    f2 = f4;
                    break;
                }
                case 4: {
                    graphics2D.setColor(Color.MAGENTA);
                    int n14 = "\u4f3f\u5341\u51b8".length();
                    int n15 = "\u5fb8\u5594\u4ec4\u609c\u5dcd".length();
                    graphics2D.draw(new Line2D.Float(f3, f4, f, f2));
                    graphics2D.setColor(Color.RED);
                    int n16 = "\u6371\u6286\u6227".length();
                    int n17 = "\u7047\u60ae".length();
                    int n18 = "\u692f".length();
                    int n19 = "\u6b15".length();
                    int n20 = "\u6a3c\u5075".length();
                    int n21 = "\u5542\u6b5d".length();
                    graphics2D.fillRect((int)f3 - 2, (int)f4 - 2, 4, 4);
                    int n22 = "\u6bf4\u58a9".length();
                    int n23 = "\u52d7".length();
                    int n24 = "\u57d2\u5bc7".length();
                    int n25 = "\u5e05\u5f11\u64be\u5f18".length();
                    int n26 = "\u6277\u5464\u5d57\u6897\u59b7".length();
                    int n27 = "\u5aa3".length();
                    graphics2D.fillRect((int)f - 2, (int)f2 - 2, 4, 4);
                    f3 = f;
                    f4 = f2;
                    break;
                }
                default: {
                    int n28 = "\u51b0".length();
                    int n29 = "\u644e\u51c5".length();
                    int n30 = "\u56dd\u6854\u64ee\u5371\u6970".length();
                    int n31 = "\u4f8e\u567b".length();
                    int n32 = "\u5e0f\u65a3\u5dfc\u6fd5".length();
                    int n33 = "\u52bf\u6e57".length();
                    throw new IllegalStateException();
                }
            }
            pathIterator.next();
        }
    }

    @NotNull
    public PathIterator createPathIterator(@NotNull RenderContext renderContext) {
        MeasureContext measureContext = renderContext.measureContext();
        Shape shape = this.pathShape.shape(renderContext);
        float f = 0.1f * measureContext.ex();
        switch (this.side) {
            case Left: {
                return shape.getPathIterator(null, f);
            }
            case Right: {
                int n = "\u5c26\u5e31\u5afb".length();
                int n2 = "\u4fe3\u6516\u5a15".length();
                int n3 = "\u546a\u65cc".length();
                return new ReversePathIterator(shape.getPathIterator(null, f));
            }
        }
        int n = "\u6408\u5de2\u545f".length();
        int n4 = "\u690c\u5aa9\u5a71\u6cc5".length();
        int n5 = "\u6b4b\u5467\u6ea4".length();
        int n6 = "\u5967\u52e1".length();
        int n7 = "\u6836\u569b\u5442\u60da\u6b53".length();
        throw new IllegalStateException();
    }

    @Override
    public GlyphCursor createLocalCursor(@NotNull RenderContext renderContext, @NotNull GlyphCursor glyphCursor) {
        int n = "\u664e\u5424\u5545\u511e".length();
        int n2 = "\u6eb0\u6ca1\u4ef3".length();
        int n3 = "\u6545\u612b\u6fcf\u5e16\u621d".length();
        return new PathGlyphCursor(glyphCursor, this.startOffset.resolveLength(renderContext.measureContext()), this.createPathIterator(renderContext));
    }

    @Override
    public void cleanUpLocalCursor(@NotNull GlyphCursor glyphCursor, @NotNull GlyphCursor glyphCursor2) {
        glyphCursor.updateFrom(glyphCursor2);
    }

    public static int INSOLENCE_\u6567\u4e85\u6c13\u6b49\u69dd\u53d8\u53f5\u60c0\u58cf\u685f\u56b9\u70b3\u5e7c\u644c\u7028\u5a48\u6c23\u572d\u504a\u4f8b\u5e18\u6008\u585e\u5c00\u5db3\u6e53\u6a1a\u651c\u6e82\u643a\u6891\u571d\u6c87\u577d\u538a\u6d54\u6d57\u6d1f\u50cc\u6695\u5645(int n) {
        return n;
    }
}

