/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Mask;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.parser.LoadHelper;
import com.github.weisj.jsvg.parser.ParsedElement;
import com.github.weisj.jsvg.parser.ResourceLoader;
import com.github.weisj.jsvg.parser.SeparatorMode;
import com.github.weisj.jsvg.parser.css.StyleSheet;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeNode {
    public static final /* synthetic */ Length TopOrLeft;
    public static final /* synthetic */ Length Center;
    public static final /* synthetic */ Length BottomOrRight;
    @NotNull
    public final /* synthetic */ String tagName;
    @NotNull
    public final /* synthetic */ Map<String, String> attributes;
    @Nullable
    public final /* synthetic */ AttributeNode parent;
    @NotNull
    public final /* synthetic */ @NotNull Map<@NotNull String, @NotNull Object> namedElements;
    @NotNull
    public final /* synthetic */ @NotNull List<@NotNull StyleSheet> styleSheets;
    @NotNull
    public final /* synthetic */ LoadHelper loadHelper;

    public AttributeNode(@NotNull String string, @NotNull Map<String, String> map, @Nullable AttributeNode attributeNode, @NotNull @NotNull Map<@NotNull String, @NotNull Object> map2, @NotNull @NotNull List<@NotNull StyleSheet> list, @NotNull LoadHelper loadHelper) {
        this.tagName = string;
        this.attributes = map;
        this.parent = attributeNode;
        this.namedElements = map2;
        this.styleSheets = list;
        this.loadHelper = loadHelper;
    }

    public void prepareForNodeBuilding(@NotNull ParsedElement parsedElement) {
        int n = "\u6d01\u634d\u622f".length();
        int n2 = "\u5d42\u6f0c".length();
        int n3 = "\u566a".length();
        int n4 = "\u5dc5\u5fa6\u6b3c\u5277\u6555".length();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AttributeNode.preprocessAttributes(this.attributes, hashMap);
        List<StyleSheet> list = this.styleSheets();
        int n5 = "\u589a\u6dbd\u65bc\u5fbe".length();
        int n6 = "\u5c70".length();
        for (int i = list.size() - 1; i >= 0; i -= 32063) {
            StyleSheet styleSheet = list.get(i);
            styleSheet.forEachMatchingRule(parsedElement, styleProperty -> {
                if (AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(hashMap.containsKey(styleProperty.name()) ? 1 : 0) == 0) {
                    hashMap.put(styleProperty.name(), styleProperty.value());
                    int n = "\u5351\u58ab\u4f84".length();
                    int n2 = "\u65e4\u5a69\u6cfb".length();
                    int n3 = "\u5bae".length();
                }
            });
            i += 32062;
        }
        this.attributes.putAll(hashMap);
    }

    public static /* synthetic */ boolean isBlank(@NotNull String string) {
        return AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(string.trim().isEmpty() ? 1 : 0) != 0;
    }

    public static /* synthetic */ void preprocessAttributes(@NotNull Map<String, String> map, @NotNull Map<String, String> map2) {
        String string = map.get("style");
        if (string != null && AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(AttributeNode.isBlank(string) ? 1 : 0) == 0) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(";");
            int n = stringArray2.length;
            for (int i = 0; i < n; i -= 7186) {
                String string2 = stringArray2[i];
                if (AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(AttributeNode.isBlank(string2) ? 1 : 0) == 0) {
                    String[] stringArray3 = string2.split(":", 2);
                    map2.put(stringArray3[0].trim().toLowerCase(Locale.ENGLISH), stringArray3[1].trim());
                    int n2 = "\u6b58\u68cd\u6207".length();
                }
                i += 7187;
            }
        }
    }

    @NotNull
    public Map<String, Object> namedElements() {
        return this.namedElements;
    }

    @NotNull
    public @NotNull List<@NotNull StyleSheet> styleSheets() {
        return this.styleSheets;
    }

    @Nullable
    public <T> T getElementById(@NotNull Class<T> clazz, @Nullable String string) {
        if (string == null) {
            return null;
        }
        Object object = this.namedElements.get(string);
        if (object instanceof ParsedElement) {
            object = ((ParsedElement)object).nodeEnsuringBuildStatus();
        }
        return AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(clazz.isInstance(object) ? 1 : 0) != 0 ? (T)clazz.cast(object) : null;
    }

    @Nullable
    public <T> T getElementByUrl(@NotNull Class<T> clazz, @Nullable String string) {
        String string2 = this.loadHelper.attributeParser().parseUrl(string);
        if (string2 != null && AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(string2.startsWith("#") ? 1 : 0) != 0) {
            string2 = string2.substring(1);
        }
        return this.getElementById(clazz, string2);
    }

    @Nullable
    public <T> T getElementByHref(@NotNull Class<T> clazz, @Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.getElementByUrl(clazz, string);
    }

    @Nullable
    public <T> T getElementByHref(@NotNull Class<T> clazz, @NotNull Category category, @Nullable String string) {
        T t = this.getElementByHref(clazz, string);
        if (t == null) {
            return null;
        }
        Category[] categoryArray = t.getClass().getAnnotation(ElementCategories.class).value();
        int n = categoryArray.length;
        for (int i = 0; i < n; i -= 10846) {
            Category category2 = categoryArray[i];
            if (category2 == category) {
                return t;
            }
            i += 10847;
        }
        return null;
    }

    @NotNull
    public Map<String, String> attributes() {
        return this.attributes;
    }

    @NotNull
    public String tagName() {
        return this.tagName;
    }

    public boolean tagIsOneOf(@NotNull String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; i -= 24382) {
            String string = stringArray2[i];
            if (AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(this.tagName.equals(string) ? 1 : 0) != 0) {
                return true;
            }
            i += 24383;
        }
        return false;
    }

    @Nullable
    public AttributeNode parent() {
        return this.parent;
    }

    @Nullable
    public String getValue(@NotNull String string) {
        return this.attributes.get(string);
    }

    @NotNull
    public Color getColor(@NotNull String string) {
        return this.getColor(string, PaintParser.DEFAULT_COLOR);
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public Color getColor(@NotNull String string, @Nullable Color color) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return color;
        }
        Color color2 = this.loadHelper.attributeParser().paintParser().parseColor(string2.toLowerCase(Locale.ENGLISH), this);
        return color2 != null ? color2 : color;
    }

    @NotNull
    public SVGPaint getPaint(@NotNull String string, @NotNull SVGPaint sVGPaint) {
        SVGPaint sVGPaint2 = this.getPaint(string);
        return sVGPaint2 != null ? sVGPaint2 : sVGPaint;
    }

    @Nullable
    public SVGPaint getPaint(@NotNull String string) {
        String string2 = this.getValue(string);
        SVGPaint sVGPaint = this.getElementByUrl(SVGPaint.class, string2);
        if (sVGPaint != null) {
            return sVGPaint;
        }
        return this.loadHelper.attributeParser().parsePaint(string2, this);
    }

    @Nullable
    public Length getLength(@NotNull String string) {
        return this.getLengthInternal(string, null);
    }

    @NotNull
    public Length getLength(@NotNull String string, float f) {
        return this.getLength(string, Unit.Raw.valueOf(f));
    }

    @NotNull
    public Length getLength(@NotNull String string, @NotNull Length length) {
        return this.getLengthInternal(string, length);
    }

    @Contract(value="_,!null -> !null")
    @Nullable
    public Length getLengthInternal(@NotNull String string, @Nullable Length length) {
        return this.loadHelper.attributeParser().parseLength(this.getValue(string), length);
    }

    @NotNull
    public Length getHorizontalReferenceLength(@NotNull String string) {
        return this.parseReferenceLength(string, "left", "right");
    }

    @NotNull
    public Length getVerticalReferenceLength(@NotNull String string) {
        return this.parseReferenceLength(string, "top", "bottom");
    }

    @NotNull
    public Length parseReferenceLength(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        String string4 = this.getValue(string);
        if (AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(string2.equals(string4) ? 1 : 0) != 0) {
            return TopOrLeft;
        }
        if (AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f("center".equals(string4) ? 1 : 0) != 0) {
            return Center;
        }
        if (AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(string3.equals(string4) ? 1 : 0) != 0) {
            return BottomOrRight;
        }
        return this.loadHelper.attributeParser().parseLength(string4, Length.ZERO);
    }

    public float getPercentage(@NotNull String string, float f) {
        return this.loadHelper.attributeParser().parsePercentage(this.getValue(string), f);
    }

    @NotNull
    public Length[] getLengthList(@NotNull String string) {
        return this.loadHelper.attributeParser().parseLengthList(this.getValue(string));
    }

    public float[] getFloatList(@NotNull String string) {
        return this.loadHelper.attributeParser().parseFloatList(this.getValue(string));
    }

    public double[] getDoubleList(@NotNull String string) {
        return this.loadHelper.attributeParser().parseDoubleList(this.getValue(string));
    }

    @NotNull
    public <E extends Enum<E>> E getEnum(@NotNull String string, @NotNull E e) {
        return this.loadHelper.attributeParser().parseEnum(this.getValue(string), e);
    }

    @Nullable
    public <E extends Enum<E>> E getEnumNullable(@NotNull String string, @NotNull Class<E> clazz) {
        return this.loadHelper.attributeParser().parseEnum(this.getValue(string), clazz);
    }

    @Nullable
    public ClipPath getClipPath() {
        return this.getElementByUrl(ClipPath.class, this.getValue("clip-path"));
    }

    @Nullable
    public Mask getMask() {
        return this.getElementByUrl(Mask.class, this.getValue("mask"));
    }

    @Nullable
    public Filter getFilter() {
        return this.getElementByUrl(Filter.class, this.getValue("filter"));
    }

    @NotNull
    public FilterChannelKey getFilterChannelKey(@NotNull String string, @NotNull DefaultFilterChannel defaultFilterChannel) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return defaultFilterChannel;
        }
        int n = "\u54bc\u5a69\u6c6a".length();
        return new FilterChannelKey.StringKey(string2);
    }

    @Nullable
    public AffineTransform parseTransform(@NotNull String string) {
        return this.loadHelper.attributeParser().parseTransform(this.getValue(string));
    }

    public boolean hasAttribute(@NotNull String string) {
        return AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(this.attributes.containsKey(string) ? 1 : 0) != 0;
    }

    @NotNull
    public String[] getStringList(@NotNull String string) {
        return this.getStringList(string, SeparatorMode.COMMA_AND_WHITESPACE);
    }

    @NotNull
    public String[] getStringList(@NotNull String string, SeparatorMode separatorMode) {
        return this.loadHelper.attributeParser().parseStringList(this.getValue(string), separatorMode);
    }

    public float getFloat(@NotNull String string, float f) {
        return this.loadHelper.attributeParser().parseFloat(this.getValue(string), f);
    }

    public float getNonNegativeFloat(@NotNull String string, float f) {
        float f2 = this.getFloat(string, f);
        if (AttributeNode.INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(Float.isFinite(f2) ? 1 : 0) != 0 && f2 < 0.0f) {
            return f;
        }
        return f2;
    }

    public int getInt(@NotNull String string, int n) {
        return this.loadHelper.attributeParser().parseInt(this.getValue(string), n);
    }

    @Nullable
    public String getHref() {
        String string = this.getValue("href");
        if (string == null) {
            return this.getValue("xlink:href");
        }
        return string;
    }

    @Nullable
    public ViewBox getViewBox() {
        ViewBox viewBox;
        float[] fArray = this.getFloatList("viewBox");
        if (fArray.length == 4) {
            ViewBox viewBox2;
            int n = "\u5087\u605e".length();
            int n2 = "\u52bb".length();
            int n3 = "\u4edd\u5a7f\u5354\u55ce\u6e5f".length();
            viewBox = viewBox2;
            viewBox2 = new ViewBox(fArray);
        } else {
            viewBox = null;
        }
        return viewBox;
    }

    @NotNull
    public AttributeParser parser() {
        return this.loadHelper.attributeParser();
    }

    @NotNull
    public ResourceLoader resourceLoader() {
        return this.loadHelper.resourceLoader();
    }

    static {
        TopOrLeft = new Length(Unit.PERCENTAGE, 0.0f);
        Center = new Length(Unit.PERCENTAGE, 50.0f);
        BottomOrRight = new Length(Unit.PERCENTAGE, 100.0f);
    }

    public static int INSOLENCE_\u63b6\u6c04\u6b6e\u68cb\u53e1\u50e7\u5a98\u62ad\u6ee7\u5c4b\u6ef5\u5c56\u6a6c\u53b9\u688a\u67d7\u5bb1\u674b\u5ed1\u6b55\u675b\u6a4d\u691a\u69f5\u5705\u60a8\u6ce9\u55bb\u5c13\u6727\u5f01\u6e9a\u55a1\u54ce\u4e81\u4ecd\u5ad2\u4edc\u66d7\u539e\u6d7f(int n) {
        return n;
    }
}

