/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.NodeSupplier;
import com.github.weisj.jsvg.parser.ParserProvider;
import com.github.weisj.jsvg.parser.ResourceLoader;
import com.github.weisj.jsvg.parser.StaxSVGLoader;
import com.github.weisj.jsvg.parser.SynchronousResourceLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SVGLoader {
    public static final /* synthetic */ Logger LOGGER;
    @NotNull
    public static final /* synthetic */ NodeSupplier NODE_SUPPLIER;
    public final /* synthetic */ StaxSVGLoader loader;

    public SVGLoader() {
        this.loader = new StaxSVGLoader(NODE_SUPPLIER);
    }

    @Nullable
    public SVGDocument load(@NotNull URL uRL) {
        int n = "\u610b".length();
        int n2 = "\u5ef6\u6d0f\u6fe2\u5172\u50d9".length();
        return this.load(uRL, (ParserProvider)new DefaultParserProvider());
    }

    @Nullable
    public SVGDocument load(@NotNull URL uRL, @NotNull ParserProvider parserProvider) {
        try {
            return this.load(uRL.openStream(), parserProvider);
        }
        catch (IOException iOException) {
            int n = "\u6cca\u6b8e\u6e47\u5289\u5203".length();
            int n2 = "\u582a\u546c\u70d9".length();
            LOGGER.log(Level.WARNING, "Could not read " + uRL, iOException);
            return null;
        }
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream) {
        int n = "\u62fa\u6bf9\u5c9e\u6721".length();
        int n2 = "\u6089\u4f31\u6a15".length();
        return this.load(inputStream, (ParserProvider)new DefaultParserProvider());
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @NotNull ParserProvider parserProvider) {
        int n = "\u6aa8\u56e0".length();
        int n2 = "\u6c63\u6e57".length();
        int n3 = "\u68e6\u61ff\u650b\u674e\u5e1e".length();
        int n4 = "\u69b8\u620c\u54fe\u6dcf".length();
        return this.load(inputStream, parserProvider, new SynchronousResourceLoader());
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @NotNull ParserProvider parserProvider, @NotNull ResourceLoader resourceLoader) {
        try {
            return this.loader.load(this.createDocumentInputStream(inputStream), parserProvider, resourceLoader);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Could not load SVG ", throwable);
            return null;
        }
    }

    @Nullable
    public InputStream createDocumentInputStream(@NotNull InputStream inputStream) {
        try {
            int n = "\u6ab3\u508e".length();
            int n2 = "\u5928\u4e4c\u6d49".length();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(2);
            int n3 = bufferedInputStream.read();
            int n4 = bufferedInputStream.read();
            bufferedInputStream.reset();
            if ((n4 << 8 | n3) == 35615) {
                int n5 = "\u4ece\u667d\u68e9\u6015\u516a".length();
                return new GZIPInputStream(bufferedInputStream);
            }
            return bufferedInputStream;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            return null;
        }
    }

    static {
        LOGGER = Logger.getLogger(SVGLoader.class.getName());
        NODE_SUPPLIER = new NodeSupplier();
    }
}

