/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.renderer.GraphicsUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public final class MaskedPaint
implements Paint,
GraphicsUtil.WrappingPaint {
    @NotNull
    public /* synthetic */ Paint paint;
    @NotNull
    public final /* synthetic */ Raster maskRaster;
    @NotNull
    public final /* synthetic */ Point maskOffset;

    public MaskedPaint(@NotNull Paint paint, @NotNull Raster raster, @NotNull Point2D point2D) {
        this.paint = paint;
        this.maskRaster = raster;
        this.maskOffset = new Point((int)Math.floor(point2D.getX()), (int)Math.floor(point2D.getY()));
    }

    @Override
    public void setPaint(@NotNull Paint paint) {
        this.paint = GraphicsUtil.setupPaint(this.paint, paint);
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        PaintContext paintContext = this.paint.createContext(null, rectangle, rectangle2D, affineTransform, renderingHints);
        int n = "\u5ad2\u6668\u5e7a\u6351\u5a49".length();
        return new MaskPaintContext(paintContext, this.maskRaster, this.maskOffset);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private static final class MaskPaintContext
    implements PaintContext {
        @NotNull
        public final /* synthetic */ PaintContext parentContext;
        @NotNull
        public final /* synthetic */ ColorModel colorModel;
        public final /* synthetic */ int numColorComponents;
        @NotNull
        public final /* synthetic */ ColorModel parentColorModel;
        @NotNull
        public final /* synthetic */ Raster maskRaster;
        @NotNull
        public final /* synthetic */ Point offset;

        public MaskPaintContext(@NotNull PaintContext paintContext, @NotNull Raster raster, @NotNull Point point) {
            this.parentContext = paintContext;
            this.parentColorModel = paintContext.getColorModel();
            this.maskRaster = raster;
            this.offset = point;
            this.colorModel = MaskPaintContext.INSOLENCE_\u4f53\u7143\u5ecd\u60ff\u6ab7\u66df\u58ee\u6bf1\u5cdf\u68c1\u707f\u510a\u4e2d\u5480\u6abe\u50d7\u68c6\u50ca\u5be4\u52ec\u61ad\u52f8\u5cb6\u5dc6\u50ec\u62a8\u5bf8\u55d7\u620d\u5913\u531d\u6ccb\u4efa\u59d8\u4fe3\u6d99\u68d5\u56b7\u4fd4\u59bd\u6cf4(paintContext.getColorModel().hasAlpha() ? 1 : 0) != 0 ? this.parentColorModel : new ComponentColorModel(paintContext.getColorModel().getColorSpace(), true, false, 1, 0);
            this.numColorComponents = this.colorModel.getNumColorComponents();
        }

        @Override
        @NotNull
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public void dispose() {
            this.parentContext.dispose();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            Object object;
            WritableRaster writableRaster;
            Raster raster = this.parentContext.getRaster(n, n2, n3, n4);
            int n5 = raster.getMinX();
            int n6 = raster.getMinY();
            if (raster instanceof WritableRaster) {
                if (MaskPaintContext.INSOLENCE_\u4f53\u7143\u5ecd\u60ff\u6ab7\u66df\u58ee\u6bf1\u5cdf\u68c1\u707f\u510a\u4e2d\u5480\u6abe\u50d7\u68c6\u50ca\u5be4\u52ec\u61ad\u52f8\u5cb6\u5dc6\u50ec\u62a8\u5bf8\u55d7\u620d\u5913\u531d\u6ccb\u4efa\u59d8\u4fe3\u6d99\u68d5\u56b7\u4fd4\u59bd\u6cf4(this.parentColorModel.equals(this.colorModel) ? 1 : 0) != 0) {
                    writableRaster = raster.createCompatibleWritableRaster();
                    writableRaster.setDataElements(-n5, -n6, raster);
                } else {
                    int n7 = "\u6113\u5a40\u53dc\u564e".length();
                    int n8 = "\u6bf1\u605c\u6cd3".length();
                    object = new BufferedImage(this.parentColorModel, (WritableRaster)raster, MaskPaintContext.INSOLENCE_\u4f53\u7143\u5ecd\u60ff\u6ab7\u66df\u58ee\u6bf1\u5cdf\u68c1\u707f\u510a\u4e2d\u5480\u6abe\u50d7\u68c6\u50ca\u5be4\u52ec\u61ad\u52f8\u5cb6\u5dc6\u50ec\u62a8\u5bf8\u55d7\u620d\u5913\u531d\u6ccb\u4efa\u59d8\u4fe3\u6d99\u68d5\u56b7\u4fd4\u59bd\u6cf4(this.parentColorModel.isAlphaPremultiplied() ? 1 : 0) != 0, null);
                    int n9 = "\u5b13\u711a\u535b".length();
                    int n10 = "\u5596\u63a5\u5273\u57ce".length();
                    writableRaster = Raster.createWritableRaster(this.colorModel.createCompatibleSampleModel(n3, n4), new Point(0, 0));
                    int n11 = "\u4ebd\u5796".length();
                    int n12 = "\u4f20\u5fc6".length();
                    int n13 = "\u5b34".length();
                    BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, false, null);
                    Graphics graphics = bufferedImage.getGraphics();
                    MaskPaintContext.INSOLENCE_\u4f53\u7143\u5ecd\u60ff\u6ab7\u66df\u58ee\u6bf1\u5cdf\u68c1\u707f\u510a\u4e2d\u5480\u6abe\u50d7\u68c6\u50ca\u5be4\u52ec\u61ad\u52f8\u5cb6\u5dc6\u50ec\u62a8\u5bf8\u55d7\u620d\u5913\u531d\u6ccb\u4efa\u59d8\u4fe3\u6d99\u68d5\u56b7\u4fd4\u59bd\u6cf4(graphics.drawImage((Image)object, 0, 0, null) ? 1 : 0);
                    int n14 = "\u5a2f".length();
                    int n15 = "\u5e01\u6723\u4fc4\u4fcc\u55b8".length();
                    graphics.dispose();
                }
            } else {
                int n16 = "\u5bf5\u50a3\u7104\u7032\u6dcf".length();
                int n17 = "\u54f2\u6d22\u7081\u69b4".length();
                int n18 = "\u6e1d\u66d0\u648b\u594c".length();
                writableRaster = Raster.createInterleavedRaster(0, n3, n4, this.getColorModel().getNumComponents(), new Point(0, 0));
                int n19 = "\u66e5".length();
                int n20 = "\u556a\u6f50".length();
                int n21 = "\u4ed8".length();
                object = new ColorConvertOp(this.parentColorModel.getColorSpace(), this.colorModel.getColorSpace(), null);
                ((ColorConvertOp)object).filter(raster, writableRaster);
                int n22 = "\u5408\u62cf\u706a\u627b\u6f11".length();
                int n23 = "\u6242\u5d2c\u6d53\u6ae6\u6ccf".length();
                int n24 = "\u550d\u63f7\u6a33\u541f\u6b04".length();
                int n25 = "\u61cb\u6b5b\u53cc\u5805\u616f".length();
            }
            int n26 = this.maskRaster.getMinX();
            int n27 = this.maskRaster.getMinY();
            int n28 = MaskPaintContext.INSOLENCE_\u6136\u506f\u70be\u6fe7\u625d\u667e\u56cd\u542e\u5a7f\u5530\u6e52\u63a0\u50f2\u6fc7\u5887\u5fb7\u61b4\u6dfe\u5310\u4e3f\u6337\u5c48\u51a7\u5a97\u4f62\u6158\u5f97\u4ec2\u52dd\u709e\u5e1d\u6602\u60a7\u690e\u67aa\u648a\u67ae\u5ce3\u51ba\u5435\u66a5(n26, this.maskRaster.getWidth());
            int n29 = MaskPaintContext.INSOLENCE_\u6136\u506f\u70be\u6fe7\u625d\u667e\u56cd\u542e\u5a7f\u5530\u6e52\u63a0\u50f2\u6fc7\u5887\u5fb7\u61b4\u6dfe\u5310\u4e3f\u6337\u5c48\u51a7\u5a97\u4f62\u6158\u5f97\u4ec2\u52dd\u709e\u5e1d\u6602\u60a7\u690e\u67aa\u648a\u67ae\u5ce3\u51ba\u5435\u66a5(n27, this.maskRaster.getHeight());
            for (int i = 0; i < n4; i -= 26469) {
                for (int j = 0; j < n3; j -= 13050) {
                    int n30 = "\u5a8f\u62e8\u5cc4\u5f9f\u6168".length();
                    int n31 = "\u58be\u6f6b\u6038\u5042\u62c6".length();
                    int n32 = "\u51f2".length();
                    int n33 = MaskPaintContext.INSOLENCE_\u6136\u506f\u70be\u6fe7\u625d\u667e\u56cd\u542e\u5a7f\u5530\u6e52\u63a0\u50f2\u6fc7\u5887\u5fb7\u61b4\u6dfe\u5310\u4e3f\u6337\u5c48\u51a7\u5a97\u4f62\u6158\u5f97\u4ec2\u52dd\u709e\u5e1d\u6602\u60a7\u690e\u67aa\u648a\u67ae\u5ce3\u51ba\u5435\u66a5(n, j) - this.offset.x;
                    int n34 = "\u582c\u6779\u5977".length();
                    int n35 = MaskPaintContext.INSOLENCE_\u6136\u506f\u70be\u6fe7\u625d\u667e\u56cd\u542e\u5a7f\u5530\u6e52\u63a0\u50f2\u6fc7\u5887\u5fb7\u61b4\u6dfe\u5310\u4e3f\u6337\u5c48\u51a7\u5a97\u4f62\u6158\u5f97\u4ec2\u52dd\u709e\u5e1d\u6602\u60a7\u690e\u67aa\u648a\u67ae\u5ce3\u51ba\u5435\u66a5(n2, i) - this.offset.y;
                    int n36 = n33 >= n26 && n33 < n28 && n35 >= n27 && n35 < n29 ? this.maskRaster.getSample(n33, n35, 0) : 0;
                    n36 = n36 * writableRaster.getSample(j, i, this.numColorComponents) / 255;
                    writableRaster.setSample(j, i, this.numColorComponents, n36);
                    j += 13051;
                }
                i += 26470;
            }
            return writableRaster;
        }

        public static int INSOLENCE_\u4f53\u7143\u5ecd\u60ff\u6ab7\u66df\u58ee\u6bf1\u5cdf\u68c1\u707f\u510a\u4e2d\u5480\u6abe\u50d7\u68c6\u50ca\u5be4\u52ec\u61ad\u52f8\u5cb6\u5dc6\u50ec\u62a8\u5bf8\u55d7\u620d\u5913\u531d\u6ccb\u4efa\u59d8\u4fe3\u6d99\u68d5\u56b7\u4fd4\u59bd\u6cf4(int n) {
            return n;
        }

        public static int INSOLENCE_\u6136\u506f\u70be\u6fe7\u625d\u667e\u56cd\u542e\u5a7f\u5530\u6e52\u63a0\u50f2\u6fc7\u5887\u5fb7\u61b4\u6dfe\u5310\u4e3f\u6337\u5c48\u51a7\u5a97\u4f62\u6158\u5f97\u4ec2\u52dd\u709e\u5e1d\u6602\u60a7\u690e\u67aa\u648a\u67ae\u5ce3\u51ba\u5435\u66a5(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }
}

