/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.font.MeasurableFontSpec;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Mask;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.container.BaseContainerNode;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.prototype.HasClip;
import com.github.weisj.jsvg.nodes.prototype.HasFillRule;
import com.github.weisj.jsvg.nodes.prototype.HasFilter;
import com.github.weisj.jsvg.nodes.prototype.HasFontContext;
import com.github.weisj.jsvg.nodes.prototype.HasFontRenderContext;
import com.github.weisj.jsvg.nodes.prototype.HasPaintContext;
import com.github.weisj.jsvg.nodes.prototype.HasShape;
import com.github.weisj.jsvg.nodes.prototype.Instantiator;
import com.github.weisj.jsvg.nodes.prototype.Mutator;
import com.github.weisj.jsvg.nodes.prototype.Renderable;
import com.github.weisj.jsvg.nodes.prototype.Transformable;
import com.github.weisj.jsvg.renderer.ContextElementAttributes;
import com.github.weisj.jsvg.renderer.FontRenderContext;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.PaintContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeRenderer {
    public static final /* synthetic */ boolean CLIP_DEBUG = false;

    public static /* synthetic */ void renderNode(@NotNull SVGNode sVGNode, @NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D) {
        Info info = NodeRenderer.createRenderInfo(sVGNode, renderContext, graphics2D, null);
        try {
            if (info != null) {
                info.renderable.render(info.context, info.graphics());
            }
            if (info != null) {
                info.close();
            }
        }
        catch (Throwable throwable) {
            if (info != null) {
                try {
                    info.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            int n = "\u609b\u527b\u5a6e".length();
            throw throwable;
        }
    }

    @Nullable
    public static /* synthetic */ Info createRenderInfo(@NotNull SVGNode sVGNode, @NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D, @Nullable Instantiator instantiator) {
        Mask mask;
        if (!(sVGNode instanceof Renderable)) {
            return null;
        }
        Renderable renderable = (Renderable)((Object)sVGNode);
        int n = NodeRenderer.INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69(renderable.requiresInstantiation() ? 1 : 0);
        if (n != 0 && (instantiator == null || NodeRenderer.INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69(instantiator.canInstantiate(sVGNode) ? 1 : 0) == 0)) {
            return null;
        }
        if (NodeRenderer.INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69(renderable.isVisible(renderContext) ? 1 : 0) == 0) {
            return null;
        }
        RenderContext renderContext2 = NodeRenderer.setupRenderContext(instantiator, sVGNode, renderContext);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (renderable instanceof Transformable && NodeRenderer.INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69(((Transformable)((Object)renderable)).shouldTransform() ? 1 : 0) != 0) {
            ((Transformable)((Object)renderable)).applyTransform(graphics2D2, renderContext2);
        }
        Rectangle2D rectangle2D = null;
        if (renderable instanceof HasClip) {
            ClipPath clipPath;
            mask = ((HasClip)((Object)renderable)).mask();
            if (mask != null && NodeRenderer.INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69((rectangle2D = NodeRenderer.elementBounds(renderable, renderContext2)).isEmpty() ? 1 : 0) == 0) {
                GraphicsUtil.safelySetPaint(graphics2D2, mask.createMaskPaint(graphics2D, renderContext2, rectangle2D));
            }
            if ((clipPath = ((HasClip)((Object)renderable)).clipPath()) != null) {
                if (NodeRenderer.INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69(clipPath.isValid() ? 1 : 0) == 0) {
                    return null;
                }
                if (rectangle2D == null) {
                    rectangle2D = NodeRenderer.elementBounds(renderable, renderContext2);
                }
                Shape shape = clipPath.clipShape(renderContext2, rectangle2D);
                graphics2D2.clip(shape);
            }
        }
        BaseContainerNode baseContainerNode = mask = renderable instanceof HasFilter ? ((HasFilter)((Object)renderable)).filter() : null;
        if (mask != null && NodeRenderer.INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69(((Filter)((Object)mask)).hasEffect() ? 1 : 0) != 0) {
            if (rectangle2D == null) {
                rectangle2D = NodeRenderer.elementBounds(renderable, renderContext2);
            }
            int n2 = "\u5583".length();
            int n3 = "\u699d\u6d1f".length();
            int n4 = "\u57f1\u5e9a\u6bae\u600e".length();
            return new InfoWithFilter(renderable, renderContext2, graphics2D2, (Filter)((Object)mask), rectangle2D);
        }
        int n5 = "\u68b9".length();
        int n6 = "\u6470\u585f\u50c0\u6a89\u6191".length();
        return new Info(renderable, renderContext2, graphics2D2);
    }

    @NotNull
    public static /* synthetic */ Rectangle2D elementBounds(@NotNull Object object, @NotNull RenderContext renderContext) {
        Rectangle2D rectangle2D;
        if (object instanceof HasShape) {
            rectangle2D = ((HasShape)object).untransformedElementBounds(renderContext);
        } else {
            MeasureContext measureContext = renderContext.measureContext();
            int n = "\u6869\u5e69".length();
            int n2 = "\u5baa\u577d".length();
            int n3 = "\u6504\u4efb\u63c5".length();
            rectangle2D = new ViewBox(measureContext.viewWidth(), measureContext.viewHeight());
        }
        return rectangle2D;
    }

    @NotNull
    public static /* synthetic */ RenderContext setupRenderContext(@NotNull Object object, @NotNull RenderContext renderContext) {
        return NodeRenderer.setupRenderContext(null, object, renderContext);
    }

    @NotNull
    public static /* synthetic */ RenderContext setupRenderContext(@Nullable Instantiator instantiator, @NotNull Object object, @NotNull RenderContext renderContext) {
        @Nullable Mutator<PaintContext> mutator = null;
        Mutator<MeasurableFontSpec> mutator2 = null;
        FontRenderContext fontRenderContext = null;
        FillRule fillRule = null;
        if (object instanceof HasPaintContext) {
            mutator = ((HasPaintContext)object).paintContext();
        }
        if (object instanceof HasFontContext) {
            mutator2 = ((HasFontContext)object).fontSpec();
        }
        if (object instanceof HasFontRenderContext) {
            fontRenderContext = ((HasFontRenderContext)object).fontRenderContext();
        }
        if (object instanceof HasFillRule) {
            fillRule = ((HasFillRule)object).fillRule();
        }
        ContextElementAttributes contextElementAttributes = null;
        if (instantiator != null) {
            contextElementAttributes = instantiator.createContextAttributes(renderContext);
        }
        return renderContext.derive(mutator, mutator2, null, fontRenderContext, fillRule, contextElementAttributes);
    }

    @NotNull
    public static /* synthetic */ RenderContext setupInnerViewRenderContext(@NotNull ViewBox viewBox, @NotNull RenderContext renderContext, boolean bl) {
        if (bl) {
            return renderContext.derive(null, null, viewBox, null, null, null);
        }
        MeasureContext measureContext = renderContext.measureContext().derive(viewBox, Float.NaN, Float.NaN);
        int n = "\u59a1\u66c3\u6f91\u632a\u5b41".length();
        int n2 = "\u5c89".length();
        int n3 = "\u6de0\u5587".length();
        int n4 = "\u697c\u6fe6\u6144\u5efa\u5b2a".length();
        int n5 = "\u58fd\u599a\u535d\u6131\u59f2".length();
        int n6 = "\u603f".length();
        int n7 = "\u6ff0\u5f94\u5f09\u5528".length();
        int n8 = "\u654d\u525c\u634a\u6d27\u643e".length();
        int n9 = "\u698f".length();
        int n10 = "\u5a36".length();
        return new RenderContext(renderContext.targetComponent(), new AffineTransform(), new AffineTransform(), PaintContext.createDefault(), measureContext, FontRenderContext.createDefault(), MeasurableFontSpec.createDefault(), renderContext.fillRule(), renderContext.contextElementAttributes());
    }

    public static int INSOLENCE_\u5423\u570e\u65a6\u70b4\u53ab\u512b\u6886\u7107\u60c4\u56a3\u7079\u5530\u509c\u66a2\u6f8e\u5770\u70b7\u511f\u6537\u67f5\u6a49\u6054\u6716\u63e1\u5167\u4fa1\u64b3\u6a09\u6dcd\u4f75\u652f\u6f0e\u6d8e\u6cde\u64ef\u5b3a\u64c7\u53b8\u6557\u64b2\u6d69(int n) {
        return n;
    }

    public static class Info
    implements AutoCloseable {
        @NotNull
        public final /* synthetic */ Renderable renderable;
        @NotNull
        public final /* synthetic */ RenderContext context;
        @NotNull
        public final /* synthetic */ Graphics2D g;

        public Info(@NotNull Renderable renderable, @NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D) {
            this.renderable = renderable;
            this.context = renderContext;
            this.g = graphics2D;
        }

        @NotNull
        public Graphics2D graphics() {
            return this.g;
        }

        @Override
        public void close() {
            this.g.dispose();
        }
    }

    private static final class InfoWithFilter
    extends Info {
        @NotNull
        public final /* synthetic */ Filter filter;
        @NotNull
        public final /* synthetic */ Filter.FilterInfo filterInfo;

        public InfoWithFilter(@NotNull Renderable renderable, @NotNull RenderContext renderContext, @NotNull Graphics2D graphics2D, @NotNull Filter filter, @NotNull Rectangle2D rectangle2D) {
            super(renderable, renderContext, graphics2D);
            this.filter = filter;
            this.filterInfo = filter.createFilterInfo(graphics2D, renderContext, rectangle2D);
        }

        @Override
        @NotNull
        public Graphics2D graphics() {
            return this.filterInfo.graphics();
        }

        @Override
        public void close() {
            this.filter.applyFilter(this.g, this.context, this.filterInfo);
            this.filterInfo.blitImage(this.g, this.context);
            this.filterInfo.close();
            super.close();
        }
    }
}

