/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.font.FontResolver;
import com.github.weisj.jsvg.attributes.font.MeasurableFontSpec;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.attributes.stroke.StrokeResolver;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.prototype.Mutator;
import com.github.weisj.jsvg.renderer.ContextElementAttributes;
import com.github.weisj.jsvg.renderer.FontRenderContext;
import com.github.weisj.jsvg.renderer.PaintContext;
import com.github.weisj.jsvg.renderer.StrokeContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ImageProducer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderContext {
    @Nullable
    public final /* synthetic */ JComponent targetComponent;
    @NotNull
    public final /* synthetic */ MeasureContext measureContext;
    @NotNull
    public final /* synthetic */ PaintContext paintContext;
    @NotNull
    public final /* synthetic */ FontRenderContext fontRenderContext;
    @NotNull
    public final /* synthetic */ MeasurableFontSpec fontSpec;
    @NotNull
    public final /* synthetic */ FillRule fillRule;
    @Nullable
    public final /* synthetic */ ContextElementAttributes contextElementAttributes;
    @NotNull
    public final /* synthetic */ AffineTransform rootTransform;
    @NotNull
    public final /* synthetic */ AffineTransform userSpaceTransform;
    public static final /* synthetic */ boolean $assertionsDisabled;

    @NotNull
    public static /* synthetic */ RenderContext createInitial(@Nullable JComponent jComponent, @NotNull MeasureContext measureContext) {
        int n = "\u6690\u6ee3\u614e".length();
        int n2 = "\u6e15\u545f\u5241".length();
        int n3 = "\u7120\u6abc".length();
        int n4 = "\u50a2\u658b\u6d40\u53f3".length();
        int n5 = "\u55fe\u58c0".length();
        int n6 = "\u5a1a".length();
        int n7 = "\u6a61".length();
        int n8 = "\u6b10\u6662\u5913\u6fb1\u6a3e".length();
        int n9 = "\u5767\u6324\u5355".length();
        int n10 = "\u64fd".length();
        return new RenderContext(jComponent, new AffineTransform(), new AffineTransform(), PaintContext.createDefault(), measureContext, FontRenderContext.createDefault(), MeasurableFontSpec.createDefault(), FillRule.Nonzero, null);
    }

    public RenderContext(@Nullable JComponent jComponent, @NotNull AffineTransform affineTransform, @NotNull AffineTransform affineTransform2, @NotNull PaintContext paintContext, @NotNull MeasureContext measureContext, @NotNull FontRenderContext fontRenderContext, @NotNull MeasurableFontSpec measurableFontSpec, @NotNull FillRule fillRule, @Nullable ContextElementAttributes contextElementAttributes) {
        this.targetComponent = jComponent;
        this.rootTransform = affineTransform;
        this.userSpaceTransform = affineTransform2;
        this.paintContext = paintContext;
        this.measureContext = measureContext;
        this.fontRenderContext = fontRenderContext;
        this.fontSpec = measurableFontSpec;
        this.fillRule = fillRule;
        this.contextElementAttributes = contextElementAttributes;
    }

    @NotNull
    public RenderContext derive(@Nullable Mutator<PaintContext> mutator, @Nullable Mutator<MeasurableFontSpec> mutator2, @Nullable ViewBox viewBox, @Nullable FontRenderContext fontRenderContext, @Nullable FillRule fillRule, @Nullable ContextElementAttributes contextElementAttributes) {
        FillRule fillRule2;
        if (mutator == null && viewBox == null && mutator2 == null && fontRenderContext == null) {
            return this;
        }
        PaintContext paintContext = this.paintContext;
        MeasurableFontSpec measurableFontSpec = this.fontSpec;
        FillRule fillRule3 = fillRule2 = fillRule != null && fillRule != FillRule.Inherit ? fillRule : this.fillRule;
        if (mutator != null) {
            paintContext = mutator.mutate(this.paintContext);
        }
        if (mutator2 != null) {
            measurableFontSpec = mutator2.mutate(measurableFontSpec);
        }
        ContextElementAttributes contextElementAttributes2 = this.contextElementAttributes;
        if (contextElementAttributes != null) {
            contextElementAttributes2 = contextElementAttributes;
        }
        float f = measurableFontSpec.effectiveSize(this.measureContext);
        float f2 = SVGFont.exFromEm(f);
        MeasureContext measureContext = this.measureContext.derive(viewBox, f, f2);
        FontRenderContext fontRenderContext2 = this.fontRenderContext.derive(fontRenderContext);
        int n = "\u7030".length();
        int n2 = "\u5c62\u6782".length();
        int n3 = "\u6a65".length();
        int n4 = "\u64c2\u50c4\u58fb\u7013\u6790".length();
        int n5 = "\u4e85\u6d8d\u5d26\u66b8".length();
        return new RenderContext(this.targetComponent, this.rootTransform, new AffineTransform(this.userSpaceTransform), paintContext, measureContext, fontRenderContext2, measurableFontSpec, fillRule2, contextElementAttributes2);
    }

    @NotNull
    public RenderContext deriveForChildGraphics() {
        return this.derive(paintContext -> paintContext, null, null, null, null, null);
    }

    @NotNull
    public StrokeContext strokeContext() {
        if (RenderContext.INSOLENCE_\u6629\u6a15\u6617\u5cb3\u6b3e\u6ce1\u5acf\u6bc6\u6b5b\u6a9e\u5270\u67e5\u4e87\u6e21\u4e3b\u6082\u51d0\u4f9a\u5a14\u6a89\u6d18\u6eef\u6a11\u65e1\u599c\u6ee1\u5129\u51ba\u50f4\u64c2\u5287\u5844\u65d3\u4f33\u5831\u54f3\u6826\u6431\u57c4\u62ff\u6c4c($assertionsDisabled ? 1 : 0) == 0 && this.paintContext.strokeContext == null) {
            int n = "\u6a0f\u6534\u5b25".length();
            int n2 = "\u589b\u58b7\u57fa\u63a9".length();
            int n3 = "\u654c\u6873\u6b08\u6d7e\u68e6".length();
            int n4 = "\u6494\u510b\u5b4e\u5def".length();
            int n5 = "\u5753\u6e24\u59df\u6961".length();
            int n6 = "\u5f6d\u597a".length();
            throw new AssertionError();
        }
        return this.paintContext.strokeContext;
    }

    @Nullable
    public ContextElementAttributes contextElementAttributes() {
        return this.contextElementAttributes;
    }

    @NotNull
    public AffineTransform rootTransform() {
        return this.rootTransform;
    }

    @NotNull
    public AffineTransform userSpaceTransform() {
        return this.userSpaceTransform;
    }

    public void setRootTransform(@NotNull AffineTransform affineTransform) {
        this.rootTransform.setTransform(affineTransform);
        this.userSpaceTransform.setToIdentity();
    }

    public void setRootTransform(@NotNull AffineTransform affineTransform, @NotNull AffineTransform affineTransform2) {
        this.rootTransform.setTransform(affineTransform);
        this.userSpaceTransform.setTransform(affineTransform2);
    }

    public void translate(@NotNull Graphics2D graphics2D, @NotNull Point2D point2D) {
        this.translate(graphics2D, point2D.getX(), point2D.getY());
    }

    public void translate(@NotNull Graphics2D graphics2D, double d, double d2) {
        graphics2D.translate(d, d2);
        this.userSpaceTransform.translate(d, d2);
    }

    public void scale(@NotNull Graphics2D graphics2D, double d, double d2) {
        graphics2D.scale(d, d2);
        this.userSpaceTransform.scale(d, d2);
    }

    public void rotate(@NotNull Graphics2D graphics2D, double d) {
        graphics2D.rotate(d);
        this.userSpaceTransform.rotate(d);
    }

    public void transform(@NotNull Graphics2D graphics2D, @NotNull AffineTransform affineTransform) {
        graphics2D.transform(affineTransform);
        this.userSpaceTransform.concatenate(affineTransform);
    }

    @Nullable
    public JComponent targetComponent() {
        return this.targetComponent;
    }

    @NotNull
    public MeasureContext measureContext() {
        return this.measureContext;
    }

    @NotNull
    public FontRenderContext fontRenderContext() {
        return this.fontRenderContext;
    }

    @NotNull
    public FillRule fillRule() {
        return this.fillRule;
    }

    @NotNull
    public SVGPaint strokePaint() {
        return this.resolvePaint(this.paintContext.strokePaint);
    }

    @NotNull
    public SVGPaint fillPaint() {
        return this.resolvePaint(this.paintContext.fillPaint);
    }

    @NotNull
    public SVGPaint resolvePaint(@Nullable SVGPaint sVGPaint) {
        if (sVGPaint == SVGPaint.DEFAULT_PAINT || sVGPaint == SVGPaint.CURRENT_COLOR) {
            return this.coerceNonNull(this.paintContext.color);
        }
        if (sVGPaint == SVGPaint.CONTEXT_STROKE) {
            if (this.contextElementAttributes == null) {
                return SVGPaint.NONE;
            }
            return this.contextElementAttributes.strokePaint;
        }
        if (sVGPaint == SVGPaint.CONTEXT_FILL) {
            if (this.contextElementAttributes == null) {
                return SVGPaint.NONE;
            }
            return this.contextElementAttributes.fillPaint;
        }
        return this.coerceNonNull(sVGPaint);
    }

    @NotNull
    public SVGPaint coerceNonNull(@Nullable SVGPaint sVGPaint) {
        return sVGPaint != null ? sVGPaint : SVGPaint.DEFAULT_PAINT;
    }

    public float rawOpacity() {
        return this.paintContext.opacity;
    }

    public float fillOpacity() {
        return this.paintContext.fillOpacity * this.paintContext.opacity;
    }

    public float strokeOpacity() {
        return this.paintContext.strokeOpacity * this.paintContext.opacity;
    }

    @NotNull
    public Stroke stroke(float f) {
        return StrokeResolver.resolve(f, this.measureContext, this.strokeContext());
    }

    @NotNull
    public SVGFont font() {
        return FontResolver.resolve(this.fontSpec, this.measureContext);
    }

    public String toString() {
        int n = "\u5862\u6de4\u5c9e\u538c".length();
        int n2 = "\u6d6c\u6ad7\u6913".length();
        return "RenderContext{\n  measureContext=" + this.measureContext + ",\n paintContext=" + this.paintContext + ",\n fontSpec=" + this.fontSpec + ",\n targetComponent=" + this.targetComponent + ",\n contextElementAttributes=" + this.contextElementAttributes + ",\n fillRule=" + (Object)((Object)this.fillRule) + ",\n baseTransform=" + this.rootTransform + ",\n userSpaceTransform=" + this.userSpaceTransform + "\n}";
    }

    @NotNull
    public Image createImage(@NotNull ImageProducer imageProducer) {
        if (this.targetComponent != null) {
            return this.targetComponent.createImage(imageProducer);
        }
        return Toolkit.getDefaultToolkit().createImage(imageProducer);
    }

    static {
        $assertionsDisabled = RenderContext.INSOLENCE_\u6629\u6a15\u6617\u5cb3\u6b3e\u6ce1\u5acf\u6bc6\u6b5b\u6a9e\u5270\u67e5\u4e87\u6e21\u4e3b\u6082\u51d0\u4f9a\u5a14\u6a89\u6d18\u6eef\u6a11\u65e1\u599c\u6ee1\u5129\u51ba\u50f4\u64c2\u5287\u5844\u65d3\u4f33\u5831\u54f3\u6826\u6431\u57c4\u62ff\u6c4c(RenderContext.INSOLENCE_\u6629\u6a15\u6617\u5cb3\u6b3e\u6ce1\u5acf\u6bc6\u6b5b\u6a9e\u5270\u67e5\u4e87\u6e21\u4e3b\u6082\u51d0\u4f9a\u5a14\u6a89\u6d18\u6eef\u6a11\u65e1\u599c\u6ee1\u5129\u51ba\u50f4\u64c2\u5287\u5844\u65d3\u4f33\u5831\u54f3\u6826\u6431\u57c4\u62ff\u6c4c(RenderContext.class.desiredAssertionStatus() ? 1 : 0) == 0 ? 1 : 0);
    }

    public static int INSOLENCE_\u6629\u6a15\u6617\u5cb3\u6b3e\u6ce1\u5acf\u6bc6\u6b5b\u6a9e\u5270\u67e5\u4e87\u6e21\u4e3b\u6082\u51d0\u4f9a\u5a14\u6a89\u6d18\u6eef\u6a11\u65e1\u599c\u6ee1\u5129\u51ba\u50f4\u64c2\u5287\u5844\u65d3\u4f33\u5831\u54f3\u6826\u6431\u57c4\u62ff\u6c4c(int n) {
        return n;
    }
}

