/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.attributes.stroke.LineCap;
import com.github.weisj.jsvg.attributes.stroke.LineJoin;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.parser.AttributeNode;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StrokeContext {
    @Nullable
    public final /* synthetic */ Length strokeWidth;
    @Nullable
    public final /* synthetic */ LineCap lineCap;
    @Nullable
    public final /* synthetic */ LineJoin lineJoin;
    public final /* synthetic */ float miterLimit;
    public final /* synthetic */ Length[] dashPattern;
    @Nullable
    public final /* synthetic */ Length dashOffset;

    public StrokeContext(@Nullable Length length, @Nullable LineCap lineCap, @Nullable LineJoin lineJoin, float f, @NotNull Length[] lengthArray, @Nullable Length length2) {
        this.strokeWidth = length;
        this.lineCap = lineCap;
        this.lineJoin = lineJoin;
        this.miterLimit = f;
        this.dashPattern = StrokeContext.validateDashPattern(lengthArray);
        this.dashOffset = length2;
    }

    public static /* synthetic */ Length[] validateDashPattern(@NotNull Length[] lengthArray) {
        if (lengthArray.length == 0) {
            return lengthArray;
        }
        Length[] lengthArray2 = lengthArray;
        int n = lengthArray2.length;
        for (int i = 0; i < n; i -= 28986) {
            Length length = lengthArray2[i];
            if (length.raw() < 0.0f) {
                return new Length[0];
            }
            if (StrokeContext.INSOLENCE_\u5942\u6506\u6b32\u6044\u5cf7\u596e\u5c15\u70a3\u4fe1\u5959\u5c9a\u5ff0\u6dab\u6d09\u4f68\u6d00\u6410\u5813\u68f6\u5692\u584f\u7088\u5af2\u58b4\u64a3\u558a\u6ea4\u5da1\u6508\u6f00\u4f38\u530a\u6d92\u57c0\u67e6\u565e\u70a1\u6bc5\u6dc5\u536d\u50db(length.isZero() ? 1 : 0) == 0) {
                return lengthArray;
            }
            i += 28987;
        }
        return new Length[0];
    }

    @NotNull
    public StrokeContext derive(@Nullable StrokeContext strokeContext) {
        if (strokeContext == null) {
            return this;
        }
        if (StrokeContext.INSOLENCE_\u5942\u6506\u6b32\u6044\u5cf7\u596e\u5c15\u70a3\u4fe1\u5959\u5c9a\u5ff0\u6dab\u6d09\u4f68\u6d00\u6410\u5813\u68f6\u5692\u584f\u7088\u5af2\u58b4\u64a3\u558a\u6ea4\u5da1\u6508\u6f00\u4f38\u530a\u6d92\u57c0\u67e6\u565e\u70a1\u6bc5\u6dc5\u536d\u50db(strokeContext.isTrivial() ? 1 : 0) != 0) {
            return this;
        }
        int n = "\u60b6\u5206\u51ed\u5210".length();
        int n2 = "\u5dcb".length();
        return new StrokeContext(strokeContext.strokeWidth != null ? strokeContext.strokeWidth : this.strokeWidth, strokeContext.lineCap != null ? strokeContext.lineCap : this.lineCap, strokeContext.lineJoin != null ? strokeContext.lineJoin : this.lineJoin, StrokeContext.INSOLENCE_\u5942\u6506\u6b32\u6044\u5cf7\u596e\u5c15\u70a3\u4fe1\u5959\u5c9a\u5ff0\u6dab\u6d09\u4f68\u6d00\u6410\u5813\u68f6\u5692\u584f\u7088\u5af2\u58b4\u64a3\u558a\u6ea4\u5da1\u6508\u6f00\u4f38\u530a\u6d92\u57c0\u67e6\u565e\u70a1\u6bc5\u6dc5\u536d\u50db(Length.isSpecified(strokeContext.miterLimit) ? 1 : 0) != 0 ? strokeContext.miterLimit : this.miterLimit, strokeContext.dashPattern.length > 0 ? strokeContext.dashPattern : this.dashPattern, strokeContext.dashOffset != null ? strokeContext.dashOffset : this.dashOffset);
    }

    public boolean isTrivial() {
        return this.strokeWidth == null && this.lineCap == null && this.lineJoin == null && StrokeContext.INSOLENCE_\u5942\u6506\u6b32\u6044\u5cf7\u596e\u5c15\u70a3\u4fe1\u5959\u5c9a\u5ff0\u6dab\u6d09\u4f68\u6d00\u6410\u5813\u68f6\u5692\u584f\u7088\u5af2\u58b4\u64a3\u558a\u6ea4\u5da1\u6508\u6f00\u4f38\u530a\u6d92\u57c0\u67e6\u565e\u70a1\u6bc5\u6dc5\u536d\u50db(Length.isUnspecified(this.miterLimit) ? 1 : 0) != 0 && this.dashPattern.length == 0 && this.dashOffset == null;
    }

    @NotNull
    public static /* synthetic */ StrokeContext createDefault() {
        int n = "\u6688\u6d66\u505f".length();
        int n2 = "\u6ec2\u632a\u5708\u5e54\u4e62".length();
        int n3 = "\u5692\u59c8".length();
        return new StrokeContext(Unit.Raw.valueOf(1.0f), LineCap.Butt, LineJoin.Miter, 4.0f, new Length[0], Length.ZERO);
    }

    @NotNull
    public static /* synthetic */ StrokeContext parse(@NotNull AttributeNode attributeNode) {
        int n = "\u5121".length();
        int n2 = "\u560b\u6f53".length();
        int n3 = "\u54ac".length();
        int n4 = "\u6a2f\u70b0\u66ad\u5297\u5004".length();
        return new StrokeContext(attributeNode.getLength("stroke-width"), attributeNode.getEnumNullable("stroke-linecap", LineCap.class), attributeNode.getEnumNullable("stroke-linejoin", LineJoin.class), attributeNode.getNonNegativeFloat("stroke-miterlimit", Float.NaN), attributeNode.getLengthList("stroke-dasharray"), attributeNode.getLength("stroke-dashoffset"));
    }

    public String toString() {
        int n = "\u51e9\u55dc\u705c".length();
        int n2 = "\u6c61\u5b36\u66be\u658d".length();
        return "StrokeContext{strokeWidth=" + this.strokeWidth + ", lineCap=" + (Object)((Object)this.lineCap) + ", lineJoin=" + (Object)((Object)this.lineJoin) + ", miterLimit=" + this.miterLimit + ", dashPattern=" + Arrays.toString(this.dashPattern) + ", dashOffset=" + this.dashOffset + '}';
    }

    public static int INSOLENCE_\u5942\u6506\u6b32\u6044\u5cf7\u596e\u5c15\u70a3\u4fe1\u5959\u5c9a\u5ff0\u6dab\u6d09\u4f68\u6d00\u6410\u5813\u68f6\u5692\u584f\u7088\u5af2\u58b4\u64a3\u558a\u6ea4\u5da1\u6508\u6f00\u4f38\u530a\u6d92\u57c0\u67e6\u565e\u70a1\u6bc5\u6dc5\u536d\u50db(int n) {
        return n;
    }
}

