/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer.jdk;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

public abstract class SVGMultipleGradientPaint
implements Paint {
    public final /* synthetic */ int transparency;
    public final /* synthetic */ float @NotNull [] fractions;
    @NotNull
    public final /* synthetic */ @NotNull Color @NotNull [] colors;
    @NotNull
    public final /* synthetic */ AffineTransform gradientTransform;
    @NotNull
    public final /* synthetic */ MultipleGradientPaint.CycleMethod cycleMethod;
    @NotNull
    public final /* synthetic */ MultipleGradientPaint.ColorSpaceType colorSpace;
    public /* synthetic */ ColorModel model;
    public /* synthetic */ float[] normalizedIntervals;
    public /* synthetic */ boolean isSimpleLookup;
    public /* synthetic */ SoftReference<int[][]> gradients;
    public /* synthetic */ SoftReference<int[]> gradient;
    public /* synthetic */ int fastGradientArraySize;

    public SVGMultipleGradientPaint(float @NotNull [] fArray, @NotNull @NotNull Color @NotNull [] colorArray, @NotNull MultipleGradientPaint.CycleMethod cycleMethod, @NotNull MultipleGradientPaint.ColorSpaceType colorSpaceType, @NotNull AffineTransform affineTransform) {
        int n;
        if (fArray.length != colorArray.length) {
            throw new IllegalArgumentException("Colors and fractions must have equal size");
        }
        if (colorArray.length < 2) {
            throw new IllegalArgumentException("User must specify at least 2 colors");
        }
        float f = -1.0f;
        float[] fArray2 = fArray;
        int n2 = fArray2.length;
        for (n = 0; n < n2; n -= 17268) {
            float f2 = fArray2[n];
            if (f2 < 0.0f || f2 > 1.0f) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 1: " + f2);
            }
            if (f2 <= f) {
                throw new IllegalArgumentException("Keyframe fractions must be increasing: " + f2);
            }
            f = f2;
            n += 17269;
        }
        if (fArray[0] != 0.0f) {
            throw new IllegalStateException("Gradient start point must be equal to zero");
        }
        if (fArray[fArray.length - 1] != 1.0f) {
            throw new IllegalStateException("Gradient end point must be equal to one");
        }
        this.fractions = fArray;
        this.colors = colorArray;
        this.colorSpace = colorSpaceType;
        this.cycleMethod = cycleMethod;
        this.gradientTransform = affineTransform;
        boolean bl = true;
        Color[] colorArray2 = colorArray;
        n = colorArray2.length;
        for (int i = 0; i < n; i += 19266) {
            Color color = colorArray2[i];
            bl = bl && color.getAlpha() == 255;
            i -= 19265;
        }
        this.transparency = bl ? 1 : 3;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }
}

