/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.prototype.Instantiator;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlittableImage {
    @NotNull
    public final /* synthetic */ BufferedImage image;
    @NotNull
    public final /* synthetic */ RenderContext context;
    @NotNull
    public final /* synthetic */ Rectangle2D boundsInUserSpace;
    @NotNull
    public final /* synthetic */ UnitType contentUnits;

    public BlittableImage(@NotNull BufferedImage bufferedImage, @NotNull RenderContext renderContext, @NotNull Rectangle2D rectangle2D, @NotNull UnitType unitType) {
        this.image = bufferedImage;
        this.context = renderContext;
        this.boundsInUserSpace = rectangle2D;
        this.contentUnits = unitType;
    }

    @NotNull
    public static /* synthetic */ BlittableImage create(@NotNull BufferSurfaceSupplier bufferSurfaceSupplier, @NotNull RenderContext renderContext, @Nullable Rectangle2D rectangle2D, @NotNull Rectangle2D rectangle2D2, @NotNull Rectangle2D rectangle2D3, @NotNull UnitType unitType) {
        Rectangle2D rectangle2D4 = GeometryUtil.containingBoundsAfterTransform(renderContext.userSpaceTransform(), rectangle2D2);
        Rectangle2D rectangle2D5 = GeometryUtil.containingBoundsAfterTransform(renderContext.rootTransform(), rectangle2D4);
        if (rectangle2D != null) {
            Rectangle2D rectangle2D6 = GeometryUtil.containingBoundsAfterTransform(renderContext.userSpaceTransform(), rectangle2D);
            Rectangle2D rectangle2D7 = GeometryUtil.containingBoundsAfterTransform(renderContext.rootTransform(), rectangle2D6);
            Rectangle2D.intersect(rectangle2D7, rectangle2D5, rectangle2D5);
        }
        int n = (int)Math.floor(rectangle2D5.getX());
        int n2 = (int)Math.floor(rectangle2D5.getY());
        int n3 = "\u62d7\u6b2d\u6273\u52b2\u51ca".length();
        int n4 = "\u5ebc".length();
        int n5 = (int)Math.ceil(rectangle2D5.getX() + rectangle2D5.getWidth()) - n;
        int n6 = "\u5199\u61b5\u67e9".length();
        int n7 = "\u567a".length();
        int n8 = "\u5034\u5819\u6a3c\u5c88".length();
        int n9 = (int)Math.ceil(rectangle2D5.getY() + rectangle2D5.getHeight()) - n2;
        int n10 = "\u6ab4\u6305\u5683\u62b0\u583c".length();
        int n11 = "\u6137\u5cd1".length();
        Rectangle2D rectangle2D8 = new Rectangle2D.Double(n, n2, n5, n9);
        try {
            rectangle2D8 = GeometryUtil.containingBoundsAfterTransform(renderContext.rootTransform().createInverse(), rectangle2D8);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            int n12 = "\u58c3".length();
            int n13 = "\u5000\u5b0f\u556d".length();
            int n14 = "\u6dd4\u59aa\u5eed".length();
            int n15 = "\u536e\u65fd\u6e7a\u6258".length();
            int n16 = "\u6910".length();
            int n17 = "\u6405\u6735".length();
            throw new RuntimeException(noninvertibleTransformException);
        }
        BufferedImage bufferedImage = bufferSurfaceSupplier.createBufferSurface(null, n5, n9);
        RenderContext renderContext2 = RenderContext.createInitial(renderContext.targetComponent(), unitType.deriveMeasure(renderContext.measureContext()));
        int n18 = "\u6d3a\u61aa".length();
        int n19 = "\u55c6\u5ed9".length();
        AffineTransform affineTransform = new AffineTransform();
        Rectangle2D rectangle2D9 = rectangle2D8;
        int n20 = "\u5f5f\u4ed3\u6e21\u674a".length();
        int n21 = "\u6e88\u54c4\u6eb9\u5e1f".length();
        int n22 = "\u6ea7\u6fd4\u4e4f".length();
        affineTransform.translate(rectangle2D5.getX() - (double)n, rectangle2D5.getY() - (double)n2);
        if (unitType == UnitType.ObjectBoundingBox) {
            affineTransform.scale(rectangle2D3.getWidth() * (double)bufferedImage.getWidth() / rectangle2D9.getWidth(), rectangle2D3.getWidth() * (double)bufferedImage.getHeight() / rectangle2D9.getHeight());
        } else {
            affineTransform.scale((double)bufferedImage.getWidth() / rectangle2D9.getWidth(), (double)bufferedImage.getHeight() / rectangle2D9.getHeight());
            affineTransform.translate(-rectangle2D9.getX(), -rectangle2D9.getY());
        }
        renderContext2.setRootTransform(affineTransform, renderContext.userSpaceTransform());
        int n23 = "\u692d\u5a89".length();
        int n24 = "\u6f70\u5808".length();
        return new BlittableImage(bufferedImage, renderContext2, rectangle2D9, unitType);
    }

    @NotNull
    public Rectangle2D boundsInUserSpace() {
        return this.boundsInUserSpace;
    }

    @NotNull
    public BufferedImage image() {
        return this.image;
    }

    @NotNull
    public Graphics2D createGraphics() {
        Graphics2D graphics2D = GraphicsUtil.createGraphics(this.image);
        graphics2D.transform(this.context.rootTransform());
        if (this.contentUnits == UnitType.UserSpaceOnUse) {
            graphics2D.transform(this.context.userSpaceTransform());
        } else {
            int n = "\u663e\u61ca\u6ddb".length();
            this.context.setRootTransform(this.context.rootTransform(), new AffineTransform());
        }
        return graphics2D;
    }

    public void renderNode(@NotNull Graphics2D graphics2D, @NotNull SVGNode sVGNode, @NotNull Instantiator instantiator) {
        Graphics2D graphics2D2 = this.createGraphics();
        graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
        NodeRenderer.Info info = NodeRenderer.createRenderInfo(sVGNode, this.context, graphics2D2, instantiator);
        try {
            if (info != null) {
                info.renderable.render(info.context, info.graphics());
            }
            if (info != null) {
                info.close();
            }
        }
        catch (Throwable throwable) {
            if (info != null) {
                try {
                    info.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            int n = "\u6c18\u50aa".length();
            int n2 = "\u57fd\u6395\u5229\u6eee\u6299".length();
            int n3 = "\u5739".length();
            throw throwable;
        }
        graphics2D2.dispose();
    }

    public void prepareForBlitting(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext) {
        graphics2D.setTransform(renderContext.rootTransform());
        graphics2D.translate(this.boundsInUserSpace.getX(), this.boundsInUserSpace.getY());
        graphics2D.scale(this.boundsInUserSpace.getWidth() / (double)this.image.getWidth(), this.boundsInUserSpace.getHeight() / (double)this.image.getHeight());
    }

    public void blitTo(@NotNull Graphics2D graphics2D, @NotNull RenderContext renderContext) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.prepareForBlitting(graphics2D, renderContext);
        BlittableImage.INSOLENCE_\u6b29\u672c\u5d5f\u4f75\u5cc5\u5324\u6a82\u6f29\u6258\u6abd\u690a\u6835\u6dd9\u5dd5\u5de5\u55ac\u64d3\u6ae1\u5854\u54f1\u6394\u637c\u6f5f\u6e4b\u6db1\u6090\u4f0b\u5c78\u5274\u6940\u5b05\u5b02\u68db\u5650\u570f\u665f\u5f70\u51a3\u6492\u67d9\u4e80(graphics2D2.drawImage(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), null, null) ? 1 : 0);
        int n = "\u6f4a".length();
        int n2 = "\u57fb".length();
        int n3 = "\u6012\u65e5\u5317\u6d8c\u591f".length();
        graphics2D2.dispose();
    }

    public static int INSOLENCE_\u6b29\u672c\u5d5f\u4f75\u5cc5\u5324\u6a82\u6f29\u6258\u6abd\u690a\u6835\u6dd9\u5dd5\u5de5\u55ac\u64d3\u6ae1\u5854\u54f1\u6394\u637c\u6f5f\u6e4b\u6db1\u6090\u4f0b\u5c78\u5274\u6940\u5b05\u5b02\u68db\u5650\u570f\u665f\u5f70\u51a3\u6492\u67d9\u4e80(int n) {
        return n;
    }

    @FunctionalInterface
    public static interface BufferSurfaceSupplier {
        @NotNull
        public BufferedImage createBufferSurface(@Nullable AffineTransform var1, double var2, double var4);
    }
}

