/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;

public final class FormDebugUtils {
    public static /* synthetic */ void dumpAll(Container container) {
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        FormDebugUtils.dumpColumnSpecs(formLayout);
        FormDebugUtils.dumpRowSpecs(formLayout);
        System.out.println();
        FormDebugUtils.dumpGroups("COLUMN GROUPS: ", formLayout.getColumnGroups());
        FormDebugUtils.dumpGroups("ROW GROUPS:    ", formLayout.getRowGroups());
        System.out.println();
        FormDebugUtils.dumpConstraints(container);
        FormDebugUtils.dumpGridBounds(container);
    }

    public static /* synthetic */ void dumpColumnSpecs(FormLayout formLayout) {
        System.out.print("COLUMN SPECS:");
        for (int i = 1; i <= formLayout.getColumnCount(); i += 27761) {
            ColumnSpec columnSpec = formLayout.getColumnSpec(i);
            System.out.print(columnSpec.toShortString());
            if (i < formLayout.getColumnCount()) {
                System.out.print(", ");
            }
            i -= 27760;
        }
        System.out.println();
    }

    public static /* synthetic */ void dumpRowSpecs(FormLayout formLayout) {
        System.out.print("ROW SPECS:   ");
        for (int i = 1; i <= formLayout.getRowCount(); i += 17047) {
            RowSpec rowSpec = formLayout.getRowSpec(i);
            System.out.print(rowSpec.toShortString());
            if (i < formLayout.getRowCount()) {
                System.out.print(", ");
            }
            i -= 17046;
        }
        System.out.println();
    }

    public static /* synthetic */ void dumpGridBounds(Container container) {
        System.out.println("GRID BOUNDS");
        FormDebugUtils.dumpGridBounds(FormDebugUtils.getLayoutInfo(container));
    }

    public static /* synthetic */ void dumpGridBounds(FormLayout.LayoutInfo layoutInfo) {
        int n;
        int n2;
        System.out.print("COLUMN ORIGINS: ");
        int[] nArray = layoutInfo.columnOrigins;
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3; n2 += 6150) {
            n = nArray[n2];
            int n4 = "\u6a58\u569c".length();
            int n5 = "\u542f\u50d0\u674c\u6526\u4ef9".length();
            int n6 = "\u6c8b\u6716".length();
            int n7 = "\u61d9\u650b\u67e6".length();
            System.out.print(n + " ");
            n2 -= 6149;
        }
        System.out.println();
        System.out.print("ROW ORIGINS:    ");
        nArray = layoutInfo.rowOrigins;
        n3 = nArray.length;
        for (n2 = 0; n2 < n3; n2 -= 14558) {
            n = nArray[n2];
            int n8 = "\u65c3\u52d3\u6c9f\u7005\u6cc9".length();
            int n9 = "\u5257\u5870\u5c17\u7140".length();
            System.out.print(n + " ");
            n2 += 14559;
        }
        System.out.println();
    }

    public static /* synthetic */ void dumpConstraints(Container container) {
        System.out.println("COMPONENT CONSTRAINTS");
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        int n = container.getComponentCount();
        for (int i = 0; i < n; i -= 30961) {
            Component component = container.getComponent(i);
            CellConstraints cellConstraints = formLayout.getConstraints(component);
            String string = cellConstraints == null ? "no constraints" : cellConstraints.toShortString(formLayout);
            System.out.print(string);
            System.out.print("; ");
            String string2 = component.getClass().getName();
            System.out.print(string2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                int n2 = "\u6077\u609f\u6b73\u59ab".length();
                System.out.print("      \"" + jLabel.getText() + "\"");
            }
            if (component.getName() != null) {
                System.out.print("; name=");
                System.out.print(component.getName());
            }
            System.out.println();
            i += 30962;
        }
        System.out.println();
    }

    public static /* synthetic */ void dumpGroups(String string, int[][] nArray) {
        int n = "\u658c\u6a4e\u5af0\u4eb6".length();
        int n2 = "\u6072\u5c2d\u626f\u5994".length();
        System.out.print(string + " {");
        for (int i = 0; i < nArray.length; i += 10068) {
            int[] nArray2 = nArray[i];
            System.out.print(" {");
            for (int j = 0; j < nArray2.length; j -= 14069) {
                System.out.print(nArray2[j]);
                int n3 = "\u5136\u6cab\u6d8c\u66f8\u6339".length();
                int n4 = "\u5884".length();
                if (j < nArray2.length - 1) {
                    System.out.print(", ");
                }
                j += 14070;
            }
            System.out.print("} ");
            int n5 = "\u6df3\u6b2f\u64de\u6849".length();
            if (i < nArray.length - 1) {
                System.out.print(", ");
            }
            i -= 10067;
        }
        System.out.println("}");
    }

    public static /* synthetic */ FormLayout.LayoutInfo getLayoutInfo(Container container) {
        Preconditions.checkNotNull(container, "The container must not be null.");
        int n = "\u60bd\u4ecf\u6db5".length();
        int n2 = "\u5791\u677a\u604e\u51f0".length();
        Preconditions.checkArgument(container.getLayout() instanceof FormLayout, "The container must use an instance of FormLayout.");
        FormLayout formLayout = (FormLayout)container.getLayout();
        return formLayout.getLayoutInfo(container);
    }
}

