/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;

public final class CellConstraints
implements Cloneable,
Serializable {
    public static final /* synthetic */ Alignment DEFAULT;
    public static final /* synthetic */ Alignment FILL;
    public static final /* synthetic */ Alignment LEFT;
    public static final /* synthetic */ Alignment RIGHT;
    public static final /* synthetic */ Alignment CENTER;
    public static final /* synthetic */ Alignment TOP;
    public static final /* synthetic */ Alignment BOTTOM;
    public static final /* synthetic */ Alignment[] VALUES;
    public static final /* synthetic */ Insets EMPTY_INSETS;
    public /* synthetic */ int gridX;
    public /* synthetic */ int gridY;
    public /* synthetic */ int gridWidth;
    public /* synthetic */ int gridHeight;
    public /* synthetic */ Alignment hAlign;
    public /* synthetic */ Alignment vAlign;
    public /* synthetic */ Insets insets;
    public /* synthetic */ Boolean honorsVisibility;

    public CellConstraints() {
        this(1, 1);
    }

    public CellConstraints(int n, int n2) {
        this(n, n2, 1, 1);
    }

    public CellConstraints(int n, int n2, Alignment alignment, Alignment alignment2) {
        this(n, n2, 1, 1, alignment, alignment2, EMPTY_INSETS);
    }

    public CellConstraints(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT, DEFAULT);
    }

    public CellConstraints(int n, int n2, int n3, int n4, Alignment alignment, Alignment alignment2) {
        this(n, n2, n3, n4, alignment, alignment2, EMPTY_INSETS);
    }

    public CellConstraints(int n, int n2, int n3, int n4, Alignment alignment, Alignment alignment2, Insets insets) {
        this.gridX = n;
        this.gridY = n2;
        this.gridWidth = n3;
        this.gridHeight = n4;
        this.hAlign = alignment;
        this.vAlign = alignment2;
        this.insets = insets;
        if (n <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        if (n2 <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (n3 <= 0) {
            throw new IndexOutOfBoundsException("The grid width must be a positive number.");
        }
        if (n4 <= 0) {
            throw new IndexOutOfBoundsException("The grid height must be a positive number.");
        }
        Preconditions.checkNotNull(alignment, "The horizontal alignment must not be null.");
        Preconditions.checkNotNull(alignment2, "The vertical alignment must not be null.");
        CellConstraints.ensureValidOrientations(alignment, alignment2);
    }

    public CellConstraints(String string) {
        this();
        this.initFromConstraints(string);
    }

    public CellConstraints translate(int n, int n2) {
        int n3 = "\u701c\u5940\u598f\u68c7".length();
        int n4 = "\u7134\u5301\u5a46\u5ecc\u69c9".length();
        int n5 = "\u5eac\u64e3\u651d".length();
        return new CellConstraints(CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(this.gridX, n), CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(this.gridY, n2), this.gridWidth, this.gridHeight, this.hAlign, this.vAlign, this.insets);
    }

    public CellConstraints xy(int n, int n2) {
        return this.xywh(n, n2, 1, 1);
    }

    public CellConstraints xy(int n, int n2, String string) {
        return this.xywh(n, n2, 1, 1, string);
    }

    public CellConstraints xy(int n, int n2, Alignment alignment, Alignment alignment2) {
        return this.xywh(n, n2, 1, 1, alignment, alignment2);
    }

    public CellConstraints xyw(int n, int n2, int n3) {
        return this.xywh(n, n2, n3, 1, DEFAULT, DEFAULT);
    }

    public CellConstraints xyw(int n, int n2, int n3, String string) {
        return this.xywh(n, n2, n3, 1, string);
    }

    public CellConstraints xyw(int n, int n2, int n3, Alignment alignment, Alignment alignment2) {
        return this.xywh(n, n2, n3, 1, alignment, alignment2);
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4) {
        return this.xywh(n, n2, n3, n4, DEFAULT, DEFAULT);
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4, String string) {
        CellConstraints cellConstraints = this.xywh(n, n2, n3, n4);
        cellConstraints.setAlignments(string, true);
        return cellConstraints;
    }

    public CellConstraints xywh(int n, int n2, int n3, int n4, Alignment alignment, Alignment alignment2) {
        this.gridX = n;
        this.gridY = n2;
        this.gridWidth = n3;
        this.gridHeight = n4;
        this.hAlign = alignment;
        this.vAlign = alignment2;
        CellConstraints.ensureValidOrientations(this.hAlign, this.vAlign);
        return this;
    }

    public CellConstraints rc(int n, int n2) {
        return this.rchw(n, n2, 1, 1);
    }

    public CellConstraints rc(int n, int n2, String string) {
        return this.rchw(n, n2, 1, 1, string);
    }

    public CellConstraints rc(int n, int n2, Alignment alignment, Alignment alignment2) {
        return this.rchw(n, n2, 1, 1, alignment, alignment2);
    }

    public CellConstraints rcw(int n, int n2, int n3) {
        return this.rchw(n, n2, 1, n3, DEFAULT, DEFAULT);
    }

    public CellConstraints rcw(int n, int n2, int n3, String string) {
        return this.rchw(n, n2, 1, n3, string);
    }

    public CellConstraints rcw(int n, int n2, int n3, Alignment alignment, Alignment alignment2) {
        return this.rchw(n, n2, 1, n3, alignment, alignment2);
    }

    public CellConstraints rchw(int n, int n2, int n3, int n4) {
        return this.rchw(n, n2, n3, n4, DEFAULT, DEFAULT);
    }

    public CellConstraints rchw(int n, int n2, int n3, int n4, String string) {
        CellConstraints cellConstraints = this.rchw(n, n2, n3, n4);
        cellConstraints.setAlignments(string, false);
        return cellConstraints;
    }

    public CellConstraints rchw(int n, int n2, int n3, int n4, Alignment alignment, Alignment alignment2) {
        return this.xywh(n2, n, n4, n3, alignment2, alignment);
    }

    public void initFromConstraints(String string) {
        int n = "\u703c\u6583".length();
        int n2 = "\u5ff6\u6e07\u6100\u6ccd\u510a".length();
        int n3 = "\u5f4e".length();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n4 = stringTokenizer.countTokens();
        Preconditions.checkArgument(n4 == 2 || n4 == 4 || n4 == 6, "You must provide 2, 4 or 6 arguments.");
        Integer n5 = CellConstraints.decodeInt(stringTokenizer.nextToken());
        Preconditions.checkArgument(n5 != null, "First cell constraint element must be a number.");
        this.gridX = n5;
        Preconditions.checkArgument(this.gridX > 0, "The grid x must be a positive number.");
        n5 = CellConstraints.decodeInt(stringTokenizer.nextToken());
        Preconditions.checkArgument(n5 != null, "Second cell constraint element must be a number.");
        this.gridY = n5;
        Preconditions.checkArgument(this.gridY > 0, "The grid y must be a positive number.");
        if (CellConstraints.INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(stringTokenizer.hasMoreTokens() ? 1 : 0) == 0) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        n5 = CellConstraints.decodeInt(string2);
        if (n5 != null) {
            this.gridWidth = n5;
            if (this.gridWidth <= 0) {
                int n6 = "\u5396".length();
                int n7 = "\u67d4\u52e7\u54e3".length();
                int n8 = "\u6466\u5d59\u589e".length();
                int n9 = "\u561d\u6ce2\u6c57".length();
                int n10 = "\u6627\u62a5".length();
                int n11 = "\u53f7\u6c71\u67a4\u55e6".length();
                int n12 = "\u634a\u6710\u711d\u703b".length();
                throw new IndexOutOfBoundsException("The grid width must be a positive number.");
            }
            n5 = CellConstraints.decodeInt(stringTokenizer.nextToken());
            if (n5 == null) {
                int n13 = "\u6f8a\u6677\u608b".length();
                int n14 = "\u665e\u5bc1".length();
                int n15 = "\u6598\u6cf9\u578a\u6500\u501f".length();
                int n16 = "\u671e\u590a\u61f1\u6c26".length();
                throw new IllegalArgumentException("Fourth cell constraint element must be like third.");
            }
            this.gridHeight = n5;
            if (this.gridHeight <= 0) {
                int n17 = "\u6c0e\u63d4\u63f1\u6583".length();
                int n18 = "\u7019\u514d\u6328".length();
                int n19 = "\u6fcd\u5ad2\u4fd5\u5f65".length();
                int n20 = "\u692a\u65ca\u652d".length();
                int n21 = "\u6c09\u6b49\u6b30\u530a".length();
                int n22 = "\u5d49\u695f".length();
                throw new IndexOutOfBoundsException("The grid height must be a positive number.");
            }
            if (CellConstraints.INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(stringTokenizer.hasMoreTokens() ? 1 : 0) == 0) {
                return;
            }
            string2 = stringTokenizer.nextToken();
        }
        this.hAlign = CellConstraints.decodeAlignment(string2);
        this.vAlign = CellConstraints.decodeAlignment(stringTokenizer.nextToken());
        CellConstraints.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    public void setAlignments(String string, boolean bl) {
        int n = "\u6220\u5341\u5ba0\u5682".length();
        int n2 = "\u5243\u60ec".length();
        int n3 = "\u70e7".length();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        Alignment alignment = CellConstraints.decodeAlignment(stringTokenizer.nextToken());
        Alignment alignment2 = CellConstraints.decodeAlignment(stringTokenizer.nextToken());
        this.hAlign = bl ? alignment : alignment2;
        this.vAlign = bl ? alignment2 : alignment;
        CellConstraints.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    public static /* synthetic */ Integer decodeInt(String string) {
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static /* synthetic */ Alignment decodeAlignment(String string) {
        return Alignment.valueOf(string);
    }

    public void ensureValidGridBounds(int n, int n2) {
        if (this.gridX <= 0) {
            int n3 = "\u5d3a\u5fa0\u68d8\u582d\u6e17".length();
            int n4 = "\u5994\u5f08".length();
            int n5 = "\u687f\u622e\u62df".length();
            int n6 = "\u5754".length();
            int n7 = "\u60ff\u54ee\u59c0\u545d\u6cec".length();
            int n8 = "\u62f9\u52a6\u652c\u577a".length();
            int n9 = "\u5cfe".length();
            int n10 = "\u689e\u5d53".length();
            int n11 = "\u4e3a\u55d4".length();
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be positive.");
        }
        if (this.gridX > n) {
            int n12 = "\u55ee\u6bf1\u4e3e".length();
            int n13 = "\u6160\u6cd7".length();
            int n14 = "\u60f8\u564c".length();
            int n15 = "\u5e92\u6320\u6e5a".length();
            int n16 = "\u58f8\u6a96\u5898\u55cb\u5e07".length();
            int n17 = "\u6035\u6061\u5dbb\u55ee\u7054".length();
            int n18 = "\u6549\u5a7a\u703a\u5867".length();
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be less than or equal to " + n + ".");
        }
        int n19 = "\u5062\u5a25\u575f\u56bf\u5fb6".length();
        int n20 = "\u6175\u62b0\u55de\u5d71\u5aed".length();
        if (CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(this.gridX, this.gridWidth) - 1 > n) {
            int n21 = "\u6487".length();
            int n22 = "\u5efa\u6593\u5650\u4ec4\u5a2b".length();
            int n23 = "\u6429\u5206\u6318".length();
            int n24 = "\u6335\u4ec6\u5de4\u6b1b\u5eba".length();
            int n25 = "\u6cb7\u4f57\u6de6".length();
            int n26 = "\u5360".length();
            int n27 = "\u54e0\u6e52\u5470\u5e0a\u679b".length();
            int n28 = "\u5c7f".length();
            int n29 = "\u68ed\u685b\u5f47".length();
            int n30 = "\u6340\u5dea\u51ab".length();
            int n31 = "\u63fd\u570d\u6992".length();
            int n32 = "\u59d2\u6bc7\u64d5\u6597".length();
            int n33 = "\u514b\u6306\u710c".length();
            int n34 = "\u5008\u5e9e".length();
            throw new IndexOutOfBoundsException("The grid width " + this.gridWidth + " must be less than or equal to " + CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(n - this.gridX, 1) + ".");
        }
        if (this.gridY <= 0) {
            int n35 = "\u5e92\u6a1a\u7111\u6b83".length();
            int n36 = "\u4e2c\u6a78".length();
            int n37 = "\u50e0\u53c8\u5b30".length();
            int n38 = "\u6f1d\u699d\u5dc4\u62a7".length();
            int n39 = "\u5bff\u54e9\u6e2e\u6fee".length();
            int n40 = "\u6c9a\u5c4d\u5a5e\u57cf".length();
            int n41 = "\u5378\u4efa".length();
            int n42 = "\u550f\u5218\u66ed\u669c\u6c3e".length();
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be positive.");
        }
        if (this.gridY > n2) {
            int n43 = "\u524a\u58f8".length();
            int n44 = "\u6633".length();
            int n45 = "\u522b".length();
            int n46 = "\u6d54".length();
            int n47 = "\u5d0f\u5b4e".length();
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be less than or equal to " + n2 + ".");
        }
        int n48 = "\u5969".length();
        if (CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(this.gridY, this.gridHeight) - 1 > n2) {
            int n49 = "\u641f\u5052\u6d35\u5026\u4e35".length();
            int n50 = "\u66d5\u6c47".length();
            int n51 = "\u6fa4".length();
            int n52 = "\u65ce\u68c6\u5de8\u4f62".length();
            int n53 = "\u5078\u5225".length();
            int n54 = "\u5f6a\u565a".length();
            int n55 = "\u51b7\u6069\u5776\u5250".length();
            int n56 = "\u70b1\u6d50".length();
            int n57 = "\u5e59\u516a\u61fe\u51a9".length();
            throw new IndexOutOfBoundsException("The grid height " + this.gridHeight + " must be less than or equal to " + CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(n2 - this.gridY, 1) + ".");
        }
    }

    public static /* synthetic */ void ensureValidOrientations(Alignment alignment, Alignment alignment2) {
        if (CellConstraints.INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(Alignment.access$100(alignment) ? 1 : 0) == 0) {
            int n = "\u5954\u6871\u709b".length();
            int n2 = "\u6568\u6dc5".length();
            int n3 = "\u6d10\u5bb7".length();
            throw new IllegalArgumentException("The horizontal alignment must be one of: left, center, right, fill, default.");
        }
        if (CellConstraints.INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(Alignment.access$200(alignment2) ? 1 : 0) == 0) {
            int n = "\u6b6c\u6cce".length();
            int n4 = "\u662d\u6905".length();
            int n5 = "\u5420".length();
            int n6 = "\u6118\u4f91\u5965\u528e\u5860".length();
            int n7 = "\u5571\u6752\u5298".length();
            int n8 = "\u63b0\u5e3e\u63b9\u6556\u6a4b".length();
            throw new IllegalArgumentException("The vertical alignment must be one of: top, center, bottom, fill, default.");
        }
    }

    public void setBounds(Component component, FormLayout formLayout, Rectangle rectangle, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3, FormLayout.Measure measure4) {
        ColumnSpec columnSpec = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
        RowSpec rowSpec = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
        Alignment alignment = CellConstraints.concreteAlignment(this.hAlign, columnSpec);
        Alignment alignment2 = CellConstraints.concreteAlignment(this.vAlign, rowSpec);
        Insets insets = this.insets != null ? this.insets : EMPTY_INSETS;
        int n = CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(rectangle.x, insets.left);
        int n2 = CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(rectangle.y, insets.top);
        int n3 = "\u6b4b\u66f9\u555f\u61bd\u641f".length();
        int n4 = "\u7054".length();
        int n5 = "\u527b\u4f9e\u64db\u6564\u5363".length();
        int n6 = "\u5ffc\u5270\u6d92\u52a2\u59e6".length();
        int n7 = "\u6f21\u530b\u5876\u6798\u5bba".length();
        int n8 = "\u4e3f\u6e53\u5ef7\u54af".length();
        int n9 = "\u5d7c\u4f9f\u5565".length();
        int n10 = rectangle.width - insets.left - insets.right;
        int n11 = "\u5b2e\u56d6\u62c6".length();
        int n12 = "\u5c8a\u5650\u700c\u5de0\u5d44".length();
        int n13 = "\u4f8f\u4e30\u6a3e\u5226\u520a".length();
        int n14 = "\u5261\u5a7f\u67b9\u70c8\u6da6".length();
        int n15 = rectangle.height - insets.top - insets.bottom;
        int n16 = CellConstraints.componentSize(component, columnSpec, n10, measure, measure3);
        int n17 = CellConstraints.componentSize(component, rowSpec, n15, measure2, measure4);
        int n18 = CellConstraints.origin(alignment, n, n10, n16);
        int n19 = CellConstraints.origin(alignment2, n2, n15, n17);
        int n20 = CellConstraints.extent(alignment, n10, n16);
        int n21 = CellConstraints.extent(alignment2, n15, n17);
        component.setBounds(n18, n19, n20, n21);
    }

    public static /* synthetic */ Alignment concreteAlignment(Alignment alignment, FormSpec formSpec) {
        return formSpec == null ? (alignment == DEFAULT ? FILL : alignment) : CellConstraints.usedAlignment(alignment, formSpec);
    }

    public static /* synthetic */ Alignment usedAlignment(Alignment alignment, FormSpec formSpec) {
        if (alignment != DEFAULT) {
            return alignment;
        }
        FormSpec.DefaultAlignment defaultAlignment = formSpec.getDefaultAlignment();
        if (defaultAlignment == FormSpec.FILL_ALIGN) {
            return FILL;
        }
        if (defaultAlignment == ColumnSpec.LEFT) {
            return LEFT;
        }
        if (defaultAlignment == FormSpec.CENTER_ALIGN) {
            return CENTER;
        }
        if (defaultAlignment == ColumnSpec.RIGHT) {
            return RIGHT;
        }
        if (defaultAlignment == RowSpec.TOP) {
            return TOP;
        }
        return BOTTOM;
    }

    public static /* synthetic */ int componentSize(Component component, FormSpec formSpec, int n, FormLayout.Measure measure, FormLayout.Measure measure2) {
        if (formSpec == null) {
            return measure2.sizeOf(component);
        }
        if (formSpec.getSize() == Sizes.MINIMUM) {
            return measure.sizeOf(component);
        }
        if (formSpec.getSize() == Sizes.PREFERRED) {
            return measure2.sizeOf(component);
        }
        return Math.min(n, measure2.sizeOf(component));
    }

    public static /* synthetic */ int origin(Alignment alignment, int n, int n2, int n3) {
        if (alignment == RIGHT || alignment == BOTTOM) {
            int n4 = "\u604d\u6873\u60ea\u5a5e\u7026".length();
            return CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(n, n2) - n3;
        }
        if (alignment == CENTER) {
            int n5 = "\u6a15\u65c5\u6714".length();
            int n6 = "\u6f92".length();
            return CellConstraints.INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(n, (n2 - n3) / 2);
        }
        return n;
    }

    public static /* synthetic */ int extent(Alignment alignment, int n, int n2) {
        return alignment == FILL ? n : n2;
    }

    public Object clone() {
        try {
            CellConstraints cellConstraints = (CellConstraints)super.clone();
            cellConstraints.insets = (Insets)this.insets.clone();
            return cellConstraints;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            int n = "\u5be6".length();
            int n2 = "\u55b9".length();
            int n3 = "\u5114\u5525\u66f6\u6ac1\u642d".length();
            int n4 = "\u6e19\u686a\u543a".length();
            throw new InternalError();
        }
    }

    public String toString() {
        int n = "\u514f".length();
        int n2 = "\u58fc\u5f71\u66b9\u51cf".length();
        StringBuffer stringBuffer = new StringBuffer("CellConstraints");
        stringBuffer.append("[x=");
        int n3 = "\u65ef\u510a\u6105\u5f04".length();
        int n4 = "\u6fab\u57af\u6c02\u5524".length();
        stringBuffer.append(this.gridX);
        int n5 = "\u5e6f\u5f06\u5532\u6d19\u55a8".length();
        int n6 = "\u6369\u5f69\u5259\u53df\u4eae".length();
        int n7 = "\u5f15\u4eb8\u56c8".length();
        stringBuffer.append("; y=");
        int n8 = "\u6bd5\u685f\u50d1\u61a8".length();
        int n9 = "\u5b59\u6d23\u4fba\u6b89".length();
        stringBuffer.append(this.gridY);
        int n10 = "\u5189\u6269".length();
        int n11 = "\u5635\u50d0\u5e86".length();
        stringBuffer.append("; w=");
        int n12 = "\u64a6\u63cd\u5271\u5c3f".length();
        int n13 = "\u6714\u5128".length();
        int n14 = "\u6b35".length();
        int n15 = "\u552f".length();
        stringBuffer.append(this.gridWidth);
        int n16 = "\u567d\u5cbb\u51c9".length();
        int n17 = "\u63e4".length();
        int n18 = "\u609c\u5466\u6fb0".length();
        stringBuffer.append("; h=");
        int n19 = "\u58b8\u6f73\u705f".length();
        stringBuffer.append(this.gridHeight);
        int n20 = "\u5835\u5965\u6b73\u5474\u62a9".length();
        stringBuffer.append("; hAlign=");
        int n21 = "\u5116\u6095\u6e72\u65eb".length();
        int n22 = "\u6166\u5637\u60a4\u5213\u5c79".length();
        int n23 = "\u5884\u6546\u59c2\u5496".length();
        stringBuffer.append(this.hAlign);
        int n24 = "\u547f".length();
        int n25 = "\u61f4".length();
        int n26 = "\u526d\u638f\u504f\u58c9\u6e65".length();
        stringBuffer.append("; vAlign=");
        int n27 = "\u6c45\u5793\u6c98\u6dbc".length();
        int n28 = "\u5de8\u4e8d\u6e72".length();
        stringBuffer.append(this.vAlign);
        int n29 = "\u653e\u67d6\u5744\u6407\u6c9e".length();
        if (CellConstraints.INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(EMPTY_INSETS.equals(this.insets) ? 1 : 0) == 0) {
            stringBuffer.append("; insets=");
            int n30 = "\u6019\u64bd\u5b3c".length();
            int n31 = "\u675a\u58fa\u555f".length();
            stringBuffer.append(this.insets);
            int n32 = "\u6135\u6094\u4eb3\u584c".length();
            int n33 = "\u5285\u52d3\u67c2".length();
        }
        stringBuffer.append("; honorsVisibility=");
        int n34 = "\u60f4\u5fa1".length();
        int n35 = "\u6232\u51c8".length();
        int n36 = "\u59e6\u70a4".length();
        int n37 = "\u6635\u53ac\u5556\u5925\u5e9b".length();
        stringBuffer.append(this.honorsVisibility);
        int n38 = "\u5ade\u5329\u5b35\u6e80".length();
        int n39 = "\u70f9\u6e0a\u6e88\u6a43".length();
        int n40 = "\u7104\u7127\u5375".length();
        int n41 = "\u4f29\u5738\u6cd2\u6a39".length();
        int n42 = "\u6893".length();
        stringBuffer.append(']');
        int n43 = "\u570b\u523c\u6fc4\u5cc9".length();
        int n44 = "\u56f4".length();
        return stringBuffer.toString();
    }

    public String toShortString() {
        return this.toShortString(null);
    }

    public String toShortString(FormLayout formLayout) {
        ColumnSpec columnSpec;
        int n = "\u5b9c\u6d2c".length();
        int n2 = "\u620b\u5842\u6a0e".length();
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(CellConstraints.formatInt(this.gridX));
        int n3 = "\u6e76\u534a\u5c67\u6c9d\u57a1".length();
        int n4 = "\u68d0\u649f\u6783".length();
        int n5 = "\u5346\u5620".length();
        int n6 = "\u6950\u6cd0\u6d36".length();
        stringBuffer.append(", ");
        int n7 = "\u6abc\u5c57\u67ba".length();
        stringBuffer.append(CellConstraints.formatInt(this.gridY));
        int n8 = "\u5ee4\u5d50\u56f6".length();
        stringBuffer.append(", ");
        int n9 = "\u656c".length();
        int n10 = "\u6742\u6e4f\u5abc\u5417\u696a".length();
        int n11 = "\u5234".length();
        int n12 = "\u6c54\u5007\u6390\u54f6".length();
        stringBuffer.append(CellConstraints.formatInt(this.gridWidth));
        int n13 = "\u61b7\u681f\u6080\u698e\u62f1".length();
        int n14 = "\u622a\u5b22".length();
        int n15 = "\u5d7a\u5914\u5e7b".length();
        stringBuffer.append(", ");
        int n16 = "\u6b75\u6cd9\u4f2b\u610d\u521a".length();
        stringBuffer.append(CellConstraints.formatInt(this.gridHeight));
        int n17 = "\u6268\u51cf\u4e67\u5736".length();
        int n18 = "\u709f\u63e7".length();
        int n19 = "\u5af0\u61fb".length();
        stringBuffer.append(", \"");
        int n20 = "\u62dc\u646e\u62a7\u6ae2".length();
        int n21 = "\u5df3\u501c".length();
        stringBuffer.append(this.hAlign.abbreviation());
        int n22 = "\u6fef".length();
        if (this.hAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            int n23 = "\u6742\u6809\u54b1\u6380\u557a".length();
            int n24 = "\u6e3b\u545b\u587e\u5962".length();
            int n25 = "\u6435".length();
            columnSpec = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
            stringBuffer.append(CellConstraints.concreteAlignment(this.hAlign, columnSpec).abbreviation());
            int n26 = "\u544e\u6812\u63c2".length();
            int n27 = "\u65bc\u6abe\u6213".length();
            int n28 = "\u5fb5\u600a".length();
        }
        stringBuffer.append(", ");
        int n29 = "\u6b2e\u4f83\u6cbd".length();
        int n30 = "\u508b\u5a92".length();
        int n31 = "\u6b2c\u6c93\u6081\u656f\u69eb".length();
        stringBuffer.append(this.vAlign.abbreviation());
        int n32 = "\u680f\u573b".length();
        int n33 = "\u6710\u502c\u6faa\u6123\u6781".length();
        if (this.vAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            int n34 = "\u6426\u5dd5".length();
            int n35 = "\u7056\u711c\u574e\u6d64\u6105".length();
            int n36 = "\u6cea\u69ac\u51a2\u6422\u6271".length();
            columnSpec = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
            stringBuffer.append(CellConstraints.concreteAlignment(this.vAlign, columnSpec).abbreviation());
            int n37 = "\u5526\u5e27\u5786".length();
            int n38 = "\u6d08".length();
        }
        stringBuffer.append("\"");
        int n39 = "\u6cff\u5541".length();
        int n40 = "\u5343\u5699\u6bd3\u6755".length();
        int n41 = "\u6079\u5aa0".length();
        int n42 = "\u664a\u5446\u6911".length();
        if (CellConstraints.INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(EMPTY_INSETS.equals(this.insets) ? 1 : 0) == 0) {
            stringBuffer.append(", ");
            int n43 = "\u69d7\u6fc8\u5a96\u50c0".length();
            int n44 = "\u52b2".length();
            stringBuffer.append(this.insets);
            int n45 = "\u51e8\u5d01\u68b0".length();
            int n46 = "\u560e\u4e48\u5586".length();
            int n47 = "\u6c6c\u57c3\u5e61\u54f9".length();
            int n48 = "\u6541\u6fad\u562c\u5f72\u5f28".length();
            int n49 = "\u5e1f\u5106".length();
        }
        if (this.honorsVisibility != null) {
            stringBuffer.append(CellConstraints.INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(this.honorsVisibility.booleanValue() ? 1 : 0) != 0 ? "honors visibility" : "ignores visibility");
            int n50 = "\u4e21\u5257\u4f9e\u6413\u5b16".length();
            int n51 = "\u50d0\u704c".length();
            int n52 = "\u586a\u60a6".length();
        }
        stringBuffer.append(')');
        int n53 = "\u6294\u4e5c\u6741\u6e0b\u62a4".length();
        int n54 = "\u521a\u54ec\u6310".length();
        return stringBuffer.toString();
    }

    public static /* synthetic */ String formatInt(int n) {
        String string;
        String string2 = Integer.toString(n);
        if (n < 10) {
            int n2 = "\u63d6\u54e8\u5d72\u6219".length();
            int n3 = "\u6cac\u64e0\u4f49\u545f\u547f".length();
            int n4 = "\u6874".length();
            string = " " + string2;
        } else {
            string = string2;
        }
        return string;
    }

    static {
        DEFAULT = new Alignment("default", 2, null);
        FILL = new Alignment("fill", 2, null);
        LEFT = new Alignment("left", 0, null);
        RIGHT = new Alignment("right", 0, null);
        CENTER = new Alignment("center", 2, null);
        TOP = new Alignment("top", 1, null);
        BOTTOM = new Alignment("bottom", 1, null);
        VALUES = new Alignment[]{DEFAULT, FILL, LEFT, RIGHT, CENTER, TOP, BOTTOM};
        EMPTY_INSETS = new Insets(0, 0, 0, 0);
    }

    public static int INSOLENCE_\u56c7\u6121\u6302\u577b\u64de\u4f73\u57a9\u52d6\u6d61\u5c37\u5853\u6b99\u6637\u5e3b\u5600\u67e6\u60d9\u60a8\u6fd4\u6895\u5a39\u5088\u5491\u5b66\u54c4\u5c58\u5cb3\u6deb\u6976\u6ab3\u5818\u711f\u6714\u5def\u5d25\u5fce\u531d\u5e87\u6ec7\u656c\u6a88(int n) {
        return n;
    }

    public static int INSOLENCE_\u4ff6\u596a\u6e7d\u5f8f\u68b2\u5811\u6038\u6157\u6dd5\u6f0c\u6841\u5557\u6bb8\u58fe\u5293\u58b1\u6525\u4fa2\u5d32\u619e\u6adb\u5da2\u69e2\u5e99\u6242\u5043\u64cb\u5a7f\u5757\u5e42\u556f\u5c46\u5ac6\u5794\u5a98\u5bf9\u6da7\u6325\u6fea\u62e7\u69ab(int n, int n2) {
        return ((n | n2) << 1) + ~(n ^ n2) + 1;
    }

    public static class 1 {
    }

    public static final class Alignment
    implements Serializable {
        public static final /* synthetic */ int HORIZONTAL = 0;
        public static final /* synthetic */ int VERTICAL = 1;
        public static final /* synthetic */ int BOTH = 2;
        public final transient /* synthetic */ String name;
        public final transient /* synthetic */ int orientation;
        public static /* synthetic */ int nextOrdinal;
        public final /* synthetic */ int ordinal;

        public Alignment(String string, int n) {
            int n2 = nextOrdinal;
            nextOrdinal = Alignment.INSOLENCE_\u69a6\u6de2\u5623\u63f0\u4f01\u59ae\u5892\u6c94\u6160\u6aa3\u64db\u6916\u5096\u5a1e\u5c8f\u6602\u6150\u6c41\u6581\u677e\u50a4\u585d\u7034\u52ff\u5737\u6e78\u56df\u5ae5\u5066\u658b\u6a98\u4edd\u4f94\u5b16\u6247\u58ae\u5e0c\u6a4f\u60f6\u62b0\u5137(n2, 1);
            this.ordinal = n2;
            this.name = string;
            this.orientation = n;
        }

        public static /* synthetic */ Alignment valueOf(String string) {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            if (Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("d") ? 1 : 0) != 0 || Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("default") ? 1 : 0) != 0) {
                return DEFAULT;
            }
            if (Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("f") ? 1 : 0) != 0 || Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("fill") ? 1 : 0) != 0) {
                return FILL;
            }
            if (Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("c") ? 1 : 0) != 0 || Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("center") ? 1 : 0) != 0) {
                return CENTER;
            }
            if (Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("l") ? 1 : 0) != 0 || Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("left") ? 1 : 0) != 0) {
                return LEFT;
            }
            if (Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("r") ? 1 : 0) != 0 || Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("right") ? 1 : 0) != 0) {
                return RIGHT;
            }
            if (Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("t") ? 1 : 0) != 0 || Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("top") ? 1 : 0) != 0) {
                return TOP;
            }
            if (Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("b") ? 1 : 0) != 0 || Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(string2.equals("bottom") ? 1 : 0) != 0) {
                return BOTTOM;
            }
            int n = "\u5fe7\u4e39\u6574".length();
            int n2 = "\u6626\u6e59\u58fd".length();
            int n3 = "\u50ba\u7030\u53d1\u6a74\u569c".length();
            int n4 = "\u601d\u5c87\u69af".length();
            int n5 = "\u5078\u604a\u65f7".length();
            int n6 = "\u51ad\u5169\u54b1\u5387\u6364".length();
            int n7 = "\u6a37\u50ed\u51c0\u61a8".length();
            int n8 = "\u6504\u6f27\u6409".length();
            int n9 = "\u67a8".length();
            throw new IllegalArgumentException("Invalid alignment " + string + ". Must be one of: left, center, right, top, bottom, " + "fill, default, l, c, r, t, b, f, d.");
        }

        public String toString() {
            return this.name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        public boolean isHorizontal() {
            return this.orientation != 1;
        }

        public boolean isVertical() {
            return this.orientation != 0;
        }

        public Object readResolve() {
            return VALUES[this.ordinal];
        }

        public /* synthetic */ Alignment(String string, int n, 1 var3_3) {
            this(string, n);
        }

        public static /* synthetic */ boolean access$100(Alignment alignment) {
            return Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(alignment.isHorizontal() ? 1 : 0) != 0;
        }

        public static /* synthetic */ boolean access$200(Alignment alignment) {
            return Alignment.INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(alignment.isVertical() ? 1 : 0) != 0;
        }

        static {
            nextOrdinal = 0;
        }

        public static int INSOLENCE_\u64c5\u5fd6\u629c\u5d5d\u5a1f\u6331\u70c9\u4e3b\u6e52\u6571\u5a90\u5062\u6319\u6221\u70e6\u6c23\u513a\u6d8e\u6dda\u4e84\u4e53\u68ab\u5b00\u61c3\u5b73\u6907\u5031\u5deb\u67e6\u62df\u53b2\u6aca\u6308\u5058\u4f74\u6d7c\u675e\u60fa\u5fbe\u6786\u6b86(int n) {
            return n;
        }

        public static int INSOLENCE_\u69a6\u6de2\u5623\u63f0\u4f01\u59ae\u5892\u6c94\u6160\u6aa3\u64db\u6916\u5096\u5a1e\u5c8f\u6602\u6150\u6c41\u6581\u677e\u50a4\u585d\u7034\u52ff\u5737\u6e78\u56df\u5ae5\u5066\u658b\u6a98\u4edd\u4f94\u5b16\u6247\u58ae\u5e0c\u6a4f\u60f6\u62b0\u5137(int n, int n2) {
            return ((n | n2) << 1) + ~(n ^ n2) + 1;
        }
    }
}

