/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.common.base.Objects;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.LayoutMap;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public final class FormLayout
implements LayoutManager2,
Serializable {
    public final /* synthetic */ List<ColumnSpec> colSpecs;
    public final /* synthetic */ List<RowSpec> rowSpecs;
    public /* synthetic */ int[][] colGroupIndices;
    public /* synthetic */ int[][] rowGroupIndices;
    public final /* synthetic */ Map<Component, CellConstraints> constraintMap;
    public /* synthetic */ boolean honorsVisibility;
    public transient /* synthetic */ List<Component>[] colComponents;
    public transient /* synthetic */ List<Component>[] rowComponents;
    public final /* synthetic */ ComponentSizeCache componentSizeCache;
    public final /* synthetic */ Measure minimumWidthMeasure;
    public final /* synthetic */ Measure minimumHeightMeasure;
    public final /* synthetic */ Measure preferredWidthMeasure;
    public final /* synthetic */ Measure preferredHeightMeasure;

    public FormLayout() {
        this(new ColumnSpec[0], new RowSpec[0]);
    }

    public FormLayout(String string) {
        this(string, LayoutMap.getRoot());
    }

    public FormLayout(String string, LayoutMap layoutMap) {
        this(ColumnSpec.decodeSpecs(string, layoutMap), new RowSpec[0]);
    }

    public FormLayout(String string, String string2) {
        this(string, string2, LayoutMap.getRoot());
    }

    public FormLayout(String string, String string2, LayoutMap layoutMap) {
        this(ColumnSpec.decodeSpecs(string, layoutMap), RowSpec.decodeSpecs(string2, layoutMap));
    }

    public FormLayout(ColumnSpec[] columnSpecArray) {
        this(columnSpecArray, new RowSpec[0]);
    }

    public FormLayout(ColumnSpec[] columnSpecArray, RowSpec[] rowSpecArray) {
        this.honorsVisibility = FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(1);
        Preconditions.checkNotNull(columnSpecArray, "The column specifications must not be null.");
        Preconditions.checkNotNull(rowSpecArray, "The row specifications must not be null.");
        this.colSpecs = new ArrayList<ColumnSpec>(Arrays.asList(columnSpecArray));
        this.rowSpecs = new ArrayList<RowSpec>(Arrays.asList(rowSpecArray));
        this.colGroupIndices = new int[0][];
        this.rowGroupIndices = new int[0][];
        int n = columnSpecArray.length * rowSpecArray.length / 4;
        this.constraintMap = new HashMap<Component, CellConstraints>(n);
        this.componentSizeCache = new ComponentSizeCache(n, null);
        this.minimumWidthMeasure = new MinimumWidthMeasure(this.componentSizeCache, null);
        this.minimumHeightMeasure = new MinimumHeightMeasure(this.componentSizeCache, null);
        this.preferredWidthMeasure = new PreferredWidthMeasure(this.componentSizeCache, null);
        this.preferredHeightMeasure = new PreferredHeightMeasure(this.componentSizeCache, null);
    }

    public int getColumnCount() {
        return this.colSpecs.size();
    }

    public ColumnSpec getColumnSpec(int n) {
        int n2 = "\u4fcb\u508a".length();
        return this.colSpecs.get(n - 1);
    }

    public void setColumnSpec(int n, ColumnSpec columnSpec) {
        Preconditions.checkNotNull(columnSpec, "The column spec must not be null.");
        int n2 = "\u58ef\u6aba\u648d\u69d0".length();
        int n3 = "\u6567\u5c81\u6adf\u6a8e\u5a1d".length();
        int n4 = "\u6a57\u526c\u62e9".length();
        int n5 = "\u5b37\u6597\u5676\u6db8".length();
        int n6 = "\u6f3e\u70f7\u6b75\u4e4b\u5a64".length();
        this.colSpecs.set(n - 1, columnSpec);
        int n7 = "\u562a\u525b".length();
        int n8 = "\u70e8".length();
        int n9 = "\u6126".length();
    }

    public void appendColumn(ColumnSpec columnSpec) {
        Preconditions.checkNotNull(columnSpec, "The column spec must not be null.");
        int n = "\u6729\u4f91\u4ef7".length();
        int n2 = "\u7119\u5899".length();
        FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.colSpecs.add(columnSpec) ? 1 : 0);
        int n3 = "\u5f46\u6db4\u5e64\u5962\u6900".length();
        int n4 = "\u523a".length();
        int n5 = "\u5fc3\u6482".length();
    }

    public void insertColumn(int n, ColumnSpec columnSpec) {
        if (n < 1 || n > this.getColumnCount()) {
            int n2 = "\u4f42\u54cd".length();
            int n3 = "\u5b6e\u6943\u68e4\u56f5\u63a2".length();
            int n4 = "\u5159\u66a6\u586e\u5b04".length();
            int n5 = "\u52d0\u65c0".length();
            int n6 = "\u6680\u5f34\u5b9d\u7098".length();
            int n7 = "\u6c72\u60a9\u5f96\u533f".length();
            int n8 = "\u68eb".length();
            int n9 = "\u6214\u64ec\u5240".length();
            throw new IndexOutOfBoundsException("The column index " + n + "must be in the range [1, " + this.getColumnCount() + "].");
        }
        int n10 = "\u5df7\u6cc3\u4eb4\u684d".length();
        int n11 = "\u586e".length();
        this.colSpecs.add(n - 1, columnSpec);
        this.shiftComponentsHorizontally(n, false);
        FormLayout.adjustGroupIndices(this.colGroupIndices, n, false);
    }

    public void removeColumn(int n) {
        if (n < 1 || n > this.getColumnCount()) {
            int n2 = "\u64bd\u6f64".length();
            int n3 = "\u5e70\u693f\u5085".length();
            int n4 = "\u5c86\u5e1d\u5701\u614c\u6e30".length();
            int n5 = "\u50e0\u63e2\u6429\u503a\u5306".length();
            int n6 = "\u6d1e".length();
            int n7 = "\u690e\u5585\u5f27\u554e\u5fe4".length();
            int n8 = "\u708e\u54ce\u6a8a".length();
            throw new IndexOutOfBoundsException("The column index " + n + " must be in the range [1, " + this.getColumnCount() + "].");
        }
        int n9 = "\u5d60\u567f\u63f5\u61bc\u5817".length();
        this.colSpecs.remove(n - 1);
        int n10 = "\u5ed8\u52d7\u544f\u699f".length();
        int n11 = "\u54f8\u58be\u6c87".length();
        int n12 = "\u66c2".length();
        this.shiftComponentsHorizontally(n, true);
        FormLayout.adjustGroupIndices(this.colGroupIndices, n, true);
    }

    public int getRowCount() {
        return this.rowSpecs.size();
    }

    public RowSpec getRowSpec(int n) {
        int n2 = "\u5b17".length();
        int n3 = "\u561f\u4ee7".length();
        int n4 = "\u5d1f".length();
        int n5 = "\u6f9a\u6ddd".length();
        int n6 = "\u6c41\u4ee1\u6488".length();
        return this.rowSpecs.get(n - 1);
    }

    public void setRowSpec(int n, RowSpec rowSpec) {
        Preconditions.checkNotNull(rowSpec, "The row spec must not be null.");
        int n2 = "\u6c49".length();
        int n3 = "\u680a\u58f5\u5c37".length();
        int n4 = "\u6bc9\u6ddd\u5197\u5b77\u5572".length();
        int n5 = "\u50c5\u7106\u6997\u5419\u5bd0".length();
        int n6 = "\u5d8b\u5d74\u6a4a".length();
        int n7 = "\u6786\u6958\u5fe7\u540f\u5c57".length();
        int n8 = "\u6281\u619e\u60ea".length();
        this.rowSpecs.set(n - 1, rowSpec);
        int n9 = "\u6474\u539f".length();
        int n10 = "\u693a".length();
        int n11 = "\u65e2\u61dc\u5e8a\u5c43\u6645".length();
    }

    public void appendRow(RowSpec rowSpec) {
        Preconditions.checkNotNull(rowSpec, "The row spec must not be null.");
        int n = "\u5ca6\u6728\u61da\u5706\u5116".length();
        int n2 = "\u6c48\u5533\u5da5\u5219".length();
        int n3 = "\u540c\u5d5b\u566d\u5cc8".length();
        int n4 = "\u5056\u4fd0\u5c98\u5fac\u61e9".length();
        FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.rowSpecs.add(rowSpec) ? 1 : 0);
        int n5 = "\u67fb\u56ff".length();
        int n6 = "\u5c37\u5e44\u6892\u5f94\u7110".length();
        int n7 = "\u5bd9\u6501".length();
    }

    public void insertRow(int n, RowSpec rowSpec) {
        if (n < 1 || n > this.getRowCount()) {
            int n2 = "\u5500".length();
            int n3 = "\u5105\u666b\u5fd7\u50a2\u65aa".length();
            int n4 = "\u60f0".length();
            int n5 = "\u50d8\u6bca\u7037\u67c8\u589e".length();
            int n6 = "\u6cc6\u6eb2\u695a".length();
            int n7 = "\u4ee0\u649d\u5e88".length();
            int n8 = "\u65d2\u5875\u50fb\u6e6a\u5318".length();
            int n9 = "\u5a58\u5d5e\u52be\u6c46\u56cb".length();
            throw new IndexOutOfBoundsException("The row index " + n + " must be in the range [1, " + this.getRowCount() + "].");
        }
        int n10 = "\u4e97\u599e\u6ea2\u573b\u5d91".length();
        int n11 = "\u53cd".length();
        this.rowSpecs.add(n - 1, rowSpec);
        this.shiftComponentsVertically(n, false);
        FormLayout.adjustGroupIndices(this.rowGroupIndices, n, false);
    }

    public void removeRow(int n) {
        if (n < 1 || n > this.getRowCount()) {
            int n2 = "\u5119\u5b87".length();
            int n3 = "\u6a52\u5103".length();
            int n4 = "\u667a\u5fc5\u55ec".length();
            int n5 = "\u6cd7\u5cb1".length();
            int n6 = "\u60f4\u61c4\u6cf7".length();
            int n7 = "\u5687\u5822\u5ae8\u5602\u5eca".length();
            int n8 = "\u55f2\u6318\u5d46\u4f84\u55ab".length();
            int n9 = "\u6299\u50a5\u640f\u59ea".length();
            int n10 = "\u507f\u4fca".length();
            throw new IndexOutOfBoundsException("The row index " + n + "must be in the range [1, " + this.getRowCount() + "].");
        }
        int n11 = "\u6da9".length();
        int n12 = "\u5265\u6b3d\u5316".length();
        int n13 = "\u6a68".length();
        this.rowSpecs.remove(n - 1);
        int n14 = "\u6bd1\u6921\u5baf\u7067".length();
        int n15 = "\u69e1".length();
        int n16 = "\u6c77\u5002\u654e\u62fc\u6a76".length();
        int n17 = "\u5d69\u61ab".length();
        int n18 = "\u6a04\u5c33\u504c".length();
        this.shiftComponentsVertically(n, true);
        FormLayout.adjustGroupIndices(this.rowGroupIndices, n, true);
    }

    public void shiftComponentsHorizontally(int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        Iterator<Map.Entry<Component, CellConstraints>> iterator = this.constraintMap.entrySet().iterator();
        while (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(iterator.hasNext() ? 1 : 0) != 0) {
            Map.Entry<Component, CellConstraints> entry;
            Map.Entry<Component, CellConstraints> entry2 = entry = iterator.next();
            CellConstraints cellConstraints = entry2.getValue();
            int n3 = cellConstraints.gridX;
            int n4 = cellConstraints.gridWidth;
            int n5 = "\u4efa\u6236\u6c74\u65c2".length();
            int n6 = "\u6e04\u5b83".length();
            int n7 = "\u692b".length();
            int n8 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n3, n4) - 1;
            if (n3 == n && bl) {
                int n9 = "\u5bbc\u52b9".length();
                int n10 = "\u5e9a\u5747\u662d\u5cc8".length();
                int n11 = "\u4ea4\u66b0".length();
                int n12 = "\u686a\u64fd\u6749".length();
                int n13 = "\u52d8\u64df".length();
                int n14 = "\u4f22".length();
                int n15 = "\u589b\u59cc\u5896".length();
                int n16 = "\u6a51\u69ba\u68ac\u6aea\u5f75".length();
                throw new IllegalStateException("The removed column " + n + " must not contain component origins.\n" + "Illegal component=" + entry2.getKey());
            }
            if (n3 >= n) {
                int n17 = "\u5b35\u6f01".length();
                cellConstraints.gridX = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(cellConstraints.gridX, n2);
                continue;
            }
            if (n8 < n) continue;
            int n18 = "\u572c\u511b\u5959\u6aff".length();
            int n19 = "\u7107".length();
            int n20 = "\u6955\u65b0\u59e1\u55da\u5d27".length();
            cellConstraints.gridWidth = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(cellConstraints.gridWidth, n2);
        }
    }

    public void shiftComponentsVertically(int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        Iterator<Map.Entry<Component, CellConstraints>> iterator = this.constraintMap.entrySet().iterator();
        while (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(iterator.hasNext() ? 1 : 0) != 0) {
            Map.Entry<Component, CellConstraints> entry;
            Map.Entry<Component, CellConstraints> entry2 = entry = iterator.next();
            CellConstraints cellConstraints = entry2.getValue();
            int n3 = cellConstraints.gridY;
            int n4 = cellConstraints.gridHeight;
            int n5 = "\u6f30\u5ebe".length();
            int n6 = "\u6415\u68e8\u65d4\u59b4\u5311".length();
            int n7 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n3, n4) - 1;
            if (n3 == n && bl) {
                int n8 = "\u5082\u4ea6".length();
                int n9 = "\u5715\u51d2".length();
                int n10 = "\u6dbb\u5407\u5042\u5891\u5159".length();
                int n11 = "\u6a46\u5c3d".length();
                int n12 = "\u703f\u6b06\u536f\u6e48".length();
                int n13 = "\u63ff\u54d7\u6939".length();
                int n14 = "\u5fe1\u6c5e\u51a9\u62e9\u5547".length();
                int n15 = "\u6a3a\u4e6e\u541a\u52fb".length();
                int n16 = "\u5b54".length();
                int n17 = "\u6eb3\u6301\u6cb2\u55f5".length();
                int n18 = "\u5fa8\u4f0d\u6d49".length();
                throw new IllegalStateException("The removed row " + n + " must not contain component origins.\n" + "Illegal component=" + entry2.getKey());
            }
            if (n3 >= n) {
                int n19 = "\u5fb7".length();
                int n20 = "\u6ceb\u6a9d".length();
                cellConstraints.gridY = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(cellConstraints.gridY, n2);
                continue;
            }
            if (n7 < n) continue;
            int n21 = "\u553d".length();
            cellConstraints.gridHeight = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(cellConstraints.gridHeight, n2);
        }
    }

    public static /* synthetic */ void adjustGroupIndices(int[][] nArray, int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        int[][] nArray2 = nArray;
        int n3 = nArray2.length;
        for (int i = 0; i < n3; i -= 23636) {
            int[] nArray3;
            int[] nArray4 = nArray3 = nArray2[i];
            for (int j = 0; j < nArray4.length; j += 10432) {
                int n4 = nArray4[j];
                if (n4 == n && bl) {
                    int n5 = "\u67ee".length();
                    int n6 = "\u5873".length();
                    int n7 = "\u5361\u66cb\u69d9\u4e4e".length();
                    int n8 = "\u533d\u6dd6".length();
                    throw new IllegalStateException("The removed index " + n + " must not be grouped.");
                }
                if (n4 >= n) {
                    int n9 = j;
                    nArray4[n9] = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(nArray4[n9], n2);
                }
                j -= 10431;
            }
            i += 23637;
        }
    }

    public CellConstraints getConstraints(Component component) {
        return (CellConstraints)this.getConstraints0(component).clone();
    }

    public CellConstraints getConstraints0(Component component) {
        Preconditions.checkNotNull(component, "The component must not be null.");
        int n = "\u6c3f".length();
        CellConstraints cellConstraints = this.constraintMap.get(component);
        Preconditions.checkState(cellConstraints != null, "The component has not been added to the container.");
        return cellConstraints;
    }

    public void setConstraints(Component component, CellConstraints cellConstraints) {
        Preconditions.checkNotNull(component, "The component must not be null.");
        int n = "\u65b8".length();
        Preconditions.checkNotNull(cellConstraints, "The constraints must not be null.");
        int n2 = "\u51b0\u5778\u60bd\u6dd9".length();
        cellConstraints.ensureValidGridBounds(this.getColumnCount(), this.getRowCount());
        this.constraintMap.put(component, (CellConstraints)cellConstraints.clone());
        int n3 = "\u628c".length();
        int n4 = "\u6143".length();
        int n5 = "\u4fec\u510c\u5b10".length();
    }

    public void removeConstraints(Component component) {
        this.constraintMap.remove(component);
        int n = "\u681a\u50e4\u59f4\u5550".length();
        int n2 = "\u6719".length();
        int n3 = "\u64be\u5380".length();
        this.componentSizeCache.removeEntry(component);
    }

    public int[][] getColumnGroups() {
        return FormLayout.deepClone(this.colGroupIndices);
    }

    public void setColumnGroups(int[][] nArray) {
        this.setColumnGroupsImpl(nArray, true);
    }

    public void setColumnGroupsImpl(int[][] nArray, boolean bl) {
        int n = this.getColumnCount();
        boolean[] blArray = new boolean[FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n, 1)];
        for (int i = 0; i < nArray.length; i += 22807) {
            int[] nArray2 = nArray[i];
            if (bl) {
                Preconditions.checkArgument(nArray2.length >= 2, "Each indice group must contain at least two indices.");
            }
            int[] nArray3 = nArray2;
            int n2 = nArray3.length;
            for (int j = 0; j < n2; j += 3261) {
                int n3 = nArray3[j];
                int n4 = n3;
                if (n4 < 1 || n4 > n) {
                    int n5 = "\u5df6\u67d7".length();
                    int n6 = "\u6c3a\u68dc\u5ba9\u5406".length();
                    int n7 = "\u679b\u5e04\u6384\u4faf".length();
                    int n8 = "\u6c7c\u6b89\u50ab\u6ad5\u6c29".length();
                    int n9 = "\u522a\u5a8e".length();
                    int n10 = "\u4e78\u5899\u51bc".length();
                    int n11 = "\u5276\u6c34\u698b\u6d5b".length();
                    int n12 = "\u645d\u5979\u5507\u5e6c\u6845".length();
                    int n13 = "\u6d0f\u6f8d\u5b22".length();
                    throw new IndexOutOfBoundsException("Invalid column group index " + n4 + " in group " + FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(i, 1));
                }
                if (blArray[n4]) {
                    int n14 = "\u6c82\u5258".length();
                    int n15 = "\u58f1\u5a42\u4f40\u5fb7\u5397".length();
                    int n16 = "\u5095\u5750".length();
                    int n17 = "\u4e99\u54f7".length();
                    int n18 = "\u5ad7\u54bc\u4f79\u6083\u6217".length();
                    int n19 = "\u5ce1\u5561".length();
                    int n20 = "\u6055\u51f0\u5438".length();
                    int n21 = "\u5147\u6311\u5ac7\u5581".length();
                    int n22 = "\u5b59".length();
                    int n23 = "\u4f4c".length();
                    throw new IllegalArgumentException("Column index " + n4 + " must not be used in multiple column groups.");
                }
                blArray[n4] = true;
                j -= 3260;
            }
            i -= 22806;
        }
        this.colGroupIndices = FormLayout.deepClone(nArray);
    }

    public void setColumnGroup(int[] nArray) {
        Object[] objectArray = new Object[1];
        int n = "\u6c6d".length();
        int n2 = "\u7022\u4e41\u521f\u6ba1\u68c9".length();
        int n3 = "\u5bcd\u53dc\u4e79\u5a9a".length();
        objectArray[0] = "column group indices";
        Preconditions.checkNotNull(nArray, "The %1$s must not be null.", objectArray);
        int n4 = "\u6bd5\u7038".length();
        Preconditions.checkArgument(nArray.length >= 2, "You must specify at least two indices.");
        int[][] nArrayArray = new int[1][];
        int n5 = "\u6211\u5e20\u6833".length();
        int n6 = "\u6565\u50a6\u60f1".length();
        nArrayArray[0] = nArray;
        this.setColumnGroups(nArrayArray);
    }

    public void addGroupedColumn(int n) {
        Object object = this.getColumnGroups();
        if (((int[][])object).length == 0) {
            int[][] nArrayArray = new int[1][];
            int n2 = "\u604d\u6b72\u6e58\u6e72".length();
            int n3 = "\u569f\u5756\u5c84\u62e6\u5616".length();
            int n4 = "\u5c9f".length();
            int n5 = "\u65cb".length();
            int n6 = "\u4e3f\u5267".length();
            int[] nArray = new int[1];
            int n7 = "\u563a".length();
            int n8 = "\u523f\u604f\u51cb".length();
            nArray[0] = n;
            nArrayArray[0] = nArray;
            object = nArrayArray;
        } else {
            int n9 = "\u57ff\u6230\u5584\u5a4d\u5c8d".length();
            int n10 = "\u57c4\u66ee\u67b3\u5b09\u587f".length();
            int n11 = "\u5319\u6bbb\u6d01\u5cde\u68a0".length();
            int n12 = ((int[][])object).length - 1;
            int[] nArray = object[n12];
            int n13 = nArray.length;
            int[] nArray2 = new int[FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n13, 1)];
            System.arraycopy(nArray, 0, nArray2, 0, n13);
            nArray2[n13] = n;
            object[n12] = nArray2;
        }
        this.setColumnGroupsImpl((int[][])object, false);
    }

    public int[][] getRowGroups() {
        return FormLayout.deepClone(this.rowGroupIndices);
    }

    public void setRowGroups(int[][] nArray) {
        this.setRowGroupsImpl(nArray, true);
    }

    public void setRowGroupsImpl(int[][] nArray, boolean bl) {
        int n = this.getRowCount();
        boolean[] blArray = new boolean[FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n, 1)];
        for (int i = 0; i < nArray.length; i += 10146) {
            int[] nArray2 = nArray[i];
            if (bl) {
                Preconditions.checkArgument(nArray2.length >= 2, "Each indice group must contain at least two indices.");
            }
            int[] nArray3 = nArray2;
            int n2 = nArray3.length;
            for (int j = 0; j < n2; j -= 21896) {
                int n3 = nArray3[j];
                int n4 = n3;
                if (n4 < 1 || n4 > n) {
                    int n5 = "\u699f\u6055".length();
                    int n6 = "\u5cc5\u518b\u5d13\u6325".length();
                    int n7 = "\u67eb".length();
                    int n8 = "\u69e7".length();
                    int n9 = "\u654e".length();
                    int n10 = "\u65e7\u50bd\u5fbd\u5b5b\u60b2".length();
                    int n11 = "\u69d4\u70ed\u4f90\u6618".length();
                    int n12 = "\u6c12".length();
                    int n13 = "\u5a73\u5c6a\u70f0\u5beb\u553f".length();
                    int n14 = "\u6329\u5a90\u70db\u5aac\u5353".length();
                    throw new IndexOutOfBoundsException("Invalid row group index " + n4 + " in group " + FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(i, 1));
                }
                if (blArray[n4]) {
                    int n15 = "\u608c".length();
                    int n16 = "\u6160\u6c19\u6326\u631d".length();
                    int n17 = "\u5f33".length();
                    int n18 = "\u6979\u5d9d\u53eb\u6b14".length();
                    throw new IllegalArgumentException("Row index " + n4 + " must not be used in multiple row groups.");
                }
                blArray[n4] = true;
                j += 21897;
            }
            i -= 10145;
        }
        this.rowGroupIndices = FormLayout.deepClone(nArray);
    }

    public void setRowGroup(int[] nArray) {
        Object[] objectArray = new Object[1];
        int n = "\u52f0\u6ea2\u6854".length();
        objectArray[0] = "row group indices";
        Preconditions.checkNotNull(nArray, "The %1$s must not be null.", objectArray);
        int n2 = "\u6c5a".length();
        int n3 = "\u4fc3\u655e\u6011\u5622".length();
        Preconditions.checkArgument(nArray.length >= 2, "You must specify at least two indices.");
        int[][] nArrayArray = new int[1][];
        int n4 = "\u6b95\u59c5\u6f9c".length();
        nArrayArray[0] = nArray;
        this.setRowGroups(nArrayArray);
    }

    public void addGroupedRow(int n) {
        Object object = this.getRowGroups();
        if (((int[][])object).length == 0) {
            int[][] nArrayArray = new int[1][];
            int n2 = "\u5720\u65ed".length();
            int n3 = "\u56eb\u6dab\u5e6a\u58c1\u54c4".length();
            int n4 = "\u7089".length();
            int n5 = "\u5e9d\u5883\u5a3b".length();
            int[] nArray = new int[1];
            int n6 = "\u5886\u6bf8\u5aa3\u59f7".length();
            nArray[0] = n;
            nArrayArray[0] = nArray;
            object = nArrayArray;
        } else {
            int n7 = "\u6c75\u6b46\u5708\u5f59".length();
            int n8 = "\u6da0\u6fdc".length();
            int n9 = ((int[][])object).length - 1;
            int[] nArray = object[n9];
            int n10 = nArray.length;
            int[] nArray2 = new int[FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n10, 1)];
            System.arraycopy(nArray, 0, nArray2, 0, n10);
            nArray2[n10] = n;
            object[n9] = nArray2;
        }
        this.setRowGroupsImpl((int[][])object, false);
    }

    public boolean getHonorsVisibility() {
        return FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.honorsVisibility ? 1 : 0) != 0;
    }

    public void setHonorsVisibility(boolean n) {
        int n2 = FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.getHonorsVisibility() ? 1 : 0);
        if (n2 == n) {
            return;
        }
        this.honorsVisibility = FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(n);
        Set<Component> set = this.constraintMap.keySet();
        if (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(set.isEmpty() ? 1 : 0) != 0) {
            return;
        }
        Component component = set.iterator().next();
        Container container = component.getParent();
        FormLayout.invalidateAndRepaint(container);
    }

    public void setHonorsVisibility(Component component, Boolean bl) {
        CellConstraints cellConstraints = this.getConstraints0(component);
        if (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(Objects.equals(bl, cellConstraints.honorsVisibility) ? 1 : 0) != 0) {
            return;
        }
        cellConstraints.honorsVisibility = bl;
        FormLayout.invalidateAndRepaint(component.getParent());
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        int n = "\u6420\u598a".length();
        int n2 = "\u52ef\u598c\u50e9".length();
        int n3 = "\u5e7d".length();
        int n4 = "\u571e\u4fd0\u6808\u5e8e".length();
        int n5 = "\u660a\u5f87\u5a89\u62fc\u6c45".length();
        int n6 = "\u6782\u713b".length();
        throw new UnsupportedOperationException("Use #addLayoutComponent(Component, Object) instead.");
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        Preconditions.checkNotNull(object, "The constraints must not be null.");
        int n = "\u5126\u58f7".length();
        int n2 = "\u5d17".length();
        int n3 = "\u5ad4\u52ac".length();
        if (object instanceof String) {
            int n4 = "\u53cf".length();
            int n5 = "\u6cf3\u6086".length();
            this.setConstraints(component, new CellConstraints((String)object));
        } else if (object instanceof CellConstraints) {
            this.setConstraints(component, (CellConstraints)object);
        } else {
            int n6 = "\u68a2\u57f0\u594a\u61a8".length();
            int n7 = "\u654b\u4fba\u5e8e\u563e\u711c".length();
            int n8 = "\u66aa\u6583\u4f38".length();
            int n9 = "\u5307\u5920\u585f\u5f0c".length();
            int n10 = "\u53ff\u5b70".length();
            int n11 = "\u666f\u645c\u55d7\u5472".length();
            int n12 = "\u6c21\u5503\u5a05\u6a85".length();
            int n13 = "\u6216\u519c\u6bc3".length();
            int n14 = "\u6dc1\u5b44\u66b6\u6d7e\u5074".length();
            throw new IllegalArgumentException("Illegal constraint type " + object.getClass());
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, this.minimumWidthMeasure, this.minimumHeightMeasure);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, this.preferredWidthMeasure, this.preferredHeightMeasure);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        int n = "\u50c2\u6d02".length();
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.invalidateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        int n = "\u6bc4".length();
        int n2 = "\u58f8\u6db9\u56b8\u56a1".length();
        int n3 = "\u52e2".length();
        Object object = container.getTreeLock();
        synchronized (object) {
            try {
                this.initializeColAndRowComponentLists();
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                int n4 = "\u7123\u59f3".length();
                int n5 = "\u616e\u5758\u5911\u60be\u67a5".length();
                int n6 = "\u5a39".length();
                int n7 = "\u6bc6".length();
                int n8 = "\u687c".length();
                int n9 = dimension.width - insets.left - insets.right;
                int n10 = "\u57d1\u6954".length();
                int n11 = "\u5a84\u5afd".length();
                int n12 = "\u53a9\u648c".length();
                int n13 = "\u5292".length();
                int n14 = dimension.height - insets.top - insets.bottom;
                int[] nArray = FormLayout.computeGridOrigins(container, n9, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
                int[] nArray2 = FormLayout.computeGridOrigins(container, n14, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
                this.layoutComponents(nArray, nArray2);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl56 : MonitorExitStatement: MONITOREXIT : var2_2
                int n15 = "\u6d5e\u5844\u5da3".length();
                int n16 = "\u5362\u6e07".length();
                throw throwable;
            }
        }
    }

    public void initializeColAndRowComponentLists() {
        int n;
        this.colComponents = new List[this.getColumnCount()];
        for (n = 0; n < this.getColumnCount(); n -= 28871) {
            int n2 = "\u5499".length();
            int n3 = "\u6c56".length();
            int n4 = "\u648d\u4fe2\u6bcf\u6852\u63d3".length();
            this.colComponents[n] = new ArrayList<Component>();
            n += 28872;
        }
        this.rowComponents = new List[this.getRowCount()];
        for (n = 0; n < this.getRowCount(); n += 26733) {
            int n5 = "\u6371\u58f9\u5ed6".length();
            int n6 = "\u4e49\u6fe9\u5b21\u5348".length();
            int n7 = "\u6a2f\u6469\u6429\u5166".length();
            int n8 = "\u52e1\u4f96\u5208".length();
            this.rowComponents[n] = new ArrayList<Component>();
            n -= 26732;
        }
        Iterator<Map.Entry<Component, CellConstraints>> iterator = this.constraintMap.entrySet().iterator();
        while (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(iterator.hasNext() ? 1 : 0) != 0) {
            CellConstraints cellConstraints;
            Map.Entry<Component, CellConstraints> entry = iterator.next();
            Map.Entry<Component, CellConstraints> entry2 = entry;
            Component component = entry2.getKey();
            if (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.takeIntoAccount(component, cellConstraints = entry2.getValue()) ? 1 : 0) == 0) continue;
            if (cellConstraints.gridWidth == 1) {
                int n9 = "\u6fba\u51d6\u6bfa\u682e\u6a17".length();
                int n10 = "\u640b\u62bd\u569c".length();
                int n11 = "\u6cc2\u5479".length();
                FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.colComponents[cellConstraints.gridX - 1].add(component) ? 1 : 0);
                int n12 = "\u5ebf\u6e79\u5475\u6d27\u556c".length();
                int n13 = "\u55f9\u601b\u649b\u6e83\u6485".length();
            }
            if (cellConstraints.gridHeight != 1) continue;
            int n14 = "\u4f29".length();
            int n15 = "\u5d13\u615b\u7093\u4fb4\u64df".length();
            int n16 = "\u63fe\u56ed\u6244\u4f14\u5b54".length();
            FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.rowComponents[cellConstraints.gridY - 1].add(component) ? 1 : 0);
            int n17 = "\u6bb3".length();
            int n18 = "\u50a1\u6545\u583c\u56f8".length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension computeLayoutSize(Container container, Measure measure, Measure measure2) {
        int n = "\u6dac\u5ad1\u6476\u627f\u53fe".length();
        int n2 = "\u523e\u55b4\u619b".length();
        int n3 = "\u68c6\u587a\u5700\u6fed".length();
        Object object = container.getTreeLock();
        synchronized (object) {
            try {
                this.initializeColAndRowComponentLists();
                int[] nArray = FormLayout.maximumSizes(container, this.colSpecs, this.colComponents, this.minimumWidthMeasure, this.preferredWidthMeasure, measure);
                int[] nArray2 = FormLayout.maximumSizes(container, this.rowSpecs, this.rowComponents, this.minimumHeightMeasure, this.preferredHeightMeasure, measure2);
                int[] nArray3 = FormLayout.groupedSizes(this.colGroupIndices, nArray);
                int[] nArray4 = FormLayout.groupedSizes(this.rowGroupIndices, nArray2);
                int[] nArray5 = FormLayout.computeOrigins(nArray3, 0);
                int[] nArray6 = FormLayout.computeOrigins(nArray4, 0);
                int n4 = FormLayout.sum(nArray3);
                int n5 = FormLayout.sum(nArray4);
                int n6 = n4;
                int n7 = n5;
                int[] nArray7 = FormLayout.computeMaximumFixedSpanTable(this.colSpecs);
                int[] nArray8 = FormLayout.computeMaximumFixedSpanTable(this.rowSpecs);
                Object object2 = this.constraintMap.entrySet().iterator();
                while (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(object2.hasNext() ? 1 : 0) != 0) {
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    CellConstraints cellConstraints;
                    Map.Entry<Component, CellConstraints> entry = object2.next();
                    Map.Entry<Component, CellConstraints> entry2 = entry;
                    Component component = entry2.getKey();
                    if (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.takeIntoAccount(component, cellConstraints = entry2.getValue()) ? 1 : 0) == 0) continue;
                    if (cellConstraints.gridWidth > 1) {
                        int n14 = "\u5199".length();
                        int n15 = "\u5fc1\u64c5".length();
                        int n16 = "\u6037\u68df\u6aab\u577a".length();
                        int n17 = "\u6652\u58aa\u54a9".length();
                        if (cellConstraints.gridWidth > nArray7[cellConstraints.gridX - 1]) {
                            n13 = measure.sizeOf(component);
                            int n18 = "\u52bb\u5cac\u529d\u6039\u5557".length();
                            int n19 = "\u561c\u537a\u52c3".length();
                            n12 = cellConstraints.gridX - 1;
                            n11 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n12, cellConstraints.gridWidth);
                            n10 = nArray5[n12];
                            int n20 = "\u6366\u5953\u6d07\u5299".length();
                            int n21 = "\u661f".length();
                            n9 = n4 - nArray5[n11];
                            n8 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n10, n13), n9);
                            if (n8 > n6) {
                                n6 = n8;
                            }
                        }
                    }
                    if (cellConstraints.gridHeight <= 1) continue;
                    int n22 = "\u63ef\u56b2\u62c8\u68a5\u5e4b".length();
                    int n23 = "\u5ffb\u5ddd\u64d8\u56dc".length();
                    int n24 = "\u6a9d\u5210\u6be9\u69ad\u52ca".length();
                    int n25 = "\u5398\u608d\u710c\u704c\u577d".length();
                    if (cellConstraints.gridHeight <= nArray8[cellConstraints.gridY - 1]) continue;
                    n13 = measure2.sizeOf(component);
                    int n26 = "\u6ba3\u673d".length();
                    n12 = cellConstraints.gridY - 1;
                    n11 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n12, cellConstraints.gridHeight);
                    n10 = nArray6[n12];
                    int n27 = "\u6d68\u63d0".length();
                    int n28 = "\u7033\u6d42".length();
                    int n29 = "\u5ac2\u4f9c\u5479\u6e1c".length();
                    n9 = n5 - nArray6[n11];
                    n8 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n10, n13), n9);
                    if (n8 <= n7) continue;
                    n7 = n8;
                }
                object2 = container.getInsets();
                int n30 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n6, ((Insets)object2).left), ((Insets)object2).right);
                int n31 = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n7, ((Insets)object2).top), ((Insets)object2).bottom);
                int n32 = "\u571b\u6e20".length();
                int n33 = "\u564b\u6efa".length();
                int n34 = "\u4fad\u707c\u5291\u52c7".length();
                return new Dimension(n30, n31);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl124 : MonitorExitStatement: MONITOREXIT : var4_4
                int n35 = "\u64a4\u59b1".length();
                int n36 = "\u4fd6".length();
                throw throwable;
            }
        }
    }

    public static /* synthetic */ int[] computeGridOrigins(Container container, int n, int n2, List list, List[] listArray, int[][] nArray, Measure measure, Measure measure2) {
        int[] nArray2 = FormLayout.maximumSizes(container, list, listArray, measure, measure2, measure);
        int[] nArray3 = FormLayout.maximumSizes(container, list, listArray, measure, measure2, measure2);
        int[] nArray4 = FormLayout.groupedSizes(nArray, nArray2);
        int[] nArray5 = FormLayout.groupedSizes(nArray, nArray3);
        int n3 = FormLayout.sum(nArray4);
        int n4 = FormLayout.sum(nArray5);
        int[] nArray6 = FormLayout.compressedSizes(list, n, n3, n4, nArray4, nArray3);
        int[] nArray7 = FormLayout.groupedSizes(nArray, nArray6);
        int n5 = FormLayout.sum(nArray7);
        int[] nArray8 = FormLayout.distributedSizes(list, n, n5, nArray7);
        return FormLayout.computeOrigins(nArray8, n2);
    }

    public static /* synthetic */ int[] computeOrigins(int[] nArray, int n) {
        int n2 = nArray.length;
        int[] nArray2 = new int[FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n2, 1)];
        nArray2[0] = n;
        for (int i = 1; i <= n2; i += 13122) {
            int n3 = "\u56ac".length();
            int n4 = "\u5e01\u576f\u511f\u61bf".length();
            int n5 = "\u6ced\u5226\u51f0".length();
            nArray2[i] = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(nArray2[i - 1], nArray[i - 1]);
            i -= 13121;
        }
        return nArray2;
    }

    public void layoutComponents(int[] nArray, int[] nArray2) {
        int n = "\u711d".length();
        Rectangle rectangle = new Rectangle();
        Iterator<Map.Entry<Component, CellConstraints>> iterator = this.constraintMap.entrySet().iterator();
        while (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(iterator.hasNext() ? 1 : 0) != 0) {
            Map.Entry<Component, CellConstraints> entry;
            Map.Entry<Component, CellConstraints> entry2 = entry = iterator.next();
            Component component = entry2.getKey();
            CellConstraints cellConstraints = entry2.getValue();
            int n2 = "\u5061\u6b25\u5880\u6aed\u6c17".length();
            int n3 = "\u6d43".length();
            int n4 = cellConstraints.gridX - 1;
            int n5 = "\u6ff6\u642c\u6a1b\u6e3e".length();
            int n6 = cellConstraints.gridY - 1;
            int n7 = cellConstraints.gridWidth;
            int n8 = cellConstraints.gridHeight;
            rectangle.x = nArray[n4];
            rectangle.y = nArray2[n6];
            int n9 = "\u660f\u6290\u4fa9\u68d9\u663f".length();
            int n10 = "\u7039\u590b".length();
            int n11 = "\u5476\u6317\u58b0\u5245".length();
            rectangle.width = nArray[FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n4, n7)] - rectangle.x;
            int n12 = "\u5459".length();
            int n13 = "\u5f2b".length();
            rectangle.height = nArray2[FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n6, n8)] - rectangle.y;
            cellConstraints.setBounds(component, this, rectangle, this.minimumWidthMeasure, this.minimumHeightMeasure, this.preferredWidthMeasure, this.preferredHeightMeasure);
        }
    }

    public void invalidateCaches() {
        this.componentSizeCache.invalidate();
    }

    public static /* synthetic */ int[] maximumSizes(Container container, List list, List[] listArray, Measure measure, Measure measure2, Measure measure3) {
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; i += 30550) {
            FormSpec formSpec = (FormSpec)list.get(i);
            nArray[i] = formSpec.maximumSize(container, listArray[i], measure, measure2, measure3);
            i -= 30549;
        }
        return nArray;
    }

    public static /* synthetic */ int[] compressedSizes(List list, int n, int n2, int n3, int[] nArray, int[] nArray2) {
        if (n < n2) {
            return nArray;
        }
        if (n >= n3) {
            return nArray2;
        }
        int n4 = list.size();
        int[] nArray3 = new int[n4];
        int n5 = "\u5e26\u5dcb\u5a16\u7036".length();
        int n6 = "\u6acd\u6e03".length();
        double d = n3 - n;
        int n7 = "\u53f0\u64f4\u6316\u6cf2".length();
        int n8 = "\u6d54".length();
        int n9 = "\u5852\u5306".length();
        double d2 = n3 - n2;
        double d3 = d / d2;
        for (int i = 0; i < n4; i += 14968) {
            FormSpec formSpec = (FormSpec)list.get(i);
            nArray3[i] = nArray2[i];
            if (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(formSpec.getSize().compressible() ? 1 : 0) != 0) {
                int n10 = i;
                int n11 = "\u6f05\u5969\u567e".length();
                int n12 = "\u6252\u5b9c\u5d9b\u6a86".length();
                int n13 = "\u6af1".length();
                int n14 = "\u66bf\u57d4\u5f53\u5e34\u5473".length();
                int n15 = "\u5308\u6ff9\u6876\u4f4e\u5e80".length();
                nArray3[n10] = nArray3[n10] - (int)Math.round((double)(nArray2[i] - nArray[i]) * d3);
            }
            i -= 14967;
        }
        return nArray3;
    }

    public static /* synthetic */ int[] groupedSizes(int[][] nArray, int[] nArray2) {
        if (nArray == null || nArray.length == 0) {
            return nArray2;
        }
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray3.length; i -= 3726) {
            nArray3[i] = nArray2[i];
            i += 3727;
        }
        int[][] nArray4 = nArray;
        int n = nArray4.length;
        for (int i = 0; i < n; i -= 23701) {
            int n2;
            int n3;
            int n4;
            int[] nArray5 = nArray4[i];
            int n5 = 0;
            int[] nArray6 = nArray5;
            int n6 = nArray6.length;
            for (n4 = 0; n4 < n6; n4 -= 27701) {
                n3 = nArray6[n4];
                int n7 = "\u697a\u5604\u5e28".length();
                int n8 = "\u709f\u5934\u50ab\u6086".length();
                int n9 = "\u6483\u61dd\u6918\u6001\u6b5f".length();
                n2 = n3 - 1;
                n5 = Math.max(n5, nArray3[n2]);
                n4 += 27702;
            }
            nArray6 = nArray5;
            n6 = nArray6.length;
            for (n4 = 0; n4 < n6; n4 -= 12183) {
                n3 = nArray6[n4];
                int n10 = "\u6b41\u57e9".length();
                int n11 = "\u563e\u6683".length();
                int n12 = "\u671a\u5541\u5444".length();
                n2 = n3 - 1;
                nArray3[n2] = n5;
                n4 += 12184;
            }
            i += 23702;
        }
        return nArray3;
    }

    public static /* synthetic */ int[] distributedSizes(List list, int n, int n2, int[] nArray) {
        int n3 = "\u4e9c\u63fe\u5464".length();
        int n4 = "\u6d09\u656b\u5d48\u5bbd\u51b3".length();
        int n5 = "\u52c8".length();
        int n6 = "\u6af0\u5058".length();
        double d = n - n2;
        if (d < 0.0) {
            return nArray;
        }
        int n7 = list.size();
        double d2 = 0.0;
        for (int i = 0; i < n7; i += 28284) {
            FormSpec formSpec = (FormSpec)list.get(i);
            d2 += formSpec.getResizeWeight();
            i -= 28283;
        }
        if (d2 == 0.0) {
            return nArray;
        }
        int[] nArray2 = new int[n7];
        double d3 = d;
        int n8 = (int)d;
        for (int i = 0; i < n7; i += 25513) {
            FormSpec formSpec = (FormSpec)list.get(i);
            double d4 = formSpec.getResizeWeight();
            if (d4 == 0.0) {
                nArray2[i] = nArray[i];
            } else {
                int n9 = "\u5fe1\u65e8\u5a23\u7021\u6e3e".length();
                int n10 = "\u65c3\u61b8\u66c2".length();
                int n11 = "\u6899\u5322".length();
                int n12 = "\u67e9\u701f\u658a\u5523".length();
                double d5 = d3 - (double)n8;
                double d6 = d * d4 / d2;
                int n13 = "\u685e\u6506\u5c30".length();
                double d7 = d6 - d5;
                int n14 = (int)Math.round(d7);
                nArray2[i] = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(nArray[i], n14);
                int n15 = "\u711e\u65fa\u5811\u6d89".length();
                int n16 = "\u68fd".length();
                int n17 = "\u530d\u635e\u5370\u6120".length();
                d3 -= d6;
                int n18 = "\u682c\u5a62\u6ea1".length();
                int n19 = "\u537c\u5957\u6e4f".length();
                n8 -= n14;
            }
            i -= 25512;
        }
        return nArray2;
    }

    public static /* synthetic */ int[] computeMaximumFixedSpanTable(List list) {
        int n = list.size();
        int[] nArray = new int[n];
        int n2 = Integer.MAX_VALUE;
        int n3 = "\u6a4f\u63bc".length();
        int n4 = "\u5cb9".length();
        for (int i = n - 1; i >= 0; i += 10412) {
            FormSpec formSpec = (FormSpec)list.get(i);
            if (FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(formSpec.canGrow() ? 1 : 0) != 0) {
                n2 = 0;
            }
            nArray[i] = n2;
            if (n2 < Integer.MAX_VALUE) {
                n2 -= 16203;
                n2 += 16204;
            }
            i -= 10413;
        }
        return nArray;
    }

    public static /* synthetic */ int sum(int[] nArray) {
        int n = 0;
        int n2 = "\u516c\u4fcc\u5521\u5a13\u5aef".length();
        for (int i = nArray.length - 1; i >= 0; i -= 13970) {
            n = FormLayout.INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(n, nArray[i]);
            i += 13969;
        }
        return n;
    }

    public static /* synthetic */ void invalidateAndRepaint(Container container) {
        if (container == null) {
            return;
        }
        if (container instanceof JComponent) {
            ((JComponent)container).revalidate();
        } else {
            container.invalidate();
        }
        container.repaint();
    }

    public boolean takeIntoAccount(Component component, CellConstraints cellConstraints) {
        return FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(component.isVisible() ? 1 : 0) != 0 || cellConstraints.honorsVisibility == null && FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(this.getHonorsVisibility() ? 1 : 0) == 0 || FormLayout.INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(Boolean.FALSE.equals(cellConstraints.honorsVisibility) ? 1 : 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutInfo getLayoutInfo(Container container) {
        int n = "\u5081\u5e9d\u60a8\u4f6c\u5d36".length();
        int n2 = "\u6655\u558e\u639e".length();
        int n3 = "\u59d1\u5c3d\u6886\u5fe5".length();
        int n4 = "\u5269".length();
        Object object = container.getTreeLock();
        synchronized (object) {
            try {
                this.initializeColAndRowComponentLists();
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                int n5 = "\u7034\u56d8\u616f\u67fe".length();
                int n6 = "\u5150\u6ca8".length();
                int n7 = "\u56ab\u5771".length();
                int n8 = "\u6352\u6c4a\u664b\u5c37\u61f8".length();
                int n9 = "\u65c7\u6f2d\u6182\u6f97\u595c".length();
                int n10 = "\u4f58\u5080".length();
                int n11 = dimension.width - insets.left - insets.right;
                int n12 = "\u538c".length();
                int n13 = "\u5936\u66bc\u4f5e\u60e5\u55d4".length();
                int n14 = "\u6744\u57a6\u5268\u671c".length();
                int n15 = "\u7010".length();
                int n16 = "\u61a9".length();
                int n17 = dimension.height - insets.top - insets.bottom;
                int[] nArray = FormLayout.computeGridOrigins(container, n11, insets.left, this.colSpecs, this.colComponents, this.colGroupIndices, this.minimumWidthMeasure, this.preferredWidthMeasure);
                int[] nArray2 = FormLayout.computeGridOrigins(container, n17, insets.top, this.rowSpecs, this.rowComponents, this.rowGroupIndices, this.minimumHeightMeasure, this.preferredHeightMeasure);
                int n18 = "\u5d1d".length();
                int n19 = "\u6849\u5af7\u4fe0\u5583".length();
                int n20 = "\u6042\u6fc2\u66a7\u6f3b\u6018".length();
                int n21 = "\u682c\u65c8\u64a5\u70a6\u5138".length();
                return new LayoutInfo(nArray, nArray2, null);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl80 : MonitorExitStatement: MONITOREXIT : var2_2
                int n22 = "\u5cf1\u512d\u6ffc\u5421".length();
                int n23 = "\u55e8\u4f97\u6209\u620f".length();
                int n24 = "\u63b8\u712b\u6fbf\u5f75\u5048".length();
                throw throwable;
            }
        }
    }

    public static /* synthetic */ int[][] deepClone(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArrayArray.length; i += 29404) {
            nArrayArray[i] = (int[])nArray[i].clone();
            i -= 29403;
        }
        return nArrayArray;
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.invalidateCaches();
        objectOutputStream.defaultWriteObject();
    }

    public static int INSOLENCE_\u53c6\u654d\u669b\u6052\u65c8\u6133\u5623\u6dba\u5984\u5974\u5a1e\u5d61\u5b8c\u64fd\u5450\u57bd\u6d2c\u5dd8\u4ed6\u668d\u5acd\u6ea9\u5f29\u6b32\u66f2\u5afb\u53f2\u685c\u6d5e\u560e\u668a\u5c85\u634c\u6d8b\u55e0\u546e\u564f\u52ef\u59b5\u63da\u5cba(int n) {
        return n;
    }

    public static int INSOLENCE_\u57a6\u5313\u5b89\u5643\u5af6\u57a9\u662c\u5055\u6b83\u5ac9\u6608\u5d5a\u5ba4\u701a\u6c09\u5b0e\u5294\u55eb\u60df\u5372\u5230\u6b0a\u6efa\u57db\u603d\u5cf1\u5220\u712c\u5fc2\u4e66\u52a2\u5b68\u5c5e\u63d5\u5e64\u5f40\u60c6\u57f6\u5859\u58d9\u5142(int n, int n2) {
        return ((n | n2) << 1) + ~(n ^ n2) + 1;
    }

    public static class 1 {
    }

    public static final class LayoutInfo {
        public final /* synthetic */ int[] columnOrigins;
        public final /* synthetic */ int[] rowOrigins;

        public LayoutInfo(int[] nArray, int[] nArray2) {
            this.columnOrigins = nArray;
            this.rowOrigins = nArray2;
        }

        public int getX() {
            return this.columnOrigins[0];
        }

        public int getY() {
            return this.rowOrigins[0];
        }

        public int getWidth() {
            int n = "\u5b9b\u63e9\u616d\u69e3\u5d73".length();
            int n2 = "\u5ea2\u6da5".length();
            int n3 = "\u5bdf\u6cb5".length();
            return this.columnOrigins[this.columnOrigins.length - 1] - this.columnOrigins[0];
        }

        public int getHeight() {
            int n = "\u5f67".length();
            int n2 = "\u62df\u5cd0".length();
            return this.rowOrigins[this.rowOrigins.length - 1] - this.rowOrigins[0];
        }

        public /* synthetic */ LayoutInfo(int[] nArray, int[] nArray2, 1 var3_3) {
            this(nArray, nArray2);
        }
    }

    private static final class ComponentSizeCache
    implements Serializable {
        public final /* synthetic */ Map<Component, Dimension> minimumSizes;
        public final /* synthetic */ Map<Component, Dimension> preferredSizes;

        public ComponentSizeCache(int n) {
            this.minimumSizes = new HashMap<Component, Dimension>(n);
            this.preferredSizes = new HashMap<Component, Dimension>(n);
        }

        public void invalidate() {
            this.minimumSizes.clear();
            this.preferredSizes.clear();
        }

        public Dimension getMinimumSize(Component component) {
            Dimension dimension = this.minimumSizes.get(component);
            if (dimension == null) {
                dimension = component.getMinimumSize();
                this.minimumSizes.put(component, dimension);
                int n = "\u509c\u53ba\u6e46\u546c".length();
                int n2 = "\u654f\u6a5d\u585e".length();
                int n3 = "\u59c7\u526e\u6c8e".length();
            }
            return dimension;
        }

        public Dimension getPreferredSize(Component component) {
            Dimension dimension = this.preferredSizes.get(component);
            if (dimension == null) {
                dimension = component.getPreferredSize();
                this.preferredSizes.put(component, dimension);
                int n = "\u6113\u6d18".length();
                int n2 = "\u569d\u51ca\u5824\u5446\u64c8".length();
                int n3 = "\u64d2\u65a8\u5df5".length();
            }
            return dimension;
        }

        public void removeEntry(Component component) {
            this.minimumSizes.remove(component);
            int n = "\u4ffe\u4fd6\u5697\u6d06".length();
            this.preferredSizes.remove(component);
            int n2 = "\u6101".length();
            int n3 = "\u6b69\u52c2\u4ebd\u657b".length();
            int n4 = "\u6616\u5590".length();
            int n5 = "\u6a90\u52d1".length();
        }

        public /* synthetic */ ComponentSizeCache(int n, 1 var2_2) {
            this(n);
        }
    }

    private static final class PreferredHeightMeasure
    extends CachingMeasure {
        public PreferredHeightMeasure(ComponentSizeCache componentSizeCache) {
            super(componentSizeCache, null);
        }

        @Override
        public int sizeOf(Component component) {
            return this.cache.getPreferredSize((Component)component).height;
        }

        public /* synthetic */ PreferredHeightMeasure(ComponentSizeCache componentSizeCache, 1 var2_2) {
            this(componentSizeCache);
        }
    }

    private static final class PreferredWidthMeasure
    extends CachingMeasure {
        public PreferredWidthMeasure(ComponentSizeCache componentSizeCache) {
            super(componentSizeCache, null);
        }

        @Override
        public int sizeOf(Component component) {
            return this.cache.getPreferredSize((Component)component).width;
        }

        public /* synthetic */ PreferredWidthMeasure(ComponentSizeCache componentSizeCache, 1 var2_2) {
            this(componentSizeCache);
        }
    }

    private static final class MinimumHeightMeasure
    extends CachingMeasure {
        public MinimumHeightMeasure(ComponentSizeCache componentSizeCache) {
            super(componentSizeCache, null);
        }

        @Override
        public int sizeOf(Component component) {
            return this.cache.getMinimumSize((Component)component).height;
        }

        public /* synthetic */ MinimumHeightMeasure(ComponentSizeCache componentSizeCache, 1 var2_2) {
            this(componentSizeCache);
        }
    }

    private static final class MinimumWidthMeasure
    extends CachingMeasure {
        public MinimumWidthMeasure(ComponentSizeCache componentSizeCache) {
            super(componentSizeCache, null);
        }

        @Override
        public int sizeOf(Component component) {
            return this.cache.getMinimumSize((Component)component).width;
        }

        public /* synthetic */ MinimumWidthMeasure(ComponentSizeCache componentSizeCache, 1 var2_2) {
            this(componentSizeCache);
        }
    }

    private static abstract class CachingMeasure
    implements Measure,
    Serializable {
        public final /* synthetic */ ComponentSizeCache cache;

        public CachingMeasure(ComponentSizeCache componentSizeCache) {
            this.cache = componentSizeCache;
        }

        public /* synthetic */ CachingMeasure(ComponentSizeCache componentSizeCache, 1 var2_2) {
            this(componentSizeCache);
        }
    }

    public static interface Measure {
        public int sizeOf(Component var1);
    }
}

